/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Artifact;

public class ArtifactBuilder {
    private String name;
    private String type;
    private String sha1;
    private String sha256;
    private String md5;
    private String localPath;
    private String remotePath;
    private Properties properties;

    public ArtifactBuilder(String name) {
        this.name = name;
    }

    public Artifact build() {
        if (StringUtils.isBlank(this.name)) {
            throw new IllegalArgumentException("Artifact must have a name");
        }
        Artifact artifact = new Artifact();
        artifact.setName(this.name);
        artifact.setType(this.type);
        artifact.setSha1(this.sha1);
        artifact.setSha256(this.sha256);
        artifact.setMd5(this.md5);
        artifact.setLocalPath(this.localPath);
        artifact.setRemotePath(this.remotePath);
        artifact.setProperties(this.properties);
        return artifact;
    }

    public ArtifactBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ArtifactBuilder type(String type) {
        this.type = type;
        return this;
    }

    public ArtifactBuilder sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    public ArtifactBuilder sha256(String sha256) {
        this.sha256 = sha256;
        return this;
    }

    public ArtifactBuilder md5(String md5) {
        this.md5 = md5;
        return this;
    }

    public ArtifactBuilder localPath(String localPath) {
        this.localPath = localPath;
        return this;
    }

    public ArtifactBuilder remotePath(String remotePath) {
        this.remotePath = remotePath;
        return this;
    }

    public ArtifactBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public ArtifactBuilder addProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
        return this;
    }

    public ArtifactBuilder addProperties(Properties properties) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }
}

