/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CaseIgnoreListMatchingRule
extends MatchingRule {
    @NotNull
    private static final CaseIgnoreListMatchingRule INSTANCE = new CaseIgnoreListMatchingRule();
    @NotNull
    public static final String EQUALITY_RULE_NAME = "caseIgnoreListMatch";
    @NotNull
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("caseIgnoreListMatch");
    @NotNull
    public static final String EQUALITY_RULE_OID = "2.5.13.11";
    @NotNull
    public static final String SUBSTRING_RULE_NAME = "caseIgnoreListSubstringsMatch";
    @NotNull
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("caseIgnoreListSubstringsMatch");
    @NotNull
    public static final String SUBSTRING_RULE_OID = "2.5.13.12";
    private static final long serialVersionUID = 7795143670808983466L;

    @NotNull
    public static CaseIgnoreListMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    @Nullable
    public String getOrderingMatchingRuleName() {
        return null;
    }

    @Override
    @Nullable
    public String getOrderingMatchingRuleOID() {
        return null;
    }

    @Override
    @NotNull
    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    @Override
    @NotNull
    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    @Override
    public boolean valuesMatch(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        return this.normalize(value1).equals(this.normalize(value2));
    }

    @Override
    public boolean matchesSubstring(@NotNull ASN1OctetString value, @Nullable ASN1OctetString subInitial, @Nullable ASN1OctetString[] subAny, @Nullable ASN1OctetString subFinal) throws LDAPException {
        String normStr = this.normalize(value).stringValue();
        if (subInitial != null) {
            String normSubInitial = this.normalizeSubstring(subInitial, (byte)-128).stringValue();
            if (normSubInitial.indexOf(36) >= 0) {
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_SUBSTRING_COMPONENT_CONTAINS_DOLLAR.get(normSubInitial));
            }
            if (!normStr.startsWith(normSubInitial)) {
                return false;
            }
            normStr = normStr.substring(normSubInitial.length());
        }
        if (subFinal != null) {
            String normSubFinal = this.normalizeSubstring(subFinal, (byte)-126).stringValue();
            if (normSubFinal.indexOf(36) >= 0) {
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_SUBSTRING_COMPONENT_CONTAINS_DOLLAR.get(normSubFinal));
            }
            if (!normStr.endsWith(normSubFinal)) {
                return false;
            }
            normStr = normStr.substring(0, normStr.length() - normSubFinal.length());
        }
        if (subAny != null) {
            for (ASN1OctetString s : subAny) {
                String normSubAny = this.normalizeSubstring(s, (byte)-127).stringValue();
                if (normSubAny.indexOf(36) >= 0) {
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_SUBSTRING_COMPONENT_CONTAINS_DOLLAR.get(normSubAny));
                }
                int pos = normStr.indexOf(normSubAny);
                if (pos < 0) {
                    return false;
                }
                normStr = normStr.substring(pos + normSubAny.length());
            }
        }
        return true;
    }

    @Override
    public int compareValues(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    @NotNull
    public ASN1OctetString normalize(@NotNull ASN1OctetString value) throws LDAPException {
        List<String> items = CaseIgnoreListMatchingRule.getLowercaseItems(value);
        Iterator<String> iterator = items.iterator();
        StringBuilder buffer = new StringBuilder();
        while (iterator.hasNext()) {
            CaseIgnoreListMatchingRule.normalizeItem(buffer, iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append('$');
        }
        return new ASN1OctetString(buffer.toString());
    }

    @Override
    @NotNull
    public ASN1OctetString normalizeSubstring(@NotNull ASN1OctetString value, byte substringType) throws LDAPException {
        return CaseIgnoreStringMatchingRule.getInstance().normalizeSubstring(value, substringType);
    }

    @NotNull
    public static List<String> getItems(@NotNull ASN1OctetString value) throws LDAPException {
        return CaseIgnoreListMatchingRule.getItems(value.stringValue());
    }

    @NotNull
    public static List<String> getItems(@NotNull String value) throws LDAPException {
        ArrayList<String> items = new ArrayList<String>(10);
        int length = value.length();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                try {
                    buffer.append(CaseIgnoreListMatchingRule.decodeHexChar(value, i + 1));
                    i += 2;
                    continue;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_MALFORMED_HEX_CHAR.get(value), e);
                }
            }
            if (c == '$') {
                String s = buffer.toString().trim();
                if (s.length() == 0) {
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_EMPTY_ITEM.get(value));
                }
                items.add(s);
                buffer.delete(0, buffer.length());
                continue;
            }
            buffer.append(c);
        }
        String s = buffer.toString().trim();
        if (s.length() == 0) {
            if (items.isEmpty()) {
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_EMPTY_LIST.get(value));
            }
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_EMPTY_ITEM.get(value));
        }
        items.add(s);
        return Collections.unmodifiableList(items);
    }

    @NotNull
    public static List<String> getLowercaseItems(@NotNull ASN1OctetString value) throws LDAPException {
        return CaseIgnoreListMatchingRule.getLowercaseItems(value.stringValue());
    }

    @NotNull
    public static List<String> getLowercaseItems(@NotNull String value) throws LDAPException {
        return CaseIgnoreListMatchingRule.getItems(StaticUtils.toLowerCase(value));
    }

    static void normalizeItem(@NotNull StringBuilder buffer, @NotNull String item) {
        int length = item.length();
        boolean lastWasSpace = false;
        for (int i = 0; i < length; ++i) {
            char c = item.charAt(i);
            if (c == '\\') {
                buffer.append("\\5c");
                lastWasSpace = false;
                continue;
            }
            if (c == '$') {
                buffer.append("\\24");
                lastWasSpace = false;
                continue;
            }
            if (c == ' ') {
                if (lastWasSpace) continue;
                buffer.append(' ');
                lastWasSpace = true;
                continue;
            }
            buffer.append(c);
            lastWasSpace = false;
        }
    }

    static char decodeHexChar(@NotNull String s, int p) throws LDAPException {
        char c = '\u0000';
        int i = 0;
        int j = p;
        while (i < 2) {
            c = (char)(c << 4);
            switch (s.charAt(j)) {
                case '0': {
                    break;
                }
                case '1': {
                    c = (char)(c | '\u0001');
                    break;
                }
                case '2': {
                    c = (char)(c | 2);
                    break;
                }
                case '3': {
                    c = (char)(c | 3);
                    break;
                }
                case '4': {
                    c = (char)(c | 4);
                    break;
                }
                case '5': {
                    c = (char)(c | 5);
                    break;
                }
                case '6': {
                    c = (char)(c | 6);
                    break;
                }
                case '7': {
                    c = (char)(c | 7);
                    break;
                }
                case '8': {
                    c = (char)(c | 8);
                    break;
                }
                case '9': {
                    c = (char)(c | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    c = (char)(c | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    c = (char)(c | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    c = (char)(c | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    c = (char)(c | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    c = (char)(c | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    c = (char)(c | 0xF);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_CASE_IGNORE_LIST_NOT_HEX_DIGIT.get(Character.valueOf(s.charAt(j))));
                }
            }
            ++i;
            ++j;
        }
        return c;
    }
}

