//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmessageport?language=objc)
#[repr(C)]
pub struct CFMessagePort {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFMessagePort"]
    unsafe impl CFMessagePort {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportsuccess?language=objc)
pub const kCFMessagePortSuccess: i32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportsendtimeout?language=objc)
pub const kCFMessagePortSendTimeout: i32 = -1;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportreceivetimeout?language=objc)
pub const kCFMessagePortReceiveTimeout: i32 = -2;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportisinvalid?language=objc)
pub const kCFMessagePortIsInvalid: i32 = -3;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageporttransporterror?language=objc)
pub const kCFMessagePortTransportError: i32 = -4;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportbecameinvaliderror?language=objc)
pub const kCFMessagePortBecameInvalidError: i32 = -5;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmessageportcontext?language=objc)
#[cfg(feature = "CFBase")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFMessagePortContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFMessagePortContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFMessagePortContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmessageportcallback?language=objc)
#[cfg(feature = "CFData")]
pub type CFMessagePortCallBack = Option<
    unsafe extern "C-unwind" fn(
        *mut CFMessagePort,
        i32,
        *const CFData,
        *mut c_void,
    ) -> *const CFData,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmessageportinvalidationcallback?language=objc)
pub type CFMessagePortInvalidationCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFMessagePort, *mut c_void)>;

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFMessagePort {
    #[doc(alias = "CFMessagePortGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFMessagePortGetTypeID() -> CFTypeID;
        }
        unsafe { CFMessagePortGetTypeID() }
    }
}

#[cfg(all(feature = "CFBase", feature = "CFData"))]
#[inline]
pub unsafe extern "C-unwind" fn CFMessagePortCreateLocal(
    allocator: Option<&CFAllocator>,
    name: Option<&CFString>,
    callout: CFMessagePortCallBack,
    context: *mut CFMessagePortContext,
    should_free_info: *mut Boolean,
) -> Option<CFRetained<CFMessagePort>> {
    extern "C-unwind" {
        fn CFMessagePortCreateLocal(
            allocator: Option<&CFAllocator>,
            name: Option<&CFString>,
            callout: CFMessagePortCallBack,
            context: *mut CFMessagePortContext,
            should_free_info: *mut Boolean,
        ) -> Option<NonNull<CFMessagePort>>;
    }
    let ret =
        unsafe { CFMessagePortCreateLocal(allocator, name, callout, context, should_free_info) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFMessagePortCreateRemote(
    allocator: Option<&CFAllocator>,
    name: Option<&CFString>,
) -> Option<CFRetained<CFMessagePort>> {
    extern "C-unwind" {
        fn CFMessagePortCreateRemote(
            allocator: Option<&CFAllocator>,
            name: Option<&CFString>,
        ) -> Option<NonNull<CFMessagePort>>;
    }
    let ret = unsafe { CFMessagePortCreateRemote(allocator, name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFMessagePortIsRemote(ms: &CFMessagePort) -> bool {
    extern "C-unwind" {
        fn CFMessagePortIsRemote(ms: &CFMessagePort) -> Boolean;
    }
    let ret = unsafe { CFMessagePortIsRemote(ms) };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFMessagePortGetName(
    ms: &CFMessagePort,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFMessagePortGetName(ms: &CFMessagePort) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFMessagePortGetName(ms) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFMessagePortSetName(
    ms: &CFMessagePort,
    new_name: Option<&CFString>,
) -> bool {
    extern "C-unwind" {
        fn CFMessagePortSetName(ms: &CFMessagePort, new_name: Option<&CFString>) -> Boolean;
    }
    let ret = unsafe { CFMessagePortSetName(ms, new_name) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFMessagePortGetContext(ms: &CFMessagePort, context: *mut CFMessagePortContext);
}

extern "C-unwind" {
    pub fn CFMessagePortInvalidate(ms: &CFMessagePort);
}

#[inline]
pub unsafe extern "C-unwind" fn CFMessagePortIsValid(ms: &CFMessagePort) -> bool {
    extern "C-unwind" {
        fn CFMessagePortIsValid(ms: &CFMessagePort) -> Boolean;
    }
    let ret = unsafe { CFMessagePortIsValid(ms) };
    ret != 0
}

extern "C-unwind" {
    pub fn CFMessagePortGetInvalidationCallBack(
        ms: &CFMessagePort,
    ) -> CFMessagePortInvalidationCallBack;
}

extern "C-unwind" {
    pub fn CFMessagePortSetInvalidationCallBack(
        ms: &CFMessagePort,
        callout: CFMessagePortInvalidationCallBack,
    );
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFData", feature = "CFDate"))]
    pub fn CFMessagePortSendRequest(
        remote: &CFMessagePort,
        msgid: i32,
        data: Option<&CFData>,
        send_timeout: CFTimeInterval,
        rcv_timeout: CFTimeInterval,
        reply_mode: Option<&CFString>,
        return_data: *mut *const CFData,
    ) -> i32;
}

#[cfg(all(feature = "CFBase", feature = "CFRunLoop"))]
#[inline]
pub unsafe extern "C-unwind" fn CFMessagePortCreateRunLoopSource(
    allocator: Option<&CFAllocator>,
    local: Option<&CFMessagePort>,
    order: CFIndex,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CFMessagePortCreateRunLoopSource(
            allocator: Option<&CFAllocator>,
            local: Option<&CFMessagePort>,
            order: CFIndex,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { CFMessagePortCreateRunLoopSource(allocator, local, order) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
