//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfattributedstring?language=objc)
#[repr(C)]
pub struct CFAttributedString {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFAttributedString"]
    unsafe impl CFAttributedString {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmutableattributedstring?language=objc)
#[repr(C)]
pub struct CFMutableAttributedString {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFAttributedString"]
    unsafe impl CFMutableAttributedString: CFAttributedString {}
);

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFAttributedString {
    /// Returns the type identifier of all CFAttributedString instances.
    #[doc(alias = "CFAttributedStringGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFAttributedStringGetTypeID() -> CFTypeID;
        }
        unsafe { CFAttributedStringGetTypeID() }
    }
}

/// Creates an attributed string with the specified string and attributes (both copied).
#[cfg(all(feature = "CFBase", feature = "CFDictionary"))]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringCreate(
    alloc: Option<&CFAllocator>,
    str: Option<&CFString>,
    attributes: Option<&CFDictionary>,
) -> Option<CFRetained<CFAttributedString>> {
    extern "C-unwind" {
        fn CFAttributedStringCreate(
            alloc: Option<&CFAllocator>,
            str: Option<&CFString>,
            attributes: Option<&CFDictionary>,
        ) -> Option<NonNull<CFAttributedString>>;
    }
    let ret = unsafe { CFAttributedStringCreate(alloc, str, attributes) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Creates a sub-attributed string from the specified range. It's a programming error for range to specify characters outside the bounds of aStr.
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringCreateWithSubstring(
    alloc: Option<&CFAllocator>,
    a_str: Option<&CFAttributedString>,
    range: CFRange,
) -> Option<CFRetained<CFAttributedString>> {
    extern "C-unwind" {
        fn CFAttributedStringCreateWithSubstring(
            alloc: Option<&CFAllocator>,
            a_str: Option<&CFAttributedString>,
            range: CFRange,
        ) -> Option<NonNull<CFAttributedString>>;
    }
    let ret = unsafe { CFAttributedStringCreateWithSubstring(alloc, a_str, range) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Creates an immutable attributed string copy.
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringCreateCopy(
    alloc: Option<&CFAllocator>,
    a_str: Option<&CFAttributedString>,
) -> Option<CFRetained<CFAttributedString>> {
    extern "C-unwind" {
        fn CFAttributedStringCreateCopy(
            alloc: Option<&CFAllocator>,
            a_str: Option<&CFAttributedString>,
        ) -> Option<NonNull<CFAttributedString>>;
    }
    let ret = unsafe { CFAttributedStringCreateCopy(alloc, a_str) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Returns the string for the attributed string. For performance reasons, this will often point at the backing store of the attributed string, and it might change if the attributed string is edited.  However, this is an implementation detail, and definitely not something that should be counted on.
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringGetString(
    a_str: &CFAttributedString,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFAttributedStringGetString(a_str: &CFAttributedString) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFAttributedStringGetString(a_str) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    /// Returns the length of the attributed string in characters; same as CFStringGetLength(CFAttributedStringGetString(aStr))
    #[cfg(feature = "CFBase")]
    pub fn CFAttributedStringGetLength(a_str: &CFAttributedString) -> CFIndex;
}

/// Returns the attributes at the specified location. If effectiveRange is not NULL, upon return *effectiveRange contains a range over which the exact same set of attributes apply. Note that for performance reasons, the returned effectiveRange is not necessarily the maximal range - for that, use CFAttributedStringGetAttributesAndLongestEffectiveRange().  It's a programming error for loc to specify a location outside the bounds of the attributed string.
///
/// Note that the returned attribute dictionary might change in unpredictable ways from under the caller if the attributed string is edited after this call. If you wish to hang on to the dictionary long-term, you should make an actual copy of it rather than just retaining it.  Also, no assumptions should be made about the relationship of the actual CFDictionaryRef returned by this call and the dictionary originally used to set the attributes, other than the fact that the values stored in the dictionary will be identical (that is, ==) to those originally specified.
#[cfg(all(feature = "CFBase", feature = "CFDictionary"))]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringGetAttributes(
    a_str: &CFAttributedString,
    loc: CFIndex,
    effective_range: *mut CFRange,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFAttributedStringGetAttributes(
            a_str: &CFAttributedString,
            loc: CFIndex,
            effective_range: *mut CFRange,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFAttributedStringGetAttributes(a_str, loc, effective_range) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Returns the value of a single attribute at the specified location. If the specified attribute doesn't exist at the location, returns NULL. If effectiveRange is not NULL, upon return *effectiveRange contains a range over which the exact same attribute value applies. Note that for performance reasons, the returned effectiveRange is not necessarily the maximal range - for that, use CFAttributedStringGetAttributeAndLongestEffectiveRange(). It's a programming error for loc to specify a location outside the bounds of the attributed string.
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringGetAttribute(
    a_str: &CFAttributedString,
    loc: CFIndex,
    attr_name: Option<&CFString>,
    effective_range: *mut CFRange,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFAttributedStringGetAttribute(
            a_str: &CFAttributedString,
            loc: CFIndex,
            attr_name: Option<&CFString>,
            effective_range: *mut CFRange,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFAttributedStringGetAttribute(a_str, loc, attr_name, effective_range) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Returns the attributes at the specified location. If longestEffectiveRange is not NULL, upon return *longestEffectiveRange contains the maximal range within inRange over which the exact same set of attributes apply. The returned range is clipped to inRange. It's a programming error for loc or inRange to specify locations outside the bounds of the attributed string.
#[cfg(all(feature = "CFBase", feature = "CFDictionary"))]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringGetAttributesAndLongestEffectiveRange(
    a_str: &CFAttributedString,
    loc: CFIndex,
    in_range: CFRange,
    longest_effective_range: *mut CFRange,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFAttributedStringGetAttributesAndLongestEffectiveRange(
            a_str: &CFAttributedString,
            loc: CFIndex,
            in_range: CFRange,
            longest_effective_range: *mut CFRange,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe {
        CFAttributedStringGetAttributesAndLongestEffectiveRange(
            a_str,
            loc,
            in_range,
            longest_effective_range,
        )
    };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Returns the value of a single attribute at the specified location. If longestEffectiveRange is not NULL, upon return *longestEffectiveRange contains the maximal range within inRange over which the exact same attribute value applies. The returned range is clipped to inRange. It's a programming error for loc or inRange to specify locations outside the bounds of the attributed string.
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringGetAttributeAndLongestEffectiveRange(
    a_str: &CFAttributedString,
    loc: CFIndex,
    attr_name: Option<&CFString>,
    in_range: CFRange,
    longest_effective_range: *mut CFRange,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFAttributedStringGetAttributeAndLongestEffectiveRange(
            a_str: &CFAttributedString,
            loc: CFIndex,
            attr_name: Option<&CFString>,
            in_range: CFRange,
            longest_effective_range: *mut CFRange,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe {
        CFAttributedStringGetAttributeAndLongestEffectiveRange(
            a_str,
            loc,
            attr_name,
            in_range,
            longest_effective_range,
        )
    };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Creates a mutable attributed string copy. maxLength, if not 0, is a hard bound on the length of the attributed string; exceeding this size limit during any editing operation is a programming error. If 0, there is no limit on the length.
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringCreateMutableCopy(
    alloc: Option<&CFAllocator>,
    max_length: CFIndex,
    a_str: Option<&CFAttributedString>,
) -> Option<CFRetained<CFMutableAttributedString>> {
    extern "C-unwind" {
        fn CFAttributedStringCreateMutableCopy(
            alloc: Option<&CFAllocator>,
            max_length: CFIndex,
            a_str: Option<&CFAttributedString>,
        ) -> Option<NonNull<CFMutableAttributedString>>;
    }
    let ret = unsafe { CFAttributedStringCreateMutableCopy(alloc, max_length, a_str) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Creates a mutable empty attributed string. maxLength, if not 0, is a hard bound on the length of the attributed string; exceeding this size limit during any editing operation is a programming error. If 0, there is no limit on the length.
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringCreateMutable(
    alloc: Option<&CFAllocator>,
    max_length: CFIndex,
) -> Option<CFRetained<CFMutableAttributedString>> {
    extern "C-unwind" {
        fn CFAttributedStringCreateMutable(
            alloc: Option<&CFAllocator>,
            max_length: CFIndex,
        ) -> Option<NonNull<CFMutableAttributedString>>;
    }
    let ret = unsafe { CFAttributedStringCreateMutable(alloc, max_length) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    /// Modifies the string for the attributed string, much like CFStringReplace().  It's an error for range to specify characters outside the bounds of aStr.
    ///
    /// (Note: This function is a convenience on CFAttributedStringGetMutableString(); however, until CFAttributedStringGetMutableString() is implemented, it remains the only way to edit the string of the attributed string.)
    #[cfg(feature = "CFBase")]
    pub fn CFAttributedStringReplaceString(
        a_str: Option<&CFMutableAttributedString>,
        range: CFRange,
        replacement: Option<&CFString>,
    );
}

/// Gets the string for the attributed string as a mutable string, allowing editing the character contents of the string as if it were an CFMutableString. Attributes corresponding to the edited range are appropriately modified. If, as a result of the edit, new characters are introduced into the string, they inherit the attributes of the first replaced character from range. If no existing characters are replaced by the edit, the new characters inherit the attributes of the character preceding range if it has any, otherwise of the character following range. If the initial string is empty, the attributes for the new characters are also empty.
///
/// (Note: This function is not yet implemented and will return NULL except for toll-free bridged instances.)
#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringGetMutableString(
    a_str: Option<&CFMutableAttributedString>,
) -> Option<CFRetained<CFMutableString>> {
    extern "C-unwind" {
        fn CFAttributedStringGetMutableString(
            a_str: Option<&CFMutableAttributedString>,
        ) -> Option<NonNull<CFMutableString>>;
    }
    let ret = unsafe { CFAttributedStringGetMutableString(a_str) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Sets the value of multiple attributes over the specified range, which should be valid. If clearOtherAttributes is false, existing attributes (which aren't being replaced) are left alone; otherwise they are cleared. The dictionary should be setup for "usual" CF type usage --- CFString keys, and arbitrary CFType values. Note that after this call, further mutations to the replacement dictionary argument by the caller will not affect the contents of the attributed string.
#[cfg(all(feature = "CFBase", feature = "CFDictionary"))]
#[inline]
pub unsafe extern "C-unwind" fn CFAttributedStringSetAttributes(
    a_str: Option<&CFMutableAttributedString>,
    range: CFRange,
    replacement: Option<&CFDictionary>,
    clear_other_attributes: bool,
) {
    extern "C-unwind" {
        fn CFAttributedStringSetAttributes(
            a_str: Option<&CFMutableAttributedString>,
            range: CFRange,
            replacement: Option<&CFDictionary>,
            clear_other_attributes: Boolean,
        );
    }
    unsafe {
        CFAttributedStringSetAttributes(a_str, range, replacement, clear_other_attributes as _)
    }
}

extern "C-unwind" {
    /// Sets the value of a single attribute over the specified range, which should be valid. value should not be NULL.
    #[cfg(feature = "CFBase")]
    pub fn CFAttributedStringSetAttribute(
        a_str: Option<&CFMutableAttributedString>,
        range: CFRange,
        attr_name: Option<&CFString>,
        value: Option<&CFType>,
    );
}

extern "C-unwind" {
    /// Removes the value of a single attribute over the specified range, which should be valid. It's OK for the attribute not the exist over the specified range.
    #[cfg(feature = "CFBase")]
    pub fn CFAttributedStringRemoveAttribute(
        a_str: Option<&CFMutableAttributedString>,
        range: CFRange,
        attr_name: Option<&CFString>,
    );
}

extern "C-unwind" {
    /// Replaces the attributed substring over the specified range with the attributed string specified in replacement. range should be valid. To delete a range of the attributed string, call CFAttributedStringReplaceString() with empty string and specified range.
    #[cfg(feature = "CFBase")]
    pub fn CFAttributedStringReplaceAttributedString(
        a_str: Option<&CFMutableAttributedString>,
        range: CFRange,
        replacement: Option<&CFAttributedString>,
    );
}

extern "C-unwind" {
    /// In cases where attributed string might do a bunch of work to assure self-consistency, CFAttributedStringBeginEditing/CFAttributedStringEndEditing allow disabling that to allow deferring and coalescing any work. It's a good idea to call these around a set of related mutation calls which don't require the string to be in consistent state in between. These calls can be nested.
    pub fn CFAttributedStringBeginEditing(a_str: Option<&CFMutableAttributedString>);
}

extern "C-unwind" {
    /// In cases where attributed string might do a bunch of work to assure self-consistency, CFAttributedStringBeginEditing/CFAttributedStringEndEditing allow disabling that to allow deferring and coalescing any work. It's a good idea to call these around a set of related mutation calls which don't require the string to be in consistent state in between. These calls can be nested.
    pub fn CFAttributedStringEndEditing(a_str: Option<&CFMutableAttributedString>);
}

extern "C-unwind" {
    /// Fills bidiLevels by applying the Unicode Bidi Algorithm (P, X, W, N, and I) to the characters in range. Returns true if the result is not uni-level LTR (in other words, needing further Bidi processing). baseDirection is NSWritingDirection (NSWritingDirectionNatural, NSWritingDirectionLeftToRight, and NSWritingDirectionRightToLeft).  Understands NSWritingDirectionAttributeName values.
    #[cfg(feature = "CFBase")]
    pub fn CFAttributedStringGetBidiLevelsAndResolvedDirections(
        attributed_string: &CFAttributedString,
        range: CFRange,
        base_direction: i8,
        bidi_levels: *mut u8,
        base_directions: *mut u8,
    ) -> bool;
}
