# Xpra Documentation Index

## [FAQ](./FAQ.md)

## [Usage](./Usage/README.md)

[Simple examples](./Usage/README.md) to get started.

<details>
  <summary>Starting a session</summary>

* [Seamless Session](./Usage/Seamless.md) : individual windows
* [Desktop Session](./Usage/Desktop.md) : a full desktop session
* [Shadow Session](./Usage/Shadow.md) : view an existing display
</details>
<details>
  <summary>Configuration</summary>

* [Authentication modules](./Usage/Authentication.md) to secure access to sessions
* [Options](./Usage/Configuration.md) to configure xpra
</details>
<details>
  <summary>Advanced Topics</summary>

* [proxy server](./Usage/Proxy-Server.md) to manage access
* [system service](./Usage/Service.md) to start on boot
* [picture encodings](./Usage/Encodings.md) : quality and performance
* [OpenGL applications](./Usage/OpenGL.md) : server-side GPU acceleration
* [Client OpenGL acceleration](./Usage/Client-OpenGL.md)
* [Xdummy](./Usage/Xdummy.md) : alternative to `Xvfb`
</details>

---

## [Features](./Features/README.md)
<details>
  <summary>Device Forwarding</summary>

* [Audio](./Features/Audio.md) : speaker and microphone
* [Printers](./Features/Printing.md)
* [Webcams](./Features/Webcam.md)
* [Keyboard](./Features/Keyboard.md)
</details>
<details>
  <summary>Data Synchronization</summary>

* [Clipboard](./Features/Clipboard.md)
* [File transfers](./Features/File-Transfers.md)
* [System tray](./Features/System-Tray.md)
* [Notifications](./Features/Notifications.md)
</details>
<details>
  <summary>Display Characteristics</summary>

* [Image Depth](./Features/Image-Depth.md)
* [DPI](./Features/DPI.md)

---

## [Network](./Network/README.md)
See [Multicast DNS](./Network/Multicast-DNS.md) and [Encryption](./Network/Encryption.md): [AES](./Network/AES.md), [SSL](./Network/SSL.md), [SSH](./Network/SSH.md)

## Technical
* [network protocol](./Network/Protocol.md)
* [subsystems](./Subsystems)
* [security](./Usage/Security.md)

---

## [Build](./Build/README.md)
Information for developers:
<details>
  <summary>building from source</summary>

* [Generic list of dependencies](./Build/Dependencies.md)
* [Fedora / RedHat](./Build/RPM.md)
* [Debian](./Build/Debian.md)
* [MS Windows](./Build/MSWindows.md)
* [MacOS](./Build/MacOS.md)
* [Other](./Build/Other.md)
</details>

---

## [Sponsors](./SPONSORS.md)
