Example of illegal code:

```ada
function F (X : out Integer) return Integer
  with Side_Effects;

declare
   X : Integer;
   Y : Integer := F (X); -- error
begin
   Y := F (X) + 1; -- error
end;
```

This error is issued on illegal calls to functions with side-effects. A
function with side-effects is identified by the aspect `Side_Effects`, to
indicate that the function is allowed to have output parameters, write global
variables, raise exceptions and not terminate.

These functions can only be called as the right-hand side of assignments, quite
similar to where procedures can be called. The fix is thus to move illegal
calls to the right-hand side of assignments as follows:

```ada
function F (X : out Integer) return Integer
  with Side_Effects;

declare
   X : Integer;
   Y : Integer;
   Z : Integer;
begin
   Y := F (X); -- ok
   Z := F (X); -- ok
   Y := Z + 1;
end;
```
