// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: pbmesh/v2beta1/pbproxystate/route.proto

package pbproxystate

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Route struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// virtual_hosts is a list of virtual hosts. A virtual host is selected based on an incoming request's host header.
	VirtualHosts []*VirtualHost `protobuf:"bytes,1,rep,name=virtual_hosts,json=virtualHosts,proto3" json:"virtual_hosts,omitempty"`
}

func (x *Route) Reset() {
	*x = Route{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Route) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Route) ProtoMessage() {}

func (x *Route) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Route.ProtoReflect.Descriptor instead.
func (*Route) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{0}
}

func (x *Route) GetVirtualHosts() []*VirtualHost {
	if x != nil {
		return x.VirtualHosts
	}
	return nil
}

type VirtualHost struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// domains are used to match an incoming request's host header and determine which virtual host to use.
	Domains []string `protobuf:"bytes,2,rep,name=domains,proto3" json:"domains,omitempty"`
	// header_mutations to apply to the request when it matches this virtual host. These are applied after any headers in
	// the RouteRule.
	HeaderMutations []*HeaderMutation `protobuf:"bytes,3,rep,name=header_mutations,json=headerMutations,proto3" json:"header_mutations,omitempty"`
	// route_rules are a list of rules to use for what to do next with this request. The first rule with a match will be
	// used.
	RouteRules []*RouteRule `protobuf:"bytes,4,rep,name=route_rules,json=routeRules,proto3" json:"route_rules,omitempty"`
}

func (x *VirtualHost) Reset() {
	*x = VirtualHost{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VirtualHost) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualHost) ProtoMessage() {}

func (x *VirtualHost) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualHost.ProtoReflect.Descriptor instead.
func (*VirtualHost) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{1}
}

func (x *VirtualHost) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VirtualHost) GetDomains() []string {
	if x != nil {
		return x.Domains
	}
	return nil
}

func (x *VirtualHost) GetHeaderMutations() []*HeaderMutation {
	if x != nil {
		return x.HeaderMutations
	}
	return nil
}

func (x *VirtualHost) GetRouteRules() []*RouteRule {
	if x != nil {
		return x.RouteRules
	}
	return nil
}

type RouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// match determines how to match the request. The first match determines which destination the request will go to.
	Match *RouteMatch `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// destination is where to send the request to.
	Destination *RouteDestination `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// header_mutations to apply to the request. These are applied before the VirtualHost header mutations.
	HeaderMutations []*HeaderMutation `protobuf:"bytes,3,rep,name=header_mutations,json=headerMutations,proto3" json:"header_mutations,omitempty"`
}

func (x *RouteRule) Reset() {
	*x = RouteRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteRule) ProtoMessage() {}

func (x *RouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteRule.ProtoReflect.Descriptor instead.
func (*RouteRule) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{2}
}

func (x *RouteRule) GetMatch() *RouteMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *RouteRule) GetDestination() *RouteDestination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *RouteRule) GetHeaderMutations() []*HeaderMutation {
	if x != nil {
		return x.HeaderMutations
	}
	return nil
}

// RouteMatch has configuration to match a request.
type RouteMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PathMatch             *PathMatch             `protobuf:"bytes,1,opt,name=path_match,json=pathMatch,proto3" json:"path_match,omitempty"`
	HeaderMatches         []*HeaderMatch         `protobuf:"bytes,2,rep,name=header_matches,json=headerMatches,proto3" json:"header_matches,omitempty"`
	MethodMatches         []string               `protobuf:"bytes,3,rep,name=method_matches,json=methodMatches,proto3" json:"method_matches,omitempty"`
	QueryParameterMatches []*QueryParameterMatch `protobuf:"bytes,4,rep,name=query_parameter_matches,json=queryParameterMatches,proto3" json:"query_parameter_matches,omitempty"`
}

func (x *RouteMatch) Reset() {
	*x = RouteMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteMatch) ProtoMessage() {}

func (x *RouteMatch) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteMatch.ProtoReflect.Descriptor instead.
func (*RouteMatch) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{3}
}

func (x *RouteMatch) GetPathMatch() *PathMatch {
	if x != nil {
		return x.PathMatch
	}
	return nil
}

func (x *RouteMatch) GetHeaderMatches() []*HeaderMatch {
	if x != nil {
		return x.HeaderMatches
	}
	return nil
}

func (x *RouteMatch) GetMethodMatches() []string {
	if x != nil {
		return x.MethodMatches
	}
	return nil
}

func (x *RouteMatch) GetQueryParameterMatches() []*QueryParameterMatch {
	if x != nil {
		return x.QueryParameterMatches
	}
	return nil
}

type PathMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to PathMatch:
	//
	//	*PathMatch_Exact
	//	*PathMatch_Prefix
	//	*PathMatch_Regex
	PathMatch isPathMatch_PathMatch `protobuf_oneof:"path_match"`
}

func (x *PathMatch) Reset() {
	*x = PathMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PathMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PathMatch) ProtoMessage() {}

func (x *PathMatch) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PathMatch.ProtoReflect.Descriptor instead.
func (*PathMatch) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{4}
}

func (m *PathMatch) GetPathMatch() isPathMatch_PathMatch {
	if m != nil {
		return m.PathMatch
	}
	return nil
}

func (x *PathMatch) GetExact() string {
	if x, ok := x.GetPathMatch().(*PathMatch_Exact); ok {
		return x.Exact
	}
	return ""
}

func (x *PathMatch) GetPrefix() string {
	if x, ok := x.GetPathMatch().(*PathMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (x *PathMatch) GetRegex() string {
	if x, ok := x.GetPathMatch().(*PathMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

type isPathMatch_PathMatch interface {
	isPathMatch_PathMatch()
}

type PathMatch_Exact struct {
	Exact string `protobuf:"bytes,1,opt,name=exact,proto3,oneof"`
}

type PathMatch_Prefix struct {
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3,oneof"`
}

type PathMatch_Regex struct {
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

func (*PathMatch_Exact) isPathMatch_PathMatch() {}

func (*PathMatch_Prefix) isPathMatch_PathMatch() {}

func (*PathMatch_Regex) isPathMatch_PathMatch() {}

type QueryParameterMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to Match:
	//
	//	*QueryParameterMatch_Exact
	//	*QueryParameterMatch_Regex
	//	*QueryParameterMatch_Present
	Match isQueryParameterMatch_Match `protobuf_oneof:"match"`
}

func (x *QueryParameterMatch) Reset() {
	*x = QueryParameterMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryParameterMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryParameterMatch) ProtoMessage() {}

func (x *QueryParameterMatch) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryParameterMatch.ProtoReflect.Descriptor instead.
func (*QueryParameterMatch) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{5}
}

func (x *QueryParameterMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *QueryParameterMatch) GetMatch() isQueryParameterMatch_Match {
	if m != nil {
		return m.Match
	}
	return nil
}

func (x *QueryParameterMatch) GetExact() string {
	if x, ok := x.GetMatch().(*QueryParameterMatch_Exact); ok {
		return x.Exact
	}
	return ""
}

func (x *QueryParameterMatch) GetRegex() string {
	if x, ok := x.GetMatch().(*QueryParameterMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

func (x *QueryParameterMatch) GetPresent() bool {
	if x, ok := x.GetMatch().(*QueryParameterMatch_Present); ok {
		return x.Present
	}
	return false
}

type isQueryParameterMatch_Match interface {
	isQueryParameterMatch_Match()
}

type QueryParameterMatch_Exact struct {
	Exact string `protobuf:"bytes,2,opt,name=exact,proto3,oneof"`
}

type QueryParameterMatch_Regex struct {
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

type QueryParameterMatch_Present struct {
	Present bool `protobuf:"varint,4,opt,name=present,proto3,oneof"`
}

func (*QueryParameterMatch_Exact) isQueryParameterMatch_Match() {}

func (*QueryParameterMatch_Regex) isQueryParameterMatch_Match() {}

func (*QueryParameterMatch_Present) isQueryParameterMatch_Match() {}

type HeaderMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to Match:
	//
	//	*HeaderMatch_Exact
	//	*HeaderMatch_Prefix
	//	*HeaderMatch_Suffix
	//	*HeaderMatch_Regex
	//	*HeaderMatch_Present
	Match       isHeaderMatch_Match `protobuf_oneof:"match"`
	InvertMatch bool                `protobuf:"varint,7,opt,name=invert_match,json=invertMatch,proto3" json:"invert_match,omitempty"`
}

func (x *HeaderMatch) Reset() {
	*x = HeaderMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeaderMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeaderMatch) ProtoMessage() {}

func (x *HeaderMatch) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeaderMatch.ProtoReflect.Descriptor instead.
func (*HeaderMatch) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{6}
}

func (x *HeaderMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *HeaderMatch) GetMatch() isHeaderMatch_Match {
	if m != nil {
		return m.Match
	}
	return nil
}

func (x *HeaderMatch) GetExact() string {
	if x, ok := x.GetMatch().(*HeaderMatch_Exact); ok {
		return x.Exact
	}
	return ""
}

func (x *HeaderMatch) GetPrefix() string {
	if x, ok := x.GetMatch().(*HeaderMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (x *HeaderMatch) GetSuffix() string {
	if x, ok := x.GetMatch().(*HeaderMatch_Suffix); ok {
		return x.Suffix
	}
	return ""
}

func (x *HeaderMatch) GetRegex() string {
	if x, ok := x.GetMatch().(*HeaderMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

func (x *HeaderMatch) GetPresent() bool {
	if x, ok := x.GetMatch().(*HeaderMatch_Present); ok {
		return x.Present
	}
	return false
}

func (x *HeaderMatch) GetInvertMatch() bool {
	if x != nil {
		return x.InvertMatch
	}
	return false
}

type isHeaderMatch_Match interface {
	isHeaderMatch_Match()
}

type HeaderMatch_Exact struct {
	Exact string `protobuf:"bytes,2,opt,name=exact,proto3,oneof"`
}

type HeaderMatch_Prefix struct {
	Prefix string `protobuf:"bytes,3,opt,name=prefix,proto3,oneof"`
}

type HeaderMatch_Suffix struct {
	Suffix string `protobuf:"bytes,4,opt,name=suffix,proto3,oneof"`
}

type HeaderMatch_Regex struct {
	Regex string `protobuf:"bytes,5,opt,name=regex,proto3,oneof"`
}

type HeaderMatch_Present struct {
	Present bool `protobuf:"varint,6,opt,name=present,proto3,oneof"`
}

func (*HeaderMatch_Exact) isHeaderMatch_Match() {}

func (*HeaderMatch_Prefix) isHeaderMatch_Match() {}

func (*HeaderMatch_Suffix) isHeaderMatch_Match() {}

func (*HeaderMatch_Regex) isHeaderMatch_Match() {}

func (*HeaderMatch_Present) isHeaderMatch_Match() {}

// RouteDestination has configuration for where to send a request.
type RouteDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// destination is one or more clusters to route to.
	//
	// Types that are assignable to Destination:
	//
	//	*RouteDestination_Cluster
	//	*RouteDestination_WeightedClusters
	Destination              isRouteDestination_Destination `protobuf_oneof:"destination"`
	DestinationConfiguration *DestinationConfiguration      `protobuf:"bytes,3,opt,name=destination_configuration,json=destinationConfiguration,proto3" json:"destination_configuration,omitempty"`
}

func (x *RouteDestination) Reset() {
	*x = RouteDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteDestination) ProtoMessage() {}

func (x *RouteDestination) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteDestination.ProtoReflect.Descriptor instead.
func (*RouteDestination) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{7}
}

func (m *RouteDestination) GetDestination() isRouteDestination_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *RouteDestination) GetCluster() *DestinationCluster {
	if x, ok := x.GetDestination().(*RouteDestination_Cluster); ok {
		return x.Cluster
	}
	return nil
}

func (x *RouteDestination) GetWeightedClusters() *L7WeightedClusterGroup {
	if x, ok := x.GetDestination().(*RouteDestination_WeightedClusters); ok {
		return x.WeightedClusters
	}
	return nil
}

func (x *RouteDestination) GetDestinationConfiguration() *DestinationConfiguration {
	if x != nil {
		return x.DestinationConfiguration
	}
	return nil
}

type isRouteDestination_Destination interface {
	isRouteDestination_Destination()
}

type RouteDestination_Cluster struct {
	Cluster *DestinationCluster `protobuf:"bytes,1,opt,name=cluster,proto3,oneof"`
}

type RouteDestination_WeightedClusters struct {
	WeightedClusters *L7WeightedClusterGroup `protobuf:"bytes,2,opt,name=weighted_clusters,json=weightedClusters,proto3,oneof"`
}

func (*RouteDestination_Cluster) isRouteDestination_Destination() {}

func (*RouteDestination_WeightedClusters) isRouteDestination_Destination() {}

type DestinationConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AutoHostRewrite *wrapperspb.BoolValue     `protobuf:"bytes,1,opt,name=auto_host_rewrite,json=autoHostRewrite,proto3" json:"auto_host_rewrite,omitempty"`
	HashPolicies    []*LoadBalancerHashPolicy `protobuf:"bytes,2,rep,name=hash_policies,json=hashPolicies,proto3" json:"hash_policies,omitempty"`
	TimeoutConfig   *TimeoutConfig            `protobuf:"bytes,3,opt,name=timeout_config,json=timeoutConfig,proto3" json:"timeout_config,omitempty"`
	PrefixRewrite   string                    `protobuf:"bytes,4,opt,name=prefix_rewrite,json=prefixRewrite,proto3" json:"prefix_rewrite,omitempty"`
	RetryPolicy     *RetryPolicy              `protobuf:"bytes,5,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
}

func (x *DestinationConfiguration) Reset() {
	*x = DestinationConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationConfiguration) ProtoMessage() {}

func (x *DestinationConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationConfiguration.ProtoReflect.Descriptor instead.
func (*DestinationConfiguration) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{8}
}

func (x *DestinationConfiguration) GetAutoHostRewrite() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoHostRewrite
	}
	return nil
}

func (x *DestinationConfiguration) GetHashPolicies() []*LoadBalancerHashPolicy {
	if x != nil {
		return x.HashPolicies
	}
	return nil
}

func (x *DestinationConfiguration) GetTimeoutConfig() *TimeoutConfig {
	if x != nil {
		return x.TimeoutConfig
	}
	return nil
}

func (x *DestinationConfiguration) GetPrefixRewrite() string {
	if x != nil {
		return x.PrefixRewrite
	}
	return ""
}

func (x *DestinationConfiguration) GetRetryPolicy() *RetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

type RetryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RetryOn              string                  `protobuf:"bytes,1,opt,name=retry_on,json=retryOn,proto3" json:"retry_on,omitempty"`
	NumRetries           *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=num_retries,json=numRetries,proto3" json:"num_retries,omitempty"`
	RetriableStatusCodes []uint32                `protobuf:"varint,3,rep,packed,name=retriable_status_codes,json=retriableStatusCodes,proto3" json:"retriable_status_codes,omitempty"`
}

func (x *RetryPolicy) Reset() {
	*x = RetryPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryPolicy) ProtoMessage() {}

func (x *RetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryPolicy.ProtoReflect.Descriptor instead.
func (*RetryPolicy) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{9}
}

func (x *RetryPolicy) GetRetryOn() string {
	if x != nil {
		return x.RetryOn
	}
	return ""
}

func (x *RetryPolicy) GetNumRetries() *wrapperspb.UInt32Value {
	if x != nil {
		return x.NumRetries
	}
	return nil
}

func (x *RetryPolicy) GetRetriableStatusCodes() []uint32 {
	if x != nil {
		return x.RetriableStatusCodes
	}
	return nil
}

type TimeoutConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// +kubebuilder:validation:Format=duration
	Timeout *durationpb.Duration `protobuf:"bytes,1,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// +kubebuilder:validation:Format=duration
	IdleTimeout *durationpb.Duration `protobuf:"bytes,2,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
}

func (x *TimeoutConfig) Reset() {
	*x = TimeoutConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeoutConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeoutConfig) ProtoMessage() {}

func (x *TimeoutConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeoutConfig.ProtoReflect.Descriptor instead.
func (*TimeoutConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{10}
}

func (x *TimeoutConfig) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *TimeoutConfig) GetIdleTimeout() *durationpb.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

type LoadBalancerHashPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Policy:
	//
	//	*LoadBalancerHashPolicy_Cookie
	//	*LoadBalancerHashPolicy_Header
	//	*LoadBalancerHashPolicy_QueryParameter
	//	*LoadBalancerHashPolicy_ConnectionProperties
	Policy isLoadBalancerHashPolicy_Policy `protobuf_oneof:"policy"`
}

func (x *LoadBalancerHashPolicy) Reset() {
	*x = LoadBalancerHashPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadBalancerHashPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerHashPolicy) ProtoMessage() {}

func (x *LoadBalancerHashPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerHashPolicy.ProtoReflect.Descriptor instead.
func (*LoadBalancerHashPolicy) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{11}
}

func (m *LoadBalancerHashPolicy) GetPolicy() isLoadBalancerHashPolicy_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (x *LoadBalancerHashPolicy) GetCookie() *CookiePolicy {
	if x, ok := x.GetPolicy().(*LoadBalancerHashPolicy_Cookie); ok {
		return x.Cookie
	}
	return nil
}

func (x *LoadBalancerHashPolicy) GetHeader() *HeaderPolicy {
	if x, ok := x.GetPolicy().(*LoadBalancerHashPolicy_Header); ok {
		return x.Header
	}
	return nil
}

func (x *LoadBalancerHashPolicy) GetQueryParameter() *QueryParameterPolicy {
	if x, ok := x.GetPolicy().(*LoadBalancerHashPolicy_QueryParameter); ok {
		return x.QueryParameter
	}
	return nil
}

func (x *LoadBalancerHashPolicy) GetConnectionProperties() *ConnectionPropertiesPolicy {
	if x, ok := x.GetPolicy().(*LoadBalancerHashPolicy_ConnectionProperties); ok {
		return x.ConnectionProperties
	}
	return nil
}

type isLoadBalancerHashPolicy_Policy interface {
	isLoadBalancerHashPolicy_Policy()
}

type LoadBalancerHashPolicy_Cookie struct {
	Cookie *CookiePolicy `protobuf:"bytes,1,opt,name=cookie,proto3,oneof"`
}

type LoadBalancerHashPolicy_Header struct {
	Header *HeaderPolicy `protobuf:"bytes,2,opt,name=header,proto3,oneof"`
}

type LoadBalancerHashPolicy_QueryParameter struct {
	QueryParameter *QueryParameterPolicy `protobuf:"bytes,3,opt,name=query_parameter,json=queryParameter,proto3,oneof"`
}

type LoadBalancerHashPolicy_ConnectionProperties struct {
	ConnectionProperties *ConnectionPropertiesPolicy `protobuf:"bytes,4,opt,name=connection_properties,json=connectionProperties,proto3,oneof"`
}

func (*LoadBalancerHashPolicy_Cookie) isLoadBalancerHashPolicy_Policy() {}

func (*LoadBalancerHashPolicy_Header) isLoadBalancerHashPolicy_Policy() {}

func (*LoadBalancerHashPolicy_QueryParameter) isLoadBalancerHashPolicy_Policy() {}

func (*LoadBalancerHashPolicy_ConnectionProperties) isLoadBalancerHashPolicy_Policy() {}

type CookiePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// +kubebuilder:validation:Format=duration
	Ttl      *durationpb.Duration `protobuf:"bytes,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
	Path     string               `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	Terminal bool                 `protobuf:"varint,4,opt,name=terminal,proto3" json:"terminal,omitempty"`
}

func (x *CookiePolicy) Reset() {
	*x = CookiePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CookiePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CookiePolicy) ProtoMessage() {}

func (x *CookiePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CookiePolicy.ProtoReflect.Descriptor instead.
func (*CookiePolicy) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{12}
}

func (x *CookiePolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CookiePolicy) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *CookiePolicy) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *CookiePolicy) GetTerminal() bool {
	if x != nil {
		return x.Terminal
	}
	return false
}

type HeaderPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Terminal bool   `protobuf:"varint,2,opt,name=terminal,proto3" json:"terminal,omitempty"`
}

func (x *HeaderPolicy) Reset() {
	*x = HeaderPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeaderPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeaderPolicy) ProtoMessage() {}

func (x *HeaderPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeaderPolicy.ProtoReflect.Descriptor instead.
func (*HeaderPolicy) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{13}
}

func (x *HeaderPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HeaderPolicy) GetTerminal() bool {
	if x != nil {
		return x.Terminal
	}
	return false
}

type QueryParameterPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Terminal bool   `protobuf:"varint,2,opt,name=terminal,proto3" json:"terminal,omitempty"`
}

func (x *QueryParameterPolicy) Reset() {
	*x = QueryParameterPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryParameterPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryParameterPolicy) ProtoMessage() {}

func (x *QueryParameterPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryParameterPolicy.ProtoReflect.Descriptor instead.
func (*QueryParameterPolicy) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{14}
}

func (x *QueryParameterPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryParameterPolicy) GetTerminal() bool {
	if x != nil {
		return x.Terminal
	}
	return false
}

type ConnectionPropertiesPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SourceIp bool `protobuf:"varint,1,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	Terminal bool `protobuf:"varint,2,opt,name=terminal,proto3" json:"terminal,omitempty"`
}

func (x *ConnectionPropertiesPolicy) Reset() {
	*x = ConnectionPropertiesPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionPropertiesPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionPropertiesPolicy) ProtoMessage() {}

func (x *ConnectionPropertiesPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionPropertiesPolicy.ProtoReflect.Descriptor instead.
func (*ConnectionPropertiesPolicy) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP(), []int{15}
}

func (x *ConnectionPropertiesPolicy) GetSourceIp() bool {
	if x != nil {
		return x.SourceIp
	}
	return false
}

func (x *ConnectionPropertiesPolicy) GetTerminal() bool {
	if x != nil {
		return x.Terminal
	}
	return false
}

var File_pbmesh_v2beta1_pbproxystate_route_proto protoreflect.FileDescriptor

var file_pbmesh_v2beta1_pbproxystate_route_proto_rawDesc = []byte{
	0x0a, 0x27, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x32, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2f, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x65, 0x0a, 0x05, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x5c, 0x0a,
	0x0d, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x52, 0x0c, 0x76,
	0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x73, 0x22, 0xfa, 0x01, 0x0a, 0x0b,
	0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x10, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x56, 0x0a, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0a, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xa0, 0x02, 0x0a, 0x09, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x4c, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x05, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x5e, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x65, 0x0a, 0x10, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6d,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe2, 0x02, 0x0a, 0x0a,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x54, 0x0a, 0x0a, 0x70, 0x61,
	0x74, 0x68, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x50, 0x61, 0x74, 0x68,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x09, 0x70, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x12, 0x5e, 0x0a, 0x0e, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x0d, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x77, 0x0a, 0x17, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x15, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x22, 0x63, 0x0a, 0x09, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x16, 0x0a,
	0x05, 0x65, 0x78, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05,
	0x65, 0x78, 0x61, 0x63, 0x74, 0x12, 0x18, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12,
	0x16, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x61, 0x74, 0x68, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x22, 0x7e, 0x0a, 0x13, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x16, 0x0a, 0x05, 0x65, 0x78, 0x61, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x05, 0x65, 0x78, 0x61, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65,
	0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78,
	0x12, 0x1a, 0x0a, 0x07, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x00, 0x52, 0x07, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x22, 0xcd, 0x01, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x65, 0x78, 0x61,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x65, 0x78, 0x61, 0x63,
	0x74, 0x12, 0x18, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x18, 0x0a, 0x06, 0x73,
	0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x73,
	0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x16, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x12, 0x1a, 0x0a,
	0x07, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00,
	0x52, 0x07, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6e, 0x76,
	0x65, 0x72, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0b, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x07, 0x0a, 0x05,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x22, 0xf4, 0x02, 0x0a, 0x10, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x07, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d,
	0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x07, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x71, 0x0a, 0x11, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c,
	0x37, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x10, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65,
	0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x81, 0x01, 0x0a, 0x19, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x18, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0d, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb0, 0x03, 0x0a,
	0x18, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x11, 0x61, 0x75, 0x74,
	0x6f, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x48, 0x6f, 0x73, 0x74, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x12, 0x67, 0x0a, 0x0d, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x72, 0x48, 0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0c, 0x68, 0x61,
	0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x0e, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25, 0x0a, 0x0e,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x65, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x12, 0x5a, 0x0a, 0x0c, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22,
	0x9d, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x19, 0x0a, 0x08, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x72, 0x65, 0x74, 0x72, 0x79, 0x4f, 0x6e, 0x12, 0x3d, 0x0a, 0x0b, 0x6e, 0x75,
	0x6d, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x6e,
	0x75, 0x6d, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x14, 0x72, 0x65, 0x74, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x22,
	0x82, 0x01, 0x0a, 0x0d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x3c, 0x0a, 0x0c, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x69, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x22, 0xb6, 0x03, 0x0a, 0x16, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x72, 0x48, 0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x52, 0x0a, 0x06, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x12, 0x52, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x48, 0x00, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x6b, 0x0a, 0x0f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x48, 0x00, 0x52, 0x0e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x12, 0x7d, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x48, 0x00, 0x52, 0x14, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x7f, 0x0a,
	0x0c, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x2b, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x22, 0x3e,
	0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x22, 0x46,
	0x0a, 0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x22, 0x55, 0x0a, 0x1a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x70, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x42, 0xd0, 0x02,
	0x0a, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x0a, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x2f, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73,
	0x74, 0x61, 0x74, 0x65, 0xa2, 0x02, 0x05, 0x48, 0x43, 0x4d, 0x56, 0x50, 0xaa, 0x02, 0x2a, 0x48,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x4d, 0x65, 0x73, 0x68, 0x2e, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x62, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xca, 0x02, 0x2a, 0x48, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73,
	0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5c, 0x50, 0x62, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xe2, 0x02, 0x36, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5c, 0x50, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea,
	0x02, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x3a, 0x3a, 0x4d, 0x65, 0x73, 0x68, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x3a, 0x3a, 0x50, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescOnce sync.Once
	file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescData = file_pbmesh_v2beta1_pbproxystate_route_proto_rawDesc
)

func file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescGZIP() []byte {
	file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescOnce.Do(func() {
		file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescData = protoimpl.X.CompressGZIP(file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescData)
	})
	return file_pbmesh_v2beta1_pbproxystate_route_proto_rawDescData
}

var file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_pbmesh_v2beta1_pbproxystate_route_proto_goTypes = []interface{}{
	(*Route)(nil),                      // 0: hashicorp.consul.mesh.v2beta1.pbproxystate.Route
	(*VirtualHost)(nil),                // 1: hashicorp.consul.mesh.v2beta1.pbproxystate.VirtualHost
	(*RouteRule)(nil),                  // 2: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteRule
	(*RouteMatch)(nil),                 // 3: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteMatch
	(*PathMatch)(nil),                  // 4: hashicorp.consul.mesh.v2beta1.pbproxystate.PathMatch
	(*QueryParameterMatch)(nil),        // 5: hashicorp.consul.mesh.v2beta1.pbproxystate.QueryParameterMatch
	(*HeaderMatch)(nil),                // 6: hashicorp.consul.mesh.v2beta1.pbproxystate.HeaderMatch
	(*RouteDestination)(nil),           // 7: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteDestination
	(*DestinationConfiguration)(nil),   // 8: hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationConfiguration
	(*RetryPolicy)(nil),                // 9: hashicorp.consul.mesh.v2beta1.pbproxystate.RetryPolicy
	(*TimeoutConfig)(nil),              // 10: hashicorp.consul.mesh.v2beta1.pbproxystate.TimeoutConfig
	(*LoadBalancerHashPolicy)(nil),     // 11: hashicorp.consul.mesh.v2beta1.pbproxystate.LoadBalancerHashPolicy
	(*CookiePolicy)(nil),               // 12: hashicorp.consul.mesh.v2beta1.pbproxystate.CookiePolicy
	(*HeaderPolicy)(nil),               // 13: hashicorp.consul.mesh.v2beta1.pbproxystate.HeaderPolicy
	(*QueryParameterPolicy)(nil),       // 14: hashicorp.consul.mesh.v2beta1.pbproxystate.QueryParameterPolicy
	(*ConnectionPropertiesPolicy)(nil), // 15: hashicorp.consul.mesh.v2beta1.pbproxystate.ConnectionPropertiesPolicy
	(*HeaderMutation)(nil),             // 16: hashicorp.consul.mesh.v2beta1.pbproxystate.HeaderMutation
	(*DestinationCluster)(nil),         // 17: hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationCluster
	(*L7WeightedClusterGroup)(nil),     // 18: hashicorp.consul.mesh.v2beta1.pbproxystate.L7WeightedClusterGroup
	(*wrapperspb.BoolValue)(nil),       // 19: google.protobuf.BoolValue
	(*wrapperspb.UInt32Value)(nil),     // 20: google.protobuf.UInt32Value
	(*durationpb.Duration)(nil),        // 21: google.protobuf.Duration
}
var file_pbmesh_v2beta1_pbproxystate_route_proto_depIdxs = []int32{
	1,  // 0: hashicorp.consul.mesh.v2beta1.pbproxystate.Route.virtual_hosts:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.VirtualHost
	16, // 1: hashicorp.consul.mesh.v2beta1.pbproxystate.VirtualHost.header_mutations:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.HeaderMutation
	2,  // 2: hashicorp.consul.mesh.v2beta1.pbproxystate.VirtualHost.route_rules:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.RouteRule
	3,  // 3: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteRule.match:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.RouteMatch
	7,  // 4: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteRule.destination:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.RouteDestination
	16, // 5: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteRule.header_mutations:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.HeaderMutation
	4,  // 6: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteMatch.path_match:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.PathMatch
	6,  // 7: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteMatch.header_matches:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.HeaderMatch
	5,  // 8: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteMatch.query_parameter_matches:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.QueryParameterMatch
	17, // 9: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteDestination.cluster:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationCluster
	18, // 10: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteDestination.weighted_clusters:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.L7WeightedClusterGroup
	8,  // 11: hashicorp.consul.mesh.v2beta1.pbproxystate.RouteDestination.destination_configuration:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationConfiguration
	19, // 12: hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationConfiguration.auto_host_rewrite:type_name -> google.protobuf.BoolValue
	11, // 13: hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationConfiguration.hash_policies:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.LoadBalancerHashPolicy
	10, // 14: hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationConfiguration.timeout_config:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TimeoutConfig
	9,  // 15: hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationConfiguration.retry_policy:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.RetryPolicy
	20, // 16: hashicorp.consul.mesh.v2beta1.pbproxystate.RetryPolicy.num_retries:type_name -> google.protobuf.UInt32Value
	21, // 17: hashicorp.consul.mesh.v2beta1.pbproxystate.TimeoutConfig.timeout:type_name -> google.protobuf.Duration
	21, // 18: hashicorp.consul.mesh.v2beta1.pbproxystate.TimeoutConfig.idle_timeout:type_name -> google.protobuf.Duration
	12, // 19: hashicorp.consul.mesh.v2beta1.pbproxystate.LoadBalancerHashPolicy.cookie:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.CookiePolicy
	13, // 20: hashicorp.consul.mesh.v2beta1.pbproxystate.LoadBalancerHashPolicy.header:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.HeaderPolicy
	14, // 21: hashicorp.consul.mesh.v2beta1.pbproxystate.LoadBalancerHashPolicy.query_parameter:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.QueryParameterPolicy
	15, // 22: hashicorp.consul.mesh.v2beta1.pbproxystate.LoadBalancerHashPolicy.connection_properties:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.ConnectionPropertiesPolicy
	21, // 23: hashicorp.consul.mesh.v2beta1.pbproxystate.CookiePolicy.ttl:type_name -> google.protobuf.Duration
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_pbmesh_v2beta1_pbproxystate_route_proto_init() }
func file_pbmesh_v2beta1_pbproxystate_route_proto_init() {
	if File_pbmesh_v2beta1_pbproxystate_route_proto != nil {
		return
	}
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_init()
	file_pbmesh_v2beta1_pbproxystate_header_mutations_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Route); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VirtualHost); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PathMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryParameterMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeaderMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeoutConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadBalancerHashPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CookiePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeaderPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryParameterPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionPropertiesPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*PathMatch_Exact)(nil),
		(*PathMatch_Prefix)(nil),
		(*PathMatch_Regex)(nil),
	}
	file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*QueryParameterMatch_Exact)(nil),
		(*QueryParameterMatch_Regex)(nil),
		(*QueryParameterMatch_Present)(nil),
	}
	file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*HeaderMatch_Exact)(nil),
		(*HeaderMatch_Prefix)(nil),
		(*HeaderMatch_Suffix)(nil),
		(*HeaderMatch_Regex)(nil),
		(*HeaderMatch_Present)(nil),
	}
	file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*RouteDestination_Cluster)(nil),
		(*RouteDestination_WeightedClusters)(nil),
	}
	file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*LoadBalancerHashPolicy_Cookie)(nil),
		(*LoadBalancerHashPolicy_Header)(nil),
		(*LoadBalancerHashPolicy_QueryParameter)(nil),
		(*LoadBalancerHashPolicy_ConnectionProperties)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pbmesh_v2beta1_pbproxystate_route_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pbmesh_v2beta1_pbproxystate_route_proto_goTypes,
		DependencyIndexes: file_pbmesh_v2beta1_pbproxystate_route_proto_depIdxs,
		MessageInfos:      file_pbmesh_v2beta1_pbproxystate_route_proto_msgTypes,
	}.Build()
	File_pbmesh_v2beta1_pbproxystate_route_proto = out.File
	file_pbmesh_v2beta1_pbproxystate_route_proto_rawDesc = nil
	file_pbmesh_v2beta1_pbproxystate_route_proto_goTypes = nil
	file_pbmesh_v2beta1_pbproxystate_route_proto_depIdxs = nil
}
