/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// EsmGet esmGet is a command that gets the value and interal details of a secret from an External Secrets Manager
type EsmGet struct {
	// Name of the External Secrets Manager item
	EsmName string `json:"esm-name"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The secret id (or name, for AWS, Azure or K8s targets) to get from the External Secrets Manager
	SecretId string `json:"secret-id"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewEsmGet instantiates a new EsmGet object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEsmGet(esmName string, secretId string, ) *EsmGet {
	this := EsmGet{}
	this.EsmName = esmName
	var json bool = false
	this.Json = &json
	this.SecretId = secretId
	return &this
}

// NewEsmGetWithDefaults instantiates a new EsmGet object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEsmGetWithDefaults() *EsmGet {
	this := EsmGet{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetEsmName returns the EsmName field value
func (o *EsmGet) GetEsmName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EsmName
}

// GetEsmNameOk returns a tuple with the EsmName field value
// and a boolean to check if the value has been set.
func (o *EsmGet) GetEsmNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EsmName, true
}

// SetEsmName sets field value
func (o *EsmGet) SetEsmName(v string) {
	o.EsmName = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *EsmGet) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmGet) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *EsmGet) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *EsmGet) SetJson(v bool) {
	o.Json = &v
}

// GetSecretId returns the SecretId field value
func (o *EsmGet) GetSecretId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SecretId
}

// GetSecretIdOk returns a tuple with the SecretId field value
// and a boolean to check if the value has been set.
func (o *EsmGet) GetSecretIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SecretId, true
}

// SetSecretId sets field value
func (o *EsmGet) SetSecretId(v string) {
	o.SecretId = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *EsmGet) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmGet) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *EsmGet) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *EsmGet) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *EsmGet) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmGet) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *EsmGet) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *EsmGet) SetUidToken(v string) {
	o.UidToken = &v
}

func (o EsmGet) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["esm-name"] = o.EsmName
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["secret-id"] = o.SecretId
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableEsmGet struct {
	value *EsmGet
	isSet bool
}

func (v NullableEsmGet) Get() *EsmGet {
	return v.value
}

func (v *NullableEsmGet) Set(val *EsmGet) {
	v.value = val
	v.isSet = true
}

func (v NullableEsmGet) IsSet() bool {
	return v.isSet
}

func (v *NullableEsmGet) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEsmGet(val *EsmGet) *NullableEsmGet {
	return &NullableEsmGet{value: val, isSet: true}
}

func (v NullableEsmGet) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEsmGet) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


