/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import org.apache.xerces.utils.StringPool;

public class XMLContentSpec {
    public static final int CONTENTSPECNODE_LEAF = 0;
    public static final int CONTENTSPECNODE_ZERO_OR_ONE = 1;
    public static final int CONTENTSPECNODE_ZERO_OR_MORE = 2;
    public static final int CONTENTSPECNODE_ONE_OR_MORE = 3;
    public static final int CONTENTSPECNODE_CHOICE = 4;
    public static final int CONTENTSPECNODE_SEQ = 5;
    public static final int CONTENTSPECNODE_ANY = 6;
    public static final int CONTENTSPECNODE_ANY_OTHER = 7;
    public static final int CONTENTSPECNODE_ANY_LOCAL = 8;
    public int type;
    public int value;
    public int otherValue;

    public XMLContentSpec() {
        this.clear();
    }

    public XMLContentSpec(int n, int n2, int n3) {
        this.setValues(n, n2, n3);
    }

    public XMLContentSpec(Provider provider, int n) {
        this.setValues(provider, n);
    }

    public XMLContentSpec(XMLContentSpec xMLContentSpec) {
        this.setValues(xMLContentSpec);
    }

    private static void appendContentSpec(Provider provider, StringPool stringPool, XMLContentSpec xMLContentSpec, StringBuffer stringBuffer, boolean bl) {
        switch (xMLContentSpec.type) {
            case 0: {
                if (xMLContentSpec.value == -1 && xMLContentSpec.otherValue == -1) {
                    stringBuffer.append("#PCDATA");
                    break;
                }
                if (xMLContentSpec.value == -1 && xMLContentSpec.otherValue != -1) {
                    stringBuffer.append("##any:uri=" + stringPool.toString(xMLContentSpec.otherValue));
                    break;
                }
                if (xMLContentSpec.value == -1) {
                    stringBuffer.append("##any");
                    break;
                }
                stringBuffer.append(stringPool.toString(xMLContentSpec.value));
                break;
            }
            case 1: {
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                XMLContentSpec.appendContentSpec(provider, stringPool, xMLContentSpec, stringBuffer, true);
                stringBuffer.append('?');
                break;
            }
            case 2: {
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                XMLContentSpec.appendContentSpec(provider, stringPool, xMLContentSpec, stringBuffer, true);
                stringBuffer.append('*');
                break;
            }
            case 3: {
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                XMLContentSpec.appendContentSpec(provider, stringPool, xMLContentSpec, stringBuffer, true);
                stringBuffer.append('+');
                break;
            }
            case 4: 
            case 5: {
                if (bl) {
                    stringBuffer.append('(');
                }
                int n = xMLContentSpec.type;
                int n2 = xMLContentSpec.otherValue;
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                XMLContentSpec.appendContentSpec(provider, stringPool, xMLContentSpec, stringBuffer, xMLContentSpec.type != n);
                if (n == 4) {
                    stringBuffer.append('|');
                } else {
                    stringBuffer.append(',');
                }
                provider.getContentSpec(n2, xMLContentSpec);
                XMLContentSpec.appendContentSpec(provider, stringPool, xMLContentSpec, stringBuffer, true);
                if (!bl) break;
                stringBuffer.append(')');
                break;
            }
            case 6: {
                stringBuffer.append("##any");
                if (xMLContentSpec.otherValue == -1) break;
                stringBuffer.append(":uri=");
                stringBuffer.append(stringPool.toString(xMLContentSpec.otherValue));
                break;
            }
            case 7: {
                stringBuffer.append("##other:uri=");
                stringBuffer.append(stringPool.toString(xMLContentSpec.otherValue));
                break;
            }
            case 8: {
                stringBuffer.append("##local");
                break;
            }
            default: {
                stringBuffer.append("???");
            }
        }
    }

    public void clear() {
        this.type = -1;
        this.value = -1;
        this.otherValue = -1;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof XMLContentSpec) {
            XMLContentSpec xMLContentSpec = (XMLContentSpec)object;
            return this.type == xMLContentSpec.type && this.value == xMLContentSpec.value && this.otherValue == xMLContentSpec.otherValue;
        }
        return false;
    }

    public int hashCode() {
        return this.type << 16 | this.value << 8 | this.otherValue;
    }

    public void setValues(int n, int n2, int n3) {
        this.type = n;
        this.value = n2;
        this.otherValue = n3;
    }

    public void setValues(Provider provider, int n) {
        if (!provider.getContentSpec(n, this)) {
            this.clear();
        }
    }

    public void setValues(XMLContentSpec xMLContentSpec) {
        this.type = xMLContentSpec.type;
        this.value = xMLContentSpec.value;
        this.otherValue = xMLContentSpec.otherValue;
    }

    public static String toString(Provider provider, StringPool stringPool, int n) {
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        if (provider.getContentSpec(n, xMLContentSpec)) {
            StringBuffer stringBuffer = new StringBuffer();
            switch (xMLContentSpec.type) {
                case 0: {
                    stringBuffer.append('(');
                    if (xMLContentSpec.value == -1 && xMLContentSpec.otherValue == -1) {
                        stringBuffer.append("#PCDATA");
                    } else if (xMLContentSpec.otherValue != -1) {
                        stringBuffer.append("##any:uri=" + stringPool.toString(xMLContentSpec.otherValue));
                    } else if (xMLContentSpec.value == -1) {
                        stringBuffer.append("##any");
                    } else {
                        stringBuffer.append(stringPool.toString(xMLContentSpec.value));
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 1: {
                    provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                    if (xMLContentSpec.type == 0) {
                        stringBuffer.append('(');
                        stringBuffer.append(stringPool.toString(xMLContentSpec.value));
                        stringBuffer.append(')');
                    } else {
                        XMLContentSpec.appendContentSpec(provider, stringPool, xMLContentSpec, stringBuffer, true);
                    }
                    stringBuffer.append('?');
                    break;
                }
                case 2: {
                    provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                    if (xMLContentSpec.type == 0) {
                        stringBuffer.append('(');
                        if (xMLContentSpec.value == -1 && xMLContentSpec.otherValue == -1) {
                            stringBuffer.append("#PCDATA");
                        } else if (xMLContentSpec.otherValue != -1) {
                            stringBuffer.append("##any:uri=" + stringPool.toString(xMLContentSpec.otherValue));
                        } else if (xMLContentSpec.value == -1) {
                            stringBuffer.append("##any");
                        } else {
                            stringBuffer.append(stringPool.toString(xMLContentSpec.value));
                        }
                        stringBuffer.append(')');
                    } else {
                        XMLContentSpec.appendContentSpec(provider, stringPool, xMLContentSpec, stringBuffer, true);
                    }
                    stringBuffer.append('*');
                    break;
                }
                case 3: {
                    provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                    if (xMLContentSpec.type == 0) {
                        stringBuffer.append('(');
                        if (xMLContentSpec.value == -1 && xMLContentSpec.otherValue == -1) {
                            stringBuffer.append("#PCDATA");
                        } else if (xMLContentSpec.otherValue != -1) {
                            stringBuffer.append("##any:uri=" + stringPool.toString(xMLContentSpec.otherValue));
                        } else if (xMLContentSpec.value == -1) {
                            stringBuffer.append("##any");
                        } else {
                            stringBuffer.append(stringPool.toString(xMLContentSpec.value));
                        }
                        stringBuffer.append(')');
                    } else {
                        XMLContentSpec.appendContentSpec(provider, stringPool, xMLContentSpec, stringBuffer, true);
                    }
                    stringBuffer.append('+');
                    break;
                }
                case 4: 
                case 5: {
                    XMLContentSpec.appendContentSpec(provider, stringPool, xMLContentSpec, stringBuffer, true);
                    break;
                }
                case 6: {
                    stringBuffer.append("##any");
                    if (xMLContentSpec.otherValue == -1) break;
                    stringBuffer.append(":uri=");
                    stringBuffer.append(stringPool.toString(xMLContentSpec.otherValue));
                    break;
                }
                case 7: {
                    stringBuffer.append("##other:uri=");
                    stringBuffer.append(stringPool.toString(xMLContentSpec.otherValue));
                    break;
                }
                case 8: {
                    stringBuffer.append("##local");
                    break;
                }
                default: {
                    stringBuffer.append("???");
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static interface Provider {
        public boolean getContentSpec(int var1, XMLContentSpec var2);
    }
}

