/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "callbacks.h"

/*
 * And the code needed to parse it
 */
static xmlPurchasePtr
parsePurchase(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {
    xmlPurchasePtr ret = NULL;

    /*
     * allocate the struct
     */
    ret = (xmlPurchasePtr) g_malloc(sizeof(xmlPurchase));
    if (ret == NULL) {
        fprintf(stderr,"out of memory\n");
	return(NULL);
    }

	memset(ret, '\0', sizeof(xmlPurchase));
	
	if ((!xmlStrcmp(cur->name, (const xmlChar *)"purchase")) && (cur->ns == ns)) {
		ret->date         = xmlGetProp(cur, (const xmlChar *) "date");
		ret->qty          = xmlGetProp(cur, (const xmlChar *) "qty");
		ret->price        = xmlGetProp(cur, (const xmlChar *) "price");
		ret->supplier     = xmlGetProp(cur, (const xmlChar *) "supplier");
		ret->supplierAdr  = xmlGetProp(cur, (const xmlChar *) "supplierAdr");
	}

    return(ret);
}

/*
 * and to print it
 */
static void
printPurchase(xmlPurchasePtr cur) {

    if (cur == NULL) return;
    if (cur->date)    printf("	date       : %s\n", cur->date);
    if (cur->qty)     printf("	qty        : %s\n", cur->qty);
    if (cur->price)   printf("	price      : %s\n", cur->price);
    if (cur->supplier)   printf("	supplier   : %s\n", cur->supplier);
    if (cur->supplierAdr) printf("	supplierAdr: %s\n", cur->supplierAdr);
    printf("\n");

    return;
}

/*
 * And the code needed to parse it
 */
static xmlDrinkingPtr
parseDrinking(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {
    xmlDrinkingPtr ret = NULL;

    /*
     * allocate the struct
     */
    ret = (xmlDrinkingPtr) g_malloc(sizeof(xmlDrinking));
    if (ret == NULL) {
        fprintf(stderr,"out of memory\n");
	return(NULL);
    }
    memset(ret, '\0', sizeof(xmlDrinking));

    if ((!xmlStrcmp(cur->name, (const xmlChar *)"drinking")) && (cur->ns == ns)) {
		ret->date       = xmlGetProp(cur, (const xmlChar *) "date");
		ret->qty        = xmlGetProp(cur, (const xmlChar *) "qty");
		ret->rated      = xmlGetProp(cur, (const xmlChar *) "rated");
		ret->comment    = xmlGetProp(cur, (const xmlChar *) "comment");
		ret->DSid       = xmlGetProp(cur, (const xmlChar *) "degustationSheetId");
     }

    return(ret);
}

/*
 * and to print it
 */
static void
printDrinking(xmlDrinkingPtr cur) {

    if (cur == NULL) return;
    if (cur->date)    printf("	date   : %s\n", cur->date);
    if (cur->qty)     printf("	qty    : %s\n", cur->qty);
    if (cur->rated)   printf("	rated  : %s\n", cur->rated);
    if (cur->comment) printf("	comment: %s\n", cur->comment);
    if (cur->DSid)    printf("	DSid   : %s\n", cur->DSid);

    printf("\n");
}


/*
 * the code needed to parse a xmlRack
 */
static xmlRacksPtr
parseRacks(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {
    xmlRacksPtr ret = NULL;


    /*
     * allocate the struct
     */
    ret = (xmlRacksPtr) g_malloc(sizeof(xmlRacks));
    if (ret == NULL) {
        fprintf(stderr,"out of memory\n");
	return(NULL);
    }
    memset(ret, '\0', sizeof(xmlRacks));

    if ((!xmlStrcmp(cur->name, (const xmlChar *)"rack")) && (cur->ns == ns)) {
		ret->rackNb = xmlGetProp(cur, (const xmlChar *) "rackNb");
		if (ret->rackNb == NULL) fprintf(stderr, "location has no rackNb\n");
		ret->row = xmlGetProp(cur, (const xmlChar *) "row");
		if (ret->row == NULL)	fprintf(stderr, "location has no row\n");
		ret->column = xmlGetProp(cur, (const xmlChar *) "column");
		if (ret->column == NULL) fprintf(stderr, "location has no column\n");
	}

    return(ret);
}

/*
 * and to print it
 */
static void
printRacks(xmlRacksPtr cur) {


    if (cur == NULL) return;
    if (cur->rackNb) printf("	rackNb  : %s\n", cur->rackNb);
    if (cur->row)    printf("	row     : %s\n", cur->row);
    if (cur->column) printf("	column  : %s\n", cur->column);
    printf("\n");


    return;
}

/*
 * the code need to print a wine
 */
void
printWine(xmlWinePtr cur) {
    gint i;


    if (cur == NULL) return;
    printf("=======  Wine\n");
    if (cur->country != NULL)                 	printf("country                 : %s\n", cur->country);
    if (cur->region != NULL)                  	printf("region                  : %s\n", cur->region);
    if (cur->appellation != NULL)             	printf("appellation             : %s\n", cur->appellation);
    if (cur->domain != NULL)                  	printf("domain                  : %s\n", cur->domain);
    if (cur->vintage != NULL)                 	printf("vintage                 : %s\n", cur->vintage);
    if (cur->color != NULL)                   	printf("color                   : %s\n", cur->color);
    if (cur->wineMaker != NULL)               	printf("wineMaker               : %s\n", cur->wineMaker);
    if (cur->wineMakerAdr != NULL)            	printf("wineMakerAdr            : %s\n", cur->wineMakerAdr);
    if (cur->cepage != NULL)                  	printf("cepage                  : %s\n", cur->cepage);
    if (cur->potentielDeGarde != NULL)        	printf("potentielDeGarde        : %s\n", cur->potentielDeGarde);
    if (cur->temperatureDeDegustation != NULL)	printf("temperatureDeDegustation: %s\n", cur->temperatureDeDegustation);
    printf("%d xmlRacks\n", cur->nbRacks);
    for (i = 0;i < cur->nbRacks;i++) printRacks(cur->xmlRacks[i]);
	printf("%d xmlPurchase\n", cur->nbPurchase);
    for (i = 0;i < cur->nbPurchase;i++) printPurchase(cur->xmlPurchase[i]);
    printf("%d xmlDrinking\n", cur->nbDrinking);
    for (i = 0;i < cur->nbDrinking;i++) printDrinking(cur->xmlDrinking[i]);
    if (cur->comment != NULL)                   printf("commentaire		: %s\n", cur->comment);
    if (cur->rated != NULL)                     printf("rated			: %s\n", cur->rated);
    printf("======= \n");


    return;
}

/*
 * the code needed to parse a wine
 */
static xmlDegustationPtr
parseDegustation(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {

    xmlDegustationPtr	ret = NULL;


    /*
     * allocate the struct
     */
    if ( (ret = (xmlDegustationPtr) g_malloc(sizeof(xmlDegustation))) == NULL) {
        fprintf(stderr,"out of memory\n");
	return(NULL);
    }

    memset(ret, '\0', sizeof(xmlDegustation));

    /* We don't care what the top level element name is */
    cur = cur->xmlChildrenNode;
    while (cur != NULL) {
        if ((!xmlStrcmp(cur->name, (const xmlChar *) "degustationSheetId")) && (cur->ns == ns))
		ret->degustation_sheet_id = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
        if ((!xmlStrcmp(cur->name, (const xmlChar *) "comment")) && (cur->ns == ns))
		ret->comment = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);

	if ((!xmlStrcmp(cur->name, (const xmlChar *) "domain")) && (cur->ns == ns))
		ret->domain = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "region")) && (cur->ns == ns))
		ret->region = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "appellation")) && (cur->ns == ns))
		ret->appellation = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "vintage")) && (cur->ns == ns))
		ret->vintage = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "color")) && (cur->ns == ns))
		ret->color = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "degree")) && (cur->ns == ns))
		ret->degree = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "producer")) && (cur->ns == ns))
		ret->producer = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);

	if ((!xmlStrcmp(cur->name, (const xmlChar *) "depthHscale")) && (cur->ns == ns))
		ret->depth_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "depthText")) && (cur->ns == ns))
		ret->depth_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "tintHscale")) && (cur->ns == ns))
		ret->tint_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "tintText")) && (cur->ns == ns))
		ret->tint_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "sosHscale")) && (cur->ns == ns))
		ret->sos_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "sosText")) && (cur->ns == ns))
		ret->sos_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "floralHscale")) && (cur->ns == ns))
		ret->floral_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "floralText")) && (cur->ns == ns))
		ret->floral_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "fruityHscale")) && (cur->ns == ns))
		ret->fruity_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "fruityText")) && (cur->ns == ns))
		ret->fruity_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "vegetableHscale")) && (cur->ns == ns))
		ret->vegetable_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "vegetableText")) && (cur->ns == ns))
		ret->vegetable_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "chemicalHscale")) && (cur->ns == ns))
		ret->chemical_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "chemicalText")) && (cur->ns == ns))
		ret->chemical_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "balsamHscale")) && (cur->ns == ns))
		ret->balsam_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "balsamText")) && (cur->ns == ns))
		ret->balsam_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "spicyHscale")) && (cur->ns == ns))
		ret->spicy_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "spicyText")) && (cur->ns == ns))
		ret->spicy_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "woodedHscale")) && (cur->ns == ns))
		ret->wooded_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "woodedText")) && (cur->ns == ns))
		ret->wooded_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "animalHscale")) && (cur->ns == ns))
		ret->animal_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "animalText")) && (cur->ns == ns))
		ret->animal_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "otherHscale")) && (cur->ns == ns))
		ret->other_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "otherText")) && (cur->ns == ns))
		ret->other_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "balsamHscale")) && (cur->ns == ns))
		ret->balsam_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "balsamText")) && (cur->ns == ns))
		ret->balsam_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "complexityHscale")) && (cur->ns == ns))
		ret->complexity_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);

	if ((!xmlStrcmp(cur->name, (const xmlChar *) "acidityHscale")) && (cur->ns == ns))
		ret->acidity_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "acidityText")) && (cur->ns == ns))
		ret->acidity_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "mellowHscale")) && (cur->ns == ns))
		ret->mellow_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "mellowText")) && (cur->ns == ns))
		ret->mellow_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "bitternessHscale")) && (cur->ns == ns))
		ret->bitterness_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "bitternessText")) && (cur->ns == ns))
		ret->bitterness_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "alcoholHscale")) && (cur->ns == ns))
		ret->alcohol_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "alcoholText")) && (cur->ns == ns))
		ret->alcohol_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "chewingHscale")) && (cur->ns == ns))
		ret->chewing_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "chewingText")) && (cur->ns == ns))
		ret->chewing_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "astringencyHscale")) && (cur->ns == ns))
		ret->astringency_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "astringencyText")) && (cur->ns == ns))
		ret->astringency_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);


	if ((!xmlStrcmp(cur->name, (const xmlChar *) "dbnText")) && (cur->ns == ns))
		ret->dbn_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "persistencyHscale")) && (cur->ns == ns))
		ret->persistency_hscale = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "persistencyText")) && (cur->ns == ns))
		ret->persistency_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "defaultText")) && (cur->ns == ns))
		ret->default_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "globalRateSpinbutton")) && (cur->ns == ns))
		ret->global_rate_spinbutton = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "maturitySpinbutton")) && (cur->ns == ns))
		ret->maturity_spinbutton = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "worthKeepingSpinbutton")) && (cur->ns == ns))
		ret->worth_keeping_spinbutton = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "dishText")) && (cur->ns == ns))
		ret->dish_text = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);

	cur = cur->next;
    }

    /* 
     * xml format to list_stock format expected later
     */
    ptrDegustation_sheet       tmp_pds;
    xmlChar		      *tmp;

    if ( ( tmp_pds = g_malloc (sizeof (degustation_sheet))) == NULL ) {
       fprintf (stderr, ":%s:Probleme allocation memoire.\n",__FUNCTION__);
       exit (-1);
    }

    memset(tmp_pds, '\0',  sizeof (degustation_sheet));

    /*
     * DEGUSTATION SHEET ID FRAME
     */
    tmp_pds->degustation_sheet_id = atoi((gchar *)ret->degustation_sheet_id);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->comment)) != NULL) {
      strncpy (tmp_pds->comment, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    /*
     * WINE INFORMATION FRAME
     */
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->domain)) != NULL) {
      strncpy (tmp_pds->domain, (gchar *)tmp, domain_size);
      xmlFree(tmp);
    }
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->region)) != NULL) {
      strncpy (tmp_pds->region, (gchar *)tmp, region_size);
      xmlFree(tmp);
    }
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->appellation)) != NULL) {
      strncpy (tmp_pds->appellation, (gchar *)tmp, appellation_size);
      xmlFree(tmp);
    }
    tmp_pds->vintage = atoi((gchar *)ret->vintage);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->color)) != NULL) {
      strncpy (tmp_pds->color, (gchar *)tmp, color_size);
      xmlFree(tmp);
    }
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->degree)) != NULL) {
      strncpy (tmp_pds->degree, (gchar *)tmp, degree_size);
      xmlFree(tmp);
    }
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->producer)) != NULL) {
      strncpy (tmp_pds->producer, (gchar *)tmp, producer_size);
      xmlFree(tmp);
    }

    /*
     * VISUAL OR COLOR FRAME
     */
    tmp_pds->depth_hscale = atoi((gchar *)ret->depth_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->depth_text)) != NULL) {
      strncpy (tmp_pds->depth_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->tint_hscale = atoi((gchar *)ret->tint_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->tint_text)) != NULL) {
      strncpy (tmp_pds->tint_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    /*
     * OLFACTIVE FRAME
     */
    tmp_pds->sos_hscale = atoi((gchar *)ret->sos_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->sos_text)) != NULL) {
      strncpy (tmp_pds->sos_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->floral_hscale = atoi((gchar *)ret->floral_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->floral_text)) != NULL) {
      strncpy (tmp_pds->floral_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->fruity_hscale = atoi((gchar *)ret->fruity_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->fruity_text)) != NULL) {
      strncpy (tmp_pds->fruity_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->vegetable_hscale = atoi((gchar *)ret->vegetable_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->vegetable_text)) != NULL) {
      strncpy (tmp_pds->vegetable_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->chemical_hscale = atoi((gchar *)ret->chemical_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->chemical_text)) != NULL) {
      strncpy (tmp_pds->chemical_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->balsam_hscale = atoi((gchar *)ret->balsam_hscale);             

    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->balsam_text)) != NULL) {
      strncpy (tmp_pds->balsam_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }


    tmp_pds->spicy_hscale = atoi((gchar *)ret->spicy_hscale);             

    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->spicy_text)) != NULL) {
      strncpy (tmp_pds->spicy_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->wooded_hscale = atoi((gchar *)ret->wooded_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->wooded_text)) != NULL) {
      strncpy (tmp_pds->wooded_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->animal_hscale = atoi((gchar *)ret->animal_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->animal_text)) != NULL) {
      strncpy (tmp_pds->animal_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->other_hscale = atoi((gchar *)ret->other_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->other_text)) != NULL) {
      strncpy (tmp_pds->other_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->complexity_hscale = atoi((gchar *)ret->complexity_hscale);             

    /*
     * GUSTATIVE (MOUTH) FRAME
     */
    tmp_pds->acidity_hscale = atoi((gchar *)ret->acidity_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->acidity_text)) != NULL) {
      strncpy (tmp_pds->acidity_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->mellow_hscale = atoi((gchar *)ret->mellow_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->mellow_text)) != NULL) {
      strncpy (tmp_pds->mellow_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->bitterness_hscale = atoi((gchar *)ret->bitterness_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->bitterness_text)) != NULL) {
      strncpy (tmp_pds->bitterness_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->alcohol_hscale = atoi((gchar *)ret->alcohol_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->alcohol_text)) != NULL) {
      strncpy (tmp_pds->alcohol_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->chewing_hscale = atoi((gchar *)ret->chewing_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->chewing_text)) != NULL) {
      strncpy (tmp_pds->chewing_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->astringency_hscale = atoi((gchar *)ret->astringency_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->astringency_text)) != NULL) {
      strncpy (tmp_pds->astringency_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    /*
     * BALANCE FRAME
     */
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->dbn_text)) != NULL) {
      strncpy (tmp_pds->dbn_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->persistency_hscale = atoi((gchar *)ret->persistency_hscale);             
    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->persistency_text)) != NULL) {
      strncpy (tmp_pds->persistency_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->default_text)) != NULL) {
      strncpy (tmp_pds->default_text, (gchar *)tmp, 80);
      xmlFree(tmp);
    }

    tmp_pds->global_rate_spinbutton = atoi((gchar *)ret->global_rate_spinbutton);             
    tmp_pds->maturity_spinbutton = atoi((gchar *)ret->maturity_spinbutton);             
    tmp_pds->worth_keeping_spinbutton = atoi((gchar *)ret->worth_keeping_spinbutton);             

    if ((tmp = xcave_isolat1toUtf8((gchar *)ret->dish_text)) != NULL) {
      strncpy (tmp_pds->dish_text, (gchar *)tmp, 400);
      xmlFree(tmp);
    }

    list_full_ds = g_list_append(list_full_ds ,tmp_pds);
    list_ds = NULL;

    xcave_debug_int(__FULL__,"worth_keeping_spinbutton",tmp_pds->worth_keeping_spinbutton);

    return(ret);

}


/*
 * the code needed to parse a wine
 */
static xmlWinePtr
parseWine(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {
    xmlWinePtr	ret = NULL;

    /*
     * allocate the struct
     */
    ret = (xmlWinePtr) g_malloc(sizeof(xmlWine));
    if (ret == NULL) {
        fprintf(stderr,"out of memory\n");
	return(NULL);
    }
    memset(ret, '\0', sizeof(xmlWine));

    ret->nbRacks    = 0;
    ret->nbPurchase = 0;
    ret->nbDrinking = 0;

    /* We don't care what the top level element name is */
    cur = cur->xmlChildrenNode;
    while (cur != NULL) {
        if ((!xmlStrcmp(cur->name, (const xmlChar *) "country")) && (cur->ns == ns))
		ret->country = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "region")) && (cur->ns == ns))
		ret->region = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "appellation")) && (cur->ns == ns))
		ret->appellation = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "domain")) && (cur->ns == ns))
		ret->domain = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "vintage")) && (cur->ns == ns))
		ret->vintage = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "color")) && (cur->ns == ns))
		ret->color = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "wineMaker")) && (cur->ns == ns))
		ret->wineMaker = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "wineMakerAddress")) && (cur->ns == ns))
		ret->wineMakerAdr = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "cepage")) && (cur->ns == ns))
		ret->cepage = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "potentielDeGarde")) && (cur->ns == ns))
		ret->potentielDeGarde = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "temperatureDeDegustation")) && (cur->ns == ns))
		ret->temperatureDeDegustation = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "rack")) && (cur->ns == ns))
		ret->xmlRacks[ret->nbRacks++] = parseRacks(doc, ns, cur);
        if ((!xmlStrcmp(cur->name, (const xmlChar *) "purchase")) && (cur->ns == ns))
		ret->xmlPurchase[ret->nbPurchase++] = parsePurchase(doc, ns, cur);
        if ((!xmlStrcmp(cur->name, (const xmlChar *) "drinking")) && (cur->ns == ns))
		ret->xmlDrinking[ret->nbDrinking++] = parseDrinking(doc, ns, cur);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "comment")) && (cur->ns == ns))
		ret->comment = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	if ((!xmlStrcmp(cur->name, (const xmlChar *) "rated")) && (cur->ns == ns))
		ret->rated = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
	cur = cur->next;
    }

    /* 
     * xml format to list_stock format expected later
     */
    ptrVin           tmp_pVin;
    xmlChar		*tmp;

    if ( ( tmp_pVin = g_malloc (sizeof (Vin))) == NULL ) {
       fprintf (stderr, "Probleme allocation memoire.\n");
       exit (-1);
    }

    memset(tmp_pVin, '\0',  sizeof (Vin));

    tmp = xcave_isolat1toUtf8((gchar *)ret->country);
    if (tmp != NULL) {
		strncpy (tmp_pVin->country,	(gchar *)tmp, country_size);
		xmlFree(tmp);
	}

    tmp = xcave_isolat1toUtf8((gchar *)ret->region);
    if (tmp != NULL) {
		strncpy (tmp_pVin->Region,	(gchar *)tmp, region_size);
		xmlFree(tmp);
	}

    tmp = xcave_isolat1toUtf8((gchar *)ret->appellation);
    if (tmp != NULL) {
		strncpy (tmp_pVin->Appellation,	(gchar *)tmp, appellation_size);                   
		xmlFree(tmp);
	}

    tmp = xcave_isolat1toUtf8((gchar *)ret->domain);
    if (tmp != NULL) {
		strncpy (tmp_pVin->Nom, (gchar *)tmp, domain_size);                   
		xmlFree(tmp);
	}

    tmp_pVin->vintage = atoi((gchar *)ret->vintage);             

    tmp = xcave_isolat1toUtf8((gchar *)ret->color);
    if (tmp != NULL) {
		strncpy (tmp_pVin->color, (gchar *)tmp, color_size);
		xmlFree(tmp);
	}
	
    tmp = xcave_isolat1toUtf8((gchar *)ret->wineMaker);
    if (tmp != NULL) {
		strncpy (tmp_pVin->supplier, (gchar *)tmp, supplier_size);
		xmlFree(tmp);
	}

    tmp = xcave_isolat1toUtf8((gchar *)ret->wineMakerAdr);
    if (tmp != NULL) {
		strncpy (tmp_pVin->wineMakerAdr, (gchar *)tmp, producerAdr_size); 
		xmlFree(tmp);
	}

    tmp = xcave_isolat1toUtf8((gchar *)ret->cepage);
    if (tmp != NULL) {
		strncpy (tmp_pVin->Cepage, (gchar *)tmp, cepage_size);
		xmlFree(tmp);
	}

    tmp_pVin->Conserv = atoi((gchar *)ret->potentielDeGarde);

    tmp = xcave_isolat1toUtf8((gchar *)ret->temperatureDeDegustation);
    if (tmp != NULL) {
		strncpy (tmp_pVin->temperatureDeDegustation, (gchar *)tmp, temperature_size);
		xmlFree(tmp);
	}

	/* 
	 * update purchase list
	 */
	gint i;
	for ( i = 0 ; i < ret->nbPurchase ; i++) {
		ptrPurchase  tmp_pPurchase;
		if ( ( tmp_pPurchase = g_malloc (sizeof (Purchase))) == NULL ) {
		   fprintf (stderr, "Probleme allocation memoire.\n");
		   exit (-1);
		}
	
		memset(tmp_pPurchase, '\0',  sizeof (Purchase));
	
		tmp_pPurchase->Achat = atoi((gchar *)ret->xmlPurchase[i]->date);
		tmp_pPurchase->qty   = atoi((gchar *)ret->xmlPurchase[i]->qty);
		tmp_pPurchase->Prix  = atof((gchar *)ret->xmlPurchase[i]->price);

		tmp = xcave_isolat1toUtf8((gchar *)ret->xmlPurchase[i]->supplier);
		if (tmp != NULL)
		
		if (tmp != NULL) {
		   strncpy (tmp_pPurchase->Supplier, (gchar *)tmp, supplier_size); 
		   xmlFree(tmp);
		}

		tmp = xcave_isolat1toUtf8((gchar *)ret->xmlPurchase[i]->supplierAdr);
		if (tmp != NULL) {
			strncpy (tmp_pPurchase->SupplierAdr, (gchar *)tmp, supplierAdr_size);                   
			xmlFree(tmp);
		}

		tmp_pVin->NbPurchase += tmp_pPurchase->qty;
	    tmp_pVin->list_purchase = g_list_append(tmp_pVin->list_purchase,tmp_pPurchase);
	}
	
	/*
	 * update drinking list
	 */
	for ( i = 0 ; i < ret->nbDrinking ; i++) {
		ptrDrinking  tmp_pDrinking;
		if ( ( tmp_pDrinking = g_malloc (sizeof (Drinking))) == NULL ) {
		   fprintf (stderr, "Probleme allocation memoire.\n");
		   exit (-1);
		}
	
		memset(tmp_pDrinking, '\0',  sizeof (Drinking));
	
		tmp_pDrinking->Conso = atoi((gchar *)ret->xmlDrinking[i]->date);
		tmp_pDrinking->qty   = atoi((gchar *)ret->xmlDrinking[i]->qty);

		tmp = xcave_isolat1toUtf8((gchar *)ret->xmlDrinking[i]->rated);
		if (tmp != NULL) {
			strncpy (tmp_pDrinking->Note, (gchar *)tmp, rated_size);                   
			xmlFree(tmp);
		}

		tmp = xcave_isolat1toUtf8((gchar *)ret->xmlDrinking[i]->comment);
		if (tmp != NULL) {
			strncpy (tmp_pDrinking->Commentaire, (gchar *)tmp, drinkingComment_size);                   
			xmlFree(tmp);
		}
		/*
		 * for compatibility with release before 2.3.0 where DSid data is unknown
		 */
		if (ret->xmlDrinking[i]->DSid != NULL)
		   tmp_pDrinking->degustation_sheet_id = atoi((gchar *)ret->xmlDrinking[i]->DSid);

		tmp_pVin->NbDrinking += tmp_pDrinking->qty;
		
	    tmp_pVin->list_drinking = g_list_append(tmp_pVin->list_drinking,tmp_pDrinking);
	}
	tmp_pVin->qty = tmp_pVin->NbPurchase - tmp_pVin->NbDrinking;
	
	NbBottleStock = NbBottleStock + tmp_pVin->qty;

	/*
	 * update rack list
	 */
	for ( i = 0 ; i < ret->nbRacks ; i++) {
		ptrEmplacement  tmp_pRacks;
		if ( ( tmp_pRacks = g_malloc (sizeof (Emplacement))) == NULL ) {
		   fprintf (stderr, "Probleme allocation memoire.\n");
		   exit (-1);
		}
	
		memset(tmp_pRacks, '\0',  sizeof (Emplacement));
	
		tmp_pRacks->Rack	= atoi((gchar *)ret->xmlRacks[i]->rackNb);
		tmp_pRacks->Row		= atoi((gchar *)ret->xmlRacks[i]->row);
		tmp_pRacks->Column	= atoi((gchar *)ret->xmlRacks[i]->column);
	
		strncpy (tmp_pRacks->Nom, tmp_pVin->Nom, domain_size);                   

	    tmp_pVin->list_emplacement = g_list_append(tmp_pVin->list_emplacement,tmp_pRacks);
	}

    tmp = xcave_isolat1toUtf8((gchar *)ret->rated);
    if (tmp != NULL) {
		strncpy (tmp_pVin->Note, (gchar *)tmp, rated_size);
		xmlFree(tmp);
	}

    tmp = xcave_isolat1toUtf8((gchar *)ret->comment);
    if (tmp != NULL) {
		strncpy (tmp_pVin->Commentaire, (gchar *)tmp, comment_size);
		xmlFree(tmp);
	}

    list_stock = g_list_append(list_stock ,tmp_pVin);

    return(ret);
}

static xmlWinePtr
parseXmlWineFile(gchar *filename) {
    xmlDocPtr	        doc;
    xmlWinePtr	        curXmlWine;
    xmlDegustationPtr	curXmlDegustation;
    xmlNsPtr	        ns;
    xmlNodePtr	        cur;

#ifdef LIBXML_SAX1_ENABLED
    /*
     * build an XML tree from a the file;
     */
    doc = xmlParseFile(filename);
    if (doc == NULL) return(NULL);
#else
    /*
     * the library has been compiled without some of the old ginterfaces
     */
    return(NULL);
#endif /* LIBXML_SAX1_ENABLED */

    /*
     * Check the document is of the right kind
     */
    
    cur = xmlDocGetRootElement(doc);
    if (cur == NULL) {
        fprintf(stderr,"empty document\n");
	xmlFreeDoc(doc);
	return(NULL);
    }
	ns = xmlSearchNsByHref(doc, cur,(const xmlChar *) "http://xcave.free.fr/xmlwine");
    if (ns == NULL) {
        fprintf(stderr,"document of the wrong type, xcave Namespace not found\n");
		xmlFreeDoc(doc);
		return(NULL);
    }
    if (xmlStrcmp(cur->name, (const xmlChar *) "xcave")) {
        fprintf(stderr,"document of the wrong type, root node != Helping");
		xmlFreeDoc(doc);
		return(NULL);
    }

    /*
     * Allocate the structure to be returned.
     */
    curXmlWine = (xmlWinePtr) g_malloc(sizeof(xmlWine));
    if (curXmlWine == NULL) {
        fprintf(stderr,"out of memory\n");
	xmlFreeDoc(doc);
	return(NULL);
    }
    memset(curXmlWine, '\0', sizeof(xmlWine));

    /*
     * Now, walk the tree.
     */
    /* First level we expect just Wines */
    cur = cur->xmlChildrenNode;
    while ( cur && xmlIsBlankNode ( cur ) ){
		cur = cur -> next;
	}
    if ( cur == 0 )      return ( NULL );
		
    if ((xmlStrcmp(cur->name, (const xmlChar *) "wines")) || (cur->ns != ns)) {
        fprintf(stderr,"document of the wrong type, was '%s', wines expected ",cur->name);
		fprintf(stderr,"xmlDocDump follows\n");
#ifdef LIBXML_OUTPUT_ENABLED
		xmlDocDump ( stderr, doc );
		fprintf(stderr,"xmlDocDump finished\n");
#endif /* LIBXML_OUTPUT_ENABLED */
		xmlFreeDoc(doc);
		free(curXmlWine);
		return(NULL);
    }

    /* Second level is a list of Wine */
    cur = cur->xmlChildrenNode;
    while (cur != NULL) {
        if (( !xmlStrcmp(cur->name, (const xmlChar *) "wine")) && (cur->ns == ns)) {
             curXmlWine = parseWine(doc, ns, cur);
        }
        if (( !xmlStrcmp(cur->name, (const xmlChar *) "degustationSheet")) && (cur->ns == ns)) {
             curXmlDegustation = parseDegustation(doc, ns, cur);
        }
        cur = cur->next;
    }

    return(curXmlWine);
}

gint
xcave_xmlread(void) {

    LIBXML_TEST_VERSION
    xmlKeepBlanksDefault(0);

    if ( parseXmlWineFile((gchar *)DBPATH) == NULL ) 
	return(-1);

    /* Clean up everything else before quitting. */
    xmlCleanupParser();

    return(0);
}

xmlChar *
xcave_isolat1toUtf8(const gchar * utf8Tag) {

    gint ret = 0;

    if ( utf8Tag == NULL ) return(NULL);

    /*
     * 2.2.6 Pango-WARNING **: Invalid UTF-8 string passed to pango_layout_set_text()
     */
    if ( strlen(utf8Tag) == 0 ) return(NULL);
    gint utf8TagLength = strlen(utf8Tag);
    gint isolat1TagLength = 2*strlen(utf8Tag);
    xmlChar *isolat1Tag  = xmlMalloc( isolat1TagLength * sizeof(isolat1Tag));
    memset(isolat1Tag,'\0',isolat1TagLength * sizeof(isolat1Tag));
	
    /* Let's take the input tag and convert from an assumed format of
     * ISO-8559-1 (iso-latin-1) to the ginternal representation UTF-8
     */
    /*
     * 2.2.6
     * warning at compilation time
     * ret = UTF8Toisolat1(isolat1Tag, &isolat1TagLength, utf8Tag, &utf8TagLength);
     */
    ret = UTF8Toisolat1(isolat1Tag, &isolat1TagLength,(guchar *) utf8Tag, &utf8TagLength);
    if (ret != -1){
       /* It worked, let's make sure that it processed the whole input string */
       if (utf8TagLength != strlen(utf8Tag)){
          fprintf(stderr, "UTF8Toisolat1 could not process entire TAG\n");
          xmlFree(isolat1Tag);
          isolat1Tag = NULL;
       }
    } else {
       fprintf(stderr, "UTF8Toisolat1 returned an error : %d %d !!\n",ret,errno);
       xmlFree(isolat1Tag);
       isolat1Tag = NULL;
    }

    return(isolat1Tag);
}
