/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

void
on_xcave_button_synthese_clicked       (GtkButton       *button,                                    gpointer         user_data)
{
    GList	*tmp_list_color;
    GList	*tmp_list_region;
    GList	*tmp_list_country;

    /* 
     * desactive window_xcave
     */
    gtk_widget_set_sensitive(xcave.window, FALSE);

    synthese.main_xml = glade_xml_new (XCAVE_GLADE_FILE, "xcave_synthese", NULL);
    glade_xml_signal_autoconnect (synthese.main_xml);

    /* get the xcave_synthese & label widgets from the glade XML file */
    synthese.window = glade_xml_get_widget(synthese.main_xml, "xcave_synthese");

    /*
     * redimensionnement de la fenetre
     */
    if ( strlen(WindowsSyntheseHeight) != 0 && strlen (WindowsSyntheseWidth) != 0 ) {
       gtk_window_resize (GTK_WINDOW (synthese.window), 
                                    atoi(WindowsSyntheseWidth), 
                                    atoi(WindowsSyntheseHeight));
    }
    gtk_widget_show (synthese.window);

    /* 
     * COLOR STAT
     */
    gint ind = 0;
	
    gchar tmp_buf[80];

    gint  tmp_nb = g_list_length(list_color)+1;	

    GtkWidget *xcave_synthese_hbox_color[tmp_nb];
    GtkWidget *xcave_synthese_entry_color1[tmp_nb];
    GtkWidget *xcave_synthese_entry_color2[tmp_nb];
    GtkWidget *xcave_synthese_progressbar_color[tmp_nb];

    synthese.frame_color = glade_xml_get_widget(synthese.main_xml,"xcave_synthese_frame_color");
    synthese.vbox_color = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (synthese.vbox_color);
    gtk_container_add (GTK_CONTAINER (synthese.frame_color), synthese.vbox_color);

    for(tmp_list_color  = list_color; 
	    tmp_list_color != NULL ; 
	    tmp_list_color  = tmp_list_color->next) {
            
	    if ((tmp_nb = calculate_nb_bottle(CALCULATE_COLOR, tmp_list_color->data, 0)) != 0) {
                        	
               xcave_synthese_hbox_color[ind] = gtk_hbox_new (FALSE, 0);
               gtk_widget_show (xcave_synthese_hbox_color[ind]);
               gtk_box_pack_start (GTK_BOX (synthese.vbox_color),
				                   xcave_synthese_hbox_color[ind],TRUE, TRUE, 0);

               /*
		        * entry color
		        */
	           memset(tmp_buf,'\0',sizeof(tmp_buf));
               sprintf(tmp_buf,_("%s"),(gchar *)tmp_list_color->data);
               xcave_synthese_entry_color1[ind] = gtk_entry_new ();
               gtk_widget_show (xcave_synthese_entry_color1[ind]);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_color[ind]),
			             		  xcave_synthese_entry_color1[ind], TRUE, TRUE, 0);
               gtk_editable_set_editable (GTK_EDITABLE (xcave_synthese_entry_color1[ind]), FALSE);
               gtk_entry_set_invisible_char (GTK_ENTRY (xcave_synthese_entry_color1[ind]), 9679);
               gtk_entry_set_width_chars (GTK_ENTRY (xcave_synthese_entry_color1[ind]), 32);
               gtk_entry_set_text (GTK_ENTRY (xcave_synthese_entry_color1[ind]),tmp_buf);
			
               /*
		        * entry number of bottle
		        */
	           memset(tmp_buf,'\0',sizeof(tmp_buf));
               sprintf(tmp_buf,_("%4.0d"),tmp_nb);												  
               xcave_synthese_entry_color2[ind] = gtk_entry_new ();
               gtk_widget_show (xcave_synthese_entry_color2[ind]);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_color[ind]),
			             		  xcave_synthese_entry_color2[ind], TRUE, TRUE, 0);
               gtk_editable_set_editable (GTK_EDITABLE (xcave_synthese_entry_color2[ind]), FALSE);
               gtk_entry_set_invisible_char (GTK_ENTRY (xcave_synthese_entry_color2[ind]), 9679);
               gtk_entry_set_width_chars (GTK_ENTRY (xcave_synthese_entry_color2[ind]), 4);
               gtk_entry_set_text (GTK_ENTRY (xcave_synthese_entry_color2[ind]),tmp_buf);
							 
	           /*
	            * percent in progressbar
	            */
               gfloat tmp_tx = (tmp_nb * 100) / NbBottleStock;
			   memset(tmp_buf,'\0',sizeof(tmp_buf));
               sprintf(tmp_buf,_("%2.0f %s "),tmp_tx,"%");
               xcave_synthese_progressbar_color[ind] = gtk_progress_bar_new ();
               gtk_progress_bar_set_text(GTK_PROGRESS_BAR(xcave_synthese_progressbar_color[ind]),
										 tmp_buf);
               gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(xcave_synthese_progressbar_color[ind]),
											 tmp_tx/100);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_color[ind]),
								   xcave_synthese_progressbar_color[ind],
								   FALSE, FALSE, 0);
               gtk_widget_set_size_request (xcave_synthese_progressbar_color[ind], -1, 10);
		       gtk_widget_show (xcave_synthese_progressbar_color[ind]);
        }
    }
	
    /* 
     * COUNTRY STAT
     */
    ind = 0;
	
    tmp_nb = g_list_length(list_country)+1;	

    GtkWidget *xcave_synthese_hbox_country[tmp_nb];
    GtkWidget *xcave_synthese_vbox_country;
    GtkWidget *xcave_synthese_entry_country1[tmp_nb];
    GtkWidget *xcave_synthese_entry_country2[tmp_nb];
    GtkWidget *xcave_synthese_progressbar_country[tmp_nb];
    GtkWidget *xcave_synthese_frame_country;

    xcave_synthese_frame_country = glade_xml_get_widget(synthese.main_xml,"xcave_synthese_frame_country");
    xcave_synthese_vbox_country = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (xcave_synthese_vbox_country);
    gtk_container_add (GTK_CONTAINER (xcave_synthese_frame_country),
					   xcave_synthese_vbox_country);

    for(tmp_list_country  = list_country; 
	    tmp_list_country != NULL ; 
	    tmp_list_country  = tmp_list_country->next) {
            
	    if ((tmp_nb = calculate_nb_bottle(CALCULATE_COUNTRY, tmp_list_country->data, 0)) != 0) {
                        	
               xcave_synthese_hbox_country[ind] = gtk_hbox_new (FALSE, 0);
               gtk_widget_show (xcave_synthese_hbox_country[ind]);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_vbox_country),
				                   xcave_synthese_hbox_country[ind],TRUE, TRUE, 0);

               /*
		        * entry country
		        */
	           memset(tmp_buf,'\0',sizeof(tmp_buf));
               sprintf(tmp_buf,_("%s"),(gchar *)tmp_list_country->data);
               xcave_synthese_entry_country1[ind] = gtk_entry_new ();
               gtk_widget_show (xcave_synthese_entry_country1[ind]);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_country[ind]),
			             		  xcave_synthese_entry_country1[ind], TRUE, TRUE, 0);
               gtk_editable_set_editable (GTK_EDITABLE (xcave_synthese_entry_country1[ind]), FALSE);
               gtk_entry_set_invisible_char (GTK_ENTRY (xcave_synthese_entry_country1[ind]), 9679);
               gtk_entry_set_width_chars (GTK_ENTRY (xcave_synthese_entry_country1[ind]), 32);
               gtk_entry_set_text (GTK_ENTRY (xcave_synthese_entry_country1[ind]),tmp_buf);
			
               /*
		        * entry number of bottle
		        */
	           memset(tmp_buf,'\0',sizeof(tmp_buf));
               sprintf(tmp_buf,_("%4.0d"),tmp_nb);												  
               xcave_synthese_entry_country2[ind] = gtk_entry_new ();
               gtk_widget_show (xcave_synthese_entry_country2[ind]);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_country[ind]),
			             		  xcave_synthese_entry_country2[ind], TRUE, TRUE, 0);
               gtk_editable_set_editable (GTK_EDITABLE (xcave_synthese_entry_country2[ind]), FALSE);
               gtk_entry_set_invisible_char (GTK_ENTRY (xcave_synthese_entry_country2[ind]), 9679);
               gtk_entry_set_width_chars (GTK_ENTRY (xcave_synthese_entry_country2[ind]), 4);
               gtk_entry_set_text (GTK_ENTRY (xcave_synthese_entry_country2[ind]),tmp_buf);
							 
	           /*
	            * percent in progressbar
	            */
               gfloat tmp_tx = (tmp_nb * 100) / NbBottleStock;
			   memset(tmp_buf,'\0',sizeof(tmp_buf));
               sprintf(tmp_buf,_("%2.0f %s "),tmp_tx,"%");
               xcave_synthese_progressbar_country[ind] = gtk_progress_bar_new ();
               gtk_progress_bar_set_text(GTK_PROGRESS_BAR(xcave_synthese_progressbar_country[ind]),
										 tmp_buf);
               gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(xcave_synthese_progressbar_country[ind]),
											 tmp_tx/100);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_country[ind]),
								   xcave_synthese_progressbar_country[ind],
								   FALSE, FALSE, 0);
               gtk_widget_set_size_request (xcave_synthese_progressbar_country[ind], -1, 10);
		       gtk_widget_show (xcave_synthese_progressbar_country[ind]);
        }
    }
	
    /* 
     * REGION STAT
     */
    ind = 0;
	tmp_nb = g_list_length(list_region)+1;	

    GtkWidget *xcave_synthese_hbox_region[tmp_nb];
    GtkWidget *xcave_synthese_vbox_region;
    GtkWidget *xcave_synthese_entry_region1[tmp_nb];
    GtkWidget *xcave_synthese_entry_region2[tmp_nb];
    GtkWidget *xcave_synthese_progressbar_region[tmp_nb];
    GtkWidget *xcave_synthese_frame_region;

    xcave_synthese_frame_region = glade_xml_get_widget(synthese.main_xml,"xcave_synthese_frame_region");
    xcave_synthese_vbox_region = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (xcave_synthese_vbox_region);
    gtk_container_add (GTK_CONTAINER (xcave_synthese_frame_region),
					   xcave_synthese_vbox_region);

    for(tmp_list_region  = list_region; 
	    tmp_list_region != NULL ; 
	    tmp_list_region  = tmp_list_region->next) {
            
	    if ((tmp_nb = calculate_nb_bottle(CALCULATE_REGION, tmp_list_region->data, 0)) != 0) {
                        	
               xcave_synthese_hbox_region[ind] = gtk_hbox_new (FALSE, 0);
               gtk_widget_show (xcave_synthese_hbox_region[ind]);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_vbox_region),
				   xcave_synthese_hbox_region[ind],
				   TRUE, TRUE, 0);

               /*
		        * entry region
		        */
	           memset(tmp_buf,'\0',sizeof(tmp_buf));
               sprintf(tmp_buf,_("%s"),(gchar *)tmp_list_region->data);
               xcave_synthese_entry_region1[ind] = gtk_entry_new ();
               gtk_widget_show (xcave_synthese_entry_region1[ind]);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_region[ind]),
			             		  xcave_synthese_entry_region1[ind], TRUE, TRUE, 0);
               gtk_editable_set_editable (GTK_EDITABLE (xcave_synthese_entry_region1[ind]), FALSE);
               gtk_entry_set_invisible_char (GTK_ENTRY (xcave_synthese_entry_region1[ind]), 9679);
               gtk_entry_set_width_chars (GTK_ENTRY (xcave_synthese_entry_region1[ind]), 32);
               gtk_entry_set_text (GTK_ENTRY (xcave_synthese_entry_region1[ind]),tmp_buf);
			
               /*
		        * entry number of bottle
		        */
	           memset(tmp_buf,'\0',sizeof(tmp_buf));
               sprintf(tmp_buf,_("%4.0d"),tmp_nb);												  
               xcave_synthese_entry_region2[ind] = gtk_entry_new ();
               gtk_widget_show (xcave_synthese_entry_region2[ind]);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_region[ind]),
			             		  xcave_synthese_entry_region2[ind], TRUE, TRUE, 0);
               gtk_editable_set_editable (GTK_EDITABLE (xcave_synthese_entry_region2[ind]), FALSE);
               gtk_entry_set_invisible_char (GTK_ENTRY (xcave_synthese_entry_region2[ind]), 9679);
               gtk_entry_set_width_chars (GTK_ENTRY (xcave_synthese_entry_region2[ind]), 4);
               gtk_entry_set_text (GTK_ENTRY (xcave_synthese_entry_region2[ind]),tmp_buf);
							 
	           /*
	            * percent in progressbar
	            */
               gfloat tmp_tx = (tmp_nb * 100) / NbBottleStock;
			   memset(tmp_buf,'\0',sizeof(tmp_buf));
               sprintf(tmp_buf,_("%2.0f %s "),tmp_tx,"%");
               xcave_synthese_progressbar_region[ind] = gtk_progress_bar_new ();
               gtk_progress_bar_set_text(GTK_PROGRESS_BAR(xcave_synthese_progressbar_region[ind]),
										 tmp_buf);
               gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(xcave_synthese_progressbar_region[ind]),
											 tmp_tx/100);
               gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_region[ind]),
								   xcave_synthese_progressbar_region[ind],
								   FALSE, FALSE, 0);
               gtk_widget_set_size_request (xcave_synthese_progressbar_region[ind], -1, 10);
		       gtk_widget_show (xcave_synthese_progressbar_region[ind]);
        }
    }

    /*
     * RACK STATS
     */
    GtkWidget *xcave_synthese_vbox_rack;
    GtkWidget *xcave_synthese_hbox_rack[rackNb];
    GtkWidget *xcave_synthese_entry_rack1[rackNb];
    GtkWidget *xcave_synthese_entry_rack3[rackNb];
    GtkWidget *xcave_synthese_progressbar_rack[rackNb];
    GtkWidget *xcave_synthese_frame_rack;

    xcave_synthese_frame_rack = glade_xml_get_widget(synthese.main_xml,"xcave_synthese_frame_rack");
    xcave_synthese_vbox_rack = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (xcave_synthese_vbox_rack);
    gtk_container_add (GTK_CONTAINER (xcave_synthese_frame_rack), xcave_synthese_vbox_rack);

    for (ind = 0; ind < rackNb; ind++) {
        tmp_nb = calculate_nb_bottle(CALCULATE_RACK,NULL,ind);

	xcave_synthese_hbox_rack[ind] = gtk_hbox_new (FALSE, 0);
        gtk_widget_show (xcave_synthese_hbox_rack[ind]);
        gtk_box_pack_start (GTK_BOX (xcave_synthese_vbox_rack),
                            xcave_synthese_hbox_rack[ind], TRUE, TRUE, 0);

	/* 
	 * entry rack
	 */
	memset(tmp_buf,'\0',sizeof(tmp_buf));
	sprintf(tmp_buf,_("rack %d"),ind+1);
        xcave_synthese_entry_rack1[ind] = gtk_entry_new ();
        gtk_widget_show (xcave_synthese_entry_rack1[ind]);
        gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_rack[ind]),
                            xcave_synthese_entry_rack1[ind], TRUE, TRUE, 0);
        gtk_editable_set_editable (GTK_EDITABLE (xcave_synthese_entry_rack1[ind]), FALSE);
        gtk_entry_set_invisible_char (GTK_ENTRY (xcave_synthese_entry_rack1[ind]), 9679);
        gtk_entry_set_width_chars (GTK_ENTRY (xcave_synthese_entry_rack1[ind]), 32);
        gtk_entry_set_text (GTK_ENTRY (xcave_synthese_entry_rack1[ind]),tmp_buf);

	/*
	 * entry rack number
	 */
	memset(tmp_buf,'\0',sizeof(tmp_buf));
	sprintf(tmp_buf,_("%4.0d"),tmp_nb);
        xcave_synthese_entry_rack3[ind] = gtk_entry_new ();
        gtk_widget_show (xcave_synthese_entry_rack3[ind]);
        gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_rack[ind]),
        		    xcave_synthese_entry_rack3[ind], TRUE, TRUE, 0);
        gtk_editable_set_editable (GTK_EDITABLE (xcave_synthese_entry_rack3[ind]), FALSE);
        gtk_entry_set_invisible_char (GTK_ENTRY (xcave_synthese_entry_rack3[ind]), 9679);
        gtk_entry_set_width_chars (GTK_ENTRY (xcave_synthese_entry_rack3[ind]), 4);
        gtk_entry_set_text (GTK_ENTRY (xcave_synthese_entry_rack3[ind]),tmp_buf);

	/*
	 * percent in progressbar
	 */
        gfloat tmp_tx = 0;
        if ( g_list_nth_data(list_rackRow, ind) != 0
           ||
             g_list_nth_data(list_rackCol, ind) != 0
           ) {
         tmp_tx = (tmp_nb * 100) / 
                        (
                        (unsigned long)g_list_nth_data(list_rackRow, ind)
                        *			        
                        (unsigned long)g_list_nth_data(list_rackCol, ind)
                        );
        }
	memset(tmp_buf,'\0',sizeof(tmp_buf));
        sprintf(tmp_buf,_("%2.0f %s "),tmp_tx,"%");
        xcave_synthese_progressbar_rack[ind] = gtk_progress_bar_new ();
        gtk_progress_bar_set_text(GTK_PROGRESS_BAR(xcave_synthese_progressbar_rack[ind]),tmp_buf);
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(xcave_synthese_progressbar_rack[ind]),tmp_tx/100);
        gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR(xcave_synthese_progressbar_rack[ind]),GTK_PROGRESS_CONTINUOUS);
        gtk_widget_show (xcave_synthese_progressbar_rack[ind]);
        gtk_box_pack_start (GTK_BOX (xcave_synthese_hbox_rack[ind]),
	xcave_synthese_progressbar_rack[ind], FALSE, FALSE, 0);
        gtk_widget_set_size_request (xcave_synthese_progressbar_rack[ind], -1, 10);
        gtk_widget_show (xcave_synthese_progressbar_rack[ind]);
    }

}

void
on_xcave_synthese_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{

   /* 
    * reactive xcave.window
    */
   gtk_widget_set_sensitive(xcave.window, TRUE);

   gtk_object_destroy (GTK_OBJECT (synthese.window));

}

void
on_xcave_synthese_check_resize         (GtkContainer    *container,
                                        gpointer         user_data)
{
   gint height = 0;
   gint width = 0;

   gdk_window_get_size( container->widget.window , &width, &height);

   sprintf(WindowsSyntheseWidth,"%d",width);
   sprintf(WindowsSyntheseHeight,"%d",height);

}

gint
calculate_nb_bottle(gint type, gchar *lib, gint nb)
{
  GList  *tmp_list;
  gint    nb_calc = 0;
	
  switch (type) {
	  case CALCULATE_COLOR:
	     {
           Vin     tmpVin;
           for(tmp_list  = list_stock; 
			   tmp_list != NULL ; 
			   tmp_list  = tmp_list->next) {
                 memcpy(&tmpVin,tmp_list->data,sizeof(Vin));
	             if (strcasecmp(tmpVin.color, lib) == 0)
			        nb_calc += tmpVin.qty;
			   }
	     }	    
		  break;
	  case CALCULATE_COUNTRY:
	     {
           Vin     tmpVin;
           for(tmp_list  = list_stock; 
			   tmp_list != NULL ; 
			   tmp_list  = tmp_list->next) {
                 memcpy(&tmpVin,tmp_list->data,sizeof(Vin));
	             if (strcasecmp(tmpVin.country, lib) == 0)
			        nb_calc += tmpVin.qty;
			   }
	     }	    
		 break;
	  case CALCULATE_REGION:
	     {
           Vin     tmpVin;
           for(tmp_list  = list_stock; 
			   tmp_list != NULL ; 
			   tmp_list  = tmp_list->next) {
                 memcpy(&tmpVin,tmp_list->data,sizeof(Vin));
	             if (strcasecmp(tmpVin.Region, lib) == 0)
			        nb_calc += tmpVin.qty;
			   }
	     }
	     break;
	  case CALCULATE_APPELLATION:
	     break;		  
	  case CALCULATE_RACK:
	     {
	       Emplacement   tmpEmplacement;
           for(tmp_list  = list_rack; 
			   tmp_list != NULL ; 
			   tmp_list  = tmp_list->next) {
                 memcpy(&tmpEmplacement,tmp_list->data,sizeof(Emplacement));
	             if (tmpEmplacement.Rack == nb) 
			        nb_calc++;
			   }
		 }
	     break;		  
	  case CALCULATE_VINTAGE:
	     break;		  
	  default:
		 break;
  }
  return(nb_calc);
}

