/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

GList* xcave_g_list_free(GList *list_to_free) {
	GList  *tmp_list;

	xcave_debug_ptr_int(__FULL__,(gchar *)list_to_free,g_list_length(list_to_free));

	tmp_list = list_to_free;
	while( tmp_list != NULL) {
		g_free(tmp_list->data);
		if (tmp_list->next != NULL) {
			tmp_list = tmp_list->next;
			list_to_free = g_list_remove_link(list_to_free, tmp_list->prev);
			g_list_free_1(tmp_list->prev);
	   }
	   else {
		  list_to_free = g_list_remove_link(list_to_free, tmp_list);
		  g_list_free_1(tmp_list);
	  break;
	   }	  
	}

	xcave_debug_ptr_int(__FULL__,(gchar *)list_to_free,g_list_length(list_to_free));
	return(list_to_free);
}


void xcave_g_list_free_stock() {
	GList		*tmp_list_stock;
	ptrVin		tmpvin;

	xcave_debug_ptr_int(__FULL__,(gchar *)list_stock,g_list_length(list_stock));

    tmpvin = g_malloc (sizeof (Vin));

	tmp_list_stock = list_stock;
	while( tmp_list_stock != NULL) {
	
		memcpy(tmpvin, tmp_list_stock->data, sizeof(Vin));
		tmpvin->list_drinking = xcave_g_list_free(tmpvin->list_drinking);
		tmpvin->list_purchase = xcave_g_list_free(tmpvin->list_purchase);
		tmpvin->list_emplacement = xcave_g_list_free(tmpvin->list_emplacement);
	
	    g_free(tmp_list_stock->data);
	    if (tmp_list_stock->next != NULL) {
			tmp_list_stock = tmp_list_stock->next;
			list_stock = g_list_remove_link(list_stock, tmp_list_stock->prev);
			g_list_free_1(tmp_list_stock->prev);
		}
		else {
			list_stock = g_list_remove_link(list_stock, tmp_list_stock);
			g_list_free_1(tmp_list_stock);
			break;
		}
	}

	g_free(tmpvin);

}

void list_append_stock() {

	xcave_g_list_free_stock();

	xcave_xmlread();

	xcave_debug_ptr_int(__FULL__,(gchar *)list_stock,g_list_length(list_stock));

}

void list_append_categ() {
    ptrCateg   tmpCtg;
    ptrCateg   Ctg;
    ptrVin     tmpVin;
    GList     *tmp_list_stock;
    GList     *tmp_list_categ;

    tmpVin = g_malloc (sizeof (Vin));
    tmpCtg = g_malloc (sizeof (Categ));
    Ctg    = g_malloc (sizeof (Categ));
    if ((Ctg == NULL) || (tmpCtg == NULL) || (tmpVin == NULL)) {
       fprintf (stderr, "Impossible d allouer de la memoire.\n");
       exit (-1);
    }

    list_categ = xcave_g_list_free(list_categ);

    for(tmp_list_stock = list_stock; tmp_list_stock != NULL; tmp_list_stock = tmp_list_stock->next) {
      memset(tmpVin,'\0',sizeof(Vin));
      memcpy(tmpVin,tmp_list_stock->data,sizeof(Vin));
      
      memcpy (Ctg->country,        tmpVin->country,         country_size);
      memcpy (Ctg->color,     tmpVin->color,      color_size);
      memcpy (Ctg->Region,      tmpVin->Region,       region_size);
      memcpy (Ctg->Appellation, tmpVin->Appellation,  appellation_size);

      if ( (QT == 0 && tmpVin->qty != 0 )  || ( QT == 1 ) ){
          if (  strcasecmp (tmpCtg->country,     Ctg->country)     != 0
             || strcasecmp (tmpCtg->Region,      Ctg->Region)      != 0
             || strcasecmp (tmpCtg->color,       Ctg->color)       != 0
             || strcasecmp (tmpCtg->Appellation, Ctg->Appellation) != 0) {
                list_categ = g_list_append(list_categ,Ctg );
                Ctg    = g_malloc (sizeof (Categ));
                if (Ctg == NULL)  {
                  fprintf (stderr, "Impossible d allouer de la memoire.\n");
                  exit (-1);
                }
           } /* end if */
           memcpy (tmpCtg->country,     tmpVin->country,     country_size);
           memcpy (tmpCtg->color,       tmpVin->color,       color_size);
           memcpy (tmpCtg->Region,      tmpVin->Region,      region_size);
           memcpy (tmpCtg->Appellation, tmpVin->Appellation, appellation_size);
      } /* end for */
    }

    g_free(tmpCtg);
    g_free(tmpVin);

    for(tmp_list_categ = list_categ; tmp_list_categ != NULL; tmp_list_categ = tmp_list_categ->next)

    list_categ = g_list_sort(list_categ,(GCompareFunc)cmp_categ_nom);
      
}

void list_append_color ()
{
  gint i = 0;

  const gchar *colorList[] = {
	_("RED"),
	_("WHITE"),
	_("ROSE"),
	_("SPARKLING"),
	_("MELLOW"),
	NULL
  };

  while (colorList[i] != NULL ) {
       list_color = g_list_append (list_color, (gpointer) colorList[i]);
       i++;
  }
}

void list_append_country ()
{
  gint i = 0;

  const gchar *countryList[] = {
	_("FRANCE"),
	_("ALGERIA"),
	_("ARGENTINA"),
	_("AUSTRALIA"),
	_("AUSTRIA"),
	_("BRASIL"),
	_("CANADA"),
	_("CHILI"),
	_("CHINA"),
	_("GEORGIE"),
	_("GERMANY"),
	_("GREECE"),
	_("INDIA"),
	_("ISRAEL"),
	_("ITALIA"),
	_("JAPAN"),
	_("HUNGARY"),
	_("LIBANO"),
	_("MEXICO"),
	_("NEW-ZEALAND"),
	_("PERU"),
	_("PORTUGAL"),
	_("SLOVENIA"),
	_("SOUTH-AFRICA"),
	_("SOUTH COREA"),
	_("SPAIN"),
	_("TURKEY"),
	_("UKRAINE"),
	_("URUGUAY"),
	_("USA"),
	NULL
  };

  list_country = g_list_append (list_country,"");
  while (countryList[i] != NULL ) {
       list_country = g_list_append (list_country, (gpointer) countryList[i]);
       i++;
  }
}

void list_append_region ()
{
  gint      i = 0;
  gchar    *tmpreg;

  const gchar *reglist[][2] = {
    {_("FRANCE"),_("ALSACE")},
    {_("FRANCE"),_("CLARET")},
    {_("FRANCE"),_("BURGUNDY")},
    {_("FRANCE"),_("BEAUJOLAIS")},
    {_("FRANCE"),_("CHAMPAGNE")},
    {_("FRANCE"),_("COTES DU RHONE")},
    {_("FRANCE"),_("LANGUEDOC-ROUSSILLON")},
    {_("FRANCE"),_("CENTRE")},
    {_("FRANCE"),_("PROVENCE")},
    {_("FRANCE"),_("CORSE")},
    {_("FRANCE"),_("SUD-OUEST")},
    {_("FRANCE"),_("VALLEE DU RHONE")},
    {_("FRANCE"),_("VAL DE LOIRE")},
    {_("FRANCE"),_("SAVOIE")},
    {_("FRANCE"),_("JURA")},
    {_("ALGERIE"),_("AIN BESSEN BOUIRA")},
    {_("ALGERIE"),_("COTEAU DE TLEMCEN")},
    {_("ALGERIE"),_("COTEAU DE MASCARA")},
    {_("ALGERIE"),_("COTEAU DU ZACCAR")},
    {_("ALGERIE"),_("GRIS D'ALGERIE")},
    {_("ALGERIE"),_("MEDEA")},
    {_("ALGERIE"),_("MONT DU TESSALA")},
    {_("AUSTRALIA"),_("MERIDIONAL AUSTRALIA")},
    {_("AUSTRALIA"),_("QUEENSLAND")},
    {_("AUSTRALIA"),_("VICTORIA")},
    {_("AUSTRALIA"),_("TASMANIA")},
    {_("AUSTRALIA"),_("SOUTH WALLES")},
    {_("AUSTRALIA"),_("AUSTRALIA")},
    {_("SPAIN"),_("ANDALOUCIA")},
    {_("SPAIN"),_("ARAGON")},
    {_("SPAIN"),_("CASTILLA LA MANCHA")},
    {_("SPAIN"),_("CASTILLA Y LEON")},
    {_("SPAIN"),_("CATALUNA")},
    {_("SPAIN"),_("EXTREMADURA")},
    {_("SPAIN"),_("GALICIA")},
    {_("SPAIN"),_("LEVANT")},
    {_("SPAIN"),_("MURCIA")},
    {_("SPAIN"),_("NAVARRA")},
    {_("SPAIN"),_("RIOJA")},
    {_("SPAIN"),_("PAIS VASCOS")},
    {_("SPAIN"),_("VALENCIANA")},
    {_("ITALIA"),_("ABRUZZES")},
    {_("ITALIA"),_("BASILICATE")},
    {_("ITALIA"),_("CALABRE")},
    {_("ITALIA"),_("CAMPANIE")},
    {_("ITALIA"),_("EMILIE ROMAGNE")},
    {_("ITALIA"),_("FRIOUL")},
    {_("ITALIA"),_("HAUT ADIGE")},
    {_("ITALIA"),_("LATIUM")},
    {_("ITALIA"),_("LIGURIE")},
    {_("ITALIA"),_("LOMBARDIE")},
    {_("ITALIA"),_("MARCHES")},
    {_("ITALIA"),_("MOLISE")},
    {_("ITALIA"),_("OMBRIES")},
    {_("ITALIA"),_("PIEMONT")},
    {_("ITALIA"),_("POUILLES")},
    {_("ITALIA"),_("SARDAIGNE")},
    {_("ITALIA"),_("SICILE")},
    {_("ITALIA"),_("TOSCANE")},
    {_("ITALIA"),_("VAL D'AOSTE")},
    {_("ITALIA"),_("VENETIE")},
    {_("GERMANY"),_("FRANCONIE")},
    {_("GERMANY"),_("HESSE RHENANIE")},
    {_("GERMANY"),_("NAHE")},
    {_("GERMANY"),_("PALATINAT")},
    {_("GERMANY"),_("MOSEL-SAAR-RUWER")},
    {_("GERMANY"),_("HESSISHE BERGSTRABE")},
    {_("GERMANY"),_("PAYS DE BADE")},
    {_("GERMANY"),_("WURTEMBERG")},
    {_("GERMANY"),_("SAXE")},
    {_("USA"),_("CALIFORNIA CENTRAL COAST")},
    {_("USA"),_("CALIFORNIA MENDOCINO")},
    {_("USA"),_("CALIFORNIA NAPA VALLEY")},
    {_("USA"),_("CALIFORNIA SIERRA FOOTHILLS")},
    {_("USA"),_("CALIFORNIA SONOMA")},
    {_("USA"),_("CALIFORNIA SOUTH COAST")},
    {_("USA"),_("OREGON")},
    {_("USA"),_("TEXAS")},
    {_("USA"),_("VIRGINIE")},
    {_("USA"),_("WASHINGTON")},
    {_("CHILI"),_("VALLE CENTRAL")},
    {_("CHILI"),_("VALLE DEL ELQUI")},
    {_("CHILI"),_("COLCHAGUA VALLEY")},
    {_("CHILI"),_("CHILI")},
    {_("NEW-ZEALAND"),_("NELSON")},
    {_("NEW-ZEALAND"),_("MARLBOROUGH")},
    {_("NEW-ZEALAND"),_("CANTERBURY")},
    {_("NEW-ZEALAND"),_("OTAGO")},
    {_("NEW-ZEALAND"),_("GISBORNE")},
    {_("NEW-ZEALAND"),_("WAIRARAPA")},
    {_("NEW-ZEALAND"),_("WAIKATO")},
    {_("NEW-ZEALAND"),_("AUCKLAND")},
    {_("SOUTH-AFRICA"),_("FRANSHCHHOEK")},
    {_("SOUTH-AFRICA"),_("DURBANVILLE")},
    {_("SOUTH-AFRICA"),_("COASTAL")},
    {_("SOUTH-AFRICA"),_("COASTAL - CONSTANTIA")},
    {_("SOUTH-AFRICA"),_("COASTAL - DURBANVILLE")},
    {_("SOUTH-AFRICA"),_("COASTAL - STELLENBOSH")},
    {_("SOUTH-AFRICA"),_("COASTAL - PAARL")},
    {_("SOUTH-AFRICA"),_("COASTAL - SWARLAND")},
    {_("SOUTH-AFRICA"),_("BOBERG")},
    {_("SOUTH-AFRICA"),_("BOBERG - TULBAGH")},
    {_("SOUTH-AFRICA"),_("BREED RIVER")},
    {_("SOUTH-AFRICA"),_("BREED RIVER - WORCESTER")},
    {_("SOUTH-AFRICA"),_("BREED RIVER - ROBERTSON")},
    {_("SOUTH-AFRICA"),_("BREED RIVER - SWELLENDAM")},
    {_("SOUTH-AFRICA"),_("ORANGE RIVER")},
    {_("SOUTH-AFRICA"),_("ORANGE RIVER - DOUGLAS")},
    {_("SOUTH-AFRICA"),_("OLIPHANT RIVER")},
    {_("SOUTH-AFRICA"),_("KLEIN KAROO")},
    {_("SOUTH-AFRICA"),_("SOUTH-AFRICA")},
    {_("MEXICO"),_("BAJA CALIFORNIA")},
    {_("MEXICO"),_("MEXICO")},
    {_("AUSTRIA"),_("Weinviertel")},
    {_("AUSTRIA"),_("Vienne")},
    {_("AUSTRIA"),_("Steiermark")},
    {_("AUSTRIA"),_("Donauland")},
    {_("AUSTRIA"),_("Carnuntum")},
    {_("AUSTRIA"),_("Kamptal")},
    {_("AUSTRIA"),_("Thermenregion")},
    {_("AUSTRIA"),_("Burgenland")},
    {_("AUSTRIA"),_("Wachau")},
    {_("AUSTRIA"),_("Kremstal")},
    {_("AUSTRIA"),_("Traisental")},
    {_("AUSTRIA"),_("Neusiedlersee-Hugelland")},
    {_("AUSTRIA"),_("Neusiedlersee")},
    {_("LIBAN"),_("Ksara")},
    {_("LIBAN"),_("Chateau Musar")},
    {_("LIBAN"),_("Kefraya")},
	{_("PORTUGAL"),_("PORTUGAL")},
	{_("INDIA"),_("Maharashtra")},
	{_("CHINA"),_("Shandong")},
	{_("ARGENTINA"),_("ARGENTINA")},
	{_("BRASIL"),_("BRASIL")},
	{_("HUNGARY"),_("HUNGARY")},
	{_("SOUTH KOREA"),_("SOUTH KOREA")},

    { NULL,NULL}
  };
  list_region = g_list_append (list_region,"");
  while (reglist[i][0] != NULL ) {
       list_region = g_list_append (list_region, (gpointer) reglist[i][1]);

       tmpreg = g_malloc (sizeof(Region));
       memset(tmpreg,'\0',sizeof(Region));
       strcpy(tmpreg,              reglist[i][0]);
       strcpy(tmpreg + country_size,  reglist[i][1]);
       list_country_region = g_list_append (list_country_region, (gpointer) tmpreg);
       i++;
  }

}

void list_append_appellation ()
{
  gint        i = 0;
  gchar      *tmpapp;

  const gchar *applist[][2] = {
    {_("BURGUNDY"),_("Aloxe-corton")},
    {_("ALSACE"),_("Altenberg de Bergbieten")},
    {_("ALSACE"),_("Altenberg de Bergheim")},
    {_("BURGUNDY"),_("Auxey-Duresses")},
    {_("PROVENCE"),_("Bandol")},
    {_("CLARET"),_("Barsac")},
    {_("BEAUJOLAIS"),_("Beaujolais nouveau")},
    {_("BEAUJOLAIS"),_("Beaujolais village")},
    {_("BURGUNDY"),_("Beaune")},
    {_("PROVENCE"),_("Bellet")},
    {_("CENTRE"),_("Côtes d'Auvergne")},
    {_("CENTRE"),_("Côtes du Forez")},
    {_("CENTRE"),_("Saint-Pourçain")},	  
    {_("CLARET"),_("Blaye")},
    {_("CLARET"),_("Bordeaux")},
    {_("CLARET"),_("Bordeaux Superieur")},
    {_("BURGUNDY"),_("Bourgogne")},
    {_("BURGUNDY"),_("Bourgogne-Passetoutgrain")},
    {_("VAL DE LOIRE"),_("Bourgueil")},
    {_("ALSACE"),_("Brand")},
    {_("BEAUJOLAIS"),_("Brouilly")},
    {_("COTES DU RHONE"),_("Cabernet-d'Anjou")},
    {_("SUD-OUEST"),_("Cahors")},
    {_("CLARET"),_("Canon-Fronsac")},
    {_("PROVENCE"),_("Cassis")},
    {_("BURGUNDY"),_("Chablis")},
    {_("BURGUNDY"),_("Chassagne-Montrachet")},
    {_("COTES DU RHONE"),_("Chateau Grillet")},
    {_("COTES DU RHONE"),_("Chateauneuf-du-Pape blanc")},
    {_("COTES DU RHONE"),_("Chateauneuf-du-Pape rouge")},
    {_("BEAUJOLAIS"),_("Chenas")},
    {_("VAL DE LOIRE"),_("Chinon")},
    {_("BEAUJOLAIS"),_("Chiroubles")},
    {_("BURGUNDY"),_("Chorey-les-Beaune")},
    {_("PROVENCE"),_("Collioure")},
    {_("COTES DU RHONE"),_("Condrieu")},
    {_("LANGUEDOC-ROUSSILLON"),_("Corbieres")},
    {_("COTES DU RHONE"),_("Cornas")},
    {_("LANGUEDOC-ROUSSILLON"),_("Costieres-de-Nimes")},
    {_("PROVENCE"),_("Coteaux-d'Aix-en-Provence")},
    {_("VAL DE LOIRE"),_("Coteaux-de-l'Aubance")},
    {_("VAL DE LOIRE"),_("Coteaux-de-Saumur")},
    {_("LANGUEDOC-ROUSSILLON"),_("Coteaux-du-Languedoc-Montpeyroux")},
    {_("LANGUEDOC-ROUSSILLON"),_("Coteaux-du-Languedoc-Pic-Saint-Loup")},
    {_("VAL DE LOIRE"),_("Coteaux-du-Layon")},
    {_("BURGUNDY"),_("Cotes-de-Beaune")},
    {_("CLARET"),_("Cotes-de-Bourg")},
    {_("SUD-OUEST"),_("Cote-de-Buzet")},
    {_("BEAUJOLAIS"),_("Cote-de-Brouilly")},
    {_("BURGUNDY"),_("Cote-de-Nuits")},
    {_("BURGUNDY"),_("Cote-de-Nuits-Village")},
    {_("COTES DU RHONE"),_("Cote-Rotie")},
    {_("PROVENCE"),_("Cote-de-Provence")},
    {_("CLARET"),_("Cotes de Castillon")},
    {_("VALLEE DU RHONE"),_("Coteaux du Tricastin")},
    {_("VALLEE DU RHONE"),_("Cotes du Luberon")},
    {_("VALLEE DU RHONE"),_("Cotes du Ventoux")},
    {_("VALLEE DU RHONE"),_("Cotes du Vivarais Orgnac l'Aven")},
    {_("VALLEE DU RHONE"),_("Cotes du Vivarais Saint Montan")},
    {_("VALLEE DU RHONE"),_("Cotes du Vivarais Saint Remeze")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Rochegude")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Rousset les Vignes")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Saint Maurice sur Eygues")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Saint Pantaleon")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Beaumes de Venise")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Cairanne")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Rasteau")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Roaix")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Sablet")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Seguret")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Valreas")},
    {_("COTES DU RHONE"),_("Cote-du-Rhone Villages Visan")},
    {_("LANGUEDOC-ROUSSILLON"),_("Cote-du-Roussillon")},
    {_("LANGUEDOC-ROUSSILLON"),_("Cote-du-Roussillon-Villages")},
    {_("COTES DU RHONE"),_("Crozes-Hermitage")},
    {_("ALSACE"),_("Eichberg")},
    {_("ALSACE"),_("Engelberg")},
    {_("LANGUEDOC-ROUSSILLON"),_("Fitou")},
    {_("BURGUNDY"),_("Fixin")},
    {_("BEAUJOLAIS"),_("Fleurie")},
    {_("ALSACE"),_("Florimont")},
    {_("ALSACE"),_("Frankstein")},
    {_("ALSACE"),_("Froehn")},
    {_("CLARET"),_("Fronsac")},
    {_("ALSACE"),_("Furstentum")},
    {_("SUD-OUEST"),_("Gaillac")},
    {_("ALSACE"),_("Geisberg")},
    {_("COTES DU RHONE"),_("Gigondas")},
    {_("BURGUNDY"),_("Givry")},
    {_("ALSACE"),_("Gloeckelberg")},
    {_("ALSACE"),_("Goldert")},
    {_("CLARET"),_("Graves blancs")},
    {_("CLARET"),_("Graves rouge")},
    {_("VAL DE LOIRE"),_("Gros-Plant-du-Pays-Nantais")},
    {_("ALSACE"),_("Hatchbourg")},
    {_("BURGUNDY"),_("Hautes-Cotes de Beaune")},
    {_("BURGUNDY"),_("Hautes-Cotes de Nuits")},
    {_("ALSACE"),_("Hengst")},
    {_("COTES DU RHONE"),_("Hermitage blanc")},
    {_("COTES DU RHONE"),_("Hermitage rouge")},
    {_("VAL DE LOIRE"),_("Jasnieres")},
    {_("BEAUJOLAIS"),_("Julienas")},
    {_("ALSACE"),_("Kanzlerberg")},
    {_("ALSACE"),_("Kastelberg")},
    {_("ALSACE"),_("Kessler")},
    {_("ALSACE"),_("Kirchberg de Barr")},
    {_("ALSACE"),_("Kirchberg de Ribeauville")},
    {_("ALSACE"),_("Kitterle")},
    {_("BURGUNDY"),_("Ladoix")},
    {_("CLARET"),_("Lalande-de-Pomerol")},
    {_("CLARET"),_("Listrac")},
    {_("CLARET"),_("Loupiac")},
    {_("COTES DU RHONE"),_("Maconnais")},
    {_("SUD-OUEST"),_("Madiran")},
    {_("ALSACE"),_("Mambourg")},
    {_("ALSACE"),_("Mandelberg")},
    {_("ALSACE"),_("Marckrain")},
    {_("CLARET"),_("Margaux")},
    {_("BURGUNDY"),_("Marsannay")},
    {_("CLARET"),_("Medoc")},
    {_("BURGUNDY"),_("Menetou-Salon")},
    {_("BURGUNDY"),_("Mercurey")},
    {_("LANGUEDOC-ROUSSILLON"),_("Minervois")},
    {_("SUD-OUEST"),_("Monbazillac")},
    {_("ALSACE"),_("Moenchberg")},
    {_("CLARET"),_("Montagne Saint-Emilion")},
    {_("BURGUNDY"),_("Monthelie")},
    {_("VAL DE LOIRE"),_("Montlouis")},
    {_("BEAUJOLAIS"),_("Morgon")},
    {_("BEAUJOLAIS"),_("Moulin-a-Vent")},
    {_("ALSACE"),_("Mienchberg")},
    {_("VAL DE LOIRE"),_("Muscadet")},
    {_("COTES DU RHONE"),_("Muscat-de-Beaumes-de-Venise")},
    {_("ALSACE"),_("Ollwiller")},
    {_("ALSACE"),_("Osterberg")},
    {_("SUD-OUEST"),_("Pacherenc du Vic-Bilh")},
    {_("PROVENCE"),_("Palette")},
    {_("CORSE"),_("Patrimonio")},
    {_("CLARET"),_("Pauillac")},
    {_("BURGUNDY"),_("Pernand-Vergelesses")},
    {_("ALSACE"),_("Pfersigberg")},
    {_("ALSACE"),_("Pfingstberg")},
    {_("CLARET"),_("Pessac-Leognan")},
    {_("CLARET"),_("Pomerol")},
    {_("BURGUNDY"),_("Pommard")},
    {_("VAL DE LOIRE"),_("Pouilly-Fume")},
    {_("BURGUNDY"),_("Pouilly-Fuisse")},
    {_("VAL DE LOIRE"),_("Pouilly-sur-Loire")},
    {_("ALSACE"),_("Praelatenberg")},
    {_("CLARET"),_("Premiere Cotes de Blaye")},
    {_("CLARET"),_("Puisseguin Saint-Emilion")},
    {_("VAL DE LOIRE"),_("Quincy")},
    {_("ALSACE"),_("Rangen")},
    {_("BEAUJOLAIS"),_("Regnie")},
    {_("ALSACE"),_("Rosacker")},
    {_("BURGUNDY"),_("Rully")},
    {_("ALSACE"),_("Saering")},
    {_("BEAUJOLAIS"),_("Saint-Amour")},
    {_("LANGUEDOC-ROUSSILLON"),_("Saint-Chinian")},
    {_("CLARET"),_("Sainte-Croix-du-Mont")},
    {_("CLARET"),_("Saint-Emilion")},
    {_("CLARET"),_("Saint-Estephe")},
    {_("COTES DU RHONE"),_("Saint-Joseph")},
    {_("CLARET"),_("Saint-Julien")},
    {_("VAL DE LOIRE"),_("Saint-Nicoles-de-Bourgueil")},
    {_("COTES DU RHONE"),_("Saint-Peray")},
    {_("VAL DE LOIRE"),_("Sancerre")},
    {_("BURGUNDY"),_("Santenay")},
    {_("VAL DE LOIRE"),_("Saumur")},
    {_("VAL DE LOIRE"),_("Saumur-Champigny")},
    {_("CLARET"),_("Sauternes")},
    {_("VAL DE LOIRE"),_("Savennieres")},
    {_("BURGUNDY"),_("Savigny-les-Beaune")},
    {_("ALSACE"),_("Schlossberg")},
    {_("ALSACE"),_("Schoenenbourg")},
    {_("ALSACE"),_("Sommerberg")},
    {_("ALSACE"),_("Sonnenglanz")},
    {_("ALSACE"),_("Speigel")},
    {_("ALSACE"),_("Sporen")},
    {_("ALSACE"),_("Steinert")},
    {_("ALSACE"),_("Steingrubler")},
    {_("ALSACE"),_("Steinklotz")},
    {_("COTES DU RHONE"),_("Tavel")},
    {_("VAL DE LOIRE"),_("Touraine")},
    {_("COTES DU RHONE"),_("Vacqueyras")},
    {_("ALSACE"),_("Vorbourg")},
    {_("VAL DE LOIRE"),_("Vouvray")},
    {_("ALSACE"),_("Wiebelsberg")},
    {_("ALSACE"),_("Wineck-Schlossberg")},
    {_("ALSACE"),_("Winzenberg")},
    {_("ALSACE"),_("Zinnkoepfle")},
    {_("ALSACE"),_("Zotzenberg")},
    {_("PIEMONT"),_("Barolo")},									/* ITALIA */
    {_("PIEMONT"),_("Barbaresco")},
    {_("PIEMONT"),_("Gattinara")},
    {_("PIEMONT"),_("Ghemme")},
    {_("PIEMONT"),_("Nebiolo")},
    {_("PIEMONT"),_("Barbera")},
    {_("PIEMONT"),_("Dolcetto")},
    {_("PIEMONT"),_("Les Freisa")},
    {_("PIEMONT"),_("Asti")},
    {_("LOMBARDIE"),_("Valtellina")},
    {_("LOMBARDIE"),_("Lugana")},
    {_("LOMBARDIE"),_("Franciacorta")},
    {_("VENETIE"),_("Soave")},
    {_("VENETIE"),_("Valpolicella")},
    {_("VENETIE"),_("Bardolino")},
    {_("VENETIE"),_("Breganze")},
    {_("VENETIE"),_("Bianco di Custoza")},
    {_("HAUT ADIGE"),_("Alto Adige")},
    {_("HAUT ADIGE"),_("Teroldego Rotaliano")},
    {_("HAUT ADIGE"),_("Terlano")},
    {_("HAUT ADIGE"),_("Trentino")},
    {_("HAUT ADIGE"),_("Santa Madalena")},
    {_("HAUT ADIGE"),_("Lago di Caldaro")},
    {_("FRIOUL"),_("Collio Goriziano")},
    {_("FRIOUL"),_("Colli Orientali del Friuli")},
    {_("TOSCANE"),_("Chianti")},
    {_("TOSCANE"),_("Carmignano Rosso")},
    {_("TOSCANE"),_("Brunello di Montalcino")},
    {_("TOSCANE"),_("Vino Nobile di Montepulciano")},
    {_("TOSCANE"),_("Vernaccia di San Gimignano")},
    {_("EMILIE ROMAGNE"),_("Albana di Romagna")},
    {_("EMILIE ROMAGNE"),_("Sangiovese di Romagna")},
    {_("EMILIE ROMAGNE"),_("Lambrusco")},
    {_("EMILIE ROMAGNE"),_("Colli Piacentini")},
    {_("MARCHES"),_("Rosso Conero")},
    {_("OMBRIE"),_("Torgiano")},
    {_("OMBRIE"),_("Orvieto")},
    {_("OMBRIE"),_("Montefalco")},
    {_("LATIUM"),_("Frascati")},
    {_("LATIUM"),_("Marino")},
    {_("LATIUM"),_("Velletri")},
    {_("CALIFORNIA"),_("Chardonnay")},							/* USA */
    {_("CALIFORNIA CENTRAL COAST"),_("Garnacha")},
    {_("CALIFORNIA CENTRAL COAST"),_("Merlot")},
    {_("CALIFORNIA CENTRAL COAST"),_("Pinot Noir")},
    {_("CALIFORNIA MENDOCINO"),_("Sauvignon Blanc")},
    {_("CALIFORNIA MENDOCINO"),_("Pinot Noir")},
    {_("CALIFORNIA NAPA VALLEY"),_("Merlot")},
    {_("CALIFORNIA NAPA VALLEY"),_("Pinot Noir")},
    {_("CALIFORNIA SIERRA FOOTHILLS"),_("Syrah")},
    {_("CALIFORNIA SIERRA FOOTHILLS"),_("Zinfandel")},
    {_("CALIFORNIA SONOMA"),_("Cabernet")},
    {_("CALIFORNIA SONOMA"),_("Merlot")},
    {_("CALIFORNIA SOUTH COAST"),_("Sauvignon Blanc")},
    {_("CALIFORNIA SOUTH COAST"),_("Pinot")},
    {_("OREGON"),_("Pinot Noir")},
    {_("WASHINGTON"),_("Cabernet")},
    {_("COLCHAGUA VALLEY"),_("Merlot")},
    {_("VALLE CENTRAL"),_("Sauvignon Blanc")},
    {_("MARLBOROUGH"),_("Sauvignon Blanc")},					/* New-Zealand */
    {_("MARLBOROUGH"),_("Chardonnay")},
    {_("MARLBOROUGH"),_("Riesling")},
    {_("MARLBOROUGH"),_("Cabernet-Sauvignon")},
    {_("MARLBOROUGH"),_("Pinot Noir")},
    {_("GISBORNE"),_("Chardonnay")},
    {_("GISBORNE"),_("Sauvignon Blanc")},
    {_("GISBORNE"),_("Gewurztraminer")},
    {_("AUCKLAND"),_("Cabernet-Sauvignon")},
    {_("AUCKLAND"),_("Merlot")},
    {_("BAJA CALIFORNIA"),_("Petite Syrah")},				/* Mexique */
    {_("MEXICO"),_("Barbera")},
    {_("MEXICO"),_("Cabernet-Sauvignon")},
    {_("MEXICO"),_("Nebbiolo")},
    {_("MEXICO"),_("Zinfandel")},
    {_("VALLE DEL ELQUI"),_("Pisoc 35")},					/* Chili */
    {_("VALLE DEL ELQUI"),_("Pisoc 40")},
    {_("CHILI"),_("Cabernet-Sauvignon")},
    {_("CHILI"),_("Cabernet-Sauvignon/Merlot")},
    {_("CHILI"),_("Cabernet Carmenere")},
    {_("CHILI"),_("Carmenere")},
    {_("CHILI"),_("Chardonnay")},
    {_("CHILI"),_("Merlot")},
    {_("CHILI"),_("Pinot Noir")},
    {_("CHILI"),_("Sauvignon")},
    {_("CHILI"),_("Syrah")},
    {_("SOUTH-AFRICA"),_("Cabernet-Sauvignon")},			/* Afrique du Sud */
    {_("SOUTH-AFRICA"),_("Cabernet-Sauvignon/Merlot")},
    {_("SOUTH-AFRICA"),_("Cabernet-Sauvignon/Syrah")},
    {_("SOUTH-AFRICA"),_("Chardonnay")},
    {_("SOUTH-AFRICA"),_("Chardonnay-Sauvignon")},
    {_("SOUTH-AFRICA"),_("Pinotage")},
    {_("SOUTH-AFRICA"),_("Rose")},
    {_("SOUTH-AFRICA"),_("Ruby Cabernet")},
    {_("SOUTH-AFRICA"),_("Sauvignon blanc")},
    {_("ARGENTINA"),_("Barbera")},							/* Argentine */
    {_("ARGENTINA"),_("Cabernet-Sauvignon")},
    {_("ARGENTINA"),_("Chanin-Chardonnay")},
    {_("ARGENTINA"),_("Malbec")},
    {_("ARGENTINA"),_("Malbec-Barbera")},
    {_("ARGENTINA"),_("Merlot")},
    {_("ARGENTINA"),_("Merlot-Malbec")},
    {_("ARGENTINA"),_("Torrontes")},
    {_("BRASIL"),_("Cabernet-Sauvignon")},				/* Bresil */
    {_("BRASIL"),_("Cachaca")},
    {_("AUSTRALIA"),_("Cabernet-Sauvignon")},			/* Australie */
    {_("AUSTRALIA"),_("Chardonnay")},
    {_("AUSTRALIA"),_("Durif")},
    {_("AUSTRALIA"),_("Mourvedre/Shiraz")},
    {_("AUSTRALIA"),_("Semillon/Chardonnay")},
    {_("AUSTRALIA"),_("Shiraz")},
    {_("URUGUAY"),_("Tannet")},							/* Uruguay */
    {_("AUSTRIA"),_("Gruner Veltliner")},				/* Autriche */
    {_("PORTUGAL"),_("Dao")},							/* Portugal */
	{_("PORTUGAL"),_("LBV")},
	{_("PORTUGAL"),_("vintage")},
	{_("PORTUGAL"),_("Ruby")},
	{_("PORTUGAL"),_("Tawny")},
	{_("PORTUGAL"),_("Vintage")},
	{_("PERU"),_("Cabernet-Sauvignon/Malbec")},			/* Perou */
	{_("Maharashtra"),_("Omar Khayyam")},				/* Inde */
	{_("HUNGARY"),_("Tokay")},							/* Hongrie */
	{_("SOUTH KOREA"),_("Kyonsang")},					/* Coree du Sud */
	{_("LEVANT"),_("Bodegas Vinival")},				/* Espagne */
	{_("LEVANT"),_("Bodegas Levantinas")},
	{_("VALENCIA"),_("Valentino")},
	{_("VALENCIA"),_("Clariano")},
	{_("VALENCIA"),_("Alto Turia")},
	{_("CATALUNA"),_("Alella")},
	{_("CATALUNA"),_("Penedes")},
	{_("CATALUNA"),_("Taragona")},
	{_("CATALUNA"),_("Terra Alta")},
	{_("CATALUNA"),_("Cava")},
	{_("CATALUNA"),_("Ampurdan Costa Brava")},
	{_("CATALUNA"),_("Costers del Segre")},
	{_("CATALUNA"),_("Priorato")},
	{_("VALENCIANA"),_("Alicante")},
	{_("VALENCIANA"),_("Utiel-Requena")},
	{_("VALENCIANA"),_("Valencia")},
	{_("ARAGON"),_("Catalayud")},
	{_("ARAGON"),_("Campo de Borja")},
	{_("ARAGON"),_("Carinena")},
	{_("ARAGON"),_("Somontano")},
	{_("MURCIA"),_("Jumilla")},
	{_("MURCIA"),_("Yecta")},
	{_("CASTILLA LA MANCHA"),_("Almansa")},
	{_("CASTILLA LA MANCHA"),_("Mentrida")},
	{_("CASTILLA LA MANCHA"),_("La Mancha")},
	{_("CASTILLA LA MANCHA"),_("Valdepenas")},
	{_("CASTILLA LA MANCHA"),_("Mondejar")},
	{_("CASTILLA LA MANCHA"),_("Manchuela")},
	{_("CASTILLA LA MANCHA"),_("Vinos de Madrid")},
	{_("NAVARRA"),_("Navarra")},
	{_("RIOJA"),_("D.O")},
	{_("RIOJA"),_("D.O.C.")},
	{_("PAIS VASCO"),_("Chacoli")},
	{_("CASTILLA Y LEON"),_("Cigales")},
	{_("CASTILLA Y LEON"),_("Toro")},
	{_("CASTILLA Y LEON"),_("Bierzo")},
	{_("CASTILLA Y LEON"),_("Rueda")},
	{_("CASTILLA Y LEON"),_("Ribera del Duero")},
	{_("GALICIA"),_("Ribeiro")},
	{_("GALICIA"),_("Valdeorras")},
	{_("GALICIA"),_("Rias Baixa")},
	{_("GALICIA"),_("Monterrei")},
	{_("GALICIA"),_("Ribeira Sacra")},
	{_("ANDALOUCIA"),_("Condado de Huelva")},
	{_("ANDALOUCIA"),_("Montilla-Morilles")},
	{_("ANDALOUCIA"),_("Malaga")},
	{_("ANDALOUCIA"),_("Jeres")},

    { NULL,NULL}
  };

  list_appellation = g_list_append (list_appellation,"");
  while (applist[i][0] != NULL ) {
  
		if (g_list_find(list_appellation,(gpointer) applist[i][1]) == NULL) {
			list_appellation = g_list_append (list_appellation, (gpointer) applist[i][1]);
		}

		tmpapp = g_malloc (sizeof(Appellation));
		memset(tmpapp,'\0',sizeof(Appellation));
		strcpy(tmpapp,               applist[i][0]);
                strcpy(tmpapp + region_size,  applist[i][1]);
		// strcpy(&tmpapp[region_size], applist[i][1]);
		list_region_appellation = g_list_append (list_region_appellation, (gpointer) tmpapp);
		i++;
	}

}
  

void list_append_cepage ()
{
  gint i = 0;

  const gchar *cepagelist[] = {
    _("Aligote"),
    _("Arrufiat"),
    _("Bourboulenc"),
    _("Cabernet franc"),
    _("Cabernet Sauvignon"),
    _("Carignan"),
    _("Chardonnay"),
    _("Chenin blanc"),
    _("Cinsault"),
    _("Clairette"),
    _("Counoise"),
    _("Courbu"),
    _("Gamay"),
    _("Gewurztraminer"),
    _("Grenache"),
    _("Grenache blanc"),
    _("Grolleau"),
    _("Gros manseng"),
    _("Gros-plant"),
    _("Maccabeu"),
    _("Malbec"),
    _("Marsanne"),
    _("Mauzac"),
    _("Merlot"),
    _("Mourvedre"),
    _("Muscadelle"),
    _("Muscadet"),
    _("Muscardin"),
    _("Muscat"),
    _("Negrette"),
    _("Petit manseng"),
    _("Petit verdot"),
    _("Picardin"),
    _("Picpoul"),
    _("Pinot beurot"),
    _("Pinot blanc"),
    _("Pinot gris"),
    _("Pinot meunier"),
    _("Pinot noir"),
    _("Riesling"),
    _("Roussane"),
    _("Sauvignon blanc"),
    _("Semillon"),
    _("Sylvaner"),
    _("Syrah"),
    _("Tannat"),
    _("Terret noir"),
    _("Tokay-Pinot gris"),
    _("Ugni blanc"),
    _("Vaccarese"),
    _("Viognier"),
     NULL
    };

	list_cepage = g_list_append (list_cepage, "");
	while (cepagelist[i] != NULL ) {
		list_cepage = g_list_append (list_cepage, (gpointer) cepagelist[i]);
		i++;
	}
}


void list_country_append_stock ()
{
  GList  *tmp_list_stock;
  Vin     tmpVin;
  GList  *tmp_list_country;
  gchar  *tmpCountry;
  gint    trouve = FALSE;
     
  for(tmp_list_stock = list_stock; tmp_list_stock != NULL ; tmp_list_stock = tmp_list_stock->next) {
        memcpy(&tmpVin,tmp_list_stock->data,sizeof(Vin));

		/* to avoid double country */
		// if (g_list_find(list_country,(gpointer) tmpVin.country) == NULL)  Pourquoi ko ?????
        for(tmp_list_country = list_country->next; tmp_list_country != NULL ; tmp_list_country = tmp_list_country->next) {
           if (strcasecmp(tmpVin.country, tmp_list_country->data) == 0) {
		   trouve = TRUE;
		   break; 
	   }
	}
	if ( trouve == FALSE ) {
		tmpCountry = g_malloc (country_size);
        memset(tmpCountry,'\0',country_size);

		strcpy(tmpCountry,tmpVin.country);

		list_country = g_list_append(list_country,(gpointer) tmpCountry);
	}
	else
	  trouve = FALSE;
  }
}

void list_region_append_stock ()
{
  GList  *tmp_list_stock;
  Vin     tmpVin;
  GList  *tmp_list_region;
  gchar   *tmpbuff;
  gint     trouve = FALSE;

  for(tmp_list_stock = list_stock; tmp_list_stock != NULL ; tmp_list_stock = tmp_list_stock->next) {
        memcpy(&tmpVin,tmp_list_stock->data,sizeof(Vin));
			
	    /* to avoid double region */
        for(tmp_list_region = list_region->next; tmp_list_region != NULL ; tmp_list_region = tmp_list_region->next) {
           if (strcasecmp(tmpVin.Region, tmp_list_region->data) == 0) {
		   trouve = TRUE;
		   break; 
	   }
	}
	if ( trouve == FALSE ) {
		tmpbuff = g_malloc (country_size + region_size);
        memset(tmpbuff,'\0',country_size + region_size);

	   strcpy(tmpbuff            , tmpVin.country);
	   strcpy(tmpbuff + country_size, tmpVin.Region);

	   list_region      = g_list_append (list_region,      (gpointer) tmpbuff + country_size);
       list_country_region = g_list_append (list_country_region, (gpointer) tmpbuff);
	}
	else
	  trouve = FALSE;
  }

}

void list_appellation_append_stock ()
{
  GList       *tmp_list_stock;
  Vin          tmpVin;
  GList       *tmp_list_appellation;
  gchar        *tmpbuff;
  gint          trouve = FALSE;

  for(tmp_list_stock = list_stock; tmp_list_stock != NULL ; tmp_list_stock = tmp_list_stock->next) {
        memcpy(&tmpVin,tmp_list_stock->data,sizeof(Vin));

	/* to avoid double same appellation in list_appellation */
        for(tmp_list_appellation = list_appellation->next; 
            tmp_list_appellation != NULL ; 
            tmp_list_appellation = tmp_list_appellation->next) {
	   
           if (strcasecmp(tmpVin.Appellation, tmp_list_appellation->data) == 0) {
		   trouve = TRUE;
		   break; 
	   }
	} /* appellation is not present in list_appellation, then include it */
	if ( trouve == FALSE ) {
           tmpbuff = g_malloc (region_size + appellation_size);
	   memset(tmpbuff,'\0',region_size + appellation_size);

	   strcpy(tmpbuff              , tmpVin.Region);
	   strcpy(tmpbuff + region_size, tmpVin.Appellation);

	   if (strcasecmp(tmpbuff + region_size,"") != 0) {
	     list_appellation        = g_list_append (list_appellation,        (gpointer) tmpbuff + region_size);
	     list_region_appellation = g_list_append (list_region_appellation, (gpointer) tmpbuff);
	   }
	}
	else
	  trouve = FALSE;
  }
}

void list_cepage_append_stock ()
{
  GList  *tmp_list_stock;
  Vin     tmpVin;
  GList  *tmp_list_cepage;
  gchar   *tmpcep;
  gint     trouve = FALSE;

  for(tmp_list_stock = list_stock; tmp_list_stock != NULL ; tmp_list_stock = tmp_list_stock->next) {
        memcpy(&tmpVin,tmp_list_stock->data,sizeof(Vin));

	/* to avoid double same cepage in list_cepage  */
        for(tmp_list_cepage = list_cepage->next; tmp_list_cepage != NULL ; tmp_list_cepage = tmp_list_cepage->next) {
	   
           if (strcasecmp(tmpVin.Cepage, tmp_list_cepage->data) == 0) {
		   trouve = TRUE;
		   break; 
	   }
	} /* cepage is not present, then include it in list_cepage */
	if ( trouve == FALSE ) {
           tmpcep = g_malloc (cepage_size);
           memset(tmpcep,'\0',cepage_size);

	   strcpy(tmpcep,tmpVin.Cepage);

	   if (strcasecmp(tmpcep,"") != 0)
	      list_cepage = g_list_append(list_cepage,(gpointer) tmpcep);
	}
	else
	  trouve = FALSE;
  }
}

void list_append_rack ()
{
	GList  *tmp_list_stock;
	Vin     tmpVin;

	xcave_debug_ptr_int(__FULL__,(gchar *)list_rack,g_list_length(list_rack));

	list_rack = xcave_g_list_free(list_rack);
	
	for(tmp_list_stock = list_stock; tmp_list_stock != NULL ; tmp_list_stock = tmp_list_stock->next) {
        GList *tmp_list_rack;	
        memset(&tmpVin,'\0',sizeof(Vin));
        memcpy(&tmpVin,tmp_list_stock->data,sizeof(Vin));

        for(tmp_list_rack = tmpVin.list_emplacement; 
	    tmp_list_rack != NULL ; 
	    tmp_list_rack = tmp_list_rack->next) {
		Rack 	*ptemp;
		ptemp = g_malloc (sizeof(Rack));
		memcpy(ptemp,tmp_list_rack->data,sizeof(Emplacement));
		ptemp->ptr_list_stock_data = (gpointer)tmp_list_stock->data;
		list_rack = g_list_append(list_rack,ptemp);
            }
	}
}


void list_append_length_width ()
{
  gint      i = 0;

  const gchar *lw[][2] = {
    {_("640"),_("480")},
    {_("800"),_("600")},
    {_("1024"),_("768")},
    {_("1152"),_("768")},
    {_("1280"),_("768")},
    {_("1400"),_("768")},
    {_("1600"),_("768")},
    { NULL,NULL}
  };
  list_lw = g_list_append (list_lw,"");
  while (lw[i][0] != NULL ) {
       list_lw = g_list_append (list_lw, (gpointer) lw[i][1]);
       i++;
  }

}
