/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "callbacks.h"

void
on_xcave_window_button_html_clicked  ()
{
    GList            *tmp_list_stock;
    GList            *tmp_list_emplacement;
    ptrVin            tmpVin;
    ptrEmplacement    tmpEmplacement = NULL;
    gint              ipos;
    gint             * tabEmplacement ;
    gchar            ** backgroundCol;
    gchar             backgroundColor[80];
    gint              nA, nR, nC;
	gint              ret = 0;

    gchar * bprinter;
    gint  fd;
    gchar print_buffer[300], chid[18];
    gchar langdep[80];

    /* where shall we write */
    bprinter = (gchar *) g_malloc (100 * sizeof (gchar *));	
    memset(print_buffer,'\0',sizeof(print_buffer));
    sprintf(bprinter,"%s/xcave.html",getenv("HOME"));

    /* take back browser selected by the user */
    strcpy(browserLocation,gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(print.main_xml, "xcave_print_hbox2_entry_printer"))));

    tmpVin = g_malloc (sizeof (Vin));
    /* open file for writing */
    fd = open (bprinter,O_RDWR|O_CREAT|O_TRUNC,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
    if (fd<0) {
	g_warning ("file error");
    }

    /*
     * Impression de la totalite du stock
     */
    sprintf(langdep,_("EN"));
    sprintf(print_buffer,"<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//%s\">",langdep);

    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"<html>\n<head>\n<meta http-equiv=\"content-type\" content=\"text/html; charset=utf8\">\n");
    ret = write(fd,print_buffer,strlen(print_buffer));    
    
    sprintf(print_buffer,"<title>xcave</title>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,"<style type=\"text/css\">\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,"td {\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	font-family: Arial, Helvetica, sans-serif;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	font-size: 12px;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,".onglet {\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	border-top-width: 1px;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	border-right-width: 1px;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	border-left-width: 1px;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	border-top-style: solid;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	border-right-style: solid;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	border-left-style: solid;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	border-top-color: #000000;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	border-right-color: #000000;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	border-left-color: #000000;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	padding: 2px;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"	background-color: #FFCC33;\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   
    sprintf(print_buffer,"}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,".filet {\n	border: 0 solid #000000;\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,".bwhite {\n   vertical-align: top; background-color: rgb( 255, 255, 0);\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,".bred1 {\n   vertical-align: top; background-color: rgb( 159, 0, 0);\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,".bred2 {\n   width: %s;  vertical-align: top; background-color: rgb( 255, 0, 0);\n}\n","20%");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,".brose {\n   vertical-align: top; background-color: rgb( 240, 119, 134);\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,".bsparkling {\n   vertical-align: top; background-color: rgb( 255, 204, 51);\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,".btransparent {\n   vertical-align: top; background-color: transparent;\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,".fblue {\n   vertical-align: top; font-weight: bold; color: rgb(51, 51, 255);\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,"a.lien1:link {\n	color: #000000;\n	text-decoration: none;\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,"a.lien1:visited {\n	color: #000000;\n	text-decoration: none;\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,"a.lien1:hover {\n	color: #0000FF;\n	text-decoration: none;\n}\n");
    ret = write(fd,print_buffer,strlen(print_buffer));   

    sprintf(print_buffer,"</style>\n</head>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));    
	
    sprintf(print_buffer,"<body>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));    

    sprintf(print_buffer," <h1 style=\"text-align: center;\">\n");
    ret = write(fd,print_buffer,strlen(print_buffer));    

    sprintf(langdep,_("Wine cellar"));
    sprintf(print_buffer,"  <span style=\"color: rgb(255, 0, 0); font-family: helvetica,arial,sans-serif;\">%s </span></h1> \n",langdep);
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"   <table cellpadding=\"2\" cellspacing=\"2\" border=\"5\" style=\"width: %s ; text-align: left;\">\n","100%");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"    <tbody>\n     <tr>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));

    sprintf(print_buffer,"      <td class=\"fblue\">%s<br> </td>\n",_("ID"));
    ret = write(fd,print_buffer,strlen(print_buffer));
	
    sprintf(print_buffer,"      <td class=\"fblue\">%s<br> </td>\n",_("Region"));
    ret = write(fd,print_buffer,strlen(print_buffer));
	
    sprintf(print_buffer,"      <td class=\"fblue\">%s<br> </td>\n",_("Appellation"));
    ret = write(fd,print_buffer,strlen(print_buffer));
	
    sprintf(print_buffer,"      <td class=\"fblue\">%s<br> </td>\n",_("Domain"));
    ret = write(fd,print_buffer,strlen(print_buffer));
	
    sprintf(print_buffer,"      <td class=\"fblue\">%s<br> </td>\n",_("Vintage"));
    ret = write(fd,print_buffer,strlen(print_buffer));
	
    sprintf(print_buffer,"      <td class=\"fblue\">%s<br> </td>\n",_("Quantity"));
    ret = write(fd,print_buffer,strlen(print_buffer));
	
    sprintf(print_buffer,"     </tr>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));

    /* et maintenant le fichier Stocks */
    list_stock = g_list_sort(list_stock,(GCompareFunc)cmp_region);
    gint id=0;
    gint total=0;
    gint nb2Alloc=0;
    gint k;
    /* coredump strncpy ligne 262 - ipos mal dimensionne
    gint rowNumber;
    gint colNumber;    
    for(k=0;k<rackNb;k++) {
       rowNumber =(gint)g_list_nth_data(list_rackRow,k);
       colNumber = (gint)g_list_nth_data (list_rackCol, k);
       nb2Alloc += rowNumber * colNumber;
    }
    */

	/*
	 * 2.3.1 crash de l'impression si le nb d emplacement est superieur au nb de stock
     * gint tmp_rackNb = g_list_length(list_rackRow);
	 */

	/*
	 * calcul exact du nombre d'emplacement total 
	 * En tenant compte du fait que les casiers peuvent etre de taille variable.
	 */
    gint tmp_rackNum;
	for (tmp_rackNum=0; tmp_rackNum < rackNb; tmp_rackNum++) {
		 nb2Alloc = nb2Alloc + ( (unsigned long)g_list_nth_data(list_rackCol, tmp_rackNum)
				          *
		                         (unsigned long)g_list_nth_data (list_rackRow, tmp_rackNum));
	}

	/*
	 * comparaison entre le nb de bouteille dans la list stock et le nb d'emplacement 
	 *   on prend la plus grande valeur pour le malloc
	 */
    if ((g_list_length(list_stock)) > nb2Alloc )
        nb2Alloc = g_list_length(list_stock);

    tabEmplacement  = g_malloc (nb2Alloc *sizeof(gint));
    backgroundCol   = (gchar **) g_malloc (nb2Alloc  * sizeof (gchar *));
    gint i;

    for (i=0; i <nb2Alloc ; i++) {
			backgroundCol[i] = (gchar *) g_malloc (10);
			memset(backgroundCol[i],'\0',10);
    }
		gint posChgtRack = 0; /* 2.3.2 */
    for (nA = 0; nA < rackNb; nA++) {
    	rackRowNb =(unsigned long)g_list_nth_data(list_rackRow,nA);
   	rackColNb = (unsigned long)g_list_nth_data (list_rackCol, nA);
	if(nA == 0)
           posChgtRack =0;
        else
	   posChgtRack += (unsigned long)g_list_nth_data(list_rackRow,nA-1)
                          *
                          (unsigned long)g_list_nth_data (list_rackCol, nA-1);
			
           for (nR = 0; nR < rackRowNb; nR++) {
               for (nC = 0; nC < rackColNb; nC++) {
                   ipos = posChgtRack+nR*rackColNb+nC;
                   *(tabEmplacement+ipos) = 0;
                }
           }
    }

    tmpEmplacement = g_malloc (sizeof(Emplacement));
    for(tmp_list_stock = list_stock; tmp_list_stock != NULL; tmp_list_stock = tmp_list_stock->next) {
			memset(tmpVin,'\0',sizeof(Vin));
			memcpy(tmpVin,tmp_list_stock->data,sizeof(Vin));

			memset(print_buffer,'\0',sizeof(print_buffer)); 
	
			if (tmpVin->qty != 0) {
			    id++;
			    for (i=0; i < tmpVin->qty; i++) {
						/* 
						 * la bouteille ne se trouve pas forcement dans un casier 
						 * ipos ne varie pas mais je flingue celui d avant
						 */
						memset(backgroundColor,'\0',80);
						if (strcmp(_("RED"),tmpVin->color) == 0) {
						    strcpy(backgroundColor,"bred1");
						}
						else if (strcmp(_("ROSE"),tmpVin->color) == 0)    {
						        strcpy(backgroundColor,"brose");
						     }
						     else if (strcmp(_("WHITE"),tmpVin->color) == 0)   {
						             strcpy(backgroundColor,"bwhite");
						          }
						          else  if (strcmp(_("SPARKLING"),tmpVin->color) == 0){
						                   strcpy(backgroundColor,"bsparkling");
						                }
							        else 
						                   strcpy(backgroundColor,"btransparent");

						for(tmp_list_emplacement = tmpVin->list_emplacement; 
						    tmp_list_emplacement != NULL; 
						    tmp_list_emplacement = tmp_list_emplacement->next) {
							memset(tmpEmplacement,'\0',sizeof(Emplacement));
							memcpy(tmpEmplacement,tmp_list_emplacement->data,sizeof(Emplacement));
							posChgtRack =0;
							for(k=0;k<tmpEmplacement->Rack;k++){
								posChgtRack += (unsigned long)g_list_nth_data(list_rackRow,k)*(unsigned long)g_list_nth_data(list_rackCol,k);
							}
								
							ipos = posChgtRack +(tmpEmplacement->Row-1)*(unsigned long)g_list_nth_data(list_rackCol,tmpEmplacement->Rack)+tmpEmplacement->Column-1;
							*(tabEmplacement+ipos)=id;
						        strcpy(backgroundCol[ipos],backgroundColor);
						    } 
		    		} /* end for tmpVin->qty */
				    sprintf(print_buffer,"     <tr>\n");
				    ret = write(fd,print_buffer,strlen(print_buffer));
				    sprintf(print_buffer,"       <td class=\"\%s\">\%d<br> </td>\n",backgroundColor,id);
				    ret = write(fd,print_buffer,strlen(print_buffer));
				    sprintf(print_buffer,"       <td style=\"vertical-align: top;\">%s<br> </td>\n", tmpVin->Region);
				    ret = write(fd,print_buffer,strlen(print_buffer));
				    sprintf(print_buffer,"       <td style=\"vertical-align: top;\">%s<br> </td>\n", tmpVin->Appellation);
				    ret = write(fd,print_buffer,strlen(print_buffer));
				    sprintf(print_buffer,"       <td style=\"vertical-align: top;\">%s<br> </td>\n",tmpVin->Nom);
				    ret = write(fd,print_buffer,strlen(print_buffer));
				    sprintf(print_buffer,"       <td style=\"vertical-align: top;\">%d<br> </td>\n",tmpVin->vintage);
				    ret = write(fd,print_buffer,strlen(print_buffer));			
				    sprintf(print_buffer,"       <td style=\"vertical-align: top;\">%d<br> </td>\n",tmpVin->qty);
				    ret = write(fd,print_buffer,strlen(print_buffer));
				    sprintf(print_buffer,"     </tr>\n");
				    ret = write(fd,print_buffer,strlen(print_buffer));
				
				    total=total+tmpVin->qty;						
				} /* end if qty = 0 */

	    } /* END for */
    g_free(tmpEmplacement);
	  
    sprintf(print_buffer,"     <tr>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"	    <td style=\"vertical-align: top;\"><br> </td>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"	    <td style=\"vertical-align: top;\"><br> </td>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"	    <td style=\"vertical-align: top;\"><br> </td>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"	    <td style=\"vertical-align: top;\"><br> </td>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"       <td class=\"bred1\">Total<br> </td>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"       <td class=\"bred1\">\%d<br> </td>\n",total);
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"     </tr>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"    </tbody>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"   </table>\n<br>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
		
	
    for (nA = 0; nA < rackNb; nA++) {
			
    	rackRowNb =(unsigned long)g_list_nth_data(list_rackRow,nA);
   	 	rackColNb = (unsigned long)g_list_nth_data (list_rackCol, nA);
			
			if(nA == 0)
                          posChgtRack =0;
			else
                          posChgtRack += (unsigned long)g_list_nth_data(list_rackRow,nA-1)
                                         *
                                         (unsigned long)g_list_nth_data (list_rackCol, nA-1);
			
			sprintf(print_buffer,"   <br>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer," <table width=%s border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\"> \n","100%");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"  <tr>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"   <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"> \n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"    <tr>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(langdep,_("Rack number : "));
			sprintf(print_buffer,"     <td class=\"onglet\"><a href=\"#\" class=\"lien1\">\%s\%d</a></td>\n",langdep,nA+1);
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"    </tr>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"   </table>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"  </tr>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));

			sprintf(print_buffer,"  <tr>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"    <td class=\"filet\">\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"      <table cellpadding=\"2\" cellspacing=\"2\" border=\"5\" style=\"text-align: center;\">\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"        <body>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			for (nR = 0; nR < rackRowNb; nR++) {
					sprintf(print_buffer,"          <tr>\n");
					ret = write(fd,print_buffer,strlen(print_buffer));
					for (nC = 0; nC < rackColNb; nC++) {
						ipos = posChgtRack+nR*rackColNb+nC;
						if (*(tabEmplacement+ipos) != 0) {
							sprintf(chid,"%3.d",*(tabEmplacement+ipos));
						}	
						else   sprintf(chid," ");
						sprintf(print_buffer,"            <td class=\"%s\">%s<br>\n</td>\n",backgroundCol[ipos],chid);
						ret = write(fd,print_buffer,strlen(print_buffer));
					}
				sprintf(print_buffer,"          </tr>\n");
				ret = write(fd,print_buffer,strlen(print_buffer));
			}
			sprintf(print_buffer,"        </tbody>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
			sprintf(print_buffer,"      </table>\n<br>\n");
			ret = write(fd,print_buffer,strlen(print_buffer));
    }
    	
	free(tabEmplacement);
    sprintf(print_buffer,"    </tr>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));

    sprintf(print_buffer,"   </tbody>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"  </table>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));
    sprintf(print_buffer,"</html>\n");
    ret = write(fd,print_buffer,strlen(print_buffer));

    g_free(tmpVin);
    sprintf(print_buffer,"%s file:%s",browserLocation,bprinter);
    ret = system(print_buffer);
}
