/***************************************************************************
 *            xcave_fileselection.c
 *
 *  Mon Dec 13 22:19:24 2004
 *  Copyright  2004  Jean-Philippe Hergott
 *  xcave@free.fr
 ****************************************************************************/
 
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
  
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "callbacks.h"

void
on_xcave_config_buttonfile_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    fileselection.main_xml = glade_xml_new (XCAVE_GLADE_FILE, "fileselection.window", NULL);

    /* get the fileselection.window & label widgets from the glade XML file */
    fileselection.window = glade_xml_get_widget(fileselection.main_xml, "fileselection.window");

    gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(fileselection.window), DBPATH);

    gtk_widget_show (fileselection.window); 
}


void
on_xcaqve_fileselection_destroy(GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_object_destroy (GTK_OBJECT (fileselection.window));

}

void
on_xcave_fileselection_button_ok_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *(buf) = (gchar *)gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (fileselection.window));

	gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget(config.main_xml, "PathStock")), (gchar *) buf);

	if (strcasecmp(buf, DBPATH) != 0){
		FILE *f;
	    if  ( (f = fopen (buf, "r")) == NULL) {
			/* 2.3.2 le fichier n'existe pas */
		    xcave_xmlWrite(buf);
		    strcpy(DBPATH,buf);
		  } else {
			/* 2.3.2 un fichier existe */
  			fclose(f);
		    strcpy(DBPATH,buf);
	        /*
	         * initialisation diverses et variees:
	         *   (GList) liste du stock
	         *   (GList) liste des country
	         *   (GList) liste des regions
	         *   (GList) liste des appellations
	         *   (GList) liste des cepages
	         */
		      list_append_stock();
		
		      list_append_rack();
		
		      list_append_categ();
		      list_append_color();
		      list_append_country();
		      list_append_region();
		      list_append_appellation();
		      list_append_cepage();
		
		      list_country_append_stock();
		      list_region_append_stock();
		      list_appellation_append_stock();
		      list_cepage_append_stock();
	
		      list_country = g_list_sort(list_country,(GCompareFunc)cmp_country);
	
              /*
               * need to cleanup the mess
               */
              xcave.information_treestore = (GtkTreeStore *) gtk_tree_view_get_model((GtkTreeView *)xcave.information_treeview);
              gtk_tree_store_clear(xcave.information_treestore);

              xcave.origin_treestore = (GtkTreeStore *) gtk_tree_view_get_model((GtkTreeView *)xcave.origin_treeview);
              gtk_tree_store_clear(xcave.origin_treestore);
	
              xcave_fill_model (xcave.origin_treestore, xcave.information_treestore);
		}
	}

	gtk_object_destroy (GTK_OBJECT (fileselection.window));

}

