 /*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

void
xcave_create_treelist_drinking(void)
{
	GtkTreeViewColumn   *col;
	GtkCellRenderer     *renderer;

    detail.drinking_treeview = glade_xml_get_widget(detail.main_xml,"xcave_detail_drinking_treeview");
    if (detail.drinking_treeview == NULL) {
       g_printerr("Could not build xcave_detail_drinking_treeview");
       return;
	}

    /* --- TreeList Column #5 -- DEGUSTATION SHEET --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("sheet"));
    renderer = gtk_cell_renderer_pixbuf_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "pixbuf", COL_TREELIST_ICON, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.drinking_treeview), col);

    /* --- TreeList Column #1 --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("year"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_DRINKING_DATE, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.drinking_treeview), col);

    /* --- TreeList Column #2 -- QUANTITY --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("Qty"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_DRINKING_QTY, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.drinking_treeview), col);

    /* --- TreeList Column #3 -- PRICE --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("Rated"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_NOTE, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.drinking_treeview), col);

    /* --- TreeList Column #4 -- SUPPLIER --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("Comment"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_COMMENTAIRE, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.drinking_treeview), col);

    /* Creates a new tree store as with n_columns columns each of the types passed in. */
    detail.drinking_liststore = gtk_list_store_new(NUM_COLS_TREELIST_DRINKING, 
                                                   GDK_TYPE_PIXBUF,
                                                   G_TYPE_UINT, 
                                                   G_TYPE_UINT, 
                                                   G_TYPE_STRING, 
                                                   G_TYPE_STRING,
                                                   G_TYPE_UINT);


    gtk_tree_view_set_model(GTK_TREE_VIEW(detail.drinking_treeview), 
                           (GtkTreeModel *)detail.drinking_liststore);

	/*
	 * 2.3.1 alternance de couleur de fond pour chaque ligne
	 */
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(detail.drinking_treeview),TRUE);

    flag_drinking_doubleclick = FALSE;

    return;
}

GdkPixbuf  *
xcave_drinking_degustation_sheet_treatment(gint *tmpDegustationSheetId)
{
    GdkPixbuf     *icon;

    *tmpDegustationSheetId = 0;
    gchar          data[80];

    memset(data,'\0',80);

    if ( lDS != NULL) {
       if (lDS->degustation_sheet_id != (time_t)0) {
          degustation_sheet       *tmp_ds;

          tmp_ds = g_malloc ( sizeof(degustation_sheet) );
          memcpy(tmp_ds,lDS,sizeof(degustation_sheet));

          strcpy(data,"xcave_degustation.png");

          *tmpDegustationSheetId = (gint)tmp_ds->degustation_sheet_id;

          list_ds = g_list_append(list_ds, tmp_ds);
	  xcave_debug_msg_int(__FULL__,"list_ds",2,g_list_length(list_ds));

      } 
      xcave_debug_str(__FULL__,"g_free(lDS)");
      g_free(lDS);
      lDS = NULL;
    }
    else {
         xcave_debug_str(__FULL__,"lDS null");
         strcpy(data,"");
    }

    icon = create_pixbuf(data);
    return(icon);
}

void
on_DrinkingOk_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkTreeModel 		*model;
    GtkTreeIter          iter;
    GtkTreeSelection    *selection;
    Drinking            *tmpDrinking;
    GdkPixbuf           *icon;
    gint                 tmpDegustationSheetId = 0;

    tmpDrinking = g_malloc (sizeof(Drinking));
    memset(tmpDrinking,'\0',sizeof(Drinking));

    tmpDrinking->Conso = atoi(
        gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_year"))));
    tmpDrinking->qty = atoi(
        gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "spinbutton_drinking_qty"))));
    strcpy(tmpDrinking->Note,
        gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_rated"))));
    strcpy(tmpDrinking->Commentaire,
        gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_comment"))));

    icon = xcave_drinking_degustation_sheet_treatment(&tmpDegustationSheetId);

    detail.drinking_liststore = (GtkListStore *) gtk_tree_view_get_model((GtkTreeView *)detail.drinking_treeview);

    if ( flag_drinking_doubleclick == FALSE ) {
       gtk_list_store_append(detail.drinking_liststore, &iter);
       gtk_list_store_set(detail.drinking_liststore, &iter,
                          COL_TREELIST_ICON,icon,
                          COL_TREELIST_DRINKING_DATE, (guint)tmpDrinking->Conso,
                          COL_TREELIST_DRINKING_QTY, (guint)tmpDrinking->qty,
                          COL_TREELIST_NOTE, tmpDrinking->Note,
                          COL_TREELIST_COMMENTAIRE, tmpDrinking->Commentaire,
                          COL_TREELIST_SHEET_ID,tmpDegustationSheetId,
                          -1);			

       NbBottleDetail -= tmpDrinking->qty;
       NbBottleStock  -= tmpDrinking->qty;

       sprintf (ach, "%d", nowan);
       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(detail.main_xml,"entry_drinking_year")),(gchar *)ach);
       gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_drinking_qty")), (guint) 1);
       gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_rated")),"");
       gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_comment")),"");

       /*
        * update de la statusbar indiquant le nb de bouteille du vin selectionne
        * se trouvant dans le stock
        */
       xcave_debug_function
       sprintf (detail.statusbar_txt, _("Number of bottles for the selection : %d"), NbBottleDetail);
       if (detail.statusbar_id != 0) 
          gtk_statusbar_remove ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_id);
       detail.statusbar_id = gtk_statusbar_push ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_txt);
       xcave_debug_function

    } else {
       gint               tmpQty;

	   selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(detail.drinking_treeview));
	   if (gtk_tree_selection_get_selected (selection, &model, &iter)) {
           gtk_tree_model_get (model, &iter, COL_TREELIST_DRINKING_QTY, &tmpQty, -1);
           NbBottleDetail += tmpQty;
           NbBottleStock  += tmpQty;
           gtk_list_store_set(detail.drinking_liststore, &iter,
                            COL_TREELIST_ICON,          icon,
                            COL_TREELIST_DRINKING_DATE, (guint)tmpDrinking->Conso,
                            COL_TREELIST_DRINKING_QTY,  (guint)tmpDrinking->qty,
                            COL_TREELIST_NOTE,          tmpDrinking->Note,
                            COL_TREELIST_COMMENTAIRE,   tmpDrinking->Commentaire,
                            COL_TREELIST_SHEET_ID,      tmpDegustationSheetId,
                            -1);			

          NbBottleDetail -= tmpDrinking->qty;
          NbBottleStock  -= tmpDrinking->qty;

          sprintf (ach, "%d", nowan);
          gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(detail.main_xml,"entry_drinking_year")),(gchar *)ach);
          gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_drinking_qty")), (guint) 1);
          gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_rated")),"");
          gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_comment")),"");

          /*
           * update de la statusbar indiquant le nb de bouteille du vin selectionne
           * se trouvant dans le stock
           */
       xcave_debug_function
          sprintf (detail.statusbar_txt, _("Number of bottles for the selection : %d"), NbBottleDetail);
          if (detail.statusbar_id != 0)
			   gtk_statusbar_remove ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_id);
          detail.statusbar_id = gtk_statusbar_push ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_txt);
       xcave_debug_function
       }
       else {
         GtkWidget	*dialog;
         dialog = gtk_message_dialog_new ((GtkWindow *)detail.window,
                                GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  _("You must select a line!!!")
                                  );
 		gtk_dialog_run (GTK_DIALOG (dialog));
 		gtk_widget_destroy (dialog);
	   }
    }

    flag_drinking_doubleclick = FALSE;
    g_free(tmpDrinking);

}

gboolean
on_xcave_detail_drinking_treeview_row_activated (GtkWidget       *widget,
                                   GdkEventButton  *event,
                                   gpointer         user_data)
{
    gchar               *tmpNote;
    gchar               *tmpComment;	
    Drinking            *tmpDrinking;

    GtkTreeModel 		*model;
    GtkTreeIter          iter;
    GtkTreeSelection    *selection;

    tmpDrinking = g_malloc (sizeof(Drinking));

    memset(tmpDrinking,'\0',sizeof(Drinking));
	
	detail.drinking_liststore = (GtkListStore *) gtk_tree_view_get_model((GtkTreeView *)detail.drinking_treeview);

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(detail.drinking_treeview));
	gtk_tree_selection_get_selected (selection, &model, &iter);

    gtk_tree_model_get (model, &iter,
                        COL_TREELIST_DRINKING_DATE, &tmpDrinking->Conso,
                        COL_TREELIST_DRINKING_QTY, &tmpDrinking->qty,
                        COL_TREELIST_NOTE, &tmpNote,
                        COL_TREELIST_COMMENTAIRE, &tmpComment,
                        COL_TREELIST_SHEET_ID, &tmpDrinking->degustation_sheet_id,
                        -1);

    sprintf (ach, "%d", tmpDrinking->Conso);
    gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(detail.main_xml,"entry_drinking_year")),(gchar *)ach);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_drinking_qty")), (guint)tmpDrinking->qty);
    gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_rated")),tmpNote);
    gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_comment")),tmpComment);

    if ((gint)tmpDrinking->degustation_sheet_id != 0){
        /*
         * degustation sheet id found
         * save the id, so when degustation_windows will be activate, I can found again
         * the degustation sheet data 
         */
	xcave_debug_str(__FULL__,"g_malloc(lDS)");
	lDS = g_malloc ( sizeof(degustation_sheet) );
	memset(lDS, '\0', sizeof( degustation_sheet ));
	xcave_debug_ptr_int(__FULL__,(gchar *)lDS,0);
        lDS->degustation_sheet_id = (time_t)tmpDrinking->degustation_sheet_id;
        xcave_debug_2str(__FULL__,"degustation_sheet_d",25,ctime(&lDS->degustation_sheet_id));
    }
    g_free(tmpDrinking);
    g_free(tmpNote);
    g_free(tmpComment);

    flag_drinking_doubleclick = TRUE;

    return FALSE;
}

void
on_DrinkingDelete_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkTreeModel 		*model;
    GtkTreeIter          iter;
    GtkTreeSelection    *selection;
    gint                 tmpQty;
    gint                 tmpDS = 0;

    detail.drinking_liststore = (GtkListStore *) gtk_tree_view_get_model((GtkTreeView *)detail.drinking_treeview);

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(detail.drinking_treeview));
	if (gtk_tree_selection_get_selected (selection, &model, &iter)) {

        gtk_tree_model_get (model, &iter,
                            COL_TREELIST_DRINKING_QTY, &tmpQty,
                            COL_TREELIST_SHEET_ID, &tmpDS, -1);
        NbBottleDetail += tmpQty;
        NbBottleStock  += tmpQty;
        /*
         * remove associated degustation sheet
         */
	if (tmpDS != 0) {
           degustation_sheet    *tmp_ds;
           GList                *tmp_list_ds; 

	   tmp_ds = g_malloc ( sizeof(degustation_sheet) );
           /*
            * controle et suppression de la liste temporaire (list_ds) celle utilisee lors de l ajout de 
            * ligne drinking pour un meme vin
            */
           for(tmp_list_ds = list_ds; tmp_list_ds != NULL ; tmp_list_ds = tmp_list_ds->next) {
              memcpy(tmp_ds,tmp_list_ds->data,sizeof(degustation_sheet));
              if (tmpDS == tmp_ds->degustation_sheet_id) {
                 list_ds = g_list_remove_link(list_ds, tmp_list_ds);
                 g_list_free_1(tmp_list_ds);
                 break; 
	      }
	   }
           /*
            * controle et suppression de la liste degustation (list_full_ds) qui contient l ensemble des
            * fiches de degustations de la cave
            */
           for(tmp_list_ds = list_full_ds; tmp_list_ds != NULL ; tmp_list_ds = tmp_list_ds->next) {
              memcpy(tmp_ds,tmp_list_ds->data,sizeof(degustation_sheet));
              if (tmpDS == tmp_ds->degustation_sheet_id) {
                 list_full_ds = g_list_remove_link(list_full_ds, tmp_list_ds);
                 g_list_free_1(tmp_list_ds);
                 break; 
	      }
	   }
	}

        /*
         * remove the drinking line
         */
        gtk_list_store_remove( detail.drinking_liststore, &iter);
        sprintf (detail.statusbar_txt, _("Number of bottles for the selection : %d"), NbBottleDetail);
        if (detail.statusbar_id != 0) gtk_statusbar_remove ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_id);
        detail.statusbar_id = gtk_statusbar_push ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_txt);
    }
    else {
         GtkWidget	*dialog;
         dialog = gtk_message_dialog_new ((GtkWindow *)detail.window,
                               GTK_DIALOG_DESTROY_WITH_PARENT,
                               GTK_MESSAGE_ERROR,
                               GTK_BUTTONS_CLOSE,
                               _("You must select a line!!!")
                               );
        gtk_dialog_run (GTK_DIALOG (dialog));
        gtk_widget_destroy (dialog);
    }

    flag_drinking_doubleclick = FALSE;

}


