/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>
#include "callbacks.h"

void detail_signal_connect()
{
    detail.s_country = g_signal_connect (GTK_OBJECT (detail.country_combo),
		                              "changed",
                                              GTK_SIGNAL_FUNC (on_country_changed), 
					      NULL);
    detail.s_region = g_signal_connect (GTK_OBJECT (detail.region_combo),
		                              "changed",
                                              GTK_SIGNAL_FUNC (on_region_changed), 
					      NULL);
    detail.s_appellation = g_signal_connect (GTK_OBJECT (detail.appellation_combo),
		                              "changed",
                                              GTK_SIGNAL_FUNC (on_appellation_changed), 
					      NULL);
    detail.s_color = g_signal_connect (GTK_OBJECT (detail.color_combo),
		                              "changed",
                                              GTK_SIGNAL_FUNC (on_color_changed), 
					      NULL);
    detail.s_cepage = g_signal_connect (GTK_OBJECT (detail.cepage_combo),
		                              "changed",
                                              GTK_SIGNAL_FUNC (on_cepage_changed), 
					      NULL);
}

void detail_init()
{
    /* 
     * desactive xcave.window
     */
    gtk_widget_set_sensitive(xcave.window, FALSE);
	
    detail.rack.main_xml = detail.main_xml = glade_xml_new (XCAVE_GLADE_FILE, "xcave_detail", NULL);
    glade_xml_signal_autoconnect (detail.main_xml);

    /* get the xcave_detail & label widgets from the glade XML file */
    detail.window = glade_xml_get_widget(detail.main_xml, "xcave_detail");
    detail.rack.window = glade_xml_get_widget(detail.main_xml, "xcave_detail");

    /*
     * 
     */
    detail.statusbar_v = glade_xml_get_widget (detail.main_xml, "xcave_detail_statusbar");
    detail.statusbar_ctxtid = gtk_statusbar_get_context_id ((GtkStatusbar *)detail.statusbar_v, "default");
    detail.statusbar_id = 0;

    /*
     * redimensionnement de la fenetre
     */
    if ( strlen(WindowsDetailHeight) != 0 && strlen (WindowsDetailWidth) != 0 ) {
       gtk_window_resize (GTK_WINDOW (detail.window), atoi(WindowsDetailWidth), atoi(WindowsDetailHeight));
    }

}

gint fill_country_combo( gchar      country[country_size])
{
    GList         *tmp_list;
    GtkTreeIter    iter;
    gint           j   = 0;
    gint           ind = 0;

    /* Create country store and populate it */
    detail.country_store = gtk_list_store_new(1, G_TYPE_STRING);
    for(tmp_list  = list_country; tmp_list != NULL ; tmp_list  = tmp_list->next) {
        j++;
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.country_store, &iter);

        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set(detail.country_store, &iter, 0, tmp_list->data, -1);
        if (strcasecmp(tmp_list->data, country) == 0) ind=j;
    }

    detail.country_combo = glade_xml_get_widget (detail.main_xml, "country_combo");

    gtk_combo_box_set_model( GTK_COMBO_BOX( detail.country_combo ),
                             GTK_TREE_MODEL( detail.country_store ) );

    g_object_unref( G_OBJECT (detail.country_store));
    gtk_combo_box_entry_set_text_column( GTK_COMBO_BOX_ENTRY (detail.country_combo),0);

    gtk_widget_show(detail.country_combo);

    return(ind - 1);

}

gint fill_region_combo(gchar  region[region_size])
{
    GList         *tmp_list;
    GtkTreeIter    iter;
    gint           j   = 0;
    gint           ind = 0;

    /* Create region store and populate it */
    detail.region_store = gtk_list_store_new(1, G_TYPE_STRING);
    for(tmp_list  = list_region; tmp_list != NULL ; tmp_list  = tmp_list->next) {
        j++;
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.region_store, &iter);

        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set(detail.region_store, &iter, 0, tmp_list->data, -1);
        if (strcasecmp(tmp_list->data, region) == 0) ind=j;
    }

    detail.region_combo = glade_xml_get_widget (detail.main_xml, "region_combo");

    gtk_combo_box_set_model( GTK_COMBO_BOX( detail.region_combo ),
                             GTK_TREE_MODEL( detail.region_store ) );

    g_object_unref( G_OBJECT (detail.region_store));
    gtk_combo_box_entry_set_text_column( GTK_COMBO_BOX_ENTRY (detail.region_combo),0);

    gtk_widget_show(detail.region_combo);

    return(ind - 1);
}

gint fill_appellation_combo(gchar   appellation[appellation_size])
{
    GList         *tmp_list;
    GtkTreeIter    iter;
    gint           j   = 0;
    gint           ind = 0;

    /* Create appellation store and populate it */
    detail.appellation_store = gtk_list_store_new(1, G_TYPE_STRING);
    for(tmp_list  = list_appellation; tmp_list != NULL ; tmp_list  = tmp_list->next) {
        j++;
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.appellation_store, &iter);

        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_set(detail.appellation_store, &iter, 0, tmp_list->data, -1);
        if (strcasecmp(tmp_list->data, appellation) == 0) ind=j;
    }

    detail.appellation_combo = glade_xml_get_widget (detail.main_xml, "appellation_combo");

    gtk_combo_box_set_model( GTK_COMBO_BOX( detail.appellation_combo ),
                             GTK_TREE_MODEL( detail.appellation_store ) );

    g_object_unref( G_OBJECT (detail.appellation_store));
    gtk_combo_box_entry_set_text_column( GTK_COMBO_BOX_ENTRY (detail.appellation_combo),0);

    gtk_widget_show(detail.appellation_combo);

    return(ind - 1);
}

gint fill_color_combo(gchar   color[color_size])
{
    GList         *tmp_list;
    GtkTreeIter    iter;
    gint           j   = 0;
    gint           ind = 0;

    xcave_debug_begin(__FULL__);

    /* Create color store and populate it */
    detail.color_store = gtk_list_store_new(1, G_TYPE_STRING);
    for(tmp_list  = list_color; tmp_list != NULL ; tmp_list  = tmp_list->next) {
        j++;
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.color_store, &iter);

        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set(detail.color_store, &iter, 0, tmp_list->data, -1);
        if (strcasecmp(tmp_list->data, color) == 0) ind=j;
    }

    detail.color_combo = glade_xml_get_widget (detail.main_xml, "color_combo");

    gtk_combo_box_set_model( GTK_COMBO_BOX( detail.color_combo ),
                             GTK_TREE_MODEL( detail.color_store ) );

    g_object_unref( G_OBJECT (detail.color_store));
    gtk_combo_box_entry_set_text_column( GTK_COMBO_BOX_ENTRY (detail.color_combo),0);

    gtk_widget_show(detail.color_combo);
    xcave_debug_end(__FULL__);
    return(ind - 1);
}

gint fill_cepage_combo(gchar   cepage[cepage_size])
{
    GList         *tmp_list;
    GtkTreeIter    iter;
    gint           j   = 0;
    gint           ind = 0;

    xcave_debug_begin(__FULL__);

    /* Create cepage store and populate it */
    detail.cepage_store = gtk_list_store_new(1, G_TYPE_STRING);
    for(tmp_list  = list_cepage; tmp_list != NULL ; tmp_list  = tmp_list->next) {
        j++;
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.cepage_store, &iter);

        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set(detail.cepage_store, &iter, 0, tmp_list->data, -1);
        if (strcasecmp(tmp_list->data, cepage) == 0) ind=j;
    }

    detail.cepage_combo = glade_xml_get_widget (detail.main_xml, "cepage_combo");

    gtk_combo_box_set_model( GTK_COMBO_BOX( detail.cepage_combo ),
                             GTK_TREE_MODEL( detail.cepage_store ) );

    g_object_unref( G_OBJECT (detail.cepage_store));
    gtk_combo_box_entry_set_text_column( GTK_COMBO_BOX_ENTRY (detail.cepage_combo),0);

    gtk_widget_show(detail.cepage_combo);
    xcave_debug_end(__FULL__);
    return(ind - 1);
}

/*
 * GtkWindow "xcave_window".
 * button_add clicked
 */
void
on_xcave_button_add_clicked (GtkButton * button,
		                     gpointer user_data)
{

    xcave_debug_begin(__FULL__);

    NbBottleDetail = 0;

    if (detail.origine != BUTTON_RACK_ADD)
       detail.origine = BUTTON_ADD;
	
    detail_init();
	
    /*
     * color combo entry
     */
    gint ind = fill_color_combo(" ");

    /*
     * country combo entry
     */
    ind = fill_country_combo(" ");

    /*
     * region combo entry
     */
    ind = fill_region_combo(" ");

    /*
     * appellation combo entry
     */
    ind = fill_appellation_combo(" ");

    /*
     * cepage combo entry
     */
    ind = fill_cepage_combo(" ");

    detail_signal_connect();

    gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget (detail.main_xml, "spinbutton_purchase_qty")), (gfloat) 1);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget (detail.main_xml, "spinbutton_drinking_qty")), (gfloat) 1);
	
    sprintf (ach, "%d", nowan);
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "entry_purchase_year")), (gchar *) ach);
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "entry_drinking_year")), (gchar *) ach);
	
    xcave_create_treelist_purchase(); 
    xcave_create_treelist_drinking();
	
    /* 
     * for the stock - let's go
     */
    xcave_createRack((gchar *)&detail.rack, NULL);

    xcave_debug_end(__FULL__);
}

/*
 * from TreeList a row is selected - doubleclick or button_modif -
 * list_stock_rowSelect contains pointer to wine informations row in list_stock
 * display of detail_window 
 */

void
on_xcave_display_modif (Vin	*Vin_rowSelected)
{
	Purchase     *tmpPurchase;
	GList        *tmp_list_purchase;
	
	Drinking     *tmpDrinking;
	GList        *tmp_list_drinking;
	
	gint	      i;
  
	fixed=gdk_font_load("-misc-fixed-medium-*-*-*-10-*-*-*-*-*-*-*");

	/* initialisation du compteur 'Nombre de bouteille detail' */
	NbBottleDetail = 0;

    detail_init ();

    detail.statusbar_v = glade_xml_get_widget (detail.main_xml, "xcave_detail_statusbar");
    detail.statusbar_ctxtid = gtk_statusbar_get_context_id ((GtkStatusbar *)detail.statusbar_v, "default");
    detail.statusbar_id = 0;
	
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinnom")),       Vin_rowSelected->Nom);
    /* general */
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinprod")),      Vin_rowSelected->supplier);
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinprodurl")),   Vin_rowSelected->wineMakerAdr);
    sprintf (an, "%d", Vin_rowSelected->vintage);
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinan")),        (gchar *) an);
    /*
     * country combo entry
     */
    gint           ind = 0;

    ind = fill_country_combo(Vin_rowSelected->country);
    gtk_combo_box_set_active( GTK_COMBO_BOX (detail.country_combo),ind);
    xcave_debug_int(__FULL__,"ind country_combo",ind);

    /*
     * region combo entry
     */
    ind = fill_region_combo(Vin_rowSelected->Region);
    gtk_combo_box_set_active( GTK_COMBO_BOX (detail.region_combo), ind);
    xcave_debug_int(__FULL__,"ind regio_combo",ind);

    /*
     * appellation combo entry
     */
    ind = fill_appellation_combo(Vin_rowSelected->Appellation);
    gtk_combo_box_set_active( GTK_COMBO_BOX (detail.appellation_combo), ind);
    xcave_debug_int(__FULL__,"ind appellation_combo",ind);

    /*
     * cepage combo entry
     */
    ind = fill_cepage_combo(Vin_rowSelected->Cepage);
    gtk_combo_box_set_active( GTK_COMBO_BOX (detail.cepage_combo), ind);

    ind = fill_color_combo(Vin_rowSelected->color);
    gtk_combo_box_set_active( GTK_COMBO_BOX (detail.color_combo), ind);

    detail_signal_connect();

	sprintf (cons, "%d", Vin_rowSelected->Conserv);
	gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vincons")),      (gchar *) cons);
	gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vintemp")),      Vin_rowSelected->temperatureDeDegustation);
	
	/* stock */
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget (detail.main_xml, "spinbutton_purchase_qty")), (guint) Vin_rowSelected->qty);

	/* 
	 * for the stock - let's go
	 */
	xcave_createRack((gchar *)&detail.rack, Vin_rowSelected->list_emplacement);

	/* Purchase */
	GtkTreeIter 	pIter;
	
	xcave_create_treelist_purchase();
	
	tmpPurchase = g_malloc (sizeof(Purchase));
	memset(tmpPurchase,'\0',sizeof(Purchase));

	detail.purchase_liststore	=(GtkListStore *)  gtk_tree_view_get_model((GtkTreeView *)detail.purchase_treeview);
	gtk_list_store_clear(GTK_LIST_STORE(detail.purchase_liststore));

	for(tmp_list_purchase = Vin_rowSelected->list_purchase;
		tmp_list_purchase != NULL; 
		tmp_list_purchase = tmp_list_purchase->next) {

		memset(tmpPurchase,'\0',sizeof(Purchase));
		memcpy(tmpPurchase,tmp_list_purchase->data,sizeof(Purchase));

          gchar   tmpPrice[12];
          g_snprintf(tmpPrice,sizeof(tmpPrice),"%9.2f",tmpPurchase->Prix);

          /* 
           * Appends a new row to list_store. iter will be changed to point to this new row.
           * The row will be empty after this function is called.
           */
          gtk_list_store_append(detail.purchase_liststore, &pIter);

          /*
           * Sets the value of one or more cells in the row referenced by iter.
           */
          gtk_list_store_set(detail.purchase_liststore, &pIter,
					COL_TREELIST_PURCHASE_DATE, (guint)tmpPurchase->Achat,
					COL_TREELIST_PURCHASE_QTY, (guint)tmpPurchase->qty,
					COL_TREELIST_PURCHASE_PRICE, &tmpPrice, 
					COL_TREELIST_SUPPLIER, &tmpPurchase->Supplier,
					COL_TREELIST_SUPPLIER_ADR, &tmpPurchase->SupplierAdr,
									-1);			

	   NbBottleDetail += tmpPurchase->qty;
	}
	g_free(tmpPurchase);

	g_object_unref(detail.purchase_liststore);

	gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget (detail.main_xml, "spinbutton_purchase_price")), (gfloat) 0);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget (detail.main_xml, "spinbutton_purchase_qty")), (guint) 1);
	sprintf (ach, "%d", nowan);
	gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "entry_purchase_year")),       (gchar *) ach);

	/* drinking */
	xcave_create_treelist_drinking();

	detail.drinking_liststore = (GtkListStore *) gtk_tree_view_get_model((GtkTreeView *)detail.drinking_treeview);
	gtk_list_store_clear(GTK_LIST_STORE(detail.drinking_liststore));
	
	tmpDrinking = g_malloc (sizeof(Drinking));
	
	for(tmp_list_drinking = Vin_rowSelected->list_drinking; 
		tmp_list_drinking != NULL; 
		tmp_list_drinking = tmp_list_drinking->next) {

            GdkPixbuf     *icon;
            GError        *error = NULL;

            memset(tmpDrinking,'\0',sizeof(Drinking));
            memcpy(tmpDrinking,tmp_list_drinking->data,sizeof(Drinking));

	        if (tmpDrinking->degustation_sheet_id != (time_t)0) 
	           icon = create_pixbuf("xcave_degustation.png");
	        else 
	           icon = gdk_pixbuf_new_from_file("", &error);

        gtk_list_store_append(detail.drinking_liststore, &pIter);
        gtk_list_store_set(detail.drinking_liststore, &pIter,
                                        COL_TREELIST_ICON,icon,
                                        COL_TREELIST_DRINKING_DATE, (guint)tmpDrinking->Conso,
                                        COL_TREELIST_DRINKING_QTY, (guint)tmpDrinking->qty,
                                        COL_TREELIST_NOTE, tmpDrinking->Note,
                                        COL_TREELIST_COMMENTAIRE, tmpDrinking->Commentaire,
                                        COL_TREELIST_SHEET_ID,tmpDrinking->degustation_sheet_id,
                                        -1);			

	   NbBottleDetail -= tmpDrinking->qty;
	}

	g_free(tmpDrinking);
	g_object_unref(detail.drinking_liststore);

	gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "entry_drinking_year")),       (gchar *) ach);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget (detail.main_xml, "spinbutton_drinking_qty")), (guint) 1);

	sprintf (detail.statusbar_txt, _("Number of bottles for the selection : %d"), NbBottleDetail);
	/* gestion du nombre de bouteille pour le vin selectionné  */
	if (detail.statusbar_id != 0) gtk_statusbar_remove ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_id);
	detail.statusbar_id = gtk_statusbar_push ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_txt);
	
	/* commentaire */
	GtkWidget		*vincom;
	GtkTextBuffer	*buffer_vincom;
	
	vincom 	= glade_xml_get_widget (detail.main_xml, "vincom");
	buffer_vincom = gtk_text_view_get_buffer (GTK_TEXT_VIEW (vincom));/* C */
	
       /*
	* commentaire. Remplacement de tout les carateres ² par <CR> avant affichage.
	* le caractere <CR> indique un fin d'enregistrement dans un fichier stream.
	*/
	for ( i=0 ; i < (comment_size - 1) ; i++) 
		if (strncmp(&Vin_rowSelected->Commentaire[i], "²",1) == 0) 
			strncpy(&Vin_rowSelected->Commentaire[i],"\n",1);

 	gtk_text_buffer_set_text (buffer_vincom, Vin_rowSelected->Commentaire, -1);
	gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinnote")), Vin_rowSelected->Note);
					
}

void
on_xcave_button_modif_clicked  (GtkButton       *button,
                                gpointer         user_data)
{
  
    Vin			  *Vin_rowSelected;

   /*
    * we need selected data 
    */
   Vin_rowSelected = xcave_id_selected_treelist_row();

   if (Vin_rowSelected != NULL) {
      /* 
       * desactive xcave.window
       */
      gtk_widget_set_sensitive(xcave.window, FALSE);

      detail.origine = BUTTON_MODIF;

      on_xcave_display_modif(Vin_rowSelected);
}

}

/*
 *	
 *
 */
void
on_xcave_detail_button_ok_clicked (GtkButton * button,
									gpointer user_data)
{
    Vin         *tmpVin;
    Vin         *Vin_rowSelected;
    ptrCateg     ptmpCtg;
    GtkTreeIter  iter;

    tmpVin = g_malloc ( sizeof(Vin) );
    memset(tmpVin, '\0', sizeof( Vin ));
    strcpy (tmpVin->Nom, gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinnom"))));

    /* get data from vpaned 'general' */
    strcpy (tmpVin->supplier, gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinprod"))));
    strcpy (tmpVin->wineMakerAdr,	gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinprodurl"))));
    tmpVin->vintage = atoi (gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinan"))));

    tmpVin->Conserv   = atoi (gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vincons"))));
    strcpy (tmpVin->temperatureDeDegustation, gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vintemp"))));
	
    strcpy (tmpVin->color,      gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.color_combo)));
    strcpy (tmpVin->country,    gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.country_combo)));
    strcpy (tmpVin->Region,     gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.region_combo)));
    strcpy (tmpVin->Appellation,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.appellation_combo)));
    strcpy (tmpVin->Cepage,     gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.cepage_combo)));

	/*
	 * get data from vpaned 'racks'
	 */
	tmpVin->qty = 0;

	/*
	 * on supprime l(es) emplacements en cas de duplication
	 * -> bug si l'utilisateur a modifie l emplacement !
	 */
	if (detail.origine != BUTTON_DUPLICATE)
		tmpVin->list_emplacement = xcave_rackTreatment(tmpVin->Nom);
	
	/*
	 * get data from vpaned 'purchase'
	 */
	gboolean		btreelist = TRUE;
	Purchase		*tmp_purchase;
	
        detail.purchase_liststore = (GtkListStore *) gtk_tree_view_get_model((GtkTreeView *)detail.purchase_treeview);

	btreelist = gtk_tree_model_get_iter_first((GtkTreeModel *)detail.purchase_liststore, &iter);
	   												
	while (btreelist == TRUE) {
		gchar	*pSupplier;
		gchar	*pSupplierAdr;
		gchar	*pPrice;
	
		tmp_purchase = g_malloc(sizeof(Purchase));
		pSupplier    = g_malloc(supplier_size);
		pSupplierAdr = g_malloc(supplierAdr_size);
		pPrice       = g_malloc(price_size);

		memset(tmp_purchase,'\0',sizeof(Purchase));
		memset(pSupplier,'\0',supplier_size);
		memset(pSupplierAdr,'\0',supplierAdr_size);
		memset(pPrice,'\0',price_size);
	
               gtk_tree_model_get ((GtkTreeModel *)detail.purchase_liststore, &iter, 
							COL_TREELIST_PURCHASE_DATE, &tmp_purchase->Achat,
							COL_TREELIST_PURCHASE_QTY, &tmp_purchase->qty,
							COL_TREELIST_PURCHASE_PRICE, &pPrice,
							COL_TREELIST_SUPPLIER, &pSupplier,
							COL_TREELIST_SUPPLIER_ADR, &pSupplierAdr,
							-1);
	
		strcpy(tmp_purchase->Supplier,pSupplier);
		strcpy(tmp_purchase->SupplierAdr,pSupplierAdr);
		tmp_purchase->Prix = atof(pPrice);
		g_free(pSupplier);
		g_free(pSupplierAdr);
		g_free(pPrice);
		
		tmpVin->list_purchase = g_list_append(tmpVin->list_purchase, tmp_purchase);
	
		btreelist = gtk_tree_model_iter_next((GtkTreeModel *)detail.purchase_liststore,
                                             &iter);
		tmpVin->qty += tmp_purchase->qty;
	}
											  
	/*
	 * get data from vpaned 'drinking'
	 */
	Drinking		*tmp_drinking;

	detail.drinking_liststore	= (GtkListStore *)gtk_tree_view_get_model((GtkTreeView *)detail.drinking_treeview);

	btreelist = gtk_tree_model_get_iter_first((GtkTreeModel *)detail.drinking_liststore, &iter);
	
	while (btreelist == TRUE) {

		gchar	*pNote;
		gchar	*pCommentaire;
	
		pNote = g_malloc(rated_size);
		pCommentaire = g_malloc(comment_size);
		tmp_drinking = g_malloc(sizeof(Drinking));
                memset(tmp_drinking, '\0', sizeof( Drinking ));
	
		gtk_tree_model_get ((GtkTreeModel *)detail.drinking_liststore, &iter,
                            COL_TREELIST_DRINKING_DATE, &tmp_drinking->Conso,
                            COL_TREELIST_DRINKING_QTY, &tmp_drinking->qty,
                            COL_TREELIST_NOTE, &pNote,
                            COL_TREELIST_COMMENTAIRE, &pCommentaire,
                            COL_TREELIST_SHEET_ID,&tmp_drinking->degustation_sheet_id,
                            -1);
	
                xcave_debug_2str(__FULL__,"degustation-sheet-id",25,ctime((time_t *)&tmp_drinking->degustation_sheet_id));

		strcpy(tmp_drinking->Note, pNote);
		strcpy(tmp_drinking->Commentaire, pCommentaire);
		g_free(pNote);
		g_free(pCommentaire);
	
		tmpVin->list_drinking = g_list_append(tmpVin->list_drinking, tmp_drinking);
	
		btreelist = gtk_tree_model_iter_next((GtkTreeModel *)detail.drinking_liststore, &iter);
		tmpVin->qty -= tmp_drinking->qty;

		/*
		 * degustation sheet 
		 */
		GList              *tmp_list_ds;
		degustation_sheet  *tmp_ds;

        for(tmp_list_ds = list_ds; tmp_list_ds != NULL; tmp_list_ds = tmp_list_ds->next) {
            tmp_ds = g_malloc ( sizeof(degustation_sheet) );
            memset(tmp_ds,'\0',sizeof(degustation_sheet));
            memcpy(tmp_ds,tmp_list_ds->data,sizeof(degustation_sheet));
            if (tmp_ds->degustation_sheet_id == tmp_drinking->degustation_sheet_id) {
                tmpVin->list_degustation = g_list_append(tmpVin->list_degustation, tmp_ds);
		        /*
		         * if the degustation sheet exist before, it must be suppress before.
		         * The ds can exist if the drinking line was modified and not created.
		         */
		        GList              *tmp_list_full_ds;
		        degustation_sheet  *tmp_full_ds;
                tmp_full_ds = g_malloc ( sizeof(degustation_sheet) );
                for(tmp_list_full_ds = list_full_ds; tmp_list_full_ds != NULL; tmp_list_full_ds = tmp_list_full_ds->next) {
                    memset(tmp_full_ds,'\0',sizeof(degustation_sheet));
                    memcpy(tmp_full_ds,tmp_list_full_ds->data,sizeof(degustation_sheet));
                    if (tmp_full_ds->degustation_sheet_id == tmp_drinking->degustation_sheet_id) {
                        list_full_ds = g_list_remove_link(list_full_ds,tmp_list_full_ds);
			g_list_free1(tmp_list_full_ds);
			break;
                    } else {
                        xcave_debug_msg_int(__FULL__,"g_list_remove(list_full_ds) ko",5,g_list_length(list_full_ds));
                    }
		        }
                g_free(tmp_full_ds);
                list_full_ds = g_list_append(list_full_ds, tmp_ds);
		    }
		    else
              g_free(tmp_ds);
	        xcave_debug_msg_int(__FULL__,"list_full_ds",2,g_list_length(list_full_ds));
		}
	}
	
	/*
	 * get data from vpaned 'comment'
	 */
	GtkWidget		*vincom;
	GtkTextBuffer	*buffer_vincom;
	GtkTextIter		start_vincom;
	GtkTextIter 	end_vincom;
	gchar			*comment;
	
	vincom 	= glade_xml_get_widget (detail.main_xml, "vincom");
	buffer_vincom = gtk_text_view_get_buffer (GTK_TEXT_VIEW (vincom));

	gtk_text_buffer_get_start_iter(buffer_vincom,&start_vincom);
	gtk_text_buffer_get_end_iter(buffer_vincom,&end_vincom);
	
	comment = g_malloc(gtk_text_buffer_get_char_count(buffer_vincom) );
	comment = gtk_text_buffer_get_text(buffer_vincom, &start_vincom, &end_vincom, FALSE );

	strcpy(tmpVin->Commentaire,comment);
	g_free(comment);
	
	/*
	 * commentaire. Remplacement de tout les carateres <CR> par ² avant mise à jour du fichier stocks.
	 * le caractere <CR> indique un fin d'enregistrement dans un fichier stream.
	 */
	gint i;
	for ( i=0 ; i < (comment_size - 1) ; i++) 
		if (strncmp(&tmpVin->Commentaire[i], "\n",1) == 0) strncpy(&tmpVin->Commentaire[i],"²",1);

	/*
	 * drinking wine rate ... or whatever u want
	 */
	strcpy (tmpVin->Note,gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget (detail.main_xml, "vinnote"))));

	/*
	 * coherency controls
	 */
	gboolean	check_ok = TRUE;
	
        /* 
         * need traces
         */
        xcave_debug_str(__FULL__,tmpVin->Nom);
        xcave_debug_str(__FULL__,tmpVin->color);
        xcave_debug_str(__FULL__,tmpVin->country);
        xcave_debug_str(__FULL__,tmpVin->Region);
        xcave_debug_str(__FULL__,tmpVin->Appellation);

	if ( strlen (tmpVin->Nom)	== 0 && check_ok == TRUE ) {
		quick_message (_(" Wine name's missing "));
		check_ok = FALSE;
	}
	if (strlen (tmpVin->color) == 0 && check_ok == TRUE ) {
		quick_message (_(" Color's missing "));
		check_ok = FALSE;
	}
	if ( (tmpVin->vintage < 1800 || tmpVin->vintage > nowan) && check_ok == TRUE ) {
		quick_message (_(" Vintage year's error "));
		check_ok = FALSE;
	}
	if ( tmpVin->Conserv < 0 && check_ok == TRUE )  {
		quick_message (_(" Data number of year for conservation is false "));
		check_ok = FALSE;
	}
	if ( strlen (tmpVin->country)	== 0 && check_ok == TRUE ) {
		quick_message (_(" Country's missing "));
		check_ok = FALSE;
	}
	if ( strlen (tmpVin->Region)	== 0 && check_ok == TRUE ) {
		quick_message (_(" Region's missing "));
		check_ok = FALSE;
	}
        xcave_debug_str(__FULL__,tmpVin->Appellation);
	if ( strlen (tmpVin->Appellation) == 0 && check_ok == TRUE ) {
		quick_message (_(" Appellation's missing "));
		check_ok = FALSE;
	}

	/*
	 * gestion des doublons
	 */
	if ( (detail.origine == BUTTON_ADD || detail.origine == BUTTON_RACK_ADD)
		&&
		 (g_list_find_custom(list_stock,(gpointer) tmpVin,(GCompareFunc)find_existing_wine) != NULL) 
		&&
		 (check_ok == TRUE)
		) {
		quick_message (_("A wine with similar characteristic\n\tcountry\n\tregion\n\tappellation\n\tdomain\n\tvintage is already in the cellar"));
		check_ok = FALSE;
	}

	if (tmpVin->qty < g_list_length(tmpVin->list_emplacement) && check_ok == TRUE ) {
		quick_message (_(" More bottles in Emplacement than in the stocks "));
		check_ok = FALSE;
	}
	
	if (tmpVin->qty < 0 && check_ok == TRUE ) {
		quick_message (_(" You drink too much (more bottles drinking than purchase ! "));
		check_ok = FALSE;
	} 

	if ( 	check_ok == TRUE ) {

		 /* controle de la relation region/appellation 
			for(tmp_list_appellation = list_appellation; 
				tmp_list_appellation != NULL; 
				tmp_list_appellation = tmp_list_appellation->next) {
				  memcpy(&tmpApp,tmp_list_appellation->data,appellation_size);
				  if (  (  strcasecmp (data->Appellation, tmpApp.Appellation) == 0 
						&& strcasecmp (data->Region     , tmpApp.Region     ) != 0) 
					 || (  strcasecmp (data->Appellation, tmpApp.Appellation) == 0 
						&& strcasecmp (data->Region     , tmpApp.Region     ) != 0))
						   quick_message (_(" No such appellation for this region "));
		}
		if (tmp_list_appellation == (g_list_last(list_appellation)))
		{
		}
		*/

		/* Positionnement du flag 'maturite' */
        if (tmpVin->qty == 0)
     	    tmpVin->Maturite = -2000;
        else
            if (tmpVin->vintage ==0 || tmpVin->Conserv == 0) 
	       tmpVin->Maturite = -1000;
            else 
               tmpVin->Maturite=(100*(nowan-(tmpVin->vintage))/tmpVin->Conserv);

		switch(detail.origine) {
			case (BUTTON_ADD): /* creation d un nouveau vin*/  
				list_stock = g_list_append(list_stock ,tmpVin);
				list_stock = g_list_sort(list_stock,(GCompareFunc)cmp_stock);
		        detail.origine = NO_BUTTON;
                /*
                 * need to clean the list_ds
                 */
                xcave_debug_msg_int(__FULL__,"list_ds",2,g_list_length(list_ds));
                list_ds = xcave_g_list_free(list_ds);
                xcave_debug_msg_int(__FULL__,"list_ds",2,g_list_length(list_ds));
                break;
				
			case (BUTTON_RACK_ADD): /* creation d un nouveau vin*/
				list_stock = g_list_append(list_stock ,tmpVin);
				list_stock = g_list_sort(list_stock,(GCompareFunc)cmp_stock);
				/* window should be closed, list_append_rack should free data 
				   used by rack.window. We could possibly imagine open again
				   rack.window ... or redesign large amount of xcave (-; */
		        detail.origine = BUTTON_RACK;
				break;
	
			case (BUTTON_MODIF): /* modification d'un vin deja existant */
				/* identifier le vin qui a ete modifie */
	
				/* we need selected data  */
				Vin_rowSelected = xcave_id_selected_treelist_row();
	
				/*
				 * BEWARE - update of the data straight in the list_stock
				 * 			get a pointer on the glist element from COL_TREELIST_PDATA
				 *			of GtkTreeList TreeList
				 */
			
				/* Emplacement */
				/* liberer la liste precedente avant svp */
				Vin_rowSelected->list_emplacement = xcave_g_list_free(Vin_rowSelected->list_emplacement);
		
				/* Purchase */
				/* liberer la liste precedente avant svp */
				Vin_rowSelected->list_purchase = xcave_g_list_free(Vin_rowSelected->list_purchase);
				
				/* Drinking */
				/* liberer la liste precedente avant svp */
				Vin_rowSelected->list_drinking = xcave_g_list_free(Vin_rowSelected->list_drinking);
				
				list_stock = g_list_remove(list_stock, Vin_rowSelected);
				list_stock = g_list_append(list_stock ,tmpVin);
	
		        detail.origine = NO_BUTTON;
				break;
				
			case (BUTTON_RACK_MODIF):
				/* identifier le vin qui a ete modifie */
	
				/* we need selected data  */
				Vin_rowSelected = xcave_id_selected_toggledbutton();

				/* Emplacement */
				/* liberer la liste precedente avant svp */
				Vin_rowSelected->list_emplacement = xcave_g_list_free(Vin_rowSelected->list_emplacement);
		
				/* Purchase */
				/* liberer la liste precedente avant svp */
				Vin_rowSelected->list_purchase = xcave_g_list_free(Vin_rowSelected->list_purchase);
				
				/* Drinking */
				/* liberer la liste precedente avant svp */
				Vin_rowSelected->list_drinking = xcave_g_list_free(Vin_rowSelected->list_drinking);
	
				list_stock = g_list_remove(list_stock, Vin_rowSelected);
				list_stock = g_list_append(list_stock ,tmpVin);
				
				/* window should be closed, list_append_rack should free data 
				   used by rack.window. We could possibly imagine open again
				   rack.window ... or redesign large amount of xcave (-; */
		        detail.origine = BUTTON_RACK;
				break;
				
			case (BUTTON_DUPLICATE): /* creation d un nouveau vin*/  
				list_stock = g_list_append(list_stock ,tmpVin);
				list_stock = g_list_sort(list_stock,(GCompareFunc)cmp_stock);

		        detail.origine = NO_BUTTON;
				break;
				
			case (BUTTON_RACK_DUPLICATE): /* creation d un nouveau vin*/
				list_stock = g_list_append(list_stock ,tmpVin);
				list_stock = g_list_sort(list_stock,(GCompareFunc)cmp_stock);
				/* window should be closed, list_append_rack should free data 
				   used by rack.window. We could possibly imagine open again
				   rack.window ... or redesign large amount of xcave (-; */
		        detail.origine = BUTTON_RACK;
				break;
	
			default:
				break;
		}

		list_stock = g_list_sort(list_stock,(GCompareFunc)cmp_stock);
		xcave_xmlWrite(DBPATH);

		/*
		 * need to update storeview_xcave_wine_origin and storelist
		 */
		xcave.information_treestore =(GtkTreeStore *) gtk_tree_view_get_model((GtkTreeView *)xcave.information_treeview);
                gtk_tree_store_clear(GTK_TREE_STORE(xcave.information_treestore));

		xcave_fill_model (xcave.origin_treestore, xcave.information_treestore);

		/*
		 * penser à mettre à jour la liste emplacement
		 */
		list_append_rack();
	
		ptmpCtg = g_malloc (sizeof(Categ));
		memset(ptmpCtg, '\0', sizeof( Categ ));
		strcpy(ptmpCtg->color,     tmpVin->color );
		strcpy(ptmpCtg->country,        tmpVin->country );
		strcpy(ptmpCtg->Region,      tmpVin->Region );
		strcpy(ptmpCtg->Appellation, tmpVin->Appellation );
	
		if (g_list_find_custom(list_categ,(gpointer) ptmpCtg,(GCompareFunc)find_categ) == NULL) {
 		   list_append_categ();
		}
	
		gtk_object_destroy (GTK_OBJECT (detail.window));

		if (detail.origine == BUTTON_RACK) {
           GtkButton *button = NULL;     /* 2.3.2 */
           gpointer   user_data = NULL;  /* 2.3.2 */
		   gtk_object_destroy (GTK_OBJECT (rack.window));
		   on_xcave_button_rack_clicked(button, user_data);
		}
		else
		   gtk_widget_set_sensitive(xcave.window, TRUE);
		
		/* 
		 * synthese update
		 */
        if (xcave.statusbar_id != 0) 
           gtk_statusbar_remove ((GtkStatusbar *)xcave.statusbar_v, xcave.statusbar_ctxtid, xcave.statusbar_id);

	    sprintf (xcave.statusbar_txt, _("Number of bottles in cellar : %d"), NbBottleStock);
        xcave.statusbar_id = gtk_statusbar_push ((GtkStatusbar *)xcave.statusbar_v, xcave.statusbar_ctxtid, xcave.statusbar_txt);
    } else {
		xcave_debug_str(__FULL__,"on_xcave_detail_button_ok_clicked:clean up the mess:\n");
		/* 
		 * suite à erreur de controle 
		 * liberation de la memoire allouee
		 */
		xcave_g_list_free(tmpVin->list_emplacement);
		xcave_g_list_free(tmpVin->list_drinking);
		xcave_g_list_free(tmpVin->list_purchase);
		g_free(tmpVin);
	}
}

/* 
 * GtkWindow 'detail_window'
 * button_add_cancel clicked
 */
void
on_xcave_detail_button_cancel_clicked (GtkButton * button,
		                               gpointer user_data)
{
		
	if (detail.origine == BUTTON_ADD || detail.origine == BUTTON_MODIF) {
		gtk_widget_set_sensitive(xcave.window, TRUE);
		detail.origine = NO_BUTTON;
	}
	else {
		gtk_widget_set_sensitive(rack.window, TRUE);
		/* we need selected data for gtk_oggle_button_set_active (GTK_TOGGLE_BUTTON (toggledbutton),FALSE); */
		Vin		*Vin_rowSelected;
		Vin_rowSelected = xcave_id_selected_toggledbutton();
		detail.origine = BUTTON_RACK;
	}

	gtk_object_destroy (GTK_OBJECT (detail.window));

	/*
	 * need to clean the list_ds (temporary degustation list)
	 */
    if (lDS != NULL) {
	   xcave_debug_str(__FULL__,"g_free(lDS)");
	}

	xcave_debug_msg_int(__FULL__,"xcave_g_list_free(list_ds)",2,g_list_length(list_ds));
	list_ds = xcave_g_list_free(list_ds);
}

/* 
 * GtkWindow 'detail_window'
 * button_duplicate_clicked
 */
void
on_xcave_detail_button_duplicate_clicked(GtkButton       *button,
                                         gpointer         user_data)
{

	if (detail.origine == BUTTON_MODIF) {
		
	   gtk_window_set_title(GTK_WINDOW (detail.window), _("Duplicate wine"));

	   if (detail.origine == BUTTON_RACK_MODIF)
	      detail.origine = BUTTON_RACK_DUPLICATE;
	   else
	      detail.origine = BUTTON_DUPLICATE;
	
	   on_xcave_detail_button_ok_clicked(button, &user_data);
	}
}

/*
 * GtkWindow 'detail'
 * destroy signal
 */
void
on_xcave_detail_destroy (GtkObject * object, gpointer user_data)
{
		
	/* 
	 * reactive xcave.window
	 */
	if (detail.origine == BUTTON_ADD || detail.origine == BUTTON_MODIF || detail.origine == BUTTON_DUPLICATE)
		gtk_widget_set_sensitive(xcave.window, TRUE);

}

void
on_xcave_detail_check_resize                 (GtkContainer    *container,
                                        gpointer         user_data)
{

   xcave_debug_begin(__FULL__);
   gint height = 0;
   gint width = 0;

   gdk_window_get_size( container->widget.window , &width, &height);

   sprintf(WindowsDetailWidth,"%d",width);
   sprintf(WindowsDetailHeight,"%d",height);

   xcave_debug_end(__FULL__);
}

