/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

void on_xcave_consdeg_check_resize (GtkContainer *, gpointer );

void
xcave_create_consdeg_treeview(void)
{
	GtkTreeViewColumn   *col;
	GtkCellRenderer     *renderer;

    /* create view consdeg.treeview */
    consdeg.treeview =glade_xml_get_widget(consdeg.main_xml,"xcave_consdeg_treeview");
	gtk_widget_show (consdeg.treeview);
	
	/* Creates a new tree store as with n_columns columns each of the types passed in. */
    consdeg.liststore = gtk_list_store_new(NUM_COLS_TREELIST_DEGUSTATION,
										   G_TYPE_STRING,
										   G_TYPE_UINT);

    /* --- TreeList Column #1 --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("Appellation"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_DEGUSTATION_APPELLATION, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(consdeg.treeview), col);
	
    /* --- TreeList Column #2 --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("Id"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_DEGUSTATION_ID, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(consdeg.treeview), col);
	gtk_tree_view_column_set_visible (col,FALSE);

	{
		degustation_sheet *tmp_ds;
	    GList             *tmp_list_ds;
		GtkTreeIter 	   pIter;

	    tmp_ds = g_malloc (sizeof(degustation_sheet));
    	memset(tmp_ds,'\0',sizeof(degustation_sheet));

	    for(tmp_list_ds = list_full_ds;
		   tmp_list_ds != NULL; 
		   tmp_list_ds = tmp_list_ds->next) {

		   memset(tmp_ds,'\0',sizeof(degustation_sheet));
		   memcpy(tmp_ds,tmp_list_ds->data,sizeof(degustation_sheet));

		   gtk_list_store_append(consdeg.liststore, &pIter);
		   gtk_list_store_set(consdeg.liststore, &pIter,
					COL_TREELIST_DEGUSTATION_APPELLATION, &tmp_ds->appellation,
					COL_TREELIST_DEGUSTATION_ID         , (guint)tmp_ds->degustation_sheet_id,	
					-1);			

	   }
	   g_free(tmp_ds);
	}

	gtk_tree_view_set_model(GTK_TREE_VIEW(consdeg.treeview), GTK_TREE_MODEL(consdeg.liststore));

	/*
	 * alternance de couleur de fond pour chaque ligne
	 */
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(consdeg.treeview),TRUE);

    return;
}

void
on_xcave_button_degustation_clicked (GtkButton * button,
		                                     gpointer user_data)
{
  
	/* 
	 * desactive xcave.window
	 */
	gtk_widget_set_sensitive(xcave.window, FALSE);

    consdeg.main_xml = glade_xml_new (XCAVE_GLADE_FILE, "xcave_consdeg", NULL);

    /* get the xcave_consdeg & label widgets from the glade XML file */
    consdeg.window = glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg");
    glade_xml_signal_autoconnect (consdeg.main_xml);

    xcave_create_consdeg_treeview ();

    /*
     * redimensionnement de la fenetre
     */
    if ( strlen(WindowsConsultDegustationHeight) != 0 && strlen (WindowsConsultDegustationWidth) != 0 ) {
        gtk_window_resize (GTK_WINDOW (consdeg.window), atoi(WindowsConsultDegustationWidth), atoi(WindowsConsultDegustationHeight));
    }
	
	gtk_widget_show (consdeg.window);

}

void
on_xcave_consdeg_destroy   (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_object_destroy (GTK_OBJECT (consdeg.window));

   /* 
    * reactive xcave.window
    */
   gtk_widget_set_sensitive(xcave.window, TRUE);

}

void
on_xcave_consdeg_check_resize
                                        (GtkContainer    *container,
                                        gpointer         user_data)
{
   gint height = 0;
   gint width = 0;

   gdk_window_get_size( container->widget.window , &width, &height);

   sprintf(WindowsConsultDegustationWidth,"%d",width);
   sprintf(WindowsConsultDegustationHeight,"%d",height);

}

gboolean
on_xcave_consdeg_treeview_row_activated(GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	
	degustation_sheet    *tmp_ds_selected;
    degustation_sheet    *tmp_ds;
    GList                *tmp_list_ds; 
    struct tm *           stnow;

	GtkTreeSelection     *selection;
	GtkTreeModel         *model;
	GtkTreeIter           selected_row;

    tmp_ds_selected = g_malloc (sizeof(degustation_sheet));
   	memset(tmp_ds_selected,'\0',sizeof(degustation_sheet));
		
	consdeg.liststore = 
			(GtkListStore *) gtk_tree_view_get_model((GtkTreeView *)consdeg.treeview);

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(consdeg.treeview));

    if (gtk_tree_selection_get_selected(selection, &model, &selected_row)) {
        gtk_tree_model_get (model, &selected_row, 
					COL_TREELIST_DEGUSTATION_APPELLATION, (gchar *)&tmp_ds_selected->appellation,
					COL_TREELIST_DEGUSTATION_ID         , &tmp_ds_selected->degustation_sheet_id,	
                    -1);

        tmp_ds = g_malloc ( sizeof(degustation_sheet) );
        for(tmp_list_ds = list_full_ds; tmp_list_ds != NULL ; tmp_list_ds = tmp_list_ds->next) {
           memcpy(tmp_ds,tmp_list_ds->data,sizeof(degustation_sheet));
           if (tmp_ds_selected->degustation_sheet_id == tmp_ds->degustation_sheet_id) {

              /*
               * INFORMATION FRAME
               */
               stnow=localtime(&tmp_ds->degustation_sheet_id);
               gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_year_spinbutton")), 
                                 (gfloat)stnow->tm_year+1900);
               gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_day_spinbutton")), 
                                 (gfloat)stnow->tm_mday);
               gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_month_spinbutton")), 
                                 (gfloat)stnow->tm_mon+1);

              /*
    	       * degustation sheet id is not anymore sensitive
	           */
               gtk_widget_set_sensitive (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_year_spinbutton"), FALSE);
               gtk_widget_set_sensitive (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_month_spinbutton"), FALSE);
               gtk_widget_set_sensitive (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_day_spinbutton"), FALSE);

              /*
               * WINE FRAME
               */
               gtk_entry_set_text (
                  GTK_ENTRY (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_domain_entry")),
                  tmp_ds->domain);

               gtk_entry_set_text (
                  GTK_ENTRY (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_app_entry")),
                  tmp_ds->appellation);

               gtk_entry_set_text (
                  GTK_ENTRY (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_reg_entry")),
                  tmp_ds->region);

               sprintf (an, "%d", tmp_ds->vintage);
               gtk_entry_set_text (
                  GTK_ENTRY (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_vintage_entry")),
                  an);

               gtk_entry_set_text (
                  GTK_ENTRY (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_color_entry")),
                  tmp_ds->color);

               gtk_entry_set_text (
                  GTK_ENTRY (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_producer_entry")),
                  tmp_ds->producer);

               gtk_entry_set_text (
                  GTK_ENTRY (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_degree_entry")),
                  tmp_ds->degree);

               /*
                * BALANCE SHEET FRAME
                */
                gtk_entry_set_text (
                   GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_dbn_entry")),
                   tmp_ds->dbn_text);

                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_persistency_hscale")),
                   (gdouble)tmp_ds->persistency_hscale);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_persistency_entry")),
                    tmp_ds->persistency_text);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_default_entry")),
                    tmp_ds->default_text);

		        gchar buf[4];
		        sprintf(buf,"%d",tmp_ds->maturity_spinbutton);
                gtk_entry_set_text (GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_maturity_entry")), 
                    buf);

		        sprintf(buf,"%d",tmp_ds->worth_keeping_spinbutton);
                gtk_entry_set_text (GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_worth_keeping_entry")), 
                    buf);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_dish_entry")),
                    tmp_ds->dish_text);

		        sprintf(buf,"%d",tmp_ds->global_rate_spinbutton);
                gtk_entry_set_text (GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_rate_entry")), 
                   buf);
		   
                /*
                 * VISUAL FRAME
                 */
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_depth_hscale")),
                    (gdouble)tmp_ds->depth_hscale);
   
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_depth_entry")),
                    tmp_ds->depth_text);
 
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_tint_hscale")),
                    (gdouble)tmp_ds->tint_hscale);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_tint_entry")),
                     tmp_ds->tint_text);

	            /*
                 * Gestion d'une image presentant les differentes robes du vin en fonction de la couleur
                xcave_consdeg_sight_image = glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_information_vbox");

		        if (strcmp(_(tmp_ds->color),_("RED")) == 0 )
                   xcave_consdeg_sight_image = create_pixmap (consdeg.window, "xcave_red_tint.png");
	            if (strcmp(_(tmp_ds->color),_("WHITE")) == 0 )
                   xcave_consdeg_sight_image = create_pixmap (consdeg.window, "xcave_white_tint.png");
                if (strcmp(_(tmp_ds->color),_("SPARKLING")) == 0 )
                   xcave_consdeg_sight_image = create_pixmap (consdeg.window, "xcave_sparkling.png");

                gtk_widget_show (xcave_consdeg_sight_image);
                gtk_box_pack_end (GTK_BOX (glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_information_vbox")), xcave_consdeg_sight_image, TRUE, TRUE, 0);

	            */

                /*
                 * OLFACTIVE FRAME
                 */
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_sos_hscale")),
                     (gdouble)tmp_ds->sos_hscale);
   
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_sos_entry")),
                    tmp_ds->sos_text);
   
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_floral_hscale")),
                    (gdouble)tmp_ds->floral_hscale);
  
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_floral_entry")),
                    tmp_ds->floral_text);
   
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_fruity_hscale")),
                    (gdouble)tmp_ds->fruity_hscale);
  
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_fruity_entry")),
                    tmp_ds->fruity_text);
  
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_vegetable_hscale")),
                    (gdouble)tmp_ds->vegetable_hscale);
   
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_vegetable_entry")),
                    tmp_ds->vegetable_text);
 
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_chemical_hscale")),
                    (gdouble)tmp_ds->chemical_hscale);
 
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_chemical_entry")),
                    tmp_ds->chemical_text);
 
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_balsam_hscale")),
                   (gdouble)tmp_ds->balsam_hscale);
 
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_balsam_entry")),
                    tmp_ds->balsam_text);

                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_spicy_hscale")),
                    (gdouble)tmp_ds->spicy_hscale);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_spicy_entry")),
                    tmp_ds->spicy_text);

                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_wooded_hscale")),
                   (gdouble)tmp_ds->wooded_hscale);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_wooded_entry")),
                   tmp_ds->wooded_text);
 
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_animal_hscale")),
                   (gdouble)tmp_ds->animal_hscale);
   
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_animal_entry")),
                    tmp_ds->animal_text);
  
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_other_hscale")),
                    (gdouble)tmp_ds->other_hscale);
   
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_other_entry")),
                   tmp_ds->other_text);

                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_complexity_hscale")),
                   (gdouble)tmp_ds->complexity_hscale);

                /*
                 * GUSTATIVE FRAME
                 */
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_acidity_hscale")),
                    (gdouble)tmp_ds->acidity_hscale);
   
                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_acidity_entry")),
                    tmp_ds->acidity_text);

                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_mellow_hscale")),
                    (gdouble)tmp_ds->mellow_hscale);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_mellow_entry")),
                    tmp_ds->mellow_text);

                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_bitterness_hscale")),
                    (gdouble)tmp_ds->bitterness_hscale);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_bitterness_entry")),
                    tmp_ds->bitterness_text);

                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_alcohol_hscale")),
                    (gdouble)tmp_ds->alcohol_hscale);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_alcohol_entry")),
                    tmp_ds->alcohol_text);

                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_chewing_hscale")),
                    (gdouble)tmp_ds->chewing_hscale);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_chewing_entry")),
                    tmp_ds->chewing_text);
   
                gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_astringency_hscale")),
                    (gdouble)tmp_ds->astringency_hscale);

                gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_astringency_entry")),
                   tmp_ds->astringency_text);

                /*
                 * INFORMATION FRAME
                 */
                gtk_entry_set_text (GTK_ENTRY(glade_xml_get_widget(consdeg.main_xml, "xcave_consdeg_comments_entry")),
                   tmp_ds->comment);
   
                /*
                 * update comment of the drinking line
                 */
            		   
	   	     break; 
             }
          }
          g_free(tmp_ds);
	}
    g_free(tmp_ds_selected);

    return FALSE;
}

