/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

/*
 * variable local
 */
GList *list_tmprackRow;
GList *list_tmprackCol;

void
on_xcave_button_config_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
    FILE *f;
    gchar filename[256];

    xcave_debug_begin(__FULL__);

    /* 
     * desactive xcave.window
     */
    gtk_widget_set_sensitive(xcave.window, FALSE);

    /* get the xcave_conf & label widgets from the glade XML file  */
    config.main_xml = glade_xml_new(XCAVE_GLADE_FILE,"xcave_config",NULL);
    
    config.window = glade_xml_get_widget(config.main_xml, "xcave_config");
    glade_xml_signal_autoconnect (config.main_xml);

    memset(filename,'\0',sizeof(filename));
    sprintf(filename,"%s/.xcaverc",getenv("HOME"));
    if ((f = fopen (filename, "r")) == NULL) {
	if ((f= fopen ("/etc/xcave.conf", "r")) == NULL) {
		quick_message (_(" Configuration file error "));
	}
    }
    /* 
     * configuration de numrack en fonction de nbrack
     */
    config.num_rack_spinbutton = GTK_SPIN_BUTTON (glade_xml_get_widget(config.main_xml,  "num_rack_spinbutton"));
    gtk_spin_button_set_range ( config.num_rack_spinbutton, 1.0, (gint) rackNb);

    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget(config.main_xml, "PathStock")), (gchar *) DBPATH);
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget(config.main_xml, "ConfVers")), (gchar *) VERSION);

    gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(config.main_xml, "ConfQt")), (gint) QT);

    config.nb_rack_spinbutton = GTK_SPIN_BUTTON (glade_xml_get_widget (config.main_xml, "nb_rack_spinbutton"));
    gtk_spin_button_set_value (config.nb_rack_spinbutton, (gint) rackNb);

    config.nb_row_spinbutton = GTK_SPIN_BUTTON (glade_xml_get_widget (config.main_xml, "nb_row_spinbutton"));
    gtk_spin_button_set_value (config.nb_row_spinbutton, (gint) g_list_nth_data(list_rackRow,0));

    config.nb_col_spinbutton = GTK_SPIN_BUTTON (glade_xml_get_widget (config.main_xml, "nb_col_spinbutton"));
    gtk_spin_button_set_value (config.nb_col_spinbutton, (gint) g_list_nth_data(list_rackCol,0));

    /*
     * signals 
     */
    config.s_nb_rack = g_signal_connect (GTK_OBJECT (config.nb_rack_spinbutton),
		                         "value-changed",
                                         GTK_SIGNAL_FUNC (on_nb_rack_value_changed), 
					 NULL);
    config.s_nb_row = g_signal_connect (GTK_OBJECT (config.nb_row_spinbutton),
		                         "value-changed",
                                         GTK_SIGNAL_FUNC (on_nb_row_value_changed), 
					 NULL);
    config.s_nb_col = g_signal_connect (GTK_OBJECT (config.nb_col_spinbutton),
		                         "value-changed",
                                         GTK_SIGNAL_FUNC (on_nb_col_value_changed), 
					 NULL);
    config.s_num_rack = g_signal_connect (GTK_OBJECT (config.num_rack_spinbutton),
		                         "value-changed",
                                         GTK_SIGNAL_FUNC (on_num_rack_value_changed), 
					 NULL);
    /* 
     * copie de la liste colonne et row dans une liste temporaire
     */
    list_tmprackRow = g_list_copy(list_rackRow);
    list_tmprackCol = g_list_copy(list_rackCol);
    gtk_widget_show (config.window);
	
    xcave_debug_end(__FULL__);
}

void
on_xcave_config_button_ok_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
  xcave_debug_begin(__FULL__);
		
  /* recopie de la liste temporaire dans la liste */
  list_rackRow = g_list_copy(list_tmprackRow);
  list_rackCol = g_list_copy(list_tmprackCol);
  
  strcpy (DBPATH, gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(config.main_xml, "PathStock"))));

  rackNb = (gint) gtk_spin_button_get_value_as_int (config.nb_rack_spinbutton);
  xcave_debug_int(__FULL__,"rackNB",rackNb);

  /*
   * Mise a jour et affichage de l'arbre (country/region/appellation) si le parametre a change
   */
  xcave_debug_str(__FULL__," :1: ");
  if (QT != (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (glade_xml_get_widget(config.main_xml, "ConfQt")))) {
     QT = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (glade_xml_get_widget(config.main_xml, "ConfQt")));
     xcave_debug_str(__FULL__," :2: ");

     /*
      * need to cleanup the mess
	  */
	 xcave.information_treestore = (GtkTreeStore *) gtk_tree_view_get_model((GtkTreeView *)xcave.information_treeview);
	 gtk_tree_store_clear(xcave.information_treestore);

	 xcave.origin_treestore = (GtkTreeStore *) gtk_tree_view_get_model((GtkTreeView *)xcave.origin_treeview);
	 gtk_tree_store_clear(xcave.origin_treestore);
	
	 xcave_fill_model (xcave.origin_treestore, xcave.information_treestore);

  }
  gtk_object_destroy (GTK_OBJECT (config.window));

  /*
   * Resizing de la fenetre pour prise en compte des nouvelles valeurs
   */
  xcave_debug_2int(__FULL__,"windows size",atoi(WindowsXcaveWidth),atoi(WindowsXcaveHeight));
  gtk_window_resize (GTK_WINDOW (xcave.window), atoi(WindowsXcaveWidth), atoi(WindowsXcaveHeight));

    xcave_debug_end(__FULL__);

}

void
on_xcave_config_destroy               (GtkObject       *object,
                                        gpointer         user_data)
{
  xcave_debug_begin(__FULL__);

  /* 
   * dans le cas de button close clicked on passe deux fois dans 
   * on_xcave_config_destroy. Coredump si les pointeurs ne sont pas 
   * traites.
   */
  if (list_tmprackRow != NULL) g_list_free(list_tmprackRow);
  if (list_tmprackCol  != NULL) g_list_free(list_tmprackCol);	
  gtk_object_destroy (GTK_OBJECT (config.window));

  /* 
   * reactive xcave.window
   */
  gtk_widget_set_sensitive(xcave.window, TRUE);

  xcave_debug_end(__FULL__);
}

void
on_xcave_config_button_cancel_clicked      (GtkObject       *object,
                                        gpointer         user_data)
{
  xcave_debug_begin(__FULL__);

  gtk_object_destroy (GTK_OBJECT (config.window));
  
  xcave_debug_end(__FULL__);
}


void on_nb_row_value_changed(GtkSpinButton *spinbutton, gpointer user_data)
{
   xcave_debug_begin(__FULL__);

   g_signal_handler_block (GTK_OBJECT (config.nb_row_spinbutton), config.s_nb_row);

   gint nb_row      = (gint) gtk_spin_button_get_value_as_int (spinbutton);
   gint num_rack    = (gint) gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON (config.num_rack_spinbutton));

   list_tmprackRow = g_list_delete_link (list_tmprackRow, g_list_nth (list_tmprackRow, num_rack - 1));
   list_tmprackRow = g_list_insert(list_tmprackRow, (gpointer)nb_row, num_rack - 1);

   g_signal_handler_unblock (GTK_OBJECT (config.nb_row_spinbutton), config.s_nb_row);
 
   xcave_debug_end(__FULL__);
}

void on_nb_col_value_changed(GtkSpinButton *spinbutton,gpointer user_data)
{

   xcave_debug_begin(__FULL__);

   g_signal_handler_block (GTK_OBJECT (config.nb_col_spinbutton), config.s_nb_col);

   gint nb_col      = (gint) gtk_spin_button_get_value_as_int (spinbutton);
   gint num_rack    = (gint) gtk_spin_button_get_value_as_int(config.num_rack_spinbutton);

   list_tmprackCol = g_list_delete_link (list_tmprackCol, g_list_nth (list_tmprackCol, num_rack - 1));
   list_tmprackCol = g_list_insert(list_tmprackCol, (gpointer)nb_col,num_rack - 1);

   g_signal_handler_unblock (GTK_OBJECT (config.nb_col_spinbutton), config.s_nb_col);

   xcave_debug_end(__FULL__);
}

void on_nb_rack_value_changed(GtkSpinButton *spinbutton, gpointer user_data){

   xcave_debug_begin(__FULL__);

   g_signal_handler_block (GTK_OBJECT (config.nb_rack_spinbutton), config.s_nb_rack);

   /*
    * le nombre de casier peut etre modifier soit par le clavier (Text) soit par la souris (SpinButton)
    * il convient donc de recuperer la valeur text au prealable a toute autre operation
    */
   gint rack_nb = atoi((const gchar*) gtk_entry_get_text(GTK_ENTRY(spinbutton)));	

   gtk_spin_button_set_range(config.num_rack_spinbutton, 1.0, (gint) rack_nb);

   while (g_list_length(list_tmprackRow) < rack_nb){
      /*
      * par defaut ajout d'un casier de 10*5
      */
      gpointer i = g_malloc(sizeof(gint));
      i=(gchar *)10;
      gpointer j = g_malloc(sizeof(gint));
      j=(gchar *)5;
      list_tmprackRow = g_list_append(list_tmprackRow, (gpointer)i);
      list_tmprackCol = g_list_append(list_tmprackCol, (gpointer)j);
   }

   /*
    * En cas de modification Text il y a deux passages dans cette fonction 
    *   le 1er tmprackNb = 0 (mise à blanc de la zone)
    *   le 2sd valeur saisie
    * donc lors du 1er passage il faut faire attention a ne pas vider les listes Row et Col
    */
   while ((g_list_length(list_tmprackRow) > rack_nb) && (rack_nb != 0)) {
      list_tmprackRow = g_list_delete_link (list_tmprackRow, g_list_nth(list_tmprackRow,g_list_length(list_tmprackRow) - 1));
      list_tmprackCol = g_list_delete_link (list_tmprackCol, g_list_nth(list_tmprackCol,g_list_length(list_tmprackCol) - 1));
   }

   g_signal_handler_unblock (GTK_OBJECT (config.nb_rack_spinbutton), config.s_nb_rack);
   xcave_debug_end(__FULL__);
}

void on_num_rack_value_changed(GtkSpinButton *spinbutton,gpointer user_data){

   xcave_debug_begin(__FULL__);

   g_signal_handler_block (GTK_OBJECT (config.num_rack_spinbutton), config.s_num_rack);

   gint num_rack =  (gint) gtk_spin_button_get_value_as_int (spinbutton);

   gtk_spin_button_set_value(config.nb_row_spinbutton, (gint) g_list_nth_data(list_tmprackRow, num_rack - 1));
   gtk_spin_button_set_value(config.nb_col_spinbutton, (gint) g_list_nth_data(list_tmprackCol, num_rack - 1));

   g_signal_handler_unblock (GTK_OBJECT (config.num_rack_spinbutton), config.s_num_rack);
   xcave_debug_end(__FULL__);
}
