/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more detailvins.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "callbacks.h"

void
on_xcave_button_rack_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
     xcave_debug_function
    /* 
     * desactive xcave.window
     */
    gtk_widget_set_sensitive(xcave.window, FALSE);

    /* get the xcave_rack widgets from the glade XML file  */
    rack.main_xml = glade_xml_new(XCAVE_GLADE_FILE,"xcave_rack",NULL);

    rack.window = glade_xml_get_widget(rack.main_xml, "xcave_rack");

    detail.origine = BUTTON_RACK;
    if (debug)
      fprintf(stderr,":%15.15s:%30.30s:%-4d:%p:\n",__FILE__,__FUNCTION__,__LINE__, &rack);
    
    xcave_createRack((gchar *) &rack, NULL);

    /*
     * redimensionnement de la fenetre
     */
    if ( strlen(WindowsRackHeight) != 0 && strlen (WindowsRackWidth) != 0 ) {
        gtk_window_resize (GTK_WINDOW (rack.window), atoi(WindowsRackWidth), atoi(WindowsRackHeight));
    }
    else
       gtk_window_resize (GTK_WINDOW (rack.window), 160,350); 

    glade_xml_signal_autoconnect (rack.main_xml);
 }

void
xcave_createRack(gchar  * pcurrent, GList *vin_list_emplacement)
{

	GList            *tmp_list_emp;
	GList            *tmp_list_rack;

	gint              rackNum;
        struct _rack_application         *current;
        
        current=(struct _rack_application *)pcurrent;

        if (debug) {
          fprintf(stderr,":%-15s:%-40s:%4d::%lu:%lu:\n",__FULL__,sizeof(pcurrent),sizeof(current));
          fflush(stderr);
          fprintf(stderr,":%-15s:%-40s:%4d::%p:%p:%p:\n",__FULL__,pcurrent,&rack,&detail.rack);
          fflush(stderr);
        }

	current->scrolledwindow = glade_xml_get_widget (current->main_xml, "xcave_rack_scrolledwindow");
    
	current->tooltips = gtk_tooltips_new ();

	current->viewport = gtk_viewport_new (NULL, NULL);

        gtk_container_add (GTK_CONTAINER (current->scrolledwindow), current->viewport);
	gtk_widget_show (current->viewport);
	
	current->hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (current->hbox);
	gtk_container_add (GTK_CONTAINER (current->viewport), current->hbox);

	rackNb = g_list_length(list_rackRow);
	for (rackNum=0; rackNum < rackNb; rackNum++) {
		gchar   buf[64];
		gchar   lab[32];

             rackRowNb = (gint)g_list_nth_data(list_rackRow, rackNum);
             rackColNb = (gint)g_list_nth_data (list_rackCol, rackNum);

		/* 
		 * create as much as frame than racks number 
		 */
		sprintf(buf,"frameRack_rack%d",rackNum+1);
		sprintf(lab,_("racks %d"),rackNum+1);
		
		current->frameRack[rackNum] = gtk_frame_new (lab);
		gtk_widget_set_name (current->frameRack[rackNum], buf);
		gtk_widget_show (current->frameRack[rackNum]);
		gtk_box_pack_start (GTK_BOX (current->hbox), current->frameRack[rackNum], TRUE, TRUE, 0);

		/* 
		 * For each frame create a table 
		 */
		sprintf(buf,"tableRack_rack%d",rackNum+1);
		
		current->tableRack[rackNum] = gtk_table_new (rackRowNb, rackColNb, TRUE);
		gtk_widget_set_name (current->tableRack[rackNum], buf);
		gtk_container_add (GTK_CONTAINER (current->frameRack[rackNum]), current->tableRack[rackNum]);
		gtk_widget_show (current->tableRack[rackNum]);
	}

	/*
	 * 
	 */
	for (rackNum=0; rackNum < rackNb; rackNum++) {
        gint    NumRow;

        rackRowNb =(gint)g_list_nth_data(list_rackRow, rackNum);
        rackColNb = (gint)g_list_nth_data (list_rackCol, rackNum);

		/* label ligne */
		for (NumRow=1; NumRow < rackRowNb + 1; NumRow++) {
			gint    NumCol;
		
			/* label colonne */
			for (NumCol=1; NumCol < rackColNb + 1; NumCol++) {
				gchar			buf[64];
				Emplacement		emp;
				gint			trouve = 0;
				Emplacement		tmpEmplacement;
				ptrRack	        tmp_rack = NULL; /* 2.3.2 */
				ptrVin			tmp_vin = NULL; /* 2.3.2 */
		
				sprintf(buf,"checkbutton%d-%d-%d",rackNum,NumRow,NumCol);
			
				memset(&emp,'\0',sizeof(Emplacement));
				emp.Rack   = rackNum;
				emp.Row    = NumRow;
				emp.Column = NumCol;
		
				/*
				 * recherche de l'emplacement de la(es) bouteilles selectionnees
				 * pour autoriser l'utilisateur a deplacer les bouteilles dans le 
				 * stock l'emplacement n'est pas fige
				 */
				for(tmp_list_emp = vin_list_emplacement; 
					tmp_list_emp != NULL ; 
					tmp_list_emp = tmp_list_emp->next) {
						memcpy(&tmpEmplacement,
								tmp_list_emp->data,
								sizeof(Emplacement));
						if (  rackNum == tmpEmplacement.Rack
						   && NumRow    == tmpEmplacement.Row
						   && NumCol    == tmpEmplacement.Column ) { trouve = 1 ; break; }
				}
			
				/*
				 * recherche si l'emplacement est occupe ou non 
				 */
				for(tmp_list_rack = list_rack;
					tmp_list_rack != NULL && trouve == 0 ; 
					tmp_list_rack = tmp_list_rack->next)
						if ( ! memcmp(&emp, tmp_list_rack->data, 3 * sizeof(gint)))
							break;
						
				if (tmp_list_rack != NULL) {		
					tmp_rack	= g_malloc(sizeof(Rack));
					tmp_vin		= g_malloc(sizeof(Vin));	
					memcpy(tmp_rack, tmp_list_rack->data, sizeof(Rack));
					memcpy(tmp_vin, tmp_rack->ptr_list_stock_data, sizeof(Vin));
				}
						
				if (tmp_list_rack == NULL || trouve == 1) 
					current->checkbutton[rackNum][NumRow][NumCol] = gtk_check_button_new();
				else {
					current->checkbutton[rackNum][NumRow][NumCol] = gtk_check_button_new ();
					GtkWidget *image;
					if (strcasecmp(tmp_vin->color, _("RED")) == 0)
						image = create_pixmap (current->window, "xcave_red.png");
					else
						if (strcasecmp(tmp_vin->color, _("ROSE")) == 0)
							image = create_pixmap (current->window, "xcave_rose.png");
						else
							image = create_pixmap (current->window, "xcave_white.png");
					gtk_container_add (GTK_CONTAINER (current->checkbutton[rackNum][NumRow][NumCol]), image);
					gtk_widget_show (image);
				}
                                if (debug)
				          fprintf(stderr,":%15.15s:%30.30s:%-4d:%s:%p:%p:%p:\n", __FULL__, buf, 
                                                         (void *)current->checkbutton[rackNum][NumRow][NumCol],
                                                         (void *)rack.checkbutton[rackNum][NumRow][NumCol],
                                                         (void *)detail.rack.checkbutton[rackNum][NumRow][NumCol]);
			
				gtk_widget_set_name (current->checkbutton[rackNum][NumRow][NumCol], buf);
		
				gtk_widget_show (current->checkbutton[rackNum][NumRow][NumCol]);
				gtk_table_attach (GTK_TABLE (current->tableRack[rackNum]), 
								  current->checkbutton[rackNum][NumRow][NumCol], 
								  NumCol,
								  NumCol + 1,
								  NumRow,
								  NumRow + 1,
								  (GtkAttachOptions) (GTK_FILL),
								  (GtkAttachOptions) (0), 0, 0);
				GTK_WIDGET_UNSET_FLAGS (current->checkbutton[rackNum][NumRow][NumCol], GTK_CAN_FOCUS);
		
				/*
				 * bouteille dans l'emplacement 
				 */
				if (tmp_list_rack != NULL) {
		                   gchar  ltooltips[128];
				   memset(ltooltips,'\0',128);
				   sprintf(ltooltips,"%s,%s,%d",tmp_vin->Appellation,tmp_vin->Nom,tmp_vin->vintage);
				   gtk_button_set_relief (GTK_BUTTON (current->checkbutton[rackNum][NumRow][NumCol]), GTK_RELIEF_NONE);
				   gtk_widget_set_sensitive (current->checkbutton[rackNum][NumRow][NumCol], TRUE);
				   if (trouve == 0) {
				      gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (current->checkbutton[rackNum][NumRow][NumCol]), FALSE);
				      gtk_tooltips_set_tip (GTK_TOOLTIPS (current->tooltips),current->checkbutton[rackNum][NumRow][NumCol] , ltooltips, NULL);
				   }
				   else {
				      gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (current->checkbutton[rackNum][NumRow][NumCol]), TRUE);
				      /*
				       * emplacement modifiable ==> deplacement du vin autorise
				       */
				      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (current->checkbutton[rackNum][NumRow][NumCol]), TRUE);
				   }
				 
				}
				/*
				 * for rack.window need to arm a signal
				 */
				if (rack.window == current->window) {
					g_signal_connect ((gpointer) current->checkbutton[rackNum][NumRow][NumCol], "toggled",
										G_CALLBACK (on_xcave_rack_toggledbutton_toggled),
										NULL);
				}
		
				/*
				 * set widget name
				 */
				gchar   lab[14];
		
				sprintf(buf,"labelRackUnit_rack%d-%d-%d",rackNum,NumRow+1,NumCol+1);
				memset(lab,'\0',14);
				if ( NumRow == 0 && NumCol != 0) sprintf(lab,"%d",NumCol);
				if ( NumCol == 0 && NumRow != 0) sprintf(lab,"%d",NumRow);
			
				current->labelRackUnit[rackNum][NumRow][NumCol] = gtk_label_new (lab);
				gtk_widget_set_name (current->labelRackUnit[rackNum][NumRow][NumCol], buf);
				gtk_widget_show (current->labelRackUnit[rackNum][NumRow][NumCol]);
				gtk_table_attach (GTK_TABLE (current->tableRack[rackNum]),
								  current->labelRackUnit[rackNum][NumRow][NumCol],
								  NumCol,
								  NumCol + 1,
								  NumRow,
								  NumRow + 1,
								 (GtkAttachOptions) (GTK_FILL),
								 (GtkAttachOptions) (0), 0, 0);
				gtk_misc_set_alignment (GTK_MISC (current->labelRackUnit[rackNum][NumRow][NumCol]), 0, 0.5);
				
				if (tmp_list_rack != NULL && detail.origine == BUTTON_RACK) {		
					/*
					 * keep track of the widget name in list_rack to help to 
					 * to retrieve wine data if selection is made thru 
					 * rack.window
					 */
					tmp_rack->ptr_widget_name = current->checkbutton[rackNum][NumRow][NumCol];
					memcpy(tmp_list_rack->data, tmp_rack, sizeof(Rack));
					g_free(tmp_vin);
				}
			}
		}
	
	}
    gtk_widget_show(current->window);
}

GList *
xcave_rackTreatment(gchar *VinNom)
{

  gint           rackNum;
  Emplacement   *ptemp;
  GList         *vin_list_emplacement = NULL;;

     xcave_debug_function
  for (rackNum=0; rackNum < rackNb; rackNum++) {
    gint    NumRow;

    rackRowNb =(gint)g_list_nth_data(list_rackRow, rackNum);
    rackColNb = (gint)g_list_nth_data (list_rackCol, rackNum);

    /* ligne */
    for (NumRow=1; NumRow < rackRowNb + 1; NumRow++) {
        gint    NumCol;

		/* colonne */
        for (NumCol=1; NumCol < rackColNb + 1; NumCol++) {

                        if (debug) {
			  fprintf(stderr,":%15.15s:%30.30s:%-4d:checkbutton[%d][%d][%d]:%p:\n",
                                  __FILE__,__FUNCTION__,__LINE__,
                                 rackNum,NumRow,NumCol,
                                 (void *)detail.rack.checkbutton[rackNum][NumRow][NumCol]);
                        }
			if ((gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON (detail.rack.checkbutton[rackNum][NumRow][NumCol]))) == 1) {
	
				ptemp = g_malloc (sizeof(Emplacement));
				memset(ptemp,'\0',sizeof(Emplacement));
				ptemp->Rack = rackNum;
				ptemp->Row    = NumRow;
				ptemp->Column = NumCol;
				strcpy(ptemp->Nom,VinNom); 
		
				vin_list_emplacement   = g_list_append(vin_list_emplacement  ,ptemp);
			}
		}
    }
  }

 return(vin_list_emplacement);
}

void
on_xcave_rack_destroy               (GtkObject       *object,
                                        gpointer         user_data)
{
	gtk_object_destroy (GTK_OBJECT (rack.window));

	/* 
     * reactive xcave.window
     */
	gtk_widget_set_sensitive(xcave.window, TRUE);
}

void
on_xcave_rack_toggledbutton_toggled	(GtkToggleButton	*toggledbutton,
					 gpointer         user_data)
{

	GList		*tmp_list_rack;
	ptrRack	        tmp_rack;

        if (debug)
	  fprintf(stderr,":%15.15s:%30.30s:%-4d:%p:\n",__FILE__,__FUNCTION__,__LINE__,(void *)toggledbutton);
	if (gtk_toggle_button_get_active(toggledbutton) == FALSE)
		return;
	
	/* recherche si l'emplacement est occupe ou non */
	tmp_rack	= g_malloc(sizeof(Rack));
	memset(tmp_rack, '\0', sizeof(Rack));

	for(tmp_list_rack = list_rack;
	    tmp_list_rack != NULL; 
	    tmp_list_rack = tmp_list_rack->next) {
		memcpy(tmp_rack, tmp_list_rack->data, sizeof(Rack));
		if ((void *)tmp_rack->ptr_widget_name == (void *)toggledbutton) {
		   break;
		}
	}


	/* 
	 * desactive rack.window
	 */
	gtk_widget_set_sensitive(rack.window, FALSE);
	
	if (tmp_list_rack == NULL) {
		detail.origine = BUTTON_RACK_ADD;
		on_xcave_button_add_clicked(NULL,NULL);

		/* I could activate the button 
		 * retrouver dans l'emplacement avec le triplet 
		 * rack-line-colum. 
		 * NOT YET IN THE POCKET 
                 */
		GtkWidget     *checkbutton;
		gint            rackNum;
		for (rackNum=0; rackNum < rackNb; rackNum++) {
			gint    NumRow;
			
			/* ligne */
			for (NumRow=1; NumRow < rackRowNb + 1; NumRow++) {
				gint    NumCol;
			
				/* colonne */
				for (NumCol=1; NumCol < rackColNb + 1; NumCol++) {
					gchar          buf[64];
			
					sprintf(buf,"checkbutton%d-%d-%d",rackNum,NumRow,NumCol);
					checkbutton = (GtkWidget *) glade_xml_get_widget(detail.rack.main_xml, buf);
                                        if (debug) {
				          fprintf(stderr,":%15.15s:%30.30s:%-4d:%s:%p:%p:%p:\n",
                                                         __FILE__,__FUNCTION__,__LINE__,
                                                         buf, toggledbutton,
                                                         (void *)rack.checkbutton[rackNum][NumRow][NumCol],
                                                         (void *)detail.rack.checkbutton[rackNum][NumRow][NumCol]);
                                        }
                                        /*
					if ((gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON (checkbutton))) == 1) {
						checkbutton = (GtkWidget *) glade_xml_get_widget(detail.main_xml, buf);
	  					gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (checkbutton), TRUE);
						break;
					}
                                        */
				} /* endfor (NumCol=1; NumCol < rackColNb + 1; NumCol++) */
			} /* endfor (NumRow=1; NumRow < rackRowNb + 1; NumRow++) */
		} /* endfor (rackNum=0; rackNum < rackNb; rackNum++) */
	
	}
	else {
		detail.origine = BUTTON_RACK_MODIF;
		on_xcave_display_modif(tmp_rack->ptr_list_stock_data);
	}

	g_free(tmp_rack);

}

ptrVin 
xcave_id_selected_toggledbutton	(void)
{
    xcave_debug_function

    GtkWidget	*toggledbutton;

    GList		*tmp_list_rack;
    ptrRack	     tmp_rack = NULL; /* 2.4 */

    gint		 rackNum;
    gint         NumRow;
    gint         NumCol;

    rackNb = g_list_length(list_rackRow);

    for (rackNum=0; rackNum < rackNb; rackNum++) {
       rackRowNb = (gint)g_list_nth_data(list_rackRow, rackNum);
       rackColNb = (gint)g_list_nth_data(list_rackCol, rackNum);

       /* ligne */
       for (NumRow=1; NumRow < rackRowNb + 1; NumRow++) { 

          /* colonne */
          for (NumCol=1; NumCol < rackColNb + 1; NumCol++) { 
             gchar buf[64];

             sprintf(buf,"checkbutton%d-%d-%d",rackNum,NumRow,NumCol);
             toggledbutton = (GtkWidget *) glade_xml_get_widget(detail.rack.main_xml, buf);

             if ( (gtk_toggle_button_get_active( 
                     GTK_TOGGLE_BUTTON (rack.checkbutton[rackNum][NumRow][NumCol]))) == TRUE) {
                 gtk_toggle_button_set_active( 
                   GTK_TOGGLE_BUTTON (rack.checkbutton[rackNum][NumRow][NumCol]), FALSE);
                 if (debug) {
		   fprintf(stderr,":%s:%.30s:%d:checkbutton[%d][%d][%d]:%p:\n",
                           __FILE__,__FUNCTION__,__LINE__,
                           rackNum,NumRow,NumCol,
                           (void *)rack.checkbutton[rackNum][NumRow][NumCol]);
                 }
						
                 /* get associated datas */
                 tmp_rack	= g_malloc(sizeof(Rack));
					
                 for (tmp_list_rack = list_rack;
                      tmp_list_rack != NULL; 
                      tmp_list_rack = tmp_list_rack->next) {
                    memcpy(tmp_rack, tmp_list_rack->data, sizeof(Rack));
                    /* retrouver le bon GList */
                    if ((void *)tmp_rack->ptr_widget_name == (void *)toggledbutton) {
                     break;
                    }
                 } /* endfor(tmp_list_rack = list_rack */
			break;
             } /* endif ((gtk_toggle_button_get_active( */
         } /* endfor (NumCol=1; NumCol < rackColNb + 1; NumCol++) */
       } /* endfor (NumRow=1; NumRow < rackRowNb + 1; NumRow++)*/
    } /* endfor (rackNum=0; rackNum < rackNb; rackNum++) */

    return(tmp_rack->ptr_list_stock_data);
}

void
on_xcave_rack_check_resize             (GtkContainer    *container,
                                        gpointer         user_data)
{
   gint height = 0;
   gint width  = 0;

   gdk_window_get_size( container->widget.window , &width, &height);

   sprintf(WindowsRackWidth,"%d",width);
   sprintf(WindowsRackHeight,"%d",height);
   
}

