/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

void
on_xcave_button_about_clicked (GtkButton * button,
		  gpointer user_data)
{
    GtkWidget *textAbout;

    /* 
     * desactive xcave.window
     */
    gtk_widget_set_sensitive(xcave.window, FALSE);

    /* get the xcave_som & label widgets from the glade XML file  */
    about.main_xml = glade_xml_new(XCAVE_GLADE_FILE,"xcave_about",NULL);
    glade_xml_signal_autoconnect (about.main_xml);

    about.window = glade_xml_get_widget(about.main_xml, "xcave_about");

    textAbout = glade_xml_get_widget(about.main_xml,"xcave_about_textview");

    gchar buf[1024];
    memset (buf,'\0',1024);
    sprintf(buf,
            _("\n\nxcave %s\n\nhttp://xcave.free.fr\n\nxcave is wine cellar manager software\n\n\nxcave@free.fr"),
            VERSION);

    gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textAbout)),	buf, -1);

    /* show the main xcave_about */
    gtk_widget_show (about.window);

}

void
on_xcave_about_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_object_destroy (GTK_OBJECT (about.window));

   /* 
    * reactive xcave.window
    */
   gtk_widget_set_sensitive(xcave.window, TRUE);

}


void
on_xcave_about_button_close_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_object_destroy (GTK_OBJECT (about.window));

   /* 
    * reactive xcave.window
    */
   gtk_widget_set_sensitive(xcave.window, TRUE);
}
