/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H    
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

/* signal callbacks */
void on_xcave_destroy (GtkWidget *widget, gpointer user_data);
               
void
xcave_init(gint argc, gchar *argv[])
{
    GtkTreeViewColumn   *col;
    GtkCellRenderer        *renderer;

    GtkTreeSelection       *selection;
    GtkTreeModel           *modelview;
    GtkTreeIter             selected_row;

    xcave_debug_begin(__FULL__);
    add_support_directory(XCAVE_PIX_DIR);

	/* 
	* variables initialisation 
	*/
	
	{
	  time_t now;
	  struct tm * stnow;
	
	  now=time(&now);
	  stnow=localtime(&now);
	  nowan=stnow->tm_year+1900;
	}
	
	NbBottleDetail = 0;
	NbBottleStock  = 0;
	
    /*
     * create an instance of the GladeXML object and build widgets within
     * the "window" root node.  We don't want to build the other nodes (the
     * two dialogs) until/unless we need them. 
     */
    xcave.main_xml = glade_xml_new (XCAVE_GLADE_FILE, "xcave", NULL);
    glade_xml_signal_autoconnect (xcave.main_xml);
        
    /* get the window & label widgets from the glade XML file */
    xcave.window = glade_xml_get_widget(xcave.main_xml, "xcave"); 

    read_xcaverc();
    if (debug) {
      printf(":%-15s:%-40s:%4d::%s\n",__FILE__,__FUNCTION__,__LINE__,XCAVE_PIX_DIR);
      printf("\n");

      printf(":%-15s:%-40s:%4.d::int    :%lud:\n","","",0,sizeof(int));
      printf(":%-15s:%-40s:%4.d::char   :%lud:\n","","",0,sizeof(char));
      printf(":%-15s:%-40s:%4.d::char * :%lud:\n","","",0,sizeof(char *));
      printf(":%-15s:%-40s:%4.d::double :%lud:\n","","",0,sizeof(double));
      printf(":%-15s:%-40s:%4.d::float  :%lud:\n","","",0,sizeof(float));
      printf("\n");
      printf(":%-15s:%-40s:%4.d::gint   :%lud:\n","","",0,sizeof(gint));
      printf(":%-15s:%-40s:%4.d::gint64 :%lud:\n","","",0,sizeof(gint64));
      printf(":%-15s:%-40s:%4.d::gchar  :%lud:\n","","",0,sizeof(gchar));
      printf(":%-15s:%-40s:%4.d::gchar *:%lud:\n","","",0,sizeof(gchar *));
      printf(":%-15s:%-40s:%4.d::gdouble:%lud:\n","","",0,sizeof(gdouble));
      printf(":%-15s:%-40s:%4.d::gfloat :%lud:\n","","",0,sizeof(gfloat));
    }

    if ( strlen(WindowsXcaveWidth) != 0 && strlen (WindowsXcaveWidth) != 0 ) {
       gtk_window_resize (GTK_WINDOW (xcave.window), 
                                    atoi(WindowsXcaveWidth), 
                                    atoi(WindowsXcaveHeight));
	}

    /*
     * initialisation diverses et variees:
     *   (GList) liste du stock
     *   (GList) liste des country
     *   (GList) liste des regions
     *   (GList) liste des appellations
     *   (GList) liste des cepages
     */
    list_append_stock();
	
    list_append_rack();
    list_append_categ();
    list_append_color();
    list_append_country();
    list_append_region();
    list_append_appellation();
    list_append_cepage();
    list_country_append_stock();
    list_region_append_stock();
    list_appellation_append_stock();
    list_cepage_append_stock();
    list_country = g_list_sort(list_country,(GCompareFunc)cmp_country);
    list_region = g_list_sort(list_region,(GCompareFunc)cmp_region);
    list_appellation = g_list_sort(list_appellation,(GCompareFunc)cmp_appellation);
    list_cepage = g_list_sort(list_cepage,(GCompareFunc)cmp_cepage);

    list_append_length_width();

    /* color */
    GList         *tmp_list;
    GtkTreeIter    iter;

    /* Create color store and populate it */
    xcave.color_store = gtk_list_store_new(1, G_TYPE_STRING);
    gtk_list_store_append(xcave.color_store, &iter);
    gtk_list_store_set(xcave.color_store, &iter, 0, _("All"), -1);
    for(tmp_list  = list_color; tmp_list != NULL ; tmp_list  = tmp_list->next) {
        gtk_list_store_append(xcave.color_store, &iter);
        gtk_list_store_set(xcave.color_store, &iter, 0, tmp_list->data, -1);
    }

    xcave.color_combo = glade_xml_get_widget (xcave.main_xml, "color_combo");

    gtk_combo_box_set_model( GTK_COMBO_BOX( xcave.color_combo ),
                             GTK_TREE_MODEL( xcave.color_store ) );

    g_object_unref( G_OBJECT (xcave.color_store));
    gtk_combo_box_entry_set_text_column( GTK_COMBO_BOX_ENTRY (xcave.color_combo),0);

    gtk_widget_show(xcave.color_combo);
    gtk_combo_box_set_active( GTK_COMBO_BOX (xcave.color_combo), 0);

    /* 
     *   stat 
     */
    xcave.statusbar_v = glade_xml_get_widget (xcave.main_xml, "xcave_statusbar");
    xcave.statusbar_ctxtid = gtk_statusbar_get_context_id ((GtkStatusbar *)xcave.statusbar_v, "default");
    xcave.statusbar_id = 0;

    sprintf (xcave.statusbar_txt, _("Number of bottles in cellar : %d"), NbBottleStock);
    xcave.statusbar_ctxtid = gtk_statusbar_push ((GtkStatusbar *)xcave.statusbar_v, xcave.statusbar_ctxtid, xcave.statusbar_txt);

    /*
     * WINE ORIGIN
     */ 
    xcave.origin_treeview = glade_xml_get_widget (xcave.main_xml, "origin_treeview");

	/* --- TreeView Column #1 --- */
    renderer = gtk_cell_renderer_text_new();
    col = gtk_tree_view_column_new_with_attributes(_("Wine origin"),renderer,"text", COL_TREEVIEW,NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(xcave.origin_treeview), col);

    /* Creates a new tree store as with n_columns columns each of the types passed in. */

    xcave.origin_treestore = gtk_tree_store_new(NUM_COLS_TREEVIEW, G_TYPE_STRING);

    gtk_tree_view_set_model(GTK_TREE_VIEW(xcave.origin_treeview), 
                           (GtkTreeModel *)xcave.origin_treestore);

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(xcave.origin_treeview));
	g_assert(gtk_tree_selection_get_mode(selection) == GTK_SELECTION_SINGLE);
	if (gtk_tree_selection_get_selected(selection, &modelview, &selected_row)){
	   gtk_tree_selection_unselect_iter(selection,&selected_row);
    }

    /*
     * WINE INFORMATION
     */ 
    xcave.information_treeview = glade_xml_get_widget (xcave.main_xml, "information_treeview");

    /* Creates a new tree store as with n_columns columns each of the types passed in. */
    xcave.information_treestore = gtk_tree_store_new(NUM_COLS_TREELIST, 
                                                          G_TYPE_UINT, 
                                                          G_TYPE_UINT, 
                                                          G_TYPE_STRING, 
                                                          G_TYPE_STRING, 
                                                          G_TYPE_STRING, 
                                                          G_TYPE_STRING, 
                                                          G_TYPE_STRING, 
                                                          G_TYPE_UINT,
                                                          G_TYPE_POINTER,
                                                          G_TYPE_POINTER);

   gtk_tree_view_set_model(GTK_TREE_VIEW(xcave.information_treeview),
                           (GtkTreeModel *)xcave.information_treestore);

	/* --- TreeList Column #1 --- */
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, _("Vintage"));
	gtk_tree_view_append_column(GTK_TREE_VIEW(xcave.information_treeview), col);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func(col, renderer, maturite_cell_data_function, NULL, NULL);
	gtk_tree_view_column_add_attribute(col, renderer, "text", COL_TREELIST_MILLESIME);
	gtk_tree_view_column_set_sort_column_id(col,COL_TREELIST_MILLESIME);
	
	/* --- TreeList Column #2 --- */
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, _("Qty"));
	gtk_tree_view_append_column(GTK_TREE_VIEW(xcave.information_treeview), col);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func(col, renderer, maturite_cell_data_function, NULL, NULL);
	gtk_tree_view_column_add_attribute(col, renderer, "text", COL_TREELIST_QTY);
	gtk_tree_view_column_set_sort_column_id(col,COL_TREELIST_QTY);
	
	/* --- TreeList Column #3 --- */
	col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(col, _("Domain"));
	gtk_tree_view_append_column(GTK_TREE_VIEW(xcave.information_treeview), col);
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func(col, renderer, maturite_cell_data_function, NULL, NULL);
	gtk_tree_view_column_add_attribute(col, renderer, "text", COL_TREELIST_DOMAIN);
	gtk_tree_view_column_set_sort_column_id(col,COL_TREELIST_DOMAIN);
	
	/* --- TreeList Column #4 -- COUNTRY --- */
    renderer = gtk_cell_renderer_text_new();
    col = gtk_tree_view_column_new_with_attributes("label",renderer,"text", COL_TREELIST_COUNTRY,NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(xcave.information_treeview), col);
	gtk_tree_view_column_set_visible (col,FALSE);
	
	/* --- TreeList Column #5 -- REGION --- */
    renderer = gtk_cell_renderer_text_new();
    col = gtk_tree_view_column_new_with_attributes("label",renderer,"text", COL_TREELIST_REGION,NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(xcave.information_treeview), col);
	gtk_tree_view_column_set_visible (col,FALSE);
	
	/* --- TreeList Column #6 -- APPELLATION --- */
    renderer = gtk_cell_renderer_text_new();
    col = gtk_tree_view_column_new_with_attributes("label",renderer,"text", COL_TREELIST_APPELLATION,NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(xcave.information_treeview), col);
	gtk_tree_view_column_set_visible (col,FALSE);
	
	/* --- TreeList Column #7 -- COLOR --- */
    renderer = gtk_cell_renderer_text_new();
    col = gtk_tree_view_column_new_with_attributes("label",renderer,"text", COL_TREELIST_COLOR,NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(xcave.information_treeview), col);
    gtk_tree_view_column_set_visible (col,FALSE);

    /* --- TreeList Column #8 -- MATURITE --- */
    renderer = gtk_cell_renderer_text_new();

    /*
	 * 2.2.6
	 * col = gtk_tree_view_column_new_with_attributes("label",renderer,"gint", COL_TREELIST_MATURITE,NULL);
	 * warning lors de l execution 
	 * GLib-GObject-WARNING **: IA__g_object_set_property: object class `GtkCellRendererText' has no property named `gint'
	 */
    col = gtk_tree_view_column_new_with_attributes("label",renderer,"text", COL_TREELIST_MATURITE,NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(xcave.information_treeview), col);
	gtk_tree_view_column_set_visible (col,FALSE);
	
	/* --- TreeList Column #9 -- GList data --- */
    renderer = gtk_cell_renderer_text_new();
	/*
	 * 2.2.6
	 *  GLib-GObject-WARNING **: unable to set property `text' of type `gchararray' from value of type `gpointer'
	 * col = gtk_tree_view_column_new_with_attributes("label",renderer,"text", COL_TREELIST_PDATA,NULL);
	 * gtk_tree_view_append_column(GTK_TREE_VIEW(TreeList), col);
	 * gtk_tree_view_column_set_visible (col,FALSE);
	 */
	
	/* --- TreeList Column #10 -- GList --- */
    renderer = gtk_cell_renderer_text_new();

    xcave_fill_model (xcave.origin_treestore, xcave.information_treestore);

    /* destroy model automatically with view */
    g_object_unref(xcave.origin_treestore);
    g_object_unref(xcave.information_treestore);

    detail.origine = NO_BUTTON;
	
    /*
     *
     */

    xcave.s_color = g_signal_connect (GTK_OBJECT (xcave.color_combo),
		                              "changed",
                                              GTK_SIGNAL_FUNC (on_main_color_combo_changed), 
					      NULL);
    gtk_widget_show (xcave.window);
    gtk_main ();

    write_xcaverc ();

    xcave_debug_end(__FULL__);
    return ;
}


gint
main (gint argc,
      gchar *argv[])
{

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");	
	/* Je ne comprends pas le pb d'accent lié à UTF-8 ... en attendant */
	// bind_textdomain_codeset (GETTEXT_PACKAGE, "ISO-8859-15");
	textdomain (GETTEXT_PACKAGE);
#endif

  xcave_debug_begin(__FULL__);
  gtk_init(&argc, &argv);

  add_support_directory(PACKAGE_DATA_DIR "/" PACKAGE "");
  
  xcave_init(argc, argv);
 
  xcave_debug_end(__FULL__);
  return 0;
}

void 
on_xcave_destroy (GtkWidget *widget, gpointer user_data)
{
        /* break gtk_main() loop */
        gtk_main_quit();                        
}
