/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"
#include <glib/gprintf.h>

FILE *
	open_xcaverc (gchar *action)
{
  FILE *f;
  gchar filename[256];

  memset(filename,'\0',sizeof(filename));
  sprintf(filename,"%s/.xcaverc",getenv("HOME"));
  
  f = fopen (filename, action);
  return ( f );
}

void
read_xcaverc ()
{
  FILE *f;
  gchar buffer[Size_CONF];
  gchar lversion[24];
  gint  ret = 0;

  if  (( f = open_xcaverc("r")) == NULL)
    f = open_xcaverc("w+");

  memset(DBPATH,'\0',Size_DBPATH);
  memset(lversion,'\0',sizeof(lversion));
  memset(WindowsXcaveHeight,'\0',sizeof(WindowsXcaveHeight));
  memset(WindowsXcaveWidth,'\0',sizeof(WindowsXcaveWidth));
  memset(WindowsDetailWidth,'\0',sizeof(WindowsDetailWidth));
  memset(WindowsDetailHeight,'\0',sizeof(WindowsDetailHeight));
  memset(WindowsRackWidth,'\0',sizeof(WindowsRackWidth));
  memset(WindowsRackHeight,'\0',sizeof(WindowsRackHeight));
  memset(WindowsDegustationWidth,'\0',sizeof(WindowsDegustationWidth));
  memset(WindowsDegustationHeight,'\0',sizeof(WindowsDegustationHeight));
  memset(WindowsConsultDegustationWidth,'\0',sizeof(WindowsConsultDegustationWidth));
  memset(WindowsConsultDegustationHeight,'\0',sizeof(WindowsConsultDegustationHeight));
  memset(WindowsSyntheseWidth,'\0',sizeof(WindowsSyntheseWidth));
  memset(WindowsSyntheseHeight,'\0',sizeof(WindowsSyntheseHeight));
  memset(fileLocation,'\0',80);
  memset(printerLocation,'\0',80);
  memset(browserLocation,'\0',80);
  /*
   * default initialization
   */
  sprintf(DBPATH,"%s/xcave.xml",getenv("HOME"));
  strcpy(lversion,"1.0.0");
  strcpy(WindowsXcaveHeight,"600");
  strcpy(WindowsXcaveWidth,"800");
  strcpy(WindowsDetailHeight,"454");
  strcpy(WindowsDetailWidth,"763");
  strcpy(WindowsRackHeight,"350");
  strcpy(WindowsRackWidth,"348");
  strcpy(WindowsDegustationHeight,"827");
  strcpy(WindowsDegustationWidth,"766");
  strcpy(WindowsConsultDegustationHeight,"743");
  strcpy(WindowsConsultDegustationWidth,"792");
  strcpy(WindowsSyntheseHeight,"236");
  strcpy(WindowsSyntheseWidth,"494");

  QT = 0;
  DetailMaxRowEmplacement = 0;
  DetailMaxRowPurchase    = 0;
  DetailMaxRowDrinking    = 0;
  rackNb                = 1;
  rackRowNb             = 9;
  rackColNb             = 6;
	
  sprintf(printerLocation,"lpr");
  sprintf(fileLocation,"xcave.txt");
  sprintf(browserLocation,"kfmclient exec");

  while (!feof (f)) {
    gint i=0;
    memset(buffer,'\0',Size_CONF);

    ret = (unsigned long)fgets (buffer, Size_CONF, f);

    if (memcmp("stocks=",buffer, sizeof("stocks=")-1) == 0) {
       memccpy(DBPATH,buffer + sizeof("stocks=")-1 ,'\n'|EOF, Size_CONF );
       for (i=1;i<Size_CONF && DBPATH[i] != '\n';i++);
       DBPATH[i]='\0';
    }

    if (memcmp("version=",buffer, sizeof("version=")-1) == 0) {
       memccpy(lversion,buffer + sizeof("version=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && lversion[i] != '\n';i++);
       lversion[i]='\0';
    }

    /*
     * pour compatibilite - introduit avec la 1.0.2
     */
    if (memcmp("WindowsXcaveHeight=",buffer, sizeof("WindowsXcaveHeight=")-1) == 0) {
       memccpy(WindowsXcaveHeight,buffer + sizeof("WindowsXcaveHeight=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsXcaveHeight[i] != '\n';i++);
       WindowsXcaveHeight[i]='\0';
    }

    if (memcmp("WindowsXcaveWidth=",buffer, sizeof("WindowsXcaveWidth=")-1) == 0) {
       memccpy(WindowsXcaveWidth,buffer + sizeof("WindowsXcaveWidth=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsXcaveWidth[i] != '\n';i++);
       WindowsXcaveWidth[i]='\0';
    }

    if (memcmp("WindowsDetailHeight=",buffer, sizeof("WindowsDetailHeight=")-1) == 0) {
       memccpy(WindowsDetailHeight,buffer + sizeof("WindowsDetailHeight=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsDetailHeight[i] != '\n';i++);
       WindowsDetailHeight[i]='\0';	
    }

    if (memcmp("WindowsDetailWidth=",buffer, sizeof("WindowsDetailWidth=")-1) == 0) {
       memccpy(WindowsDetailWidth,buffer + sizeof("WindowsDetailWidth=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsDetailWidth[i] != '\n';i++);
       WindowsDetailWidth[i]='\0';
    }

    if (memcmp("WindowsRackHeight=",buffer, sizeof("WindowsRackHeight=")-1) == 0) {
       memccpy(WindowsRackHeight,buffer + sizeof("WindowsRackHeight=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsRackHeight[i] != '\n';i++);
       WindowsRackHeight[i]='\0';
    }

    if (memcmp("WindowsRackWidth=",buffer, sizeof("WindowsRackWidth=")-1) == 0) {
       memccpy(WindowsRackWidth,buffer + sizeof("WindowsRackWidth=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsRackWidth[i] != '\n';i++);
       WindowsRackWidth[i]='\0';
    }

    if (memcmp("WindowsDegustationHeight=",buffer, sizeof("WindowsDegustationHeight=")-1) == 0) {
       memccpy(WindowsDegustationHeight,buffer + sizeof("WindowsDegustationHeight=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsDegustationHeight[i] != '\n';i++);
       WindowsDegustationHeight[i]='\0';
    }

    if (memcmp("WindowsDegustationWidth=",buffer, sizeof("WindowsDegustationWidth=")-1) == 0) {
       memccpy(WindowsDegustationWidth,buffer + sizeof("WindowsDegustationWidth=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsDegustationWidth[i] != '\n';i++);
       WindowsDegustationWidth[i]='\0';
    }

    if (memcmp("WindowsConsultDegustationHeight=",buffer, sizeof("WindowsConsultDegustationHeight=")-1) == 0) {
       memccpy(WindowsConsultDegustationHeight,buffer + sizeof("WindowsConsultDegustationHeight=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsConsultDegustationHeight[i] != '\n';i++);
       WindowsConsultDegustationHeight[i]='\0';
    }

    if (memcmp("WindowsConsultDegustationWidth=",buffer, sizeof("WindowsConsultDegustationWidth=")-1) == 0) {
       memccpy(WindowsConsultDegustationWidth,buffer + sizeof("WindowsConsultDegustationWidth=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsConsultDegustationWidth[i] != '\n';i++);
       WindowsConsultDegustationWidth[i]='\0';
    }

    if (memcmp("WindowsSyntheseHeight=",buffer, sizeof("WindowsSyntheseHeight=")-1) == 0) {
       memccpy(WindowsSyntheseHeight,buffer + sizeof("WindowsSyntheseHeight=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsSyntheseHeight[i] != '\n';i++);
       WindowsSyntheseHeight[i]='\0';
    }

    if (memcmp("WindowsSyntheseWidth=",buffer, sizeof("WindowsSyntheseWidth=")-1) == 0) {
       memccpy(WindowsSyntheseWidth,buffer + sizeof("WindowsSyntheseWidth=")-1 ,'\n'|EOF, 8 );
       for (i=1;i<8 && WindowsSyntheseWidth[i] != '\n';i++);
       WindowsSyntheseWidth[i]='\0';
    }

	if (memcmp("qt=",buffer, sizeof("qt=")-1) == 0) {
       QT = atoi(&buffer[3]); 
    }

    if (memcmp("DetailMaxRowEmplacement=",buffer, sizeof("DetailMaxRowEmplacement=")-1) == 0) {
       DetailMaxRowEmplacement = atoi(&buffer[sizeof("DetailMaxRowEmplacement=")-1]); 
    }
    if (memcmp("DetailMaxRowPurchase=",buffer, sizeof("DetailMaxRowPurchase=")-1) == 0) {
       DetailMaxRowPurchase = atoi(&buffer[sizeof("DetailMaxRowPurchase=")-1]); 
    }
    if (memcmp("DetailMaxRowDrinking=",buffer, sizeof("DetailMaxRowDrinking=")-1) == 0) {
       DetailMaxRowDrinking = atoi(&buffer[sizeof("DetailMaxRowDrinking=")-1]); 
    }
    if (memcmp("rackNb=",buffer, sizeof("rackNb=")-1) == 0) {
       rackNb = atoi(&buffer[sizeof("rackNb=")-1]); 
    }
    if (memcmp("debug=",buffer, sizeof("debug=")-1) == 0) {
       debug = atoi(&buffer[sizeof("debug=")-1]); 
    }
	/* remplissage de la liste des lignes des racks */
	for(i=0;i<rackNb;i++){
		gchar tmp[15];
		guint size;
		g_sprintf(tmp,"rackRowNb%d=",i+1);
		if(i<10)
			size = 11;
		else
			size = 12;
		if (memcmp(tmp,buffer, size) == 0) {
                   rackRowNb = atoi(buffer + size); 
                   list_rackRow=g_list_append(list_rackRow,(gpointer)rackRowNb);
		}
	}
	for(i=0;i<rackNb;i++){
		gchar tmp[15];
		guint size;
		g_sprintf(tmp,"rackColNb%d=",i+1);
		if(i<10)
			size = 11;
		else
			size = 12;
		if (memcmp(tmp,buffer, size) == 0) {
                   rackColNb = atoi(buffer + size); 
                   list_rackCol=g_list_append(list_rackCol,(gpointer)rackColNb);
		}
	}	
	
    if (memcmp("fileLocation=",buffer, sizeof("fileLocation=")-1) == 0) {
       memccpy(fileLocation,buffer + sizeof("fileLocation=")-1 ,'\n'|EOF, Size_CONF );
       for (i=1;i<Size_CONF && fileLocation[i] != '\n';i++);
       fileLocation[i]='\0';
    }
    if (memcmp("printerLocation=",buffer, sizeof("printerLocation=")-1) == 0) {
       memccpy(printerLocation,buffer + sizeof("printerLocation=")-1 ,'\n'|EOF, Size_CONF );
       for (i=1;i<Size_CONF && printerLocation[i] != '\n';i++);
       printerLocation[i]='\0';
    }
    if (memcmp("browserLocation=",buffer, sizeof("browserLocation=")-1) == 0) {
       memccpy(browserLocation,buffer + sizeof("browserLocation=")-1 ,'\n'|EOF, Size_CONF );
       for (i=1;i<Size_CONF && browserLocation[i] != '\n';i++);
       browserLocation[i]='\0';
    }

  } /* end while */

  struct stat f_stat;

  if (  (stat (DBPATH, &f_stat) != -1) && (int)f_stat.st_size != 0 ) {
     if (strncmp(lversion,VERSION,sizeof(VERSION))){

         gint i;
         for (i=1; i < sizeof(DBPATH) ; i++)
             if ( memcmp(DBPATH + i , ".", 1) == 0) break; 

         gchar     f_basename[128];
         memset(f_basename,'\0',i+1);
         memcpy(f_basename,DBPATH,i);

         gchar f_backup[128];
         sprintf(f_backup,"%s.%s.bak",f_basename,VERSION);

         gint cr=0;

         gchar msg[128];
         g_sprintf(msg,_("First use of xcave-%s, do you want to backup up your data ?"),VERSION);
         GtkWidget	*dialog;
         dialog = gtk_message_dialog_new ((GtkWindow *)detail.window,
                                          GTK_DIALOG_DESTROY_WITH_PARENT,
                                          GTK_MESSAGE_QUESTION,
                                          GTK_BUTTONS_YES_NO,
                                          msg);
         gint result = gtk_dialog_run (GTK_DIALOG (dialog));

         gchar   f_cmd[sizeof(f_basename) + sizeof(f_backup) + 8];
         switch (result)
         {
           case GTK_RESPONSE_YES:
                memset(f_cmd,'\0',sizeof(f_cmd));
                sprintf(f_cmd,"cp -f %s %s\n",DBPATH,f_backup);
   	            setenv("PATH","/bin:/usr/bin:/sbin:/usr/local/bin",1);

                cr=system(f_cmd);
                break;
           case GTK_RESPONSE_NO:
           default:
                break;
         }

         gtk_widget_destroy (dialog);
     }
  }

  fclose(f);

}

void
write_xcaverc ()
{
    FILE *f;
    gchar buffer[256];
    gint i;

    xcave_debug_begin(__FULL__);
    f = open_xcaverc("w");

    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"%s/.xcaverc",getenv("HOME"));

    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"stocks=%s\n",DBPATH);
    fputs (buffer, f);
  
    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"version=%s\n",VERSION);
    fputs (buffer, f);
  
    if ( strlen(WindowsXcaveWidth) != 0 ) {
     memset(buffer,'\0',sizeof(buffer));
     sprintf(buffer,"WindowsXcaveWidth=%s\n",WindowsXcaveWidth);
     fputs (buffer, f);
    }
  
    if ( strlen(WindowsXcaveHeight) != 0 ) {
      memset(buffer,'\0',sizeof(buffer));
      sprintf(buffer,"WindowsXcaveHeight=%s\n",WindowsXcaveHeight);
      fputs (buffer, f);
    }
  
    if ( strlen(WindowsDetailHeight) != 0 ) {
       memset(buffer,'\0',sizeof(buffer));
       sprintf(buffer,"WindowsDetailHeight=%s\n",WindowsDetailHeight);
       fputs (buffer, f);
    }
  
    if ( strlen(WindowsDetailWidth) != 0 ) {
       memset(buffer,'\0',sizeof(buffer));
       sprintf(buffer,"WindowsDetailWidth=%s\n",WindowsDetailWidth);
      fputs (buffer, f);
    }
  
    if ( strlen(WindowsRackHeight) != 0 ) {
      memset(buffer,'\0',sizeof(buffer));
      sprintf(buffer,"WindowsRackHeight=%s\n",WindowsRackHeight);
      fputs (buffer, f);
    }
  
    if ( strlen(WindowsRackWidth) != 0 ) {
       memset(buffer,'\0',sizeof(buffer));
       sprintf(buffer,"WindowsRackWidth=%s\n",WindowsRackWidth);
       fputs (buffer, f);
    }
  
    if ( strlen(WindowsDegustationHeight) != 0 ) {
      memset(buffer,'\0',sizeof(buffer));
      sprintf(buffer,"WindowsDegustationHeight=%s\n",WindowsDegustationHeight);
      fputs (buffer, f);
    }
  
    if ( strlen(WindowsDegustationWidth) != 0 ) {
       memset(buffer,'\0',sizeof(buffer));
       sprintf(buffer,"WindowsDegustationWidth=%s\n",WindowsDegustationWidth);
       fputs (buffer, f);
    }

    if ( strlen(WindowsConsultDegustationHeight) != 0 ) {
      memset(buffer,'\0',sizeof(buffer));
      sprintf(buffer,"WindowsConsultDegustationHeight=%s\n",WindowsConsultDegustationHeight);
      fputs (buffer, f);
    }
  
    if ( strlen(WindowsConsultDegustationWidth) != 0 ) {
       memset(buffer,'\0',sizeof(buffer));
       sprintf(buffer,"WindowsConsultDegustationWidth=%s\n",WindowsConsultDegustationWidth);
       fputs (buffer, f);
    }

    if ( strlen(WindowsSyntheseHeight) != 0 ) {
      memset(buffer,'\0',sizeof(buffer));
      sprintf(buffer,"WindowsSyntheseHeight=%s\n",WindowsSyntheseHeight);
      fputs (buffer, f);
    }
  
    if ( strlen(WindowsSyntheseWidth) != 0 ) {
       memset(buffer,'\0',sizeof(buffer));
       sprintf(buffer,"WindowsSyntheseWidth=%s\n",WindowsSyntheseWidth);
       fputs (buffer, f);
    }
  
	memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"qt=%.1d\n",QT);
    fputs (buffer, f);

    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"DetailMaxRowEmplacement=%.1d\n",DetailMaxRowEmplacement);
    fputs (buffer, f);
  
    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"DetailMaxRowPurchase=%.1d\n",DetailMaxRowPurchase);
    fputs (buffer, f);

    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"DetailMaxRowDrinking=%.1d\n",DetailMaxRowDrinking);
    fputs (buffer, f);

    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"rackNb=%.1d\n",rackNb);
    fputs (buffer, f);
    for(i=0;i<rackNb;i++){
  	memset(buffer,'\0',sizeof(buffer));
  	sprintf(buffer,"rackRowNb%d=%.1d\n",i+1,(gint)g_list_nth_data(list_rackRow,i));
		fputs (buffer, f);
    }
    for(i=0;i<rackNb;i++){
        memset(buffer,'\0',sizeof(buffer));
        sprintf(buffer,"rackColNb%d=%.1d\n",i+1,(gint)g_list_nth_data(list_rackCol,i));
        fputs (buffer, f);
    }

    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"fileLocation=%s\n",fileLocation);
    fputs (buffer, f);

    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"printerLocation=%s\n",printerLocation);
    fputs (buffer, f);

    memset(buffer,'\0',sizeof(buffer));
    sprintf(buffer,"browserLocation=%s\n",browserLocation);
    fputs (buffer, f);

	if ( debug != 0) {
       memset(buffer,'\0',sizeof(buffer));
       sprintf(buffer,"debug=%d\n",debug);
       fputs (buffer, f);
	}

    fclose(f);
    xcave_debug_end(__FULL__);

}
