/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#include "callbacks.h"

void
fill_information_treeview (gpointer data, gint colonne)
{
    GList			    *tmp_list_stock;
    GtkTreeModel 		*model;
    GtkTreeSelection	*selection;
    GtkTreeIter			iter;
    GtkTreeIter			child;
    GtkTreeIter			grandson;
    GtkTreeIter			parent;
    GtkTreeIter			grandpa;

    ptrVin 	    		tmpVin;
    gchar                       color[color_size];
    gchar			*pAppellation;
    gchar			*pRegion;
    gchar			*pcountry;
    gint			tmpcol;
    gint 			nbrow;

    tmpVin = g_malloc (sizeof (Vin));

	/*
	 * cleanup the treelist 
	 */
	xcave.information_treeview = glade_xml_get_widget(xcave.main_xml,"information_treeview");
	xcave.information_treestore	=(GtkTreeStore *)  gtk_tree_view_get_model((GtkTreeView *)xcave.information_treeview);
	gtk_tree_store_clear(GTK_TREE_STORE(xcave.information_treestore));

	/*
	 * get the selected color 
	 * needed to display only wine corresponding to the selected color
	 */
	xcave.color_combo = glade_xml_get_widget(xcave.main_xml,"color_combo");
	strcpy (color,gtk_combo_box_get_active_text (GTK_COMBO_BOX (xcave.color_combo)));

	/*
	 * get the selected row of the treeview 
	 * needed to display only wine belonging to country/region/appellation 
	 * selected
	 * if no row is selected then (tmpcol = -1) to display all wine on the 
	 * stock
	 */
	xcave.origin_treeview = glade_xml_get_widget(xcave.main_xml,"origin_treeview");

	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (xcave.origin_treeview));  
	gtk_tree_selection_get_selected (selection, &model, &iter);

	pAppellation = g_malloc(appellation_size);

	nbrow = gtk_tree_selection_count_selected_rows(selection);
	
	if (nbrow == 0)
		tmpcol = -1;
	else {
		gtk_tree_model_get (model, &iter, COL_TREEVIEW, &pAppellation, -1);
		/*
		 * Determine level the selected data is 
		 */
		if (gtk_tree_model_iter_children(model, &child, &iter) == FALSE) {
			tmpcol = COL_TREELIST_APPELLATION;
		
			pRegion	= g_malloc(region_size);
			pcountry	= g_malloc(country_size);
		
			gtk_tree_model_iter_parent(model, &parent, &iter);
			gtk_tree_model_get (model, &parent, COL_TREEVIEW, &pRegion, -1);
			gtk_tree_model_iter_parent(model, &grandpa, &parent);
			gtk_tree_model_get (model, &grandpa, COL_TREEVIEW, &pcountry, -1);
		
		}
		else 
			if (gtk_tree_model_iter_children(model, &grandson, &child) == FALSE) 
				tmpcol = COL_TREELIST_REGION;
			else 
				tmpcol = COL_TREELIST_COUNTRY;
	}
		
	/*
	 * ok now it's time to play the game. I mean to glance through the stocks
	 * to display wine depending of different selection
	 */
	for(tmp_list_stock = list_stock; tmp_list_stock != NULL; tmp_list_stock = tmp_list_stock->next) {
        GtkTreeIter pIter;

		memset(tmpVin,'\0',sizeof(Vin));
		memcpy(tmpVin,tmp_list_stock->data,sizeof(Vin));

		if ( /* color */
 			 ( 
			   (strcasecmp(color,_("ALL")) == 0)
			   ||
			   (strcasecmp(color,_("All")) == 0)
			   ||
		       (strcasecmp(color,tmpVin->color) == 0)
			  )
			&&	/* treelist selection when color is changed */	
			 ( (tmpcol == COL_TREELIST_APPELLATION && strcasecmp(pAppellation,tmpVin->Appellation) == 0)
			   ||
			   (tmpcol == COL_TREELIST_REGION && strcasecmp(pAppellation,tmpVin->Region) == 0)
			   ||		   (tmpcol == COL_TREELIST_COUNTRY && strcasecmp(pAppellation,tmpVin->country) == 0)
			   ||
			   (tmpcol == -1)
			 )
			&&	/* treelist selection when treelist is changed */	
			 ( (colonne == COL_TREELIST_APPELLATION && 
				strcasecmp(data,tmpVin->Appellation) == 0 &&
				strcasecmp(pRegion,tmpVin->Region)   == 0 &&
				strcasecmp(pcountry,tmpVin->country)       == 0
			    )
			   ||
			   (colonne == COL_TREELIST_REGION && strcasecmp(data,tmpVin->Region) == 0)
			   ||
			   (colonne == COL_TREELIST_COUNTRY && strcasecmp(data,tmpVin->country) == 0)
			   ||
			   (colonne == COL_TREELIST_COLOR && strcasecmp(data,tmpVin->color) == 0)
			   ||
			   (colonne == COL_TREELIST_COLOR && strcasecmp(data,_("All")) == 0)
			   ||
			   (colonne == COL_TREELIST_COLOR && strcasecmp(data,_("ALL")) == 0)
			 )
		   && /* quantity to display drinking wine that are not deleted from
			   * the stock
			   */
		     ( (QT == 0 && tmpVin->qty != 0 )  || ( QT == 1 ) )
			) {
				tmpVin->Maturite = xcave_compute_maturity_value(tmpVin->qty,tmpVin->vintage,tmpVin->Conserv);
				gtk_tree_store_append(xcave.information_treestore, &pIter, NULL);/* C */
				gtk_tree_store_set(xcave.information_treestore, &pIter, COL_TREELIST_MILLESIME, (guint)tmpVin->vintage,
									COL_TREELIST_QTY, (guint)tmpVin->qty,
									COL_TREELIST_DOMAIN, tmpVin->Nom,
									COL_TREELIST_COUNTRY, tmpVin->country,
									COL_TREELIST_REGION, tmpVin->Region,
									COL_TREELIST_APPELLATION, tmpVin->Appellation,
									COL_TREELIST_COLOR, tmpVin->color,
									COL_TREELIST_MATURITE, tmpVin->Maturite,
									COL_TREELIST_PDATA, tmp_list_stock->data,
									COL_TREELIST_PGLIST, tmp_list_stock,
									-1);			
			}
	
	}

	gtk_tree_sortable_set_sort_column_id (	GTK_TREE_SORTABLE (xcave.information_treestore),
											COL_TREELIST_MATURITE, 
											GTK_SORT_DESCENDING);

	gtk_tree_view_set_model(GTK_TREE_VIEW(xcave.information_treeview), GTK_TREE_MODEL(xcave.information_treestore));

	{
		gint nb_bottle = calculate_nb_bottle (CALCULATE_COLOR,color,0);
        if ( nb_bottle != 0) {			
			sprintf (xcave.statusbar_txt, _("Number of bottles in cellar: %d (%s: %d)"),
			                        NbBottleStock,
                                    color,
					                nb_bottle);
            xcave.statusbar_ctxtid = gtk_statusbar_push ((GtkStatusbar *)xcave.statusbar_v, xcave.statusbar_ctxtid, xcave.statusbar_txt);
		}  else {
	        sprintf (xcave.statusbar_txt, _("Number of bottles in cellar: %d"),NbBottleStock);
            xcave.statusbar_ctxtid = gtk_statusbar_push ((GtkStatusbar *)xcave.statusbar_v, xcave.statusbar_ctxtid, xcave.statusbar_txt);
		} 
	}
	
	g_free(tmpVin);
	g_free(pAppellation);

}

void
xcave_fill_model (GtkTreeStore * storeview_origin, GtkTreeStore * storeview_information)
{
    GList 		*tmp_list_stock;
    ptrVin     		tmpVin;
    gchar		*pCountry;
    gchar		*pRegCountry;
    gchar		*pAppCountry;
    gchar		*pRegion;
    gchar		*pAppRegion;
    gchar		*pAppellation;

    xcave_debug_begin(__FULL__);

    tmpVin          = g_malloc (sizeof (Vin));
    pCountry        = g_malloc(country_size);
    pRegCountry	    = g_malloc(country_size);
    pAppCountry	    = g_malloc(country_size);
    pRegion	    = g_malloc(region_size);
    pAppRegion      = g_malloc(region_size);
    pAppellation    = g_malloc(appellation_size);

    strcpy (pCountry, ".");
    strcpy (pRegion, ".");
    strcpy (pAppellation, ".");
    strcpy (pRegCountry,".");
    strcpy (pAppCountry,".");
    strcpy (pAppRegion, ".");

    /*
     * Removes all rows from tree_store
     */
    gtk_tree_store_clear(storeview_origin);

    for(tmp_list_stock = list_stock; tmp_list_stock != NULL; tmp_list_stock = tmp_list_stock->next) {
        GtkTreeIter pIter;
        GtkTreeIter pIter2;
        GtkTreeIter pIter3;
        GtkTreeIter pIter4;

        memset(tmpVin,'\0',sizeof(Vin));
        memcpy(tmpVin,tmp_list_stock->data,sizeof(Vin));

        /*
         * Affichage des vins consommés - dont la quantité est nulle dans le stocks
         * mais dont la trace a neanmoins ete conservee
         */
        if ( (QT == 0 && tmpVin->qty != 0 )  || ( QT == 1 ) ){
          /* 
           * new country
           */
          if (strcasecmp (tmpVin->country,pCountry) != 0 ) {
             /*
              * Appends a new row to tree_store
              */
             gtk_tree_store_append(storeview_origin, &pIter, NULL);
             strncpy (pCountry,tmpVin->country,country_size);
             /*
              * Sets the value of one or more cells in the row referenced by iter.
              */
             gtk_tree_store_set(storeview_origin, &pIter, COL_TREEVIEW, pCountry, -1);			
          } /* end if */

          /* 
           * new region
           */
          if ( strcasecmp (tmpVin->Region,pRegion) != 0 
               || (strcasecmp (tmpVin->Region,pRegion) == 0 
                   &&
                   strcasecmp (tmpVin->country,pRegCountry) != 0 )
             ) {
             /*
              * Appends a new row to tree_store
              */
             gtk_tree_store_append(storeview_origin, &pIter2, &pIter);/* C */
             strncpy (pRegion, tmpVin->Region, region_size);
             /*
              * Sets the value of one or more cells in the row referenced by iter.
              */
             gtk_tree_store_set(storeview_origin, &pIter2, COL_TREEVIEW, pRegion, -1);			
          } /* end if */
		
          /*
           * new appellation 
           */ 
          if (  (strcasecmp (tmpVin->Appellation,pAppellation) != 0)  
                || (strcasecmp (tmpVin->Appellation,pAppellation) == 0 
                   && strcasecmp (tmpVin->Region,pAppRegion) != 0 ) 
	        || (strcasecmp (tmpVin->Appellation,pAppellation) == 0 
                   && strcasecmp (tmpVin->Region,pAppRegion) == 0 
                   && strcasecmp (tmpVin->country,pAppCountry) != 0)
             ) {
             /*
              * Appends a new row to tree_store
              */
	     gtk_tree_store_append(storeview_origin, &pIter3, &pIter2);/* C */
             strncpy (pAppellation, tmpVin->Appellation,  appellation_size);
             /*
              * Sets the value of one or more cells in the row referenced by iter.
              */
             gtk_tree_store_set(storeview_origin, &pIter3, COL_TREEVIEW, pAppellation, -1);			
          } /* end if */
          /*
           * Appends a new row to tree_store
           */
          gtk_tree_store_append(storeview_information, &pIter4, NULL);/* C */

          tmpVin->Maturite = xcave_compute_maturity_value(tmpVin->qty,tmpVin->vintage,tmpVin->Conserv);

          /*
           * Sets the value of one or more cells in the row referenced by iter.
           */
          gtk_tree_store_set(storeview_information, &pIter4, 
						COL_TREELIST_MILLESIME, (guint)tmpVin->vintage,
						COL_TREELIST_QTY, (guint)tmpVin->qty,
						COL_TREELIST_DOMAIN, tmpVin->Nom,
						COL_TREELIST_COUNTRY, tmpVin->country,
						COL_TREELIST_REGION, tmpVin->Region,
						COL_TREELIST_APPELLATION, tmpVin->Appellation,
						COL_TREELIST_COLOR, tmpVin->color,
						COL_TREELIST_MATURITE, tmpVin->Maturite,
						COL_TREELIST_PDATA, tmp_list_stock->data,
						COL_TREELIST_PGLIST, tmp_list_stock,
						-1);			

          strncpy (pRegCountry,tmpVin->country,country_size);
          strncpy (pAppCountry,tmpVin->country,country_size);
          strncpy (pAppRegion, tmpVin->Region, region_size);
        } /* end if ( (QT == 0 && tmpVin->qty != 0 )  || ( QT == 1 ) ){ */
	
    } /* end for */

    gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE (storeview_information),
					COL_TREELIST_MATURITE, 
					GTK_SORT_DESCENDING);
    g_free(tmpVin);
    g_free(pCountry); 
    g_free(pRegCountry); 
    g_free(pAppCountry); 
    g_free(pAppRegion);
    g_free(pRegion);
    g_free(pAppellation);

    xcave_debug_end(__FULL__);
}

void
quick_message (const gchar * buf)
{

    /* desactive window_xcave */
    gtk_widget_set_sensitive(detail.window, FALSE);

    GtkWidget	*dialog;
    dialog = gtk_message_dialog_new ((GtkWindow *)detail.window,
                                     GTK_DIALOG_DESTROY_WITH_PARENT,
                                     GTK_MESSAGE_WARNING,
                                     GTK_BUTTONS_CLOSE,
                                     buf);
    gtk_dialog_run (GTK_DIALOG (dialog));
    gtk_widget_destroy (dialog);

    gtk_widget_set_sensitive(detail.window, TRUE);
}

/*
 * row selected from TreeView -> filter 
 * TreeList display 
 */
void
on_treeview_cursor_changed             (GtkTreeView     *treeview,
                                        gpointer         user_data)
{
	GtkTreeModel 		*model;
	GtkTreeSelection	*selection;
	GtkTreeIter			iter;
	GtkTreeIter			child;
	GtkTreeIter			grandson;
	gchar				*pAppellation;

	pAppellation			= g_malloc(appellation_size);

	g_return_if_fail (GTK_IS_TREE_VIEW (treeview));
	selection = gtk_tree_view_get_selection (treeview);  

	if (!gtk_tree_selection_get_selected (selection, &model, &iter))
		return;

	gtk_tree_model_get (model, &iter, COL_TREEVIEW, &pAppellation, -1);

	/*
	 * Determine level the selected data is 
	 */
	if (gtk_tree_model_iter_children(model, &child, &iter) == FALSE) {
		fill_information_treeview(pAppellation,COL_TREELIST_APPELLATION);
	}
	else {
		if (gtk_tree_model_iter_children(model, &grandson, &child) == FALSE) {
			fill_information_treeview(pAppellation,COL_TREELIST_REGION);
		}
		else {
			fill_information_treeview(pAppellation,COL_TREELIST_COUNTRY);

		}
			
	}

	g_free(pAppellation);

}

/*
 * Double click on TreeList View -> display
 * GtkWindow "detail".
 */
void
on_information_treelist_double_clicked              (GtkTreeView     *treeview,
                                        GtkTreePath     *path,
                                        GtkTreeViewColumn *column,
                                        gpointer         user_data)
{
    GtkButton       *button = NULL;
    on_xcave_button_modif_clicked(button,&user_data);
}


