(set-option :produce-proofs true)
(set-option :proof-check-mode true)
(set-option :model-check-mode true)
(set-option :print-terms-cse false)

(set-logic QF_LIRA)
(declare-const i Int)
(declare-const j Int)
(declare-const x Real)
(declare-const y Real)

(push 1)
(assert (not (= (+ i i i) (* i 3))))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (not (= (+ i j i) (+ j i i))))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (not (= (+ (* 1.0 i) (* 2.0 i)) (* 3 i))))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (not (= (+ i x i) (+ x i i))))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (not (= (- x x y) (- y))))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (not (= (+ x (- x) y) y)))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (not (= (+ (* 2 x) (- x) (- y x)) y)))
(check-sat)
(get-proof)
(pop 1)
