/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transfer.AbstractTransferListener;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transfer.TransferCancelledException;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transfer.TransferEvent;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transfer.TransferResource;
import org.apache.tools.ant.Task;

class AntTransferListener
extends AbstractTransferListener {
    private Task task;

    AntTransferListener(Task task) {
        this.task = task;
    }

    @Override
    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        String msg = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        msg = msg + " " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName();
        this.task.log(msg);
    }

    @Override
    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.task.log(event.getException().getMessage() + " for " + resource.getRepositoryUrl() + resource.getResourceName(), 1);
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        String msg = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
        msg = msg + " " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String len = contentLength >= 1024L ? (contentLength + 1023L) / 1024L + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - event.getResource().getTransferStartTime();
            if (duration > 0L) {
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            msg = msg + " (" + len + throughput + ")";
        }
        this.task.log(msg);
    }
}

