<!---
Copyright (C) 2019-2020 Robin Krahl <robin.krahl@ireas.org>
SPDX-License-Identifier: CC0-1.0
-->

# nitrokey-rs

A libnitrokey wrapper for Rust providing access to Nitrokey devices.

## Usage

For usage information, have a look at the [API reference][API reference] and at
the [examples][] in the `examples` directory.  You can also have a look at the
[`nitrocli`][] crate, a command-line interface for Nitrokey devices that uses
this crate.

## Compatibility

This crate provides access to all features of the [`libnitrokey`][] C API for
both the Nitrokey Pro and the Nitrokey Storage: general configuration, one-time
password generation, the password safe and the secure storage on the Nitrokey
Storage.

The required `libnitrokey` version is built from source.  The host system
must provide `libhidapi-libusb0` (Linux) or `libhidapi` (non-Linux) in the
default library search path.  Depending on your system, you might also have to
install the [Nitrokey udev rules][].

If you want to use a precompiled version of `libnitrokey`, you can set the
`USE_SYSTEM_LIBNITROKEY` environment variable during build.  In this case,
`libnitrokey` must be available in the library search path.

### Unsupported Functions

The following functions provided by `libnitrokey` are deliberately not
supported by `nitrokey-rs`:

- `NK_connect_with_ID`, `NK_list_devices_by_cpuID`.  These functions can be
  replaced by calls to `NK_connect_with_path` and `NK_list_devices`, which
  also have a cleaner API.
- `NK_enable_firmware_update_pro`, `NK_change_firmware_password_pro`.  These
  functions execute commands that are not yet supported by the Nitrokey Pro
  firmware.
- `NK_get_device_model`.  We know which model we connected to, so we can
  provide this information without calling `libnitrokey`.
- `NK_is_AES_supported`.  This function is no longer needed for Nitrokey
  devices with a recent firmware version.
- `NK_send_startup`.  Currently, this function is redundant to `NK_get_time`.
- `NK_set_unencrypted_volume_rorw_pin_type_user`: This function is only
  relevant for older firmware versions (pre-v0.51).  As the Nitrokey Storage
  firmware can be updated easily, we do not support these outdated versions.
- `NK_totp_get_time`, `NK_status`, `NK_set_unencrypted_read_only`,
  `NK_set_unencrypted_read_write`.  These functions are deprecated.
- `NK_read_HOTP_slot`.  This function is only available for HOTP slots, not for
  TOTP.  We will support it once both types are supported by `libnitrokey`.
- All `*_as_string` functions that return string representations of data
  returned by other functions.

## Tests

This crate has tests for different scenarios:  Some tests require that no
Nitrokey device is connected, others require a Nitrokey Storage or a Nitrokey
Pro.  We use the [`nitrokey-test`][] crate to select the test cases.  You can
just run `cargo test` to auto-detect connected Nitrokey devices and to run the
appropriate tests.  If you want to manually select the tests, set the
`NITROKEY_TEST_GROUP` environment variable to `nodev` (no device connected),
`pro` (Nitrokey Pro connected) or `storage` (Nitrokey Storage connected).

Note that the tests assume that the device’s passwords are the factory defaults
(admin PIN `12345678`, user PIN `123456`, update password `12345678`) and that
an AES key has been built.  Some tests will overwrite the data stored on the
Nitrokey device or perform a factory reset.  Never execute the tests if you
don’t want to destroy all data on any connected Nitrokey device!

The test suite contains some test that take very long to execute, for example
filling the SD card of a Nitrokey Storage with random data.  These tests are
ignored per default.  Use `cargo test -- --ignored` to execute the tests.

Currently, there are no tests specifically for the Librem Key as we first have
to release a new `nitrokey-rs` version that `nitrokey-test` can use.

## Contributing

Contributions to this project are welcome!  Please submit patches to the
mailing list [~ireas/nitrokey-rs-dev@lists.sr.ht][] ([archive][]) using the
`[PATCH nitrokey-rs]` subject prefix.  For more information, see the
[Contributing Guide][].

## Acknowledgments

Thanks to Nitrokey GmbH for providing two Nitrokey devices to support the
development of this crate.  Thanks to Daniel Mueller for contributions to
`nitrokey-rs` and for the `nitrokey-test` crate.

## Minimum Supported Rust Version

This crate supports Rust 1.40.0 or later.

## Contact

For bug reports, patches, feature requests or other messages, please send a
mail to [~ireas/nitrokey-rs-dev@lists.sr.ht][] ([archive][]).

## License

This project is licensed under the [MIT][] license.  The documentation and
configuration files contained in this repository are licensed under the
[Creative Commons Zero][CC0] license.  You can find a copy of the license texts
in the `LICENSES` directory.  `libnitrokey` is licensed under the [LGPL-3.0][].

`nitrokey-rs` complies with [version 3.0 of the REUSE specification][reuse].

[API reference]: https://docs.rs/nitrokey
[examples]: https://git.ireas.org/nitrokey-rs/tree/examples
[`nitrocli`]: https://github.com/d-e-s-o/nitrocli
[Nitrokey udev rules]: https://www.nitrokey.com/documentation/frequently-asked-questions-faq#openpgp-card-not-available
[`libnitrokey`]: https://github.com/nitrokey/libnitrokey
[`nitrokey-test`]: https://github.com/d-e-s-o/nitrokey-test
[~ireas/nitrokey-rs-dev@lists.sr.ht]: mailto:~ireas/nitrokey-rs-dev@lists.sr.ht
[archive]: https://lists.sr.ht/~ireas/nitrokey-rs-dev
[Contributing Guide]: https://man.sr.ht/~ireas/guides/contributing.md
[MIT]: https://opensource.org/licenses/MIT
[CC0]: https://creativecommons.org/publicdomain/zero/1.0/
[LGPL-3.0]: https://opensource.org/licenses/lgpl-3.0.html
[reuse]: https://reuse.software/practices/3.0/
