/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.ArcFourHmac;
import sun.security.krb5.internal.crypto.EType;

public final class ArcFourHmacEType
extends EType {
    @Override
    public int eType() {
        return 23;
    }

    @Override
    public int minimumPadSize() {
        return 1;
    }

    @Override
    public int confounderSize() {
        return 8;
    }

    @Override
    public int checksumType() {
        return -138;
    }

    @Override
    public int checksumSize() {
        return ArcFourHmac.getChecksumLength();
    }

    @Override
    public int blockSize() {
        return 1;
    }

    @Override
    public int keyType() {
        return 4;
    }

    @Override
    public int keySize() {
        return 16;
    }

    @Override
    public byte[] encrypt(byte[] byArray, byte[] byArray2, int n) throws KrbCryptoException {
        byte[] byArray3 = new byte[this.blockSize()];
        return this.encrypt(byArray, byArray2, byArray3, n);
    }

    @Override
    public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbCryptoException {
        try {
            return ArcFourHmac.encrypt(byArray2, n, byArray3, byArray, 0, byArray.length);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    @Override
    public byte[] decrypt(byte[] byArray, byte[] byArray2, int n) throws KrbApErrException, KrbCryptoException {
        byte[] byArray3 = new byte[this.blockSize()];
        return this.decrypt(byArray, byArray2, byArray3, n);
    }

    @Override
    public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbApErrException, KrbCryptoException {
        try {
            return ArcFourHmac.decrypt(byArray2, n, byArray3, byArray, 0, byArray.length);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    @Override
    public byte[] decryptedData(byte[] byArray) {
        return byArray;
    }
}

