/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import jdk.jfr.EventType;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.EventPrintWriter;
import jdk.jfr.internal.tool.JSONWriter;
import jdk.jfr.internal.tool.PrettyWriter;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;
import jdk.jfr.internal.tool.XMLWriter;

final class Print
extends Command {
    Print() {
    }

    @Override
    public String getName() {
        return "print";
    }

    @Override
    public List<String> getOptionSyntax() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("[--xml|--json]");
        arrayList.add("[--categories <filter>]");
        arrayList.add("[--events <filter>]");
        arrayList.add("[--stack-depth <depth>]");
        arrayList.add("<file>");
        return arrayList;
    }

    @Override
    protected String getTitle() {
        return "Print contents of a recording file";
    }

    @Override
    public String getDescription() {
        return this.getTitle() + ". See 'jfr help print' for details.";
    }

    @Override
    public void displayOptionUsage(PrintStream printStream) {
        printStream.println("  --xml                   Print recording in XML format");
        printStream.println();
        printStream.println("  --json                  Print recording in JSON format");
        printStream.println();
        printStream.println("  --categories <filter>   Select events matching a category name.");
        printStream.println("                          The filter is a comma-separated list of names,");
        printStream.println("                          simple and/or qualified, and/or quoted glob patterns");
        printStream.println();
        printStream.println("  --events <filter>       Select events matching an event name.");
        printStream.println("                          The filter is a comma-separated list of names,");
        printStream.println("                          simple and/or qualified, and/or quoted glob patterns");
        printStream.println();
        printStream.println("  --stack-depth <depth>   Number of frames in stack traces, by default 5");
        printStream.println();
        printStream.println("  <file>                  Location of the recording file (.jfr)");
        printStream.println();
        printStream.println();
        printStream.println("Example usage:");
        printStream.println();
        printStream.println(" jfr print --events OldObjectSample recording.jfr");
        printStream.println();
        printStream.println(" jfr print --events CPULoad,GarbageCollection recording.jfr");
        printStream.println();
        printStream.println(" jfr print --categories \"GC,JVM,Java*\" recording.jfr");
        printStream.println();
        printStream.println(" jfr print --events \"jdk.*\" --stack-depth 64 recording.jfr");
        printStream.println();
        printStream.println(" jfr print --json --events CPULoad recording.jfr");
    }

    @Override
    public void execute(Deque<String> deque) throws UserSyntaxException, UserDataException {
        Path path = this.getJFRInputFile(deque);
        PrintWriter printWriter = new PrintWriter(System.out, false);
        Predicate<EventType> predicate = null;
        int n = 5;
        EventPrintWriter eventPrintWriter = null;
        int n2 = deque.size();
        boolean bl = false;
        boolean bl2 = false;
        while (n2 > 0) {
            String string;
            if (this.acceptFilterOption(deque, "--events")) {
                if (bl) {
                    throw new UserSyntaxException("use --events event1,event2,event3 to include multiple events");
                }
                bl = true;
                string = deque.remove();
                this.warnForWildcardExpansion("--events", string);
                predicate = Print.addEventFilter(string, predicate);
            }
            if (this.acceptFilterOption(deque, "--categories")) {
                if (bl2) {
                    throw new UserSyntaxException("use --categories category1,category2 to include multiple categories");
                }
                bl2 = true;
                string = deque.remove();
                this.warnForWildcardExpansion("--categories", string);
                predicate = Print.addCategoryFilter(string, predicate);
            }
            if (this.acceptOption(deque, "--stack-depth")) {
                string = deque.pop();
                try {
                    n = Integer.parseInt(string);
                    if (n < 0) {
                        throw new UserSyntaxException("stack depth must be zero or a positive integer.");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UserSyntaxException("not a valid value for --stack-depth");
                }
            }
            if (Print.acceptFormatterOption(deque, eventPrintWriter, "--json")) {
                eventPrintWriter = new JSONWriter(printWriter);
            }
            if (Print.acceptFormatterOption(deque, eventPrintWriter, "--xml")) {
                eventPrintWriter = new XMLWriter(printWriter);
            }
            if (n2 == deque.size()) {
                this.checkCommonError(deque, "--event", "--events");
                this.checkCommonError(deque, "--category", "--categories");
                throw new UserSyntaxException("unknown option " + deque.peek());
            }
            n2 = deque.size();
        }
        if (eventPrintWriter == null) {
            eventPrintWriter = new PrettyWriter(printWriter);
        }
        eventPrintWriter.setStackDepth(n);
        if (predicate != null) {
            predicate = Print.addCache(predicate, eventType -> eventType.getId());
            eventPrintWriter.setEventFilter(predicate);
        }
        try {
            eventPrintWriter.print(path);
        }
        catch (IOException iOException) {
            this.couldNotReadError(path, iOException);
        }
        printWriter.flush();
    }

    private void checkCommonError(Deque<String> deque, String string, String string2) throws UserSyntaxException {
        if (string.equals(deque.peek())) {
            throw new UserSyntaxException("unknown option " + string + ", did you mean " + string2 + "?");
        }
    }

    private static boolean acceptFormatterOption(Deque<String> deque, EventPrintWriter eventPrintWriter, String string) throws UserSyntaxException {
        if (string.equals(deque.peek())) {
            if (eventPrintWriter != null) {
                throw new UserSyntaxException("only one format can be specified at a time");
            }
            deque.remove();
            return true;
        }
        return false;
    }

    private static <T, X> Predicate<T> addCache(Predicate<T> predicate, Function<T, X> function) {
        HashMap hashMap = new HashMap();
        return object -> hashMap.computeIfAbsent(function.apply(object), object2 -> predicate.test(object));
    }

    private static <T> Predicate<T> recurseIfPossible(Predicate<T> predicate) {
        return object -> predicate != null && predicate.test(object);
    }

    private static Predicate<EventType> addCategoryFilter(String string, Predicate<EventType> predicate) throws UserSyntaxException {
        List<String> list = Print.explodeFilter(string);
        Predicate<EventType> predicate2 = Print.recurseIfPossible(eventType -> {
            for (String string : eventType.getCategoryNames()) {
                for (String string2 : list) {
                    if (Print.match(string, string2)) {
                        return true;
                    }
                    if (!string.contains(" ") || !Print.acronomify(string).equals(string2)) continue;
                    return true;
                }
            }
            return false;
        });
        return predicate == null ? predicate2 : predicate.or(predicate2);
    }

    private static String acronomify(String string) {
        boolean bl = true;
        String string2 = "";
        for (char c : string.toCharArray()) {
            if (bl && Character.isAlphabetic(c) && Character.isUpperCase(c)) {
                string2 = string2 + c;
            }
            bl = Character.isWhitespace(c);
        }
        return string2;
    }

    private static Predicate<EventType> addEventFilter(String string, Predicate<EventType> predicate) throws UserSyntaxException {
        List<String> list = Print.explodeFilter(string);
        Predicate<EventType> predicate2 = Print.recurseIfPossible(eventType -> {
            for (String string : list) {
                String string2 = eventType.getName();
                if (Print.match(string2, string)) {
                    return true;
                }
                String string3 = string2.substring(string2.lastIndexOf(".") + 1);
                if (!Print.match(string3, string)) continue;
                return true;
            }
            return false;
        });
        return predicate == null ? predicate2 : predicate.or(predicate2);
    }

    private static boolean match(String string, String string2) {
        if (string2.length() == 0) {
            return string.length() == 0;
        }
        if (string2.charAt(0) == '*') {
            string2 = string2.substring(1);
            for (int i = 0; i <= string.length(); ++i) {
                if (!Print.match(string.substring(i), string2)) continue;
                return true;
            }
        } else {
            if (string.length() == 0) {
                return false;
            }
            if (string2.charAt(0) == '?') {
                return Print.match(string.substring(1), string2.substring(1));
            }
            if (string2.charAt(0) == string.charAt(0)) {
                return Print.match(string.substring(1), string2.substring(1));
            }
        }
        return false;
    }

    private static List<String> explodeFilter(String string) throws UserSyntaxException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(",")) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

