/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.AccessFlags;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.oops.FieldType;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.Symbol;

public class Field {
    private long offset;
    private FieldIdentifier id;
    private boolean isVMField;
    private InstanceKlass holder;
    private FieldType fieldType;
    private Symbol signature;
    private Symbol genericSignature;
    private AccessFlags accessFlags;
    private int fieldIndex;

    Field(FieldIdentifier id, long offset, boolean isVMField) {
        this.offset = offset;
        this.id = id;
        this.isVMField = isVMField;
    }

    Field(InstanceKlass holder, int fieldIndex) {
        this.holder = holder;
        this.fieldIndex = fieldIndex;
        this.offset = holder.getFieldOffset(fieldIndex);
        this.genericSignature = holder.getFieldGenericSignature(fieldIndex);
        Symbol name = holder.getFieldName(fieldIndex);
        this.id = new NamedFieldIdentifier(name.asString());
        this.signature = holder.getFieldSignature(fieldIndex);
        this.fieldType = new FieldType(this.signature);
        short access = holder.getFieldAccessFlags(fieldIndex);
        this.accessFlags = new AccessFlags(access);
    }

    public long getOffset() {
        return this.offset;
    }

    public FieldIdentifier getID() {
        return this.id;
    }

    public boolean isVMField() {
        return this.isVMField;
    }

    public boolean isNamedField() {
        return this.id instanceof NamedFieldIdentifier;
    }

    public void printOn(PrintStream tty) {
        this.getID().printOn(tty);
        tty.print(" {" + this.getOffset() + "} :");
    }

    public InstanceKlass getFieldHolder() {
        return this.holder;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public long getAccessFlags() {
        return this.accessFlags.getValue();
    }

    public AccessFlags getAccessFlagsObj() {
        return this.accessFlags;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public Symbol getSignature() {
        return this.signature;
    }

    public Symbol getGenericSignature() {
        return this.genericSignature;
    }

    public boolean hasInitialValue() {
        return this.holder.getFieldInitialValueIndex(this.fieldIndex) != 0;
    }

    public boolean isPublic() {
        return this.accessFlags.isPublic();
    }

    public boolean isPrivate() {
        return this.accessFlags.isPrivate();
    }

    public boolean isProtected() {
        return this.accessFlags.isProtected();
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return this.accessFlags.isStatic();
    }

    public boolean isFinal() {
        return this.accessFlags.isFinal();
    }

    public boolean isVolatile() {
        return this.accessFlags.isVolatile();
    }

    public boolean isTransient() {
        return this.accessFlags.isTransient();
    }

    public boolean isSynthetic() {
        return this.accessFlags.isSynthetic();
    }

    public boolean isEnumConstant() {
        return this.accessFlags.isEnum();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        return this.getFieldHolder().equals(other.getFieldHolder()) && this.getID().equals(other.getID());
    }

    public int hashCode() {
        return this.getFieldHolder().hashCode() ^ this.getID().hashCode();
    }
}

