from functools import wraps


def deco1(func):
    """docstring for deco1"""

    @wraps(func)
    def wrapper():
        return func()

    return wrapper


def deco2(condition, message):
    """docstring for deco2"""

    def decorator(func):
        def wrapper():
            return func()

        return wrapper

    return decorator


@deco1
def foo(name=None, age=None):
    pass


class Bar:
    @deco1
    def meth(self, name=None, age=None):
        pass


class Baz:
    @deco1
    def __init__(self, name=None, age=None):
        pass


class Qux:
    @deco1
    def __new__(cls, name=None, age=None):
        pass


class _Metaclass(type):
    @deco1
    def __call__(cls, name=None, age=None):
        pass


class Quux(metaclass=_Metaclass):
    pass
