/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.worker;

import java.io.IOException;
import java.util.ArrayList;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.testing.DefaultNestedTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultParameterizedTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.DefaultTestFailureDetails;
import org.gradle.api.internal.tasks.testing.DefaultTestMethodDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestFailureSerializationException;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.worker.WorkerTestClassProcessor;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.id.CompositeIdGenerator;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

public class TestEventSerializer {
    public static SerializerRegistry create() {
        BaseSerializerFactory factory = new BaseSerializerFactory();
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(DefaultTestClassRunInfo.class, (Serializer)new DefaultTestClassRunInfoSerializer());
        registry.register(CompositeIdGenerator.CompositeId.class, (Serializer)new IdSerializer());
        registry.register(DefaultNestedTestSuiteDescriptor.class, (Serializer)new DefaultNestedTestSuiteDescriptorSerializer());
        registry.register(DefaultParameterizedTestDescriptor.class, (Serializer)new DefaultParameterizedTestDescriptorSerializer());
        registry.register(DefaultTestSuiteDescriptor.class, (Serializer)new DefaultTestSuiteDescriptorSerializer());
        registry.register(WorkerTestClassProcessor.WorkerTestSuiteDescriptor.class, (Serializer)new WorkerTestSuiteDescriptorSerializer());
        registry.register(DefaultTestClassDescriptor.class, (Serializer)new DefaultTestClassDescriptorSerializer());
        registry.register(DefaultTestMethodDescriptor.class, (Serializer)new DefaultTestMethodDescriptorSerializer());
        registry.register(DefaultTestDescriptor.class, (Serializer)new DefaultTestDescriptorSerializer());
        registry.register(TestStartEvent.class, (Serializer)new TestStartEventSerializer());
        registry.register(TestCompleteEvent.class, (Serializer)new TestCompleteEventSerializer());
        registry.register(DefaultTestOutputEvent.class, (Serializer)new DefaultTestOutputEventSerializer());
        Serializer throwableSerializer = factory.getSerializerFor(Throwable.class);
        registry.register(Throwable.class, throwableSerializer);
        registry.register(DefaultTestFailure.class, (Serializer)new DefaultTestFailureSerializer((Serializer<Throwable>)throwableSerializer));
        return registry;
    }

    private static class DefaultTestMethodDescriptorSerializer
    implements Serializer<DefaultTestMethodDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestMethodDescriptorSerializer() {
        }

        public DefaultTestMethodDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String className = decoder.readString();
            String name = decoder.readString();
            return new DefaultTestMethodDescriptor(id, className, name);
        }

        public void write(Encoder encoder, DefaultTestMethodDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getClassName());
            encoder.writeString((CharSequence)value.getName());
        }
    }

    private static class DefaultTestDescriptorSerializer
    implements Serializer<DefaultTestDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestDescriptorSerializer() {
        }

        public DefaultTestDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String className = decoder.readString();
            String classDisplayName = decoder.readString();
            String name = decoder.readString();
            String displayName = decoder.readString();
            return new DefaultTestDescriptor(id, className, name, classDisplayName, displayName);
        }

        public void write(Encoder encoder, DefaultTestDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getClassName());
            encoder.writeString((CharSequence)value.getClassDisplayName());
            encoder.writeString((CharSequence)value.getName());
            encoder.writeString((CharSequence)value.getDisplayName());
        }
    }

    private static class DefaultTestClassDescriptorSerializer
    implements Serializer<DefaultTestClassDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestClassDescriptorSerializer() {
        }

        public DefaultTestClassDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            String displayName = decoder.readString();
            return new DefaultTestClassDescriptor(id, name, displayName);
        }

        public void write(Encoder encoder, DefaultTestClassDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
            encoder.writeString((CharSequence)value.getDisplayName());
        }
    }

    private static class WorkerTestSuiteDescriptorSerializer
    implements Serializer<WorkerTestClassProcessor.WorkerTestSuiteDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private WorkerTestSuiteDescriptorSerializer() {
        }

        public WorkerTestClassProcessor.WorkerTestSuiteDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            return new WorkerTestClassProcessor.WorkerTestSuiteDescriptor(id, name);
        }

        public void write(Encoder encoder, WorkerTestClassProcessor.WorkerTestSuiteDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
        }
    }

    @NonNullApi
    private static class DefaultParameterizedTestDescriptorSerializer
    implements Serializer<DefaultParameterizedTestDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultParameterizedTestDescriptorSerializer() {
        }

        public DefaultParameterizedTestDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            String className = decoder.readNullableString();
            String displayName = decoder.readString();
            CompositeIdGenerator.CompositeId parentId = (CompositeIdGenerator.CompositeId)this.idSerializer.read(decoder);
            return new DefaultParameterizedTestDescriptor(id, name, className, displayName, parentId);
        }

        public void write(Encoder encoder, DefaultParameterizedTestDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
            encoder.writeNullableString((CharSequence)value.getClassName());
            encoder.writeString((CharSequence)value.getDisplayName());
            this.idSerializer.write(encoder, (Object)value.getParentId());
        }
    }

    private static class DefaultNestedTestSuiteDescriptorSerializer
    implements Serializer<DefaultNestedTestSuiteDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultNestedTestSuiteDescriptorSerializer() {
        }

        public DefaultNestedTestSuiteDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            String displayName = decoder.readString();
            CompositeIdGenerator.CompositeId parentId = (CompositeIdGenerator.CompositeId)this.idSerializer.read(decoder);
            return new DefaultNestedTestSuiteDescriptor(id, name, displayName, parentId);
        }

        public void write(Encoder encoder, DefaultNestedTestSuiteDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
            encoder.writeString((CharSequence)value.getDisplayName());
            this.idSerializer.write(encoder, (Object)value.getParentId());
        }
    }

    private static class DefaultTestSuiteDescriptorSerializer
    implements Serializer<DefaultTestSuiteDescriptor> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new IdSerializer();

        private DefaultTestSuiteDescriptorSerializer() {
        }

        public DefaultTestSuiteDescriptor read(Decoder decoder) throws Exception {
            Object id = this.idSerializer.read(decoder);
            String name = decoder.readString();
            return new DefaultTestSuiteDescriptor(id, name);
        }

        public void write(Encoder encoder, DefaultTestSuiteDescriptor value) throws Exception {
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getId()));
            encoder.writeString((CharSequence)value.getName());
        }
    }

    private static class DefaultTestFailureSerializer
    implements Serializer<DefaultTestFailure> {
        private final Serializer<Throwable> throwableSerializer;

        public DefaultTestFailureSerializer(Serializer<Throwable> throwableSerializer) {
            this.throwableSerializer = throwableSerializer;
        }

        public DefaultTestFailure read(Decoder decoder) throws Exception {
            byte[] actualContent;
            byte[] expectedContent;
            String message = decoder.readNullableString();
            String className = decoder.readString();
            String stacktrace = decoder.readString();
            boolean isAssertionFailure = decoder.readBoolean();
            String expected = decoder.readNullableString();
            String actual = decoder.readNullableString();
            int numOfCauses = decoder.readSmallInt();
            ArrayList<TestFailure> causes = new ArrayList<TestFailure>(numOfCauses);
            for (int i = 0; i < numOfCauses; ++i) {
                causes.add(this.read(decoder));
            }
            boolean isFileComparisonFailure = decoder.readBoolean();
            int expectedContentSize = decoder.readInt();
            if (expectedContentSize == -1) {
                expectedContent = null;
            } else {
                expectedContent = new byte[expectedContentSize];
                decoder.readBytes(expectedContent);
            }
            int actualContentSize = decoder.readInt();
            if (actualContentSize == -1) {
                actualContent = null;
            } else {
                actualContent = new byte[actualContentSize];
                decoder.readBytes(actualContent);
            }
            Throwable rawFailure = this.readThrowableCatchingFailure(decoder);
            return new DefaultTestFailure(rawFailure, new DefaultTestFailureDetails(message, className, stacktrace, isAssertionFailure, isFileComparisonFailure, expected, actual, expectedContent, actualContent), causes);
        }

        private Throwable readThrowableCatchingFailure(Decoder decoder) throws IOException {
            Object rawFailure;
            String rawFailureName = decoder.readString();
            try {
                rawFailure = (Throwable)this.throwableSerializer.read(decoder);
            }
            catch (Exception e) {
                rawFailure = new TestFailureSerializationException("An exception of type " + rawFailureName + " was thrown by the test, but Gradle was unable to recreate the exception in the build process", e);
            }
            return rawFailure;
        }

        public void write(Encoder encoder, DefaultTestFailure value) throws Exception {
            encoder.writeNullableString((CharSequence)value.getDetails().getMessage());
            encoder.writeString((CharSequence)value.getDetails().getClassName());
            encoder.writeString((CharSequence)value.getDetails().getStacktrace());
            encoder.writeBoolean(value.getDetails().isAssertionFailure());
            encoder.writeNullableString((CharSequence)value.getDetails().getExpected());
            encoder.writeNullableString((CharSequence)value.getDetails().getActual());
            encoder.writeSmallInt(value.getCauses().size());
            for (TestFailure cause : value.getCauses()) {
                this.write(encoder, (DefaultTestFailure)cause);
            }
            encoder.writeBoolean(value.getDetails().isFileComparisonFailure());
            byte[] expectedContent = value.getDetails().getExpectedContent();
            if (expectedContent == null) {
                encoder.writeInt(-1);
            } else {
                encoder.writeInt(expectedContent.length);
                encoder.writeBytes(expectedContent);
            }
            byte[] actualContent = value.getDetails().getActualContent();
            if (actualContent == null) {
                encoder.writeInt(-1);
            } else {
                encoder.writeInt(actualContent.length);
                encoder.writeBytes(actualContent);
            }
            this.writeThrowableWithType(encoder, value, value.getRawFailure());
        }

        private void writeThrowableWithType(Encoder encoder, DefaultTestFailure value, Throwable rawFailure) throws Exception {
            encoder.writeString((CharSequence)rawFailure.getClass().getName());
            this.throwableSerializer.write(encoder, (Object)value.getRawFailure());
        }
    }

    private static class DefaultTestOutputEventSerializer
    implements Serializer<DefaultTestOutputEvent> {
        private final Serializer<TestOutputEvent.Destination> destinationSerializer = new BaseSerializerFactory().getSerializerFor(TestOutputEvent.Destination.class);

        private DefaultTestOutputEventSerializer() {
        }

        public DefaultTestOutputEvent read(Decoder decoder) throws Exception {
            long logTime = decoder.readLong();
            TestOutputEvent.Destination destination = (TestOutputEvent.Destination)((Object)this.destinationSerializer.read(decoder));
            String message = decoder.readString();
            return new DefaultTestOutputEvent(logTime, destination, message);
        }

        public void write(Encoder encoder, DefaultTestOutputEvent value) throws Exception {
            encoder.writeLong(value.getLogTime());
            this.destinationSerializer.write(encoder, (Object)value.getDestination());
            encoder.writeString((CharSequence)value.getMessage());
        }
    }

    private static class TestCompleteEventSerializer
    implements Serializer<TestCompleteEvent> {
        private final Serializer<TestResult.ResultType> typeSerializer = new NullableSerializer<TestResult.ResultType>(new BaseSerializerFactory().getSerializerFor(TestResult.ResultType.class));

        private TestCompleteEventSerializer() {
        }

        public TestCompleteEvent read(Decoder decoder) throws Exception {
            long endTime = decoder.readLong();
            TestResult.ResultType result = (TestResult.ResultType)((Object)this.typeSerializer.read(decoder));
            return new TestCompleteEvent(endTime, result);
        }

        public void write(Encoder encoder, TestCompleteEvent value) throws Exception {
            encoder.writeLong(value.getEndTime());
            this.typeSerializer.write(encoder, (Object)value.getResultType());
        }
    }

    private static class TestStartEventSerializer
    implements Serializer<TestStartEvent> {
        final Serializer<CompositeIdGenerator.CompositeId> idSerializer = new NullableSerializer<CompositeIdGenerator.CompositeId>(new IdSerializer());

        private TestStartEventSerializer() {
        }

        public TestStartEvent read(Decoder decoder) throws Exception {
            long time = decoder.readLong();
            Object id = this.idSerializer.read(decoder);
            return new TestStartEvent(time, id);
        }

        public void write(Encoder encoder, TestStartEvent value) throws Exception {
            encoder.writeLong(value.getStartTime());
            this.idSerializer.write(encoder, (Object)((CompositeIdGenerator.CompositeId)value.getParentId()));
        }
    }

    private static class DefaultTestClassRunInfoSerializer
    implements Serializer<DefaultTestClassRunInfo> {
        private DefaultTestClassRunInfoSerializer() {
        }

        public DefaultTestClassRunInfo read(Decoder decoder) throws Exception {
            return new DefaultTestClassRunInfo(decoder.readString());
        }

        public void write(Encoder encoder, DefaultTestClassRunInfo value) throws Exception {
            encoder.writeString((CharSequence)value.getTestClassName());
        }
    }

    private static class IdSerializer
    implements Serializer<CompositeIdGenerator.CompositeId> {
        private IdSerializer() {
        }

        public CompositeIdGenerator.CompositeId read(Decoder decoder) throws Exception {
            return new CompositeIdGenerator.CompositeId((Object)decoder.readLong(), (Object)decoder.readLong());
        }

        public void write(Encoder encoder, CompositeIdGenerator.CompositeId value) throws Exception {
            encoder.writeLong(((Long)value.getScope()).longValue());
            encoder.writeLong(((Long)value.getId()).longValue());
        }
    }

    private static class NullableSerializer<T>
    implements Serializer<T> {
        private final Serializer<T> serializer;

        private NullableSerializer(Serializer<T> serializer) {
            this.serializer = serializer;
        }

        public T read(Decoder decoder) throws Exception {
            if (!decoder.readBoolean()) {
                return null;
            }
            return (T)this.serializer.read(decoder);
        }

        public void write(Encoder encoder, T value) throws Exception {
            encoder.writeBoolean(value != null);
            if (value != null) {
                this.serializer.write(encoder, value);
            }
        }
    }
}

