package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServiceMeshes invokes the servicemesh.DescribeServiceMeshes API synchronously
func (client *Client) DescribeServiceMeshes(request *DescribeServiceMeshesRequest) (response *DescribeServiceMeshesResponse, err error) {
	response = CreateDescribeServiceMeshesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServiceMeshesWithChan invokes the servicemesh.DescribeServiceMeshes API asynchronously
func (client *Client) DescribeServiceMeshesWithChan(request *DescribeServiceMeshesRequest) (<-chan *DescribeServiceMeshesResponse, <-chan error) {
	responseChan := make(chan *DescribeServiceMeshesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServiceMeshes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServiceMeshesWithCallback invokes the servicemesh.DescribeServiceMeshes API asynchronously
func (client *Client) DescribeServiceMeshesWithCallback(request *DescribeServiceMeshesRequest, callback func(response *DescribeServiceMeshesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServiceMeshesResponse
		var err error
		defer close(result)
		response, err = client.DescribeServiceMeshes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServiceMeshesRequest is the request struct for api DescribeServiceMeshes
type DescribeServiceMeshesRequest struct {
	*requests.RpcRequest
}

// DescribeServiceMeshesResponse is the response struct for api DescribeServiceMeshes
type DescribeServiceMeshesResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ServiceMeshes []ServiceMesh `json:"ServiceMeshes" xml:"ServiceMeshes"`
}

// CreateDescribeServiceMeshesRequest creates a request to invoke DescribeServiceMeshes API
func CreateDescribeServiceMeshesRequest() (request *DescribeServiceMeshesRequest) {
	request = &DescribeServiceMeshesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "DescribeServiceMeshes", "servicemesh", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeServiceMeshesResponse creates a response to parse from DescribeServiceMeshes response
func CreateDescribeServiceMeshesResponse() (response *DescribeServiceMeshesResponse) {
	response = &DescribeServiceMeshesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
