package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfirmOTATask invokes the iot.ConfirmOTATask API synchronously
func (client *Client) ConfirmOTATask(request *ConfirmOTATaskRequest) (response *ConfirmOTATaskResponse, err error) {
	response = CreateConfirmOTATaskResponse()
	err = client.DoAction(request, response)
	return
}

// ConfirmOTATaskWithChan invokes the iot.ConfirmOTATask API asynchronously
func (client *Client) ConfirmOTATaskWithChan(request *ConfirmOTATaskRequest) (<-chan *ConfirmOTATaskResponse, <-chan error) {
	responseChan := make(chan *ConfirmOTATaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfirmOTATask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfirmOTATaskWithCallback invokes the iot.ConfirmOTATask API asynchronously
func (client *Client) ConfirmOTATaskWithCallback(request *ConfirmOTATaskRequest, callback func(response *ConfirmOTATaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfirmOTATaskResponse
		var err error
		defer close(result)
		response, err = client.ConfirmOTATask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfirmOTATaskRequest is the request struct for api ConfirmOTATask
type ConfirmOTATaskRequest struct {
	*requests.RpcRequest
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	TaskId        *[]string `position:"Query" name:"TaskId"  type:"Repeated"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
}

// ConfirmOTATaskResponse is the response struct for api ConfirmOTATask
type ConfirmOTATaskResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateConfirmOTATaskRequest creates a request to invoke ConfirmOTATask API
func CreateConfirmOTATaskRequest() (request *ConfirmOTATaskRequest) {
	request = &ConfirmOTATaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ConfirmOTATask", "", "")
	request.Method = requests.POST
	return
}

// CreateConfirmOTATaskResponse creates a response to parse from ConfirmOTATask response
func CreateConfirmOTATaskResponse() (response *ConfirmOTATaskResponse) {
	response = &ConfirmOTATaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
