package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBandWithdChargeType invokes the ens.DescribeBandWithdChargeType API synchronously
func (client *Client) DescribeBandWithdChargeType(request *DescribeBandWithdChargeTypeRequest) (response *DescribeBandWithdChargeTypeResponse, err error) {
	response = CreateDescribeBandWithdChargeTypeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBandWithdChargeTypeWithChan invokes the ens.DescribeBandWithdChargeType API asynchronously
func (client *Client) DescribeBandWithdChargeTypeWithChan(request *DescribeBandWithdChargeTypeRequest) (<-chan *DescribeBandWithdChargeTypeResponse, <-chan error) {
	responseChan := make(chan *DescribeBandWithdChargeTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBandWithdChargeType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBandWithdChargeTypeWithCallback invokes the ens.DescribeBandWithdChargeType API asynchronously
func (client *Client) DescribeBandWithdChargeTypeWithCallback(request *DescribeBandWithdChargeTypeRequest, callback func(response *DescribeBandWithdChargeTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBandWithdChargeTypeResponse
		var err error
		defer close(result)
		response, err = client.DescribeBandWithdChargeType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBandWithdChargeTypeRequest is the request struct for api DescribeBandWithdChargeType
type DescribeBandWithdChargeTypeRequest struct {
	*requests.RpcRequest
}

// DescribeBandWithdChargeTypeResponse is the response struct for api DescribeBandWithdChargeType
type DescribeBandWithdChargeTypeResponse struct {
	*responses.BaseResponse
	BandWithTypeInfo   string `json:"BandWithTypeInfo" xml:"BandWithTypeInfo"`
	ChargeContractType string `json:"ChargeContractType" xml:"ChargeContractType"`
	ChargeCycleInfo    string `json:"ChargeCycleInfo" xml:"ChargeCycleInfo"`
	Code               int    `json:"Code" xml:"Code"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeBandWithdChargeTypeRequest creates a request to invoke DescribeBandWithdChargeType API
func CreateDescribeBandWithdChargeTypeRequest() (request *DescribeBandWithdChargeTypeRequest) {
	request = &DescribeBandWithdChargeTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeBandWithdChargeType", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBandWithdChargeTypeResponse creates a response to parse from DescribeBandWithdChargeType response
func CreateDescribeBandWithdChargeTypeResponse() (response *DescribeBandWithdChargeTypeResponse) {
	response = &DescribeBandWithdChargeTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
