/*
    SPDX-FileCopyrightText: 2006-2007, 2009, 2011, 2019 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_DOCUMENTMANAGER_P_HPP
#define KASTEN_DOCUMENTMANAGER_P_HPP

// lib
#include "documentmanager.hpp"
// Qt
#include <QList>
// Std
#include <memory>

namespace Kasten {

class AbstractDocument;

class DocumentCreateManager; // TODO: temporary
class DocumentSyncManager; // TODO: temporary
class ModelCodecManager; // TODO: temporary

class DocumentManagerPrivate
{
public:
    explicit DocumentManagerPrivate(DocumentManager* q);
    DocumentManagerPrivate(const DocumentManagerPrivate&) = delete;
    DocumentManagerPrivate(DocumentManagerPrivate&&) = delete;

    ~DocumentManagerPrivate();

    DocumentManagerPrivate& operator=(const DocumentManagerPrivate&) = delete;
    DocumentManagerPrivate& operator=(DocumentManagerPrivate&&) = delete;

public:
    void addDocument(std::unique_ptr<AbstractDocument>&& document);

    void closeDocument(AbstractDocument* document);
    void closeDocuments(const QList<AbstractDocument*>& documents);
    void closeAll();
// TODO: think about if a more general close( documentList, theseOrOthers ) is better, same with canCloseAllOther()
    void closeAllOther(AbstractDocument* document);

    // TODO: what to do for documents not added?
    [[nodiscard]]
    bool canClose(AbstractDocument* document) const;
    [[nodiscard]]
    bool canClose(const QList<AbstractDocument*>& documents) const;
    [[nodiscard]]
    bool canCloseAll() const;
    [[nodiscard]]
    bool canCloseAllOther(AbstractDocument* document) const;

    void requestFocus(AbstractDocument* document);

public:
    [[nodiscard]]
    QList<AbstractDocument*> documents() const;
    [[nodiscard]]
    bool isEmpty() const;

public:
    [[nodiscard]]
    DocumentCreateManager* createManager() const;
    [[nodiscard]]
    DocumentSyncManager* syncManager() const;
    [[nodiscard]]
    ModelCodecManager* codecManager() const;

private:
    DocumentManager* const q_ptr;

    QList<AbstractDocument*> mList;

    // TODO: remove into own singleton
    const std::unique_ptr<DocumentCreateManager> mCreateManager;
    const std::unique_ptr<DocumentSyncManager> mSyncManager;
    const std::unique_ptr<ModelCodecManager> mCodecManager;

    Q_DECLARE_PUBLIC(DocumentManager)
};


inline DocumentCreateManager* DocumentManagerPrivate::createManager() const { return mCreateManager.get(); }
inline DocumentSyncManager* DocumentManagerPrivate::syncManager() const { return mSyncManager.get(); }
inline ModelCodecManager* DocumentManagerPrivate::codecManager() const { return mCodecManager.get(); }

inline QList<AbstractDocument*> DocumentManagerPrivate::documents() const { return mList; }
inline bool DocumentManagerPrivate::isEmpty() const { return mList.isEmpty(); }

}

#endif
