/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.gtk.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    @Override
    public TransferData[] getSupportedTypes() {
        int[] types = this.getTypeIds();
        TransferData[] data = new TransferData[types.length];
        for (int i = 0; i < types.length; ++i) {
            data[i] = new TransferData();
            data[i].type = types[i];
        }
        return data;
    }

    @Override
    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] types = this.getTypeIds();
        for (int i = 0; i < types.length; ++i) {
            if (transferData.type != (long)types[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void javaToNative(Object object, TransferData transferData) {
        byte[] buffer;
        transferData.result = 0;
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((buffer = (byte[])object).length == 0) {
            return;
        }
        long pValue = OS.g_malloc(buffer.length);
        if (pValue == 0L) {
            return;
        }
        C.memmove(pValue, buffer, (long)buffer.length);
        transferData.length = buffer.length;
        transferData.format = 8;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    @Override
    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L) {
            return null;
        }
        int size = transferData.format * transferData.length / 8;
        if (size == 0) {
            return null;
        }
        byte[] buffer = new byte[size];
        C.memmove(buffer, transferData.pValue, (long)size);
        return buffer;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

