/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    NSTableColumn column;
    String[] items;
    int itemCount;
    boolean ignoreSelect;
    boolean didSelect;
    boolean rowsChanged;
    boolean mouseIsDown;
    static int NEXT_ID;
    static final int CELL_GAP = 1;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    @Override
    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        return super.accessibilityAttributeValue(id2, sel, arg0);
    }

    @Override
    boolean acceptsFirstResponder(long id2, long sel) {
        return true;
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.itemCount == this.items.length) {
            String[] newItems = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        this.items[this.itemCount++] = string;
        this.updateRowCount();
        this.setScrollWidth(string);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > index || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            String[] newItems = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = string;
        this.updateRowCount();
        if (index != this.itemCount) {
            this.fixSelection(index, true);
        }
        this.setScrollWidth(string);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        if (wHint == -1) {
            NSCell cell = this.column.dataCell();
            Font font = this.font != null ? this.font : this.defaultFont();
            cell.setFont(font.handle);
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                cell.setTitle(NSString.stringWith(this.items[i]));
                NSSize size = cell.cellSize();
                width = Math.max(width, (int)Math.ceil(size.width));
            }
            ++width;
        } else {
            width = wHint;
        }
        if (width <= 0) {
            width = 64;
        }
        int height = 0;
        if (hHint == -1) {
            int itemHeight = this.getItemHeight() + 1;
            height = this.itemCount * itemHeight;
        } else {
            height = hHint;
        }
        if (height <= 0) {
            height = 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new Point(rect.width, rect.height);
    }

    @Override
    void createHandle() {
        NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
        scrollWidget.init();
        if ((this.style & 0x100) != 0) {
            scrollWidget.setHasHorizontalScroller(true);
        }
        if ((this.style & 0x200) != 0) {
            scrollWidget.setHasVerticalScroller(true);
        }
        scrollWidget.setAutohidesScrollers(true);
        scrollWidget.setBorderType((this.style & 0x800) != 0 ? 2L : 0L);
        NSTableView widget = (NSTableView)new SWTTableView().alloc();
        widget.init();
        widget.setAllowsMultipleSelection((this.style & 2) != 0);
        widget.setDataSource(widget);
        widget.setHeaderView(null);
        widget.setDelegate(widget);
        if ((this.style & 0x100) != 0) {
            widget.setColumnAutoresizingStyle(0L);
        }
        NSSize spacing = new NSSize();
        spacing.height = 1.0;
        spacing.width = 1.0;
        widget.setIntercellSpacing(spacing);
        widget.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            widget.setFocusRingType(1L);
        }
        this.column = (NSTableColumn)new NSTableColumn().alloc();
        this.column = this.column.initWithIdentifier(NSString.stringWith(String.valueOf(++NEXT_ID)));
        this.column.setWidth(0.0);
        widget.addTableColumn(this.column);
        this.scrollView = scrollWidget;
        this.view = widget;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new String[4];
    }

    @Override
    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.tableViewFont;
    }

    @Override
    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (0 <= index && index < this.itemCount) {
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            widget.deselectRow(index);
            this.ignoreSelect = false;
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (end < 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(this.itemCount - 1, end);
        if (start == 0 && end == this.itemCount - 1) {
            this.deselectAll();
        } else {
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            for (int i = start; i <= end; ++i) {
                widget.deselectRow(i);
            }
            this.ignoreSelect = false;
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        NSTableView widget = (NSTableView)this.view;
        this.ignoreSelect = true;
        for (int i = 0; i < indices.length; ++i) {
            widget.deselectRow(indices[i]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        this.ignoreSelect = true;
        widget.deselectAll(null);
        this.ignoreSelect = false;
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        NSTableView widget = (NSTableView)this.view;
        NSPoint pt = new NSPoint();
        pt.x = x;
        pt.y = y;
        long row = widget.rowAtPoint(pt);
        if (row == -1L) {
            return false;
        }
        boolean dragging = super.dragDetect(x, y, filter, consume);
        if (dragging && !widget.isRowSelected(row)) {
            NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
            set = set.initWithIndex(row);
            widget.selectRowIndexes(set, false);
            set.release();
        }
        consume[0] = dragging;
        return dragging;
    }

    @Override
    void drawBackgroundInClipRect(long id2, long sel, NSRect rect) {
        super.drawViewBackgroundInRect(id2, sel, rect);
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, NSGraphicsContext.currentContext(), rect, -1);
    }

    void fixSelection(int index, boolean add) {
        int[] selection = this.getSelectionIndices();
        if (selection.length == 0) {
            return;
        }
        int newCount = 0;
        boolean fix = false;
        for (int i = 0; i < selection.length; ++i) {
            if (!add && selection[i] == index) {
                fix = true;
                continue;
            }
            int newIndex = newCount++;
            selection[newIndex] = selection[i];
            if (selection[newIndex] < index) continue;
            int n = newIndex;
            selection[n] = selection[n] + (add ? 1 : -1);
            fix = true;
        }
        if (fix) {
            this.select(selection, newCount, true);
        }
    }

    public int getFocusIndex() {
        this.checkWidget();
        return (int)((NSTableView)this.view).selectedRow();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (0 > index || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSTableView)this.view).rowHeight();
    }

    public String[] getItems() {
        this.checkWidget();
        String[] result = new String[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        if (widget.numberOfSelectedRows() == 0L) {
            return new String[0];
        }
        NSIndexSet selection = widget.selectedRowIndexes();
        int count = (int)selection.count();
        long[] indexBuffer = new long[count];
        selection.getIndexes(indexBuffer, count, 0L);
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.items[(int)indexBuffer[i]];
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSTableView)this.view).numberOfSelectedRows();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        if (widget.numberOfSelectedRows() == 0L) {
            return -1;
        }
        NSIndexSet selection = widget.selectedRowIndexes();
        int count = (int)selection.count();
        long[] result = new long[count];
        selection.getIndexes(result, count, 0L);
        return (int)result[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        if (widget.numberOfSelectedRows() == 0L) {
            return new int[0];
        }
        NSIndexSet selection = widget.selectedRowIndexes();
        int count = (int)selection.count();
        long[] indices = new long[count];
        selection.getIndexes(indices, count, 0L);
        int[] result = new int[count];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)indices[i];
        }
        return result;
    }

    public int getTopIndex() {
        this.checkWidget();
        NSRect rect = this.scrollView.documentVisibleRect();
        NSPoint point = new NSPoint();
        point.x = rect.x;
        point.y = rect.y;
        int result = (int)((NSTableView)this.view).rowAtPoint(point);
        if (result == -1) {
            result = 0;
        }
        return result;
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (!this.items[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        for (int i = start; i < this.itemCount; ++i) {
            if (!this.items[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        if (0 > index || index >= this.itemCount) {
            return false;
        }
        return ((NSTableView)this.view).isRowSelected(index);
    }

    @Override
    long menuForEvent(long id2, long sel, long theEvent) {
        NSPoint mousePoint;
        long row;
        if (this.display.lastHandledMenuForEventId == theEvent) {
            return 0L;
        }
        NSEvent event = new NSEvent(theEvent);
        NSTableView table = (NSTableView)this.view;
        NSIndexSet selectedRowIndexes = table.selectedRowIndexes();
        if (!selectedRowIndexes.containsIndex(row = table.rowAtPoint(mousePoint = this.view.convertPoint_fromView_(event.locationInWindow(), null)))) {
            NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
            set = set.initWithIndex(row);
            table.selectRowIndexes(set, false);
            set.release();
        }
        return super.menuForEvent(id2, sel, theEvent);
    }

    @Override
    void mouseDownSuper(long id2, long sel, long theEvent) {
        this.ignoreSelect = false;
        NSTableView widget = (NSTableView)this.view;
        NSEvent nsEvent = new NSEvent(theEvent);
        NSPoint pt = this.view.convertPoint_fromView_(nsEvent.locationInWindow(), null);
        int row = (int)widget.rowAtPoint(pt);
        if (row != -1 && (nsEvent.modifierFlags() & 0xFFFF0000L) == 0L && nsEvent.clickCount() == 1L && widget.isRowSelected(row) && widget.selectedRowIndexes().count() == 1L && 0 <= row && row < this.itemCount) {
            this.sendSelection();
        }
        this.didSelect = false;
        super.mouseDownSuper(id2, sel, theEvent);
        this.didSelect = false;
    }

    @Override
    boolean needsPanelToBecomeKey(long id2, long sel) {
        return false;
    }

    @Override
    long numberOfRowsInTableView(long id2, long sel, long aTableView) {
        return this.itemCount;
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.column != null) {
            this.column.release();
        }
        this.column = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.items = null;
    }

    public void remove(int index) {
        this.checkWidget();
        if (0 > index || index >= this.itemCount) {
            this.error(6);
        }
        this.remove(index, true);
    }

    void remove(int index, boolean fixScroll) {
        if (index != this.itemCount - 1) {
            this.fixSelection(index, false);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        this.updateRowCount();
        if (fixScroll) {
            this.setScrollWidth();
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (0 > start || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int length = end - start + 1;
        for (int i = 0; i < length; ++i) {
            this.remove(start, false);
        }
        this.setScrollWidth();
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = this.getItemCount();
        if (0 > start || start > end || end >= count) {
            this.error(6);
        }
        int last = -1;
        for (int i = 0; i < newIndices.length; ++i) {
            int index = newIndices[i];
            if (index == last) continue;
            this.remove(index, false);
            last = index;
        }
        this.setScrollWidth();
    }

    public void removeAll() {
        this.checkWidget();
        this.items = new String[4];
        this.itemCount = 0;
        this.updateRowCount();
        this.setScrollWidth();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (0 <= index && index < this.itemCount) {
            NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
            set = set.initWithIndex(index);
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            widget.selectRowIndexes(set, (this.style & 2) != 0);
            this.ignoreSelect = false;
            set.release();
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.selectAll();
        } else {
            start = Math.max(0, start);
            end = Math.min(end, this.itemCount - 1);
            NSRange range = new NSRange();
            range.location = start;
            range.length = end - start + 1;
            NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
            set = set.initWithIndexesInRange(range);
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            widget.selectRowIndexes(set, (this.style & 2) != 0);
            this.ignoreSelect = false;
            set.release();
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int count = 0;
        NSMutableIndexSet set = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i = 0; i < length; ++i) {
            int index = indices[i];
            if (index < 0 || index >= this.itemCount) continue;
            set.addIndex(indices[i]);
            ++count;
        }
        if (count > 0) {
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            widget.selectRowIndexes(set, (this.style & 2) != 0);
            this.ignoreSelect = false;
        }
        set.release();
    }

    void select(int[] indices, int count, boolean clear) {
        NSMutableIndexSet set = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i = 0; i < count; ++i) {
            set.addIndex(indices[i]);
        }
        NSTableView widget = (NSTableView)this.view;
        this.ignoreSelect = true;
        widget.selectRowIndexes(set, !clear);
        this.ignoreSelect = false;
        set.release();
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        NSTableView widget = (NSTableView)this.view;
        this.ignoreSelect = true;
        widget.selectAll(null);
        this.ignoreSelect = false;
    }

    @Override
    void sendDoubleSelection() {
        if (((NSTableView)this.view).clickedRow() != -1L) {
            this.sendSelectionEvent(14);
        }
    }

    @Override
    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        boolean result = super.sendKeyEvent(nsEvent, type);
        if (!result) {
            return result;
        }
        if (type != 1) {
            return result;
        }
        short keyCode = nsEvent.keyCode();
        switch (keyCode) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
            }
        }
        return result;
    }

    @Override
    boolean sendMouseEvent(NSEvent nsEvent, int type, boolean send) {
        boolean handleMouseDown = true;
        if (nsEvent != null) {
            long nsType = nsEvent.type();
            boolean bl = handleMouseDown = nsType == 1L || nsType == 2L;
        }
        if (handleMouseDown) {
            if (type == 3) {
                this.mouseIsDown = true;
            } else if (type == 4 || type == 29) {
                this.mouseIsDown = false;
                if (this.rowsChanged) {
                    this.rowsChanged = false;
                    ((NSTableView)this.view).noteNumberOfRowsChanged();
                }
            }
        }
        return super.sendMouseEvent(nsEvent, type, send);
    }

    @Override
    void sendSelection() {
        if (this.ignoreSelect) {
            return;
        }
        this.sendSelectionEvent(13);
    }

    @Override
    void setBackgroundColor(NSColor nsColor) {
        ((NSTableView)this.view).setBackgroundColor(nsColor);
    }

    @Override
    void setFont(NSFont font) {
        super.setFont(font);
        double ascent = font.ascender();
        double descent = -font.descender() + font.leading();
        ((NSTableView)this.view).setRowHeight((int)Math.ceil(ascent + descent) + 1);
        this.setScrollWidth();
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > index || index >= this.itemCount) {
            this.error(6);
        }
        this.items[index] = string;
        NSTableView tableView = (NSTableView)this.view;
        NSRect rect = tableView.rectOfRow(index);
        tableView.setNeedsDisplayInRect(rect);
        this.setScrollWidth(string);
    }

    public void setItems(String ... items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != null) continue;
            this.error(5);
        }
        this.items = new String[items.length];
        System.arraycopy(items, 0, this.items, 0, items.length);
        this.itemCount = items.length;
        ((NSTableView)this.view).reloadData();
        this.setScrollWidth();
    }

    boolean setScrollWidth(String item) {
        if ((this.style & 0x100) == 0) {
            return false;
        }
        NSCell cell = this.column.dataCell();
        Font font = this.font != null ? this.font : this.defaultFont();
        cell.setFont(font.handle);
        cell.setTitle(NSString.stringWith(item));
        NSSize size = cell.cellSize();
        double oldWidth = this.column.width();
        if (oldWidth < size.width) {
            this.column.setWidth(size.width);
            return true;
        }
        return false;
    }

    boolean setScrollWidth() {
        if ((this.style & 0x100) == 0) {
            return false;
        }
        if (this.items == null) {
            return false;
        }
        NSCell cell = this.column.dataCell();
        Font font = this.font != null ? this.font : this.defaultFont();
        cell.setFont(font.handle);
        double width = 0.0;
        for (int i = 0; i < this.itemCount; ++i) {
            cell.setTitle(NSString.stringWith(this.items[i]));
            NSSize size = cell.cellSize();
            width = Math.max(width, size.width);
        }
        this.column.setWidth(width);
        return true;
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        if (0 <= index && index < this.itemCount) {
            NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
            set = set.initWithIndex(index);
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            widget.selectRowIndexes(set, false);
            this.ignoreSelect = false;
            set.release();
            this.showIndex(index);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        NSRange range = new NSRange();
        range.location = start;
        range.length = end - start + 1;
        NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
        set = set.initWithIndexesInRange(range);
        NSTableView widget = (NSTableView)this.view;
        this.ignoreSelect = true;
        widget.selectRowIndexes(set, false);
        this.ignoreSelect = false;
        set.release();
        this.showIndex(end);
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] newIndices = new int[length];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            int index = indices[length - i - 1];
            if (index < 0 || index >= this.itemCount) continue;
            newIndices[count++] = index;
        }
        if (count > 0) {
            this.select(newIndices, count, true);
            this.showIndex(newIndices[0]);
        }
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int count = 0;
        int[] indices = new int[length];
        for (int i = 0; i < length; ++i) {
            int index;
            String string = items[length - i - 1];
            if ((this.style & 4) != 0) {
                index = this.indexOf(string, 0);
                if (index == -1) continue;
                count = 1;
                indices = new int[]{index};
                continue;
            }
            index = 0;
            while ((index = this.indexOf(string, index)) != -1) {
                if (count == indices.length) {
                    int[] newIds = new int[indices.length + 4];
                    System.arraycopy(indices, 0, newIds, 0, indices.length);
                    indices = newIds;
                }
                indices[count++] = index++;
            }
        }
        if (count > 0) {
            this.select(indices, count, true);
            this.showIndex(indices[0]);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        int row = Math.max(0, Math.min(index, this.itemCount));
        NSPoint pt = new NSPoint();
        pt.x = this.scrollView.contentView().bounds().x;
        pt.y = widget.frameOfCellAtColumn((long)0L, (long)((long)row)).y;
        this.view.scrollPoint(pt);
    }

    void showIndex(int index) {
        if (0 <= index && index < this.itemCount) {
            ((NSTableView)this.view).scrollRowToVisible(index);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index >= 0) {
            this.showIndex(index);
        }
    }

    @Override
    void tableViewSelectionDidChange(long id2, long sel, long aNotification) {
        if (this.didSelect) {
            return;
        }
        this.sendSelection();
    }

    @Override
    void tableViewSelectionIsChanging(long id2, long sel, long aNotification) {
        this.didSelect = true;
        this.sendSelection();
    }

    @Override
    long tableView_objectValueForTableColumn_row(long id2, long sel, long aTableView, long aTableColumn, long rowIndex) {
        double[] fg = ((NSTableView)this.view).isRowSelected(rowIndex) ? null : this.foreground;
        NSAttributedString attribStr = this.createString(this.items[(int)rowIndex], null, fg, 16384, false, this.getEnabled(), false);
        attribStr.autorelease();
        return attribStr.id;
    }

    long tableView_selectionIndexesForProposedSelection(long id2, long sel, long aTableView, long indexSet) {
        if ((this.style & 4) != 0) {
            NSIndexSet indexes = new NSIndexSet(indexSet);
            NSTableView table = new NSTableView(aTableView);
            if (indexes.count() != 1L && table.selectedRow() != -1L) {
                NSIndexSet newSelection = (NSIndexSet)new NSIndexSet().alloc();
                newSelection = newSelection.initWithIndex(table.selectedRow());
                newSelection.autorelease();
                return newSelection.id;
            }
        }
        return indexSet;
    }

    void updateRowCount() {
        if (this.mouseIsDown) {
            this.rowsChanged = true;
        } else {
            NSTableView widget = (NSTableView)this.view;
            this.setRedraw(false);
            this.ignoreSelect = true;
            widget.noteNumberOfRowsChanged();
            this.ignoreSelect = false;
            widget.tile();
            this.setRedraw(true);
        }
    }
}

