## 0.30.8

### Added

- `ActivationToken::from_raw` and `ActivationToken::into_raw`.
- On X11, add a workaround for disabling IME on GNOME.

### Fixed

- On Windows, fixed the event loop not waking on accessibility requests.
- On X11, fixed cursor grab mode state tracking on error.

## 0.30.7

### Fixed

- On X11, fixed KeyboardInput delivered twice when IME enabled.

## 0.30.6

### Added

- On macOS, add `WindowExtMacOS::set_borderless_game` and `WindowAttributesExtMacOS::with_borderless_game`
  to fully disable the menu bar and dock in Borderless Fullscreen as commonly done in games.
- On X11, the `window` example now understands the `X11_VISUAL_ID` and `X11_SCREEN_ID` env
  variables to test the respective modifiers of window creation.
- On Android, the soft keyboard can now be shown using `Window::set_ime_allowed`.
- Add basic iOS IME support. The soft keyboard can now be shown using `Window::set_ime_allowed`.

### Fixed

- On macOS, fix `WindowEvent::Moved` sometimes being triggered unnecessarily on resize.
- On macOS, package manifest definitions of `LSUIElement` will no longer be overridden with the
  default activation policy, unless explicitly provided during initialization.
- On macOS, fix crash when calling `drag_window()` without a left click present.
- On X11, key events forward to IME anyway, even when it's disabled.
- On Windows, make `ControlFlow::WaitUntil` work more precisely using `CREATE_WAITABLE_TIMER_HIGH_RESOLUTION`.
- On X11, creating windows on screen that is not the first one (e.g. `DISPLAY=:0.1`) works again.
- On X11, creating windows while passing `with_x11_screen(non_default_screen)` works again.
- On X11, fix XInput handling that prevented a new window from getting the focus in some cases.
- On macOS, fix crash when pressing Caps Lock in certain configurations.
- On iOS, fixed `MonitorHandle`'s `PartialEq` and `Hash` implementations.
- On macOS, fixed undocumented cursors (e.g. zoom, resize, help) always appearing to be invalid and falling back to the default cursor.

## 0.30.5

### Added

- Add `ActiveEventLoop::system_theme()`, returning the current system theme.
- On Web, implement `Error` for `platform::web::CustomCursorError`.
- On Android, add `{Active,}EventLoopExtAndroid::android_app()` to access the app used to create the loop.

### Fixed

- On MacOS, fix building with `feature = "rwh_04"`.
- On Web, pen events are now routed through to `WindowEvent::Cursor*`.
- On macOS, fix panic when releasing not available monitor.
- On MacOS, return the system theme in `Window::theme()` if no theme override is set.

## 0.30.4

### Changed

- `DeviceId::dummy()` and `WindowId::dummy()` are no longer marked `unsafe`.

### Fixed

- On Wayland, avoid crashing when compositor is misbehaving.
- On Web, fix `WindowEvent::Resized` not using `requestAnimationFrame` when sending
  `WindowEvent::RedrawRequested` and also potentially causing `WindowEvent::RedrawRequested`
  to not be de-duplicated.
- Account for different browser engine implementations of pointer movement coordinate space.

## 0.30.3

### Added

- On Web, add `EventLoopExtWebSys::(set_)poll_strategy()` to allow setting
  control flow strategies before starting the event loop.
- On Web, add `WaitUntilStrategy`, which allows to set different strategies for
  `ControlFlow::WaitUntil`. By default the Prioritized Task Scheduling API is
  used, with a fallback to `setTimeout()` with a trick to circumvent throttling
  to 4ms. But an option to use a Web worker to schedule the timer is available
  as well, which commonly prevents any throttling when the window is not focused.

### Changed

- On macOS, set the window theme on the `NSWindow` instead of application-wide.

### Fixed

- On X11, build on arm platforms.
- On macOS, fixed `WindowBuilder::with_theme` not having any effect on the window.

## 0.30.2

### Fixed

- On Web, fix `EventLoopProxy::send_event()` triggering event loop immediately
  when not called from inside the event loop. Now queues a microtask instead.
- On Web, stop overwriting default cursor with `CursorIcon::Default`.
- On Web, prevent crash when using `InnerSizeWriter::request_inner_size()`.
- On macOS, fix not working opacity for entire window.

## 0.30.1

### Added

- Reexport `raw-window-handle` versions 0.4 and 0.5 as `raw_window_handle_04` and `raw_window_handle_05`.
- Implement `ApplicationHandler` for `&mut` references and heap allocations to something that implements `ApplicationHandler`.

### Fixed

- On macOS, fix panic on exit when dropping windows outside the event loop.
- On macOS, fix window dragging glitches when dragging across a monitor boundary with different scale factor.
- On macOS, fix the range in `Ime::Preedit`.
- On macOS, use the system's internal mechanisms for queuing events.
- On macOS, handle events directly instead of queuing when possible.

## 0.30.0

### Added

- Add `OwnedDisplayHandle` type for allowing safe display handle usage outside of
  trivial cases.
- Add `ApplicationHandler<T>` trait which mimics `Event<T>`.
- Add `WindowBuilder::with_cursor` and `Window::set_cursor` which takes a
  `CursorIcon` or `CustomCursor`.
- Add `Sync` implementation for `EventLoopProxy<T: Send>`.
- Add `Window::default_attributes` to get default `WindowAttributes`.
- Add `EventLoop::builder` to get `EventLoopBuilder` without export.
- Add `CustomCursor::from_rgba` to allow creating cursor images from RGBA data.
- Add `CustomCursorExtWebSys::from_url` to allow loading cursor images from URLs.
- Add `CustomCursorExtWebSys::from_animation` to allow creating animated
  cursors from other `CustomCursor`s.
- Add `{Active,}EventLoop::create_custom_cursor` to load custom cursor image sources.
- Add `ActiveEventLoop::create_window` and `EventLoop::create_window`.
- Add `CustomCursor` which could be set via `Window::set_cursor`, implemented on
  Windows, macOS, X11, Wayland, and Web.
- On Web, add to toggle calling `Event.preventDefault()` on `Window`.
- On iOS, add `PinchGesture`, `DoubleTapGesture`, `PanGesture` and `RotationGesture`.
- on iOS, use `UIGestureRecognizerDelegate` for fine grained control of gesture recognizers.
- On macOS, add services menu.
- On Windows, add `with_title_text_color`, and `with_corner_preference` on
  `WindowAttributesExtWindows`.
- On Windows, implement resize increments.
- On Windows, add `AnyThread` API to access window handle off the main thread.

### Changed

- Bump MSRV from `1.65` to `1.70`.
- On Wayland, bump `sctk-adwaita` to `0.9.0`, which changed system library
  crates. This change is a **cascading breaking change**, you must do breaking
  change as well, even if you don't expose winit.
- Rename `TouchpadMagnify` to `PinchGesture`.
- Rename `SmartMagnify` to `DoubleTapGesture`.
- Rename `TouchpadRotate` to `RotationGesture`.
- Rename `EventLoopWindowTarget` to `ActiveEventLoop`.
- Rename `platform::x11::XWindowType` to `platform::x11::WindowType`.
- Rename `VideoMode` to `VideoModeHandle` to represent that it doesn't hold
  static data.
- Make `Debug` formatting of `WindowId` more concise.
- Move `dpi` types to its own crate, and re-export it from the root crate.
- Replace `log` with `tracing`, use `log` feature on `tracing` to restore old
  behavior.
- `EventLoop::with_user_event` now returns `EventLoopBuilder`.
- On Web, return `HandleError::Unavailable` when a window handle is not available.
- On Web, return `RawWindowHandle::WebCanvas` instead of `RawWindowHandle::Web`.
- On Web, remove queuing fullscreen request in absence of transient activation.
- On iOS, return `HandleError::Unavailable` when a window handle is not available.
- On macOS, return `HandleError::Unavailable` when a window handle is not available.
- On Windows, remove `WS_CAPTION`, `WS_BORDER`, and `WS_EX_WINDOWEDGE` styles
  for child windows without decorations.
- On Android, bump `ndk` to `0.9.0` and `android-activity` to `0.6.0`,
  and remove unused direct dependency on `ndk-sys`.

### Deprecated

- Deprecate `EventLoop::run`, use `EventLoop::run_app`.
- Deprecate `EventLoopExtRunOnDemand::run_on_demand`, use `EventLoop::run_app_on_demand`.
- Deprecate `EventLoopExtPumpEvents::pump_events`, use `EventLoopExtPumpEvents::pump_app_events`.

  The new `app` APIs accept a newly added `ApplicationHandler<T>` instead of
  `Fn`. The semantics are mostly the same, given that the capture list of the
  closure is your new `State`. Consider the following code:

  ```rust,no_run
  use winit::event::Event;
  use winit::event_loop::EventLoop;
  use winit::window::Window;

  struct MyUserEvent;

  let event_loop = EventLoop::<MyUserEvent>::with_user_event().build().unwrap();
  let window = event_loop.create_window(Window::default_attributes()).unwrap();
  let mut counter = 0;

  let _ = event_loop.run(move |event, event_loop| {
      match event {
          Event::AboutToWait => {
              window.request_redraw();
              counter += 1;
          }
          Event::WindowEvent { window_id, event } => {
              // Handle window event.
          }
          Event::UserEvent(event) => {
              // Handle user event.
          }
          Event::DeviceEvent { device_id, event } => {
              // Handle device event.
          }
          _ => (),
      }
  });
  ```

  To migrate this code, you should move all the captured values into some
  newtype `State` and implement `ApplicationHandler` for this type. Finally,
  we move particular `match event` arms into methods on `ApplicationHandler`,
  for example:

  ```rust,no_run
  use winit::application::ApplicationHandler;
  use winit::event::{Event, WindowEvent, DeviceEvent, DeviceId};
  use winit::event_loop::{EventLoop, ActiveEventLoop};
  use winit::window::{Window, WindowId};

  struct MyUserEvent;

  struct State {
      window: Window,
      counter: i32,
  }

  impl ApplicationHandler<MyUserEvent> for State {
      fn user_event(&mut self, event_loop: &ActiveEventLoop, user_event: MyUserEvent) {
          // Handle user event.
      }

      fn resumed(&mut self, event_loop: &ActiveEventLoop) {
          // Your application got resumed.
      }

      fn window_event(&mut self, event_loop: &ActiveEventLoop, window_id: WindowId, event: WindowEvent) {
          // Handle window event.
      }

      fn device_event(&mut self, event_loop: &ActiveEventLoop, device_id: DeviceId, event: DeviceEvent) {
          // Handle device event.
      }

      fn about_to_wait(&mut self, event_loop: &ActiveEventLoop) {
          self.window.request_redraw();
          self.counter += 1;
      }
  }

  let event_loop = EventLoop::<MyUserEvent>::with_user_event().build().unwrap();
  #[allow(deprecated)]
  let window = event_loop.create_window(Window::default_attributes()).unwrap();
  let mut state = State { window, counter: 0 };

  let _ = event_loop.run_app(&mut state);
  ```

  Please submit your feedback after migrating in [this issue](https://github.com/rust-windowing/winit/issues/3626).

- Deprecate `Window::set_cursor_icon`, use `Window::set_cursor`.

### Removed

- Remove `Window::new`, use `ActiveEventLoop::create_window` instead.

  You now have to create your windows inside the actively running event loop
  (usually the `new_events(cause: StartCause::Init)` or `resumed()` events),
  and can no longer do it before the application has properly launched.
  This change is done to fix many long-standing issues on iOS and macOS, and
  will improve things on Wayland once fully implemented.

  To ease migration, we provide the deprecated `EventLoop::create_window` that
  will allow you to bypass this restriction in this release.

  Using the migration example from above, you can change your code as follows:

  ```rust,no_run
  use winit::application::ApplicationHandler;
  use winit::event::{Event, WindowEvent, DeviceEvent, DeviceId};
  use winit::event_loop::{EventLoop, ActiveEventLoop};
  use winit::window::{Window, WindowId};

  #[derive(Default)]
  struct State {
      // Use an `Option` to allow the window to not be available until the
      // application is properly running.
      window: Option<Window>,
      counter: i32,
  }

  impl ApplicationHandler for State {
      // This is a common indicator that you can create a window.
      fn resumed(&mut self, event_loop: &ActiveEventLoop) {
          self.window = Some(event_loop.create_window(Window::default_attributes()).unwrap());
      }
      fn window_event(&mut self, event_loop: &ActiveEventLoop, window_id: WindowId, event: WindowEvent) {
          // `unwrap` is fine, the window will always be available when
          // receiving a window event.
          let window = self.window.as_ref().unwrap();
          // Handle window event.
      }
      fn device_event(&mut self, event_loop: &ActiveEventLoop, device_id: DeviceId, event: DeviceEvent) {
          // Handle window event.
      }
      fn about_to_wait(&mut self, event_loop: &ActiveEventLoop) {
          if let Some(window) = self.window.as_ref() {
              window.request_redraw();
              self.counter += 1;
          }
      }
  }

  let event_loop = EventLoop::new().unwrap();
  let mut state = State::default();
  let _ = event_loop.run_app(&mut state);
  ```

- Remove `Deref` implementation for `EventLoop` that gave `EventLoopWindowTarget`.
- Remove `WindowBuilder` in favor of `WindowAttributes`.
- Remove Generic parameter `T` from `ActiveEventLoop`.
- Remove `EventLoopBuilder::with_user_event`, use `EventLoop::with_user_event`.
- Remove Redundant `EventLoopError::AlreadyRunning`.
- Remove `WindowAttributes::fullscreen` and expose as field directly.
- On X11, remove `platform::x11::XNotSupported` export.

### Fixed

- On Web, fix setting cursor icon overriding cursor visibility.
- On Windows, fix cursor not confined to center of window when grabbed and hidden.
- On macOS, fix sequence of mouse events being out of order when dragging on the trackpad.
- On Wayland, fix decoration glitch on close with some compositors.
- On Android, fix a regression introduced in #2748 to allow volume key events to be received again.
- On Windows, don't return a valid window handle outside of the GUI thread.
- On macOS, don't set the background color when initializing a window with transparency.
