/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench;

import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.directory.jxplorer.JXConfig;
import com.pegacat.jxworkbench.JXWBrowser;
import com.pegacat.jxworkbench.JXWMainMenu;
import com.pegacat.jxworkbench.JXWUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class JXWRegister
extends CBDialog {
    public JTextField email;
    public JTextField key;
    private JXWMainMenu jxwMainMenu;
    private JXWBrowser parentBrowser;
    private static Logger log = Logger.getLogger(JXWRegister.class.getName());

    public JXWRegister(JXWMainMenu jxwMainMenu, JXWBrowser owner) {
        super((Frame)((Object)owner), CBIntText.get((String)"Register JXWorkbench"), null);
        this.parentBrowser = owner;
        this.jxwMainMenu = jxwMainMenu;
        this.setBackground(Color.white);
        this.setSize(500, 380);
        this.setResizable(false);
        String bannerPath = Theme.getInstance().getDirTemplates() + "jxworkbench.png";
        ImageIcon banner = new ImageIcon(bannerPath);
        final JLabel productLogoLabel = new JLabel(banner);
        productLogoLabel.setBackground(Color.white);
        JTextPane advert = new JTextPane();
        advert.setSize(380, 140);
        advert.setBackground(Color.white);
        advert.setBorder(new EmptyBorder(new Insets(5, 10, 0, 10)));
        this.appendToPane(advert, "JXWorkbench is the commercial JXplorer bundle which includes:\n* enterprise grade directory reporting\n* csv import and export in a variety of formats\n* a secure password vault for storing directory credentials\n* powerful search & replace tools with regexp and attribute copying\n", Color.black);
        final JTextPane link = new JTextPane();
        link.setBackground(Color.white);
        this.appendToPane(link, "                 find out more at ", Color.black);
        this.appendToPane(link, "http://jxworkbench.com", Color.blue);
        advert.setEditable(false);
        link.setEditable(false);
        CBPanel separatorsInset = new CBPanel();
        separatorsInset.setBackground(Color.white);
        separatorsInset.setSize(300, 100);
        separatorsInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Register Licence Key:")));
        separatorsInset.addln((Component)new JLabel(CBIntText.get((String)"Licensed email") + ":"));
        this.email = new JTextField(JXConfig.getProperty((String)"licencedUser", (String)""), 30);
        separatorsInset.addWide((Component)this.email, 2);
        separatorsInset.newLine();
        separatorsInset.addln((Component)new JLabel(CBIntText.get((String)"License key") + ":"));
        this.key = new JTextField(8);
        separatorsInset.addWide((Component)this.key, 1);
        separatorsInset.add((Component)new JLabel(""));
        separatorsInset.newLine();
        this.addln(productLogoLabel);
        this.makeHeavy();
        this.addln(advert);
        this.addln(link);
        this.addln((Component)separatorsInset);
        this.pack();
        CBUtility.center((Component)((Object)this), (Component)((Object)owner));
        productLogoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CBUtility.setHandCursor((Component)productLogoLabel);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CBUtility.setNormalCursor((Component)productLogoLabel);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JXWRegister.this.showWebsite();
            }
        });
        link.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CBUtility.setHandCursor((Component)link);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CBUtility.setNormalCursor((Component)link);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JXWRegister.this.showWebsite();
            }
        });
    }

    public void showWebsite() {
        try {
            Desktop.getDesktop().browse(URI.create("http://www.jxworkbench.com"));
        }
        catch (IOException e) {
            log.severe("unable to open browser for jxworkbench website: " + e.getMessage());
        }
    }

    private void appendToPane(JTextPane tp, String msg, Color c) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
        aset = sc.addAttribute(aset, StyleConstants.FontFamily, "Lucida Console");
        aset = sc.addAttribute(aset, StyleConstants.Alignment, 3);
        int len = tp.getDocument().getLength();
        tp.setCaretPosition(len);
        tp.setCharacterAttributes(aset, false);
        tp.replaceSelection(msg);
    }

    public void doOK() {
        String licenceKey;
        String user = this.email.getText();
        if (JXWUtil.checkLicence(user, licenceKey = this.key.getText().trim())) {
            JXConfig.setProperty((String)"licencedUser", (String)user, (String)CBIntText.get((String)"this copy of JXW is licenced to this user or company"));
            JXConfig.setProperty((String)"licenceKey", (String)licenceKey, (String)CBIntText.get((String)"the JXW licence key"));
            JXConfig.writePropertyFile();
            JOptionPane.showMessageDialog((Component)((Object)this), CBIntText.get((String)"You have registered JXWorkBench.\nPlease restart JXplorer."), CBIntText.get((String)"Success!"), 1);
            this.parentBrowser.licenced = true;
            this.jxwMainMenu.setMenuStateToRegistered();
            this.jxwMainMenu.addWorkBenchMenu();
            this.quit();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), CBIntText.get((String)"Licence key invalid"), CBIntText.get((String)"Registration Failed"), 0);
        }
    }
}

