/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.Sequence;
import com.ca.commons.security.cert.extensions.V3Extension;

public class PolicyMappings
implements V3Extension {
    String value = null;

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for PolicyMappings");
        }
        for (int i = 0; i < asn1object.size(); ++i) {
            Sequence seq = (Sequence)asn1object.getComponent(i);
            for (int j = 0; j < seq.size(); ++j) {
                ASN1Object nextComp = seq.getComponent(j);
                String certPolicyID = nextComp.getValue().toString();
                if (j == 0) {
                    if (this.value == null) {
                        this.value = "Issuer Domain Policy: " + certPolicyID;
                        continue;
                    }
                    this.value = this.value + "\n" + "Issuer Domain Policy: " + certPolicyID;
                    continue;
                }
                if (j != 1) continue;
                this.value = this.value + "\n" + "Subject Domain Policy: " + certPolicyID;
            }
        }
    }

    public String toString() {
        return this.value;
    }
}

