/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.jndi;

import com.ca.commons.jndi.JXCallbackHandler;
import com.ca.commons.jndi.JndiAction;
import com.ca.commons.jndi.JndiSocketFactory;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXNamingEnumeration;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.Rdn;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class JNDIOps {
    public static final int NO_PAGING = -1;
    private static int pageSize = -1;
    private static final String DEFAULT_CTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private SearchControls existanceConstraints = new SearchControls();
    public static final String DEFAULT_REFERRAL_HANDLING = "ignore";
    public static final String DEFAULT_ALIAS_HANDLING = "finding";
    private NameParser nameParser;
    private LdapContext ctx = null;
    private static Logger log = Logger.getLogger(JNDIOps.class.getName());
    private static Properties nameParserSyntax = null;

    public static void setPageSize(int newSize) {
        pageSize = newSize;
    }

    public JNDIOps(LdapContext c) {
        this.existanceConstraints.setSearchScope(0);
        this.existanceConstraints.setCountLimit(0L);
        this.existanceConstraints.setTimeLimit(0);
        this.existanceConstraints.setReturningAttributes(new String[]{"1.1"});
        this.setContext(c);
    }

    public JNDIOps(Hashtable env) throws NamingException {
        this.existanceConstraints.setSearchScope(0);
        this.existanceConstraints.setCountLimit(0L);
        this.existanceConstraints.setTimeLimit(0);
        this.existanceConstraints.setReturningAttributes(new String[]{"1.1"});
        if (env.get("java.naming.security.authentication").equals("GSSAPI")) {
            this.setupKerberosContext(env);
        } else {
            this.setContext(JNDIOps.openContext(env));
        }
    }

    protected void setupKerberosContext(Hashtable env) throws NamingException {
        log.finest("dumping kerberos environment keys");
        Enumeration keys = env.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            log.finest(key + " : " + env.get(key));
        }
        LoginContext lc = null;
        try {
            lc = new LoginContext(JNDIOps.class.getName(), new JXCallbackHandler());
            lc.login();
        }
        catch (LoginException ex) {
            ex.printStackTrace();
            throw new NamingException("login problem: " + ex);
        }
        LdapContext newCtx = (LdapContext)Subject.doAs(lc.getSubject(), new JndiAction(env));
        if (newCtx == null) {
            throw new NamingException("a problem with GSSAPI occurred - couldn't create a GSSAPI directory context");
        }
        this.setContext(newCtx);
        if (this.ctx == null) {
            throw new NamingException("another problem with GSSAPI occurred");
        }
    }

    public JNDIOps(String url) throws NamingException {
        this.existanceConstraints.setSearchScope(0);
        this.existanceConstraints.setCountLimit(0L);
        this.existanceConstraints.setTimeLimit(0);
        this.existanceConstraints.setReturningAttributes(new String[]{"1.1"});
        Hashtable env = new Hashtable();
        JNDIOps.setupBasicProperties(env, url);
        this.setContext(JNDIOps.openContext(env));
    }

    public JNDIOps(String url, String userDN, char[] pwd) throws NamingException {
        this.existanceConstraints.setSearchScope(0);
        this.existanceConstraints.setCountLimit(0L);
        this.existanceConstraints.setTimeLimit(0);
        this.existanceConstraints.setReturningAttributes(new String[]{"1.1"});
        Hashtable env = new Hashtable();
        JNDIOps.setupBasicProperties(env, url);
        JNDIOps.setupSimpleSecurityProperties(env, userDN, pwd);
        this.setContext(JNDIOps.openContext(env));
    }

    public JNDIOps(String url, String cacerts, String clientcerts, char[] caKeystorePwd, char[] clientKeystorePwd, String caKeystoreType, String clientKeystoreType, boolean tracing, boolean sslTracing, String sslSocketFactory) throws NamingException {
        this.existanceConstraints.setSearchScope(0);
        this.existanceConstraints.setCountLimit(0L);
        this.existanceConstraints.setTimeLimit(0);
        this.existanceConstraints.setReturningAttributes(new String[]{"1.1"});
        Hashtable env = new Hashtable();
        JNDIOps.setupBasicProperties(env, url, tracing, DEFAULT_REFERRAL_HANDLING, DEFAULT_ALIAS_HANDLING);
        JNDIOps.setupSSLProperties(env, cacerts, clientcerts, caKeystorePwd, clientKeystorePwd, caKeystoreType, clientKeystoreType, sslTracing, sslSocketFactory);
        this.setContext(JNDIOps.openContext(env));
    }

    public static void setupBasicProperties(Hashtable env, String url) throws NamingException {
        JNDIOps.setupBasicProperties(env, url, false, DEFAULT_REFERRAL_HANDLING, DEFAULT_ALIAS_HANDLING);
    }

    public static String makeServerURL(String serverURL, String baseDN) {
        if (baseDN != null && baseDN.length() > 0) {
            if (serverURL.length() > 7 && serverURL.endsWith("/")) {
                serverURL = serverURL.substring(0, serverURL.length() - 1);
            }
            baseDN = baseDN.replaceAll("[%]", "%25");
            baseDN = baseDN.replaceAll(" ", "%20");
            baseDN = baseDN.replaceAll("[<]", "%3c");
            baseDN = baseDN.replaceAll("[>]", "%3e");
            baseDN = baseDN.replaceAll("[\"]", "%3f");
            baseDN = baseDN.replaceAll("[#]", "%23");
            baseDN = baseDN.replaceAll("[{]", "%7b");
            baseDN = baseDN.replaceAll("[}]", "%7d");
            baseDN = baseDN.replaceAll("[|]", "%7c");
            baseDN = baseDN.replaceAll("[\\\\]", "%5c");
            baseDN = baseDN.replaceAll("[\\^]", "%5e");
            baseDN = baseDN.replaceAll("[~]", "%7e");
            baseDN = baseDN.replaceAll("[\\[]", "%5b");
            baseDN = baseDN.replaceAll("[\\]]", "%5d");
            baseDN = baseDN.replaceAll("[']", "%27");
            baseDN = baseDN.replaceAll("[?]", "%3f");
            serverURL = serverURL + "/" + baseDN;
        }
        return serverURL;
    }

    public static void setupBasicProperties(Hashtable env, String url, boolean tracing, String referralType, String aliasType) throws NamingException {
        if (url == null) {
            throw new NamingException("URL not specified in openContext()!");
        }
        if (tracing) {
            env.put("com.sun.jndi.ldap.trace.ber", System.err);
        }
        env.put("java.naming.ldap.version", "3");
        if (env.get("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", DEFAULT_CTX);
        }
        env.put("java.naming.ldap.deleteRDN", "false");
        env.put("java.naming.referral", referralType);
        env.put("java.naming.ldap.attributes.binary", "photo jpegphoto jpegPhoto");
        env.put("java.naming.ldap.derefAliases", aliasType);
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.provider.url", url);
    }

    public static void setupSimpleSecurityProperties(Hashtable env, String userDN, char[] pwd) {
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", new String(pwd));
    }

    public static void setupSSLProperties(Hashtable env, String cacerts, String clientcerts, char[] caKeystorePwd, char[] clientKeystorePwd, String caKeystoreType, String clientKeystoreType, boolean tracing, boolean sslTracing, String sslSocketFactory) throws NamingException {
        JNDIOps.setupSSLProperties(env, cacerts, clientcerts, caKeystorePwd, clientKeystorePwd, caKeystoreType, clientKeystoreType, sslTracing, sslSocketFactory);
    }

    public static void setupSSLProperties(Hashtable env, String cacerts, String clientcerts, char[] caKeystorePwd, char[] clientKeystorePwd, String caKeystoreType, String clientKeystoreType, boolean sslTracing, String sslSocketFactory) throws NamingException {
        if (cacerts == null) {
            throw new NamingException("Cannot use SSL without a trusted CA certificates JKS file.");
        }
        env.put("java.naming.security.protocol", "ssl");
        if (sslSocketFactory.equals("com.ca.commons.jndi.JndiSocketFactory")) {
            JndiSocketFactory.init(cacerts, clientcerts, caKeystorePwd, clientKeystorePwd, caKeystoreType, clientKeystoreType);
        }
        env.put("java.naming.ldap.factory.socket", sslSocketFactory);
        if (clientcerts != null && clientKeystorePwd != null && clientKeystorePwd.length > 0) {
            env.put("java.naming.security.authentication", "EXTERNAL");
        }
        if (sslTracing) {
            System.setProperty("javax.net.debug", "ssl handshake verbose");
        }
    }

    public static LdapContext openContext(Hashtable env) throws NamingException {
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        if (ctx == null) {
            throw new NamingException("Internal Error with jndi connection: No Context was returned, however no exception was reported by jndi.");
        }
        return ctx;
    }

    public void renameEntry(Name oldDN, Name newDN) throws NamingException {
        Name rdn = newDN.getSuffix(newDN.size() - 1);
        Name oldRdn = oldDN.getSuffix(oldDN.size() - 1);
        if (!oldRdn.toString().equals(rdn.toString())) {
            this.ctx.rename(oldDN, rdn);
        } else {
            log.fine("EXPERIMENTAL: ATTEMPTING FULL RENAME: " + oldDN + " to " + newDN);
            this.ctx.rename(oldDN, newDN);
        }
    }

    public void copyEntry(Name fromDN, Name toDN) throws NamingException {
        Attributes originalAtts = this.read(fromDN);
        if (!fromDN.get(fromDN.size() - 1).equals(toDN.get(toDN.size() - 1))) {
            try {
                LdapName to = new LdapName(toDN.toString());
                Rdn rdn = to.getRdn(to.size() - 1);
                DXAttributes rdnAtts = new DXAttributes(rdn.toAttributes());
                for (DXAttribute att : rdnAtts) {
                    for (Object value : att.getValues()) {
                        if (originalAtts.get(att.getID()) != null) {
                            if (originalAtts.get(att.getID()).contains(value)) continue;
                            Attribute original = originalAtts.get(att.getID());
                            original.add(value);
                            continue;
                        }
                        originalAtts.put(att);
                    }
                }
            }
            catch (Exception e) {
                log.severe("unexpected error trying to add naming att/val to entry: " + e.getMessage());
            }
        }
        this.addEntry(toDN, originalAtts);
    }

    public void addEntry(Name dn, Attributes atts) throws NamingException {
        this.ctx.createSubcontext(dn, atts);
    }

    public void deleteEntry(Name dn) throws NamingException {
        this.ctx.destroySubcontext(dn);
    }

    public boolean exists(Name nodeDN) throws NamingException {
        try {
            this.ctx.search(nodeDN, "(objectclass=*)", this.existanceConstraints);
            return true;
        }
        catch (NoSuchAttributeException e) {
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
        catch (NullPointerException e) {
            if (this.ctx != null && this.ctx.getEnvironment().get("java.naming.factory.initial").toString().indexOf("dsml") > 0) {
                return false;
            }
            throw e;
        }
    }

    public boolean exists(String nodeDN) throws NamingException {
        try {
            this.ctx.search(nodeDN, "(objectclass=*)", this.existanceConstraints);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
        catch (NullPointerException e) {
            if (this.ctx != null && this.ctx.getEnvironment().get("java.naming.factory.initial").toString().indexOf("dsml") > 0) {
                return false;
            }
            throw e;
        }
    }

    public synchronized Attributes read(Name dn) throws NamingException {
        return this.read(dn, null);
    }

    public synchronized Attributes read(Name dn, String[] returnAttributes) throws NamingException {
        Attributes atts = this.ctx.getAttributes(dn, returnAttributes);
        return atts;
    }

    public void modifyAttributes(Name dn, int mod_type, Attributes attr) throws NamingException {
        this.ctx.modifyAttributes(dn, mod_type, attr);
    }

    public void modifyAttributes(Name dn, ModificationItem[] modList) throws NamingException {
        this.ctx.modifyAttributes(dn, modList);
    }

    public void updateEntry(Name dn, Attributes atts) throws NamingException {
        this.modifyAttributes(dn, 2, atts);
    }

    public void deleteAttribute(Name dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 3, (Attributes)atts);
    }

    public void deleteAttributes(Name dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 3, a);
    }

    public void updateAttribute(Name dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 2, (Attributes)atts);
    }

    public void updateAttributes(Name dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 2, a);
    }

    public void addAttribute(Name dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 1, (Attributes)atts);
    }

    public void addAttributes(Name dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 1, a);
    }

    public NamingEnumeration list(Name Searchbase) throws NamingException {
        return this.rawSearchOneLevel(Searchbase, "(objectclass=*)", 0, 0, new String[]{"objectclass"});
    }

    public NamingEnumeration searchOneLevel(String searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.searchOneLevel(searchbase, filter, limit, timeout, new String[]{"1.1"});
    }

    public NamingEnumeration searchOneLevel(String searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchOneLevel(this.nameParser.parse(searchbase), filter, limit, timeout, returnAttributes);
    }

    public NamingEnumeration searchOneLevel(Name searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.rawSearchOneLevel(searchbase, filter, limit, timeout, new String[]{"1.1"});
    }

    public NamingEnumeration searchOneLevel(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchOneLevel(searchbase, filter, limit, timeout, returnAttributes);
    }

    protected NamingEnumeration rawSearchOneLevel(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearch(searchbase, filter, limit, timeout, returnAttributes, 1);
    }

    public NamingEnumeration searchSubTree(Name searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.searchSubTree(searchbase, filter, limit, timeout, new String[]{"1.1"});
    }

    public NamingEnumeration searchSubTree(String searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.searchSubTree(searchbase, filter, limit, timeout, new String[]{"1.1"});
    }

    public NamingEnumeration searchSubTree(String searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchSubTree(this.nameParser.parse(searchbase), filter, limit, timeout, returnAttributes);
    }

    public NamingEnumeration searchSubTree(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchSubTree(searchbase, filter, limit, timeout, returnAttributes);
    }

    protected NamingEnumeration rawSearchSubTree(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        if (returnAttributes != null && returnAttributes.length == 0) {
            returnAttributes = new String[]{"objectClass"};
        }
        return this.rawSearch(searchbase, filter, limit, timeout, returnAttributes, 2);
    }

    public NamingEnumeration searchBaseEntry(Name searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.rawSearchBaseEntry(searchbase, filter, limit, timeout, new String[]{"objectClass"});
    }

    public NamingEnumeration searchBaseEntry(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchBaseEntry(searchbase, filter, limit, timeout, returnAttributes);
    }

    protected NamingEnumeration rawSearchBaseEntry(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        if (returnAttributes != null && returnAttributes.length == 0) {
            returnAttributes = new String[]{"objectClass"};
        }
        return this.rawSearch(searchbase, filter, limit, timeout, returnAttributes, 0);
    }

    protected NamingEnumeration rawSearch(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes, int scope) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(scope);
        constraints.setCountLimit(limit);
        constraints.setTimeLimit(timeout);
        constraints.setReturningAttributes(returnAttributes);
        try {
            if (pageSize >= 0) {
                try {
                    byte[] cookie;
                    this.ctx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, false)});
                    DXNamingEnumeration result = new DXNamingEnumeration();
                    do {
                        NamingEnumeration<SearchResult> pageResult = this.ctx.search(searchbase, filter, constraints);
                        while (pageResult.hasMoreElements()) {
                            result.add(pageResult.next());
                        }
                        cookie = this.getPagingCookie(this.ctx.getResponseControls());
                        this.ctx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true)});
                        log.fine("*** PAGING TOTAL SO FAR: " + result.size());
                    } while (cookie != null);
                    this.ctx.setRequestControls(null);
                    return result;
                }
                catch (IOException e) {
                    this.ctx.setRequestControls(null);
                    throw new NamingException("unexpected error creating page request controls: " + e.getMessage());
                }
            }
            NamingEnumeration<SearchResult> result = this.ctx.search(searchbase, filter, constraints);
            return result;
        }
        catch (NamingException e) {
            log.warning("error in rawSearch with filter: " + filter + " from base: " + searchbase + " => " + e.getMessage());
            throw e;
        }
    }

    private byte[] getPagingCookie(Control[] controls) {
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl pagedResponse = (PagedResultsResponseControl)controls[i];
                int total = pagedResponse.getResultSize();
                if (total != 0) {
                    log.fine("***************** END-OF-PAGE (read : " + total + ") *****************\n");
                } else {
                    log.fine("***************** END-OF-PAGE (total: unknown) ***************\n");
                }
                byte[] cookie = pagedResponse.getCookie();
                return cookie;
            }
        } else {
            log.fine("No paged result control was sent from the server");
        }
        return null;
    }

    public NamingEnumeration searchBaseEntry(String searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.rawSearchBaseEntry(this.nameParser.parse(searchbase), filter, limit, timeout, new String[]{"objectClass"});
    }

    public NamingEnumeration searchBaseEntry(String searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchBaseEntry(this.nameParser.parse(searchbase), filter, limit, timeout, returnAttributes);
    }

    public void renameEntry(Name OldDN, Name NewDN, boolean deleteOldRDN) throws NamingException {
        String value = deleteOldRDN ? "true" : "false";
        try {
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", value);
            this.renameEntry(OldDN, NewDN);
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        }
        catch (NamingException e) {
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
            throw e;
        }
    }

    public void renameEntry(String oldDN, String newDN) throws NamingException {
        this.ctx.rename(oldDN, newDN);
    }

    public void copyEntry(String fromDN, String toDN) throws NamingException {
        this.addEntry(toDN, this.read(fromDN));
    }

    public void addEntry(String dn, Attributes atts) throws NamingException {
        this.ctx.createSubcontext(dn, atts);
    }

    public void deleteEntry(String dn) throws NamingException {
        this.ctx.destroySubcontext(dn);
    }

    public synchronized Attributes read(String dn) throws NamingException {
        return this.read(dn, null);
    }

    public synchronized Attributes read(String dn, String[] returnAttributes) throws NamingException {
        return this.ctx.getAttributes(dn, returnAttributes);
    }

    public void modifyAttributes(String dn, int mod_type, Attributes attr) throws NamingException {
        this.ctx.modifyAttributes(dn, mod_type, attr);
    }

    public void modifyAttributes(String dn, ModificationItem[] modList) throws NamingException {
        this.ctx.modifyAttributes(dn, modList);
    }

    public void updateEntry(String dn, Attributes atts) throws NamingException {
        this.modifyAttributes(dn, 2, atts);
    }

    public void deleteAttribute(String dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 3, (Attributes)atts);
    }

    public void deleteAttributes(String dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 3, a);
    }

    public void updateAttribute(String dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 2, (Attributes)atts);
    }

    public void updateAttributes(String dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 2, a);
    }

    public void addAttribute(String dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 1, (Attributes)atts);
    }

    public void addAttributes(String dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 1, a);
    }

    public NamingEnumeration list(String searchbase) throws NamingException {
        return this.rawSearchOneLevel(this.nameParser.parse(searchbase), "(objectclass=*)", 0, 0, new String[]{"1.1"});
    }

    public void close() throws NamingException {
        if (this.ctx == null) {
            return;
        }
        this.nameParser = null;
        this.ctx.close();
    }

    public void renameEntry(String OldDN, String NewDN, boolean deleteOldRDN) throws NamingException {
        String value = deleteOldRDN ? "true" : "false";
        try {
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", value);
            this.renameEntry(OldDN, NewDN);
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        }
        catch (NamingException e) {
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
            throw e;
        }
    }

    private static void setupLDAPSyntax() {
        nameParserSyntax = new Properties();
        nameParserSyntax.put("jndi.syntax.direction", "right_to_left");
        nameParserSyntax.put("jndi.syntax.separator", ",");
        nameParserSyntax.put("jndi.syntax.escape", "\\");
        nameParserSyntax.put("jndi.syntax.trimblanks", "true");
        nameParserSyntax.put("jndi.syntax.separator.typeval", "=");
    }

    public static Name getNameFromString(String iDN) throws NamingException {
        String DN2 = iDN;
        CompositeName CompositeFormDN = null;
        CompoundName CompoundFormDN = null;
        if (iDN.indexOf("ldap://") != -1 && (CompositeFormDN = new CompositeName(iDN)).size() != 0) {
            DN2 = CompositeFormDN.get(CompositeFormDN.size() - 1);
        }
        if (nameParserSyntax == null) {
            JNDIOps.setupLDAPSyntax();
        }
        CompoundFormDN = new CompoundName(DN2, nameParserSyntax);
        return CompoundFormDN;
    }

    public static Name getNameFromSearchResult(SearchResult iDirectoryEntry, Name iBaseDN) throws InvalidNameException, NamingException {
        String RDN2 = JNDIOps.applyJNDIRDNBugWorkAround(iDirectoryEntry.getName());
        Name JNDIRDN = JNDIOps.getNameFromString(RDN2);
        if (JNDIRDN != null) {
            if (iDirectoryEntry.isRelative()) {
                JNDIRDN.addAll(0, iBaseDN);
            }
        } else {
            JNDIRDN = (Name)iBaseDN.clone();
        }
        return JNDIRDN;
    }

    private static String applyJNDIRDNBugWorkAround(String iRDN) {
        int SlashPos = iRDN.lastIndexOf("\\\\");
        String ReturnString = SlashPos == iRDN.length() - 2 ? iRDN.substring(0, SlashPos) : iRDN;
        return ReturnString;
    }

    public LdapContext getContext() {
        return this.ctx;
    }

    public void setContext(LdapContext ctx) {
        this.ctx = ctx;
        try {
            this.nameParser = ctx.getNameParser("");
        }
        catch (NamingException e) {
            System.out.println("Error initialising name parser " + e);
        }
    }
}

