// Copyright 2019 Drone.IO Inc. All rights reserved.
// Use of this source code is governed by the Drone Non-Commercial License
// that can be found in the LICENSE file.

// +build !oss

package admission

import (
	"testing"

	"github.com/drone/drone/core"
	"github.com/drone/drone/mock"
	"github.com/golang/mock/gomock"
)

func TestCombineAdmit(t *testing.T) {
	user := &core.User{Login: "octocat"}
	err := Combine(
		Membership(nil, nil),
		Membership(nil, nil),
	).Admit(noContext, user)
	if err != nil {
		t.Error(err)
	}
}

func TestCombineAdmit_Error(t *testing.T) {
	controller := gomock.NewController(t)
	defer controller.Finish()

	user := &core.User{Login: "octocat"}

	orgs := mock.NewMockOrganizationService(controller)
	orgs.EXPECT().List(gomock.Any(), user).Return(nil, nil)

	service1 := Membership(orgs, nil)
	service2 := Membership(orgs, []string{"github"})
	err := Combine(service1, service2).Admit(noContext, user)
	if err != ErrMembership {
		t.Errorf("expect ErrMembership")
	}
}
