/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;

public final class SimpleStepExpression
extends SlashExpression {
    public SimpleStepExpression(Expression start, Expression step) {
        super(start, step);
        if (!(step instanceof AxisExpression)) {
            throw new IllegalArgumentException();
        }
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        ContextItemStaticInfo info2;
        Expression step2;
        Expression start2 = visitor.typeCheck(this.start, contextInfo);
        if (start2 != this.start) {
            this.setStartExpression(start2);
        }
        if ((step2 = visitor.typeCheck(this.step, info2 = new ContextItemStaticInfo(start2.getItemType(), false, this.start))) != this.step) {
            this.setStepExpression(step2);
        }
        if (!(this.step instanceof AxisExpression)) {
            SlashExpression se = new SlashExpression(this.start, this.step);
            ExpressionTool.copyLocationInfo(this, se);
            return se;
        }
        if (this.start instanceof ContextItemExpression && AxisInfo.isForwards[((AxisExpression)this.step).getAxis()]) {
            return this.step;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    public Expression copy() {
        return new SimpleStepExpression(this.start.copy(), this.step.copy());
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        NodeInfo origin = (NodeInfo)this.start.evaluateItem(context);
        if (origin == null) {
            return EmptyIterator.getInstance();
        }
        return ((AxisExpression)this.step).iterate(origin);
    }
}

