package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUisNodes invokes the uis.DescribeUisNodes API synchronously
// api document: https://help.aliyun.com/api/uis/describeuisnodes.html
func (client *Client) DescribeUisNodes(request *DescribeUisNodesRequest) (response *DescribeUisNodesResponse, err error) {
	response = CreateDescribeUisNodesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUisNodesWithChan invokes the uis.DescribeUisNodes API asynchronously
// api document: https://help.aliyun.com/api/uis/describeuisnodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUisNodesWithChan(request *DescribeUisNodesRequest) (<-chan *DescribeUisNodesResponse, <-chan error) {
	responseChan := make(chan *DescribeUisNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUisNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUisNodesWithCallback invokes the uis.DescribeUisNodes API asynchronously
// api document: https://help.aliyun.com/api/uis/describeuisnodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUisNodesWithCallback(request *DescribeUisNodesRequest, callback func(response *DescribeUisNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUisNodesResponse
		var err error
		defer close(result)
		response, err = client.DescribeUisNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUisNodesRequest is the request struct for api DescribeUisNodes
type DescribeUisNodesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	UisId                string           `position:"Query" name:"UisId"`
	Name                 string           `position:"Query" name:"Name"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	Status               string           `position:"Query" name:"Status"`
}

// DescribeUisNodesResponse is the response struct for api DescribeUisNodes
type DescribeUisNodesResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	TotalCount  int         `json:"TotalCount" xml:"TotalCount"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	UisNodeList UisNodeList `json:"UisNodeList" xml:"UisNodeList"`
}

// CreateDescribeUisNodesRequest creates a request to invoke DescribeUisNodes API
func CreateDescribeUisNodesRequest() (request *DescribeUisNodesRequest) {
	request = &DescribeUisNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DescribeUisNodes", "uis", "openAPI")
	return
}

// CreateDescribeUisNodesResponse creates a response to parse from DescribeUisNodes response
func CreateDescribeUisNodesResponse() (response *DescribeUisNodesResponse) {
	response = &DescribeUisNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
