package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUserInfoByUserId invokes the quickbi_public.QueryUserInfoByUserId API synchronously
func (client *Client) QueryUserInfoByUserId(request *QueryUserInfoByUserIdRequest) (response *QueryUserInfoByUserIdResponse, err error) {
	response = CreateQueryUserInfoByUserIdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUserInfoByUserIdWithChan invokes the quickbi_public.QueryUserInfoByUserId API asynchronously
func (client *Client) QueryUserInfoByUserIdWithChan(request *QueryUserInfoByUserIdRequest) (<-chan *QueryUserInfoByUserIdResponse, <-chan error) {
	responseChan := make(chan *QueryUserInfoByUserIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUserInfoByUserId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUserInfoByUserIdWithCallback invokes the quickbi_public.QueryUserInfoByUserId API asynchronously
func (client *Client) QueryUserInfoByUserIdWithCallback(request *QueryUserInfoByUserIdRequest, callback func(response *QueryUserInfoByUserIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUserInfoByUserIdResponse
		var err error
		defer close(result)
		response, err = client.QueryUserInfoByUserId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUserInfoByUserIdRequest is the request struct for api QueryUserInfoByUserId
type QueryUserInfoByUserIdRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	UserId      string `position:"Query" name:"UserId"`
}

// QueryUserInfoByUserIdResponse is the response struct for api QueryUserInfoByUserId
type QueryUserInfoByUserIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateQueryUserInfoByUserIdRequest creates a request to invoke QueryUserInfoByUserId API
func CreateQueryUserInfoByUserIdRequest() (request *QueryUserInfoByUserIdRequest) {
	request = &QueryUserInfoByUserIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-08-01", "QueryUserInfoByUserId", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryUserInfoByUserIdResponse creates a response to parse from QueryUserInfoByUserId response
func CreateQueryUserInfoByUserIdResponse() (response *QueryUserInfoByUserIdResponse) {
	response = &QueryUserInfoByUserIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
