package httpdns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccountInfo invokes the httpdns.GetAccountInfo API synchronously
func (client *Client) GetAccountInfo(request *GetAccountInfoRequest) (response *GetAccountInfoResponse, err error) {
	response = CreateGetAccountInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccountInfoWithChan invokes the httpdns.GetAccountInfo API asynchronously
func (client *Client) GetAccountInfoWithChan(request *GetAccountInfoRequest) (<-chan *GetAccountInfoResponse, <-chan error) {
	responseChan := make(chan *GetAccountInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccountInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccountInfoWithCallback invokes the httpdns.GetAccountInfo API asynchronously
func (client *Client) GetAccountInfoWithCallback(request *GetAccountInfoRequest, callback func(response *GetAccountInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccountInfoResponse
		var err error
		defer close(result)
		response, err = client.GetAccountInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccountInfoRequest is the request struct for api GetAccountInfo
type GetAccountInfoRequest struct {
	*requests.RpcRequest
}

// GetAccountInfoResponse is the response struct for api GetAccountInfo
type GetAccountInfoResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	AccountInfo AccountInfo `json:"AccountInfo" xml:"AccountInfo"`
}

// CreateGetAccountInfoRequest creates a request to invoke GetAccountInfo API
func CreateGetAccountInfoRequest() (request *GetAccountInfoRequest) {
	request = &GetAccountInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Httpdns", "2016-02-01", "GetAccountInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAccountInfoResponse creates a response to parse from GetAccountInfo response
func CreateGetAccountInfoResponse() (response *GetAccountInfoResponse) {
	response = &GetAccountInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
