package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLivePassword invokes the aliyuncvc.UpdateLivePassword API synchronously
func (client *Client) UpdateLivePassword(request *UpdateLivePasswordRequest) (response *UpdateLivePasswordResponse, err error) {
	response = CreateUpdateLivePasswordResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLivePasswordWithChan invokes the aliyuncvc.UpdateLivePassword API asynchronously
func (client *Client) UpdateLivePasswordWithChan(request *UpdateLivePasswordRequest) (<-chan *UpdateLivePasswordResponse, <-chan error) {
	responseChan := make(chan *UpdateLivePasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLivePassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLivePasswordWithCallback invokes the aliyuncvc.UpdateLivePassword API asynchronously
func (client *Client) UpdateLivePasswordWithCallback(request *UpdateLivePasswordRequest, callback func(response *UpdateLivePasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLivePasswordResponse
		var err error
		defer close(result)
		response, err = client.UpdateLivePassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLivePasswordRequest is the request struct for api UpdateLivePassword
type UpdateLivePasswordRequest struct {
	*requests.RpcRequest
	LiveUUID         string           `position:"Body" name:"LiveUUID"`
	UserId           string           `position:"Body" name:"UserId"`
	OpenPasswordFlag requests.Boolean `position:"Body" name:"OpenPasswordFlag"`
	Password         string           `position:"Body" name:"Password"`
}

// UpdateLivePasswordResponse is the response struct for api UpdateLivePassword
type UpdateLivePasswordResponse struct {
	*responses.BaseResponse
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLivePasswordRequest creates a request to invoke UpdateLivePassword API
func CreateUpdateLivePasswordRequest() (request *UpdateLivePasswordRequest) {
	request = &UpdateLivePasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "UpdateLivePassword", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLivePasswordResponse creates a response to parse from UpdateLivePassword response
func CreateUpdateLivePasswordResponse() (response *UpdateLivePasswordResponse) {
	response = &UpdateLivePasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
