/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_or extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "ଫିଜି";
        final String metaValue_NR = "ନାଉରୁ";
        final String metaValue_SO = "ସୋମାଲିଆ";
        final String metaValue_TO = "ଟୋଙ୍ଗା";
        final String metaValue_TK = "ଟୋକେଲାଉ";
        final String metaValue_TV = "ତୁଭାଲୁ";
        final String metaValue_ar = "ଆରବିକ୍";
        final String metaValue_ban = "ବାଲିନୀଜ୍";
        final String metaValue_zbl = "ବ୍ଲିସିମ୍ବଲସ୍";
        final String metaValue_ccp = "ଚକମା";
        final String metaValue_got = "ଗୋଥିକ୍";
        final String metaValue_el = "ଗ୍ରୀକ୍";
        final String metaValue_gu = "ଗୁଜରାଟୀ";
        final String metaValue_ko = "କୋରିଆନ୍";
        final String metaValue_lo = "ଲାଓ";
        final String metaValue_la = "ଲାଟିନ୍";
        final String metaValue_or = "ଓଡ଼ିଆ";
        final String metaValue_si = "ସିଂହଳ";
        final String metaValue_ta = "ତାମିଲ୍";
        final String metaValue_te = "ତେଲୁଗୁ";
        final String metaValue_th = "ଥାଇ";
        final Object[][] data = new Object[][] {
            { "001", "ବିଶ୍ୱ" },
            { "002", "ଆଫ୍ରିକା" },
            { "003", "ଉତ୍ତର ଆମେରିକା" },
            { "005", "ଦକ୍ଷିଣ ଆମେରିକା" },
            { "009", "ଓସିନିଆ" },
            { "011", "ପଶ୍ଚିମ ଆଫ୍ରିକା" },
            { "013", "ମଧ୍ୟ ଆମେରିକା" },
            { "014", "ପୂର୍ବ ଆଫ୍ରିକା" },
            { "015", "ଉତ୍ତର ଆଫ୍ରିକା" },
            { "017", "ମଧ୍ୟ ଆଫ୍ରିକା" },
            { "018", "ଦକ୍ଷିଣସ୍ଥ ଆଫ୍ରିକା" },
            { "019", "ଆମେରିକା" },
            { "021", "ଉତ୍ତରସ୍ଥ ଆମେରିକା" },
            { "029", "କାରିବିଆନ୍" },
            { "030", "ପୂର୍ବ ଏସିଆ" },
            { "034", "ଦକ୍ଷିଣ ଏସିଆ" },
            { "035", "ଦକ୍ଷିଣପୂର୍ବ ଏସିଆ" },
            { "039", "ଦକ୍ଷିଣ ୟୁରୋପ୍" },
            { "053", "ଅଷ୍ଟ୍ରେଲେସିଆ" },
            { "054", "ମେଲାନେସିଆ" },
            { "057", "ମାଇକ୍ରୋନେସିଆନ୍ ଅଞ୍ଚଳ" },
            { "061", "ପଲିନେସିଆ" },
            { "142", "ଏସିଆ" },
            { "143", "ମଧ୍ୟ ଏସିଆ" },
            { "145", "ପଶ୍ଚିମ ଏସିଆ" },
            { "150", "ୟୁରୋପ୍" },
            { "151", "ପୂର୍ବ ୟୁରୋପ୍" },
            { "154", "ଉତ୍ତର ୟୁରୋପ୍" },
            { "155", "ପଶ୍ଚିମ ୟୁରୋପ୍" },
            { "202", "ଉପ-ସାହାରା ଆଫ୍ରିକା" },
            { "419", "ଲାଟିନ୍‌ ଆମେରିକା" },
            { "AC", "ଆସେନସିଅନ୍‌ ଦ୍ୱୀପ" },
            { "AD", "ଆଣ୍ଡୋରା" },
            { "AE", "ସଂଯୁକ୍ତ ଆରବ ଏମିରେଟସ୍" },
            { "AF", "ଆଫଗାନିସ୍ତାନ୍" },
            { "AG", "ଆଣ୍ଟିଗୁଆ ଏବଂ ବାରବୁଦା" },
            { "AI", "ଆଙ୍ଗୁଇଲ୍ଲା" },
            { "AL", "ଆଲବାନିଆ" },
            { "AM", "ଆର୍ମେନିଆ" },
            { "AO", "ଆଙ୍ଗୋଲା" },
            { "AQ", "ଆଣ୍ଟାର୍କାଟିକା" },
            { "AR", "ଆର୍ଜେଣ୍ଟିନା" },
            { "AS", "ଆମେରିକାନ୍ ସାମୋଆ" },
            { "AT", "ଅଷ୍ଟ୍ରିଆ" },
            { "AU", "ଅଷ୍ଟ୍ରେଲିଆ" },
            { "AW", "ଆରୁବା" },
            { "AX", "ଅଲାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ" },
            { "AZ", "ଆଜେରବାଇଜାନ୍" },
            { "BA", "ବୋସନିଆ ଏବଂ ହର୍ଜଗୋଭିନା" },
            { "BB", "ବାରବାଡୋସ୍" },
            { "BD", "ବାଂଲାଦେଶ" },
            { "BE", "ବେଲଜିୟମ୍" },
            { "BF", "ବୁର୍କିନା ଫାସୋ" },
            { "BG", "ବୁଲଗେରିଆ" },
            { "BH", "ବାହାରିନ୍" },
            { "BI", "ବୁରୁଣ୍ଡି" },
            { "BJ", "ବେନିନ୍" },
            { "BL", "ସେଣ୍ଟ ବାର୍ଥେଲେମି" },
            { "BM", "ବର୍ମୁଡା" },
            { "BN", "ବ୍ରୁନେଇ" },
            { "BO", "ବୋଲିଭିଆ" },
            { "BQ", "କାରବିୟନ୍‌ ନେଦରଲ୍ୟାଣ୍ଡ" },
            { "BR", "ବ୍ରାଜିଲ୍" },
            { "BS", "ବାହାମାସ୍" },
            { "BT", "ଭୁଟାନ" },
            { "BV", "ବୌଭେଟ୍‌ ଦ୍ୱୀପ" },
            { "BW", "ବୋଟସ୍ୱାନା" },
            { "BY", "ବେଲାରୁଷ୍" },
            { "BZ", "ବେଲିଜ୍" },
            { "CA", "କାନାଡା" },
            { "CC", "କୋକୋସ୍ (କୀଲିଂ) ଦ୍ଵୀପପୁଞ୍ଜ" },
            { "CD", "କଙ୍ଗୋ (ଡିଆରସି)" },
            { "CF", "ମଧ୍ୟ ଆଫ୍ରିକୀୟ ସାଧାରଣତନ୍ତ୍ର" },
            { "CG", "କଙ୍ଗୋ-ବ୍ରାଜିଭିଲ୍ଲେ" },
            { "CH", "ସ୍ୱିଜରଲ୍ୟାଣ୍ଡ" },
            { "CI", "କୋତ୍ ଡି ଭ୍ଵାର୍" },
            { "CK", "କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "CL", "ଚିଲି" },
            { "CM", "କାମେରୁନ୍" },
            { "CN", "ଚୀନ୍‌" },
            { "CO", "କଲମ୍ବିଆ" },
            { "CP", "କ୍ଲିପରଟନ୍‌ ଦ୍ୱୀପ" },
            { "CR", "କୋଷ୍ଟା ରିକା" },
            { "CU", "କ‍୍ୟୁବା" },
            { "CV", "କେପ୍ ଭର୍ଦେ" },
            { "CW", "କୁରାକାଓ" },
            { "CX", "ଖ୍ରୀଷ୍ଟମାସ ଦ୍ୱୀପ" },
            { "CY", "ସାଇପ୍ରସ୍" },
            { "CZ", "ଚେଚିଆ" },
            { "DE", "ଜର୍ମାନୀ" },
            { "DG", "ଡିଏଗୋ ଗାର୍ସିଆ" },
            { "DJ", "ଜିବୋଟି" },
            { "DK", "ଡେନମାର୍କ" },
            { "DM", "ଡୋମିନିକା" },
            { "DO", "ଡୋମିନିକାନ୍‌ ସାଧାରଣତନ୍ତ୍ର" },
            { "DZ", "ଆଲଜେରିଆ" },
            { "EA", "ସିଉଟା ଏବଂ ମେଲିଲା" },
            { "EC", "ଇକ୍ୱେଡର୍‌" },
            { "EE", "ଏସ୍ତୋନିଆ" },
            { "EG", "ଇଜିପ୍ଟ" },
            { "EH", "ପଶ୍ଚିମ ସାହାରା" },
            { "ER", "ଇରିଟ୍ରିୟା" },
            { "ES", "ସ୍ପେନ୍" },
            { "ET", "ଇଥିଓପିଆ" },
            { "EU", "ୟୁରୋପୀୟ ସଂଘ" },
            { "EZ", "ୟୁରୋକ୍ଷେତ୍ର" },
            { "FI", "ଫିନଲ୍ୟାଣ୍ଡ" },
            { "FJ", metaValue_FJ },
            { "FK", "ଫକ୍‌ଲ୍ୟାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ" },
            { "FM", "ମାଇକ୍ରୋନେସିଆ" },
            { "FO", "ଫାରୋଇ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "FR", "ଫ୍ରାନ୍ସ" },
            { "GA", "ଗାବୋନ୍" },
            { "GB", "ଯୁକ୍ତରାଜ୍ୟ" },
            { "GD", "ଗ୍ରେନାଡା" },
            { "GE", "ଜର୍ଜିଆ" },
            { "GF", "ଫ୍ରେଞ୍ଚ ଗୁଇନା" },
            { "GG", "ଗୁଏରନେସି" },
            { "GH", "ଘାନା" },
            { "GI", "ଜିବ୍ରାଲ୍ଟର୍" },
            { "GL", "ଗ୍ରୀନଲ୍ୟାଣ୍ଡ" },
            { "GM", "ଗାମ୍ବିଆ" },
            { "GN", "ଗୁଇନିଆ" },
            { "GP", "ଗୁଆଡେଲୋପ୍" },
            { "GQ", "ଇକ୍ବାଟୋରିଆଲ୍ ଗୁଇନିଆ" },
            { "GR", "ଗ୍ରୀସ୍" },
            { "GS", "ଦକ୍ଷିଣ ଜର୍ଜିଆ ଏବଂ ଦକ୍ଷିଣ ସାଣ୍ଡୱିଚ୍ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "GT", "ଗୁଏତମାଲା" },
            { "GU", "ଗୁଆମ୍" },
            { "GW", "ଗୁଇନିଆ-ବିସାଉ" },
            { "GY", "ଗୁଇନା" },
            { "HK", "ହଂ କଂ ଏସଏଆର୍‌ ଚାଇନା" },
            { "HM", "ହାର୍ଡ୍‌ ଏବଂ ମ୍ୟାକଡୋନାଲ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "HN", "ହୋଣ୍ଡୁରାସ୍‌" },
            { "HR", "କ୍ରୋଏସିଆ" },
            { "HT", "ହାଇତି" },
            { "HU", "ହଙ୍ଗେରୀ" },
            { "IC", "କେନେରୀ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "ID", "ଇଣ୍ଡୋନେସିଆ" },
            { "IE", "ଆୟରଲ୍ୟାଣ୍ଡ" },
            { "IL", "ଇସ୍ରାଏଲ୍" },
            { "IM", "ଆଇଲ୍‌ ଅଫ୍‌ ମ୍ୟାନ୍‌" },
            { "IN", "ଭାରତ" },
            { "IO", "ବ୍ରିଟିଶ୍‌ ଭାରତୀୟ ମହାସାଗର କ୍ଷେତ୍ର" },
            { "IQ", "ଇରାକ୍" },
            { "IR", "ଇରାନ" },
            { "IS", "ଆଇସଲ୍ୟାଣ୍ଡ" },
            { "IT", "ଇଟାଲୀ" },
            { "JE", "ଜର୍ସି" },
            { "JM", "ଜାମାଇକା" },
            { "JO", "ଜୋର୍ଡାନ୍" },
            { "JP", "ଜାପାନ" },
            { "KE", "କେନିୟା" },
            { "KG", "କିର୍ଗିଜିସ୍ତାନ" },
            { "KH", "କାମ୍ବୋଡିଆ" },
            { "KI", "କିରିବାଟି" },
            { "KM", "କୋମୋରସ୍" },
            { "KN", "ସେଣ୍ଟ କିଟସ୍‌ ଏବଂ ନେଭିସ୍‌" },
            { "KP", "ଉତ୍ତର କୋରିଆ" },
            { "KR", "ଦକ୍ଷିଣ କୋରିଆ" },
            { "KW", "କୁଏତ୍" },
            { "KY", "କେମ୍ୟାନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "KZ", "କାଜାଖସ୍ତାନ୍‌" },
            { "LA", "ଲାଓସ୍" },
            { "LB", "ଲେବାନନ୍" },
            { "LC", "ସେଣ୍ଟ ଲୁସିଆ" },
            { "LI", "ଲିକ୍ଟନ୍‌ଷ୍ଟାଇନ୍‌" },
            { "LK", "ଶ୍ରୀଲଙ୍କା" },
            { "LR", "ଲାଇବେରିଆ" },
            { "LS", "ଲେସୋଥୋ" },
            { "LT", "ଲିଥୁଆନିଆ" },
            { "LU", "ଲକ୍ସେମବର୍ଗ" },
            { "LV", "ଲାଟଭିଆ" },
            { "LY", "ଲିବ୍ୟା" },
            { "MA", "ମୋରୋକ୍କୋ" },
            { "MC", "ମୋନାକୋ" },
            { "MD", "ମୋଲଡୋଭା" },
            { "ME", "ମଣ୍ଟେନିଗ୍ରୋ" },
            { "MF", "ସେଣ୍ଟ ମାର୍ଟିନ୍" },
            { "MG", "ମାଡାଗାସ୍କର୍" },
            { "MH", "ମାର୍ଶାଲ୍ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "MK", "ଉତ୍ତର ମାସେଡୋନିଆ" },
            { "ML", "ମାଲି" },
            { "MM", "ମିଆଁମାର" },
            { "MN", "ମଙ୍ଗୋଲିଆ" },
            { "MO", "ମାକାଉ ଏସଏଆର୍‌ ଚାଇନା" },
            { "MP", "ଉତ୍ତର ମାରିଆନା ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "MQ", "ମାର୍ଟିନିକ୍ୟୁ" },
            { "MR", "ମୌରିଟାନିଆ" },
            { "MS", "ମଣ୍ଟେସେରାଟ୍" },
            { "MT", "ମାଲ୍ଟା" },
            { "MU", "ମରିସସ" },
            { "MV", "ମାଲଦିଭସ୍‌" },
            { "MW", "ମାଲୱି" },
            { "MX", "ମେକ୍ସିକୋ" },
            { "MY", "ମାଲେସିଆ" },
            { "MZ", "ମୋଜାମ୍ବିକ୍‌" },
            { "NA", "ନାମିବିଆ" },
            { "NC", "ନୂତନ କାଲେଡୋନିଆ" },
            { "NE", "ନାଇଜର" },
            { "NF", "ନର୍ଫକ୍ ଦ୍ଵୀପ" },
            { "NG", "ନାଇଜେରିଆ" },
            { "NI", "ନିକାରାଗୁଆ" },
            { "NL", "ନେଦରଲ୍ୟାଣ୍ଡ" },
            { "NO", "ନରୱେ" },
            { "NP", "ନେପାଳ" },
            { "NR", metaValue_NR },
            { "NU", "ନିଉ" },
            { "NZ", "ନ୍ୟୁଜିଲାଣ୍ଡ" },
            { "OM", "ଓମାନ୍" },
            { "PA", "ପାନାମା" },
            { "PE", "ପେରୁ" },
            { "PF", "ଫ୍ରେଞ୍ଚ ପଲିନେସିଆ" },
            { "PG", "ପପୁଆ ନ୍ୟୁ ଗିନି" },
            { "PH", "ଫିଲିପାଇନସ୍" },
            { "PK", "ପାକିସ୍ତାନ" },
            { "PL", "ପୋଲାଣ୍ଡ" },
            { "PM", "ସେଣ୍ଟ ପିଏରେ ଏବଂ ମିକ୍ୱେଲନ୍‌" },
            { "PN", "ପିଟକାଇରିନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "PR", "ପୁଏର୍ତ୍ତୋ ରିକୋ" },
            { "PS", "ପାଲେଷ୍ଟେନିୟ ଭୂଭାଗ" },
            { "PT", "ପର୍ତ୍ତୁଗାଲ୍" },
            { "PW", "ପାଲାଉ" },
            { "PY", "ପାରାଗୁଏ" },
            { "QA", "କତାର୍" },
            { "QO", "ସୀମାନ୍ତବର୍ତ୍ତୀ ଓସିନିଆ" },
            { "RE", "ରିୟୁନିଅନ୍" },
            { "RO", "ରୋମାନିଆ" },
            { "RS", "ସର୍ବିଆ" },
            { "RU", "ରୁଷିଆ" },
            { "RW", "ରାୱାଣ୍ଡା" },
            { "SA", "ସାଉଦି ଆରବିଆ" },
            { "SB", "ସୋଲୋମନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "SC", "ସେଚେଲସ୍" },
            { "SD", "ସୁଦାନ" },
            { "SE", "ସ୍ୱିଡେନ୍‌" },
            { "SG", "ସିଙ୍ଗାପୁର୍" },
            { "SH", "ସେଣ୍ଟ ହେଲେନା" },
            { "SI", "ସ୍ଲୋଭେନିଆ" },
            { "SJ", "ସାଲବାର୍ଡ ଏବଂ ଜାନ୍‌ ମାୟେନ୍‌" },
            { "SK", "ସ୍ଲୋଭାକିଆ" },
            { "SL", "ସିଏରା ଲିଓନ" },
            { "SM", "ସାନ୍ ମାରିନୋ" },
            { "SN", "ସେନେଗାଲ୍" },
            { "SO", metaValue_SO },
            { "SR", "ସୁରିନାମ" },
            { "SS", "ଦକ୍ଷିଣ ସୁଦାନ" },
            { "ST", "ସାଓ ଟୋମେ ଏବଂ ପ୍ରିନସିପି" },
            { "SV", "ଏଲ୍ ସାଲଭାଡୋର୍" },
            { "SX", "ସିଣ୍ଟ ମାର୍ଟୀନ୍‌" },
            { "SY", "ସିରିଆ" },
            { "SZ", "ଇସ୍ୱାତିନୀ" },
            { "TA", "ଟ୍ରାଇଷ୍ଟନ୍‌ ଦା କୁନ୍‌ଚା" },
            { "TC", "ତୁର୍କସ୍‌ ଏବଂ କାଇକୋସ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "TD", "ଚାଦ୍" },
            { "TF", "ଫରାସୀ ଦକ୍ଷିଣ କ୍ଷେତ୍ର" },
            { "TG", "ଟୋଗୋ" },
            { "TH", "ଥାଇଲ୍ୟାଣ୍ଡ" },
            { "TJ", "ତାଜିକିସ୍ଥାନ୍" },
            { "TK", metaValue_TK },
            { "TL", "ତିମୋର୍-ଲେଷ୍ଟେ" },
            { "TM", "ତୁର୍କମେନିସ୍ତାନ" },
            { "TN", "ଟ୍ୟୁନିସିଆ" },
            { "TO", metaValue_TO },
            { "TR", "ତୁର୍କୀ" },
            { "TT", "ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ" },
            { "TV", metaValue_TV },
            { "TW", "ତାଇୱାନ" },
            { "TZ", "ତାଞ୍ଜାନିଆ" },
            { "UA", "ୟୁକ୍ରେନ୍" },
            { "UG", "ଉଗାଣ୍ଡା" },
            { "UM", "ଯୁକ୍ତରାଷ୍ଟ୍ର ଆଉଟ୍‌ଲାଇଙ୍ଗ ଦ୍ଵୀପପୁଞ୍ଜ" },
            { "UN", "ଜାତିସଂଘ" },
            { "US", "ଯୁକ୍ତ ରାଷ୍ଟ୍ର" },
            { "UY", "ଉରୁଗୁଏ" },
            { "UZ", "ଉଜବେକିସ୍ତାନ" },
            { "VA", "ଭାଟିକାନ୍ ସିଟି" },
            { "VC", "ସେଣ୍ଟ ଭିନସେଣ୍ଟ ଏବଂ ଗ୍ରେନାଡାଇନ୍ସ" },
            { "VE", "ଭେନେଜୁଏଲା" },
            { "VG", "ବ୍ରିଟିଶ୍‌ ଭର୍ଜିନ୍ ଦ୍ୱୀପପୁଞ୍ଜ" },
            { "VI", "ଯୁକ୍ତରାଷ୍ଟ୍ର ଭର୍ଜିନ୍ ଦ୍ଵୀପପୁଞ୍ଜ" },
            { "VN", "ଭିଏତନାମ୍" },
            { "VU", "ଭାନୁଆତୁ" },
            { "WF", "ୱାଲିସ୍ ଏବଂ ଫୁତୁନା" },
            { "WS", "ସାମୋଆ" },
            { "XA", "ସିୟୁଡୋ-ଏସେଣ୍ଟ" },
            { "XB", "ସିୟୁଡୋ-ବିଡି" },
            { "XK", "କୋସୋଭୋ" },
            { "YE", "ୟେମେନ୍" },
            { "YT", "ମାୟୋଟେ" },
            { "ZA", "ଦକ୍ଷିଣ ଆଫ୍ରିକା" },
            { "ZM", "ଜାମ୍ବିଆ" },
            { "ZW", "ଜିମ୍ବାୱେ" },
            { "ZZ", "ଅଜଣା ଅଞ୍ଚଳ" },
            { "aa", "ଅଫାର୍" },
            { "ab", "ଆବ୍ଖାଜିଆନ୍" },
            { "ae", "ଅବେସ୍ତନ" },
            { "af", "ଆଫ୍ରିକୀୟ" },
            { "ak", "ଅକନ୍" },
            { "am", "ଆମହାରକି" },
            { "an", "ଆର୍ଗୋନୀ" },
            { "ar", metaValue_ar },
            { "as", "ଆସାମୀୟ" },
            { "av", "ଆଭାରିକ୍" },
            { "ay", "ଆୟମାରା" },
            { "az", "ଆଜେରବାଇଜାନି" },
            { "ba", "ବାଶକିର୍" },
            { "be", "ବେଲାରୁଷିଆନ୍" },
            { "bg", "ବୁଲଗେରିଆନ୍" },
            { "bi", "ବିସଲାମା" },
            { "bm", "ବାମ୍ବାରା" },
            { "bn", "ବଙ୍ଗଳା" },
            { "bo", "ତିବ୍ବତୀୟ" },
            { "br", "ବ୍ରେଟନ୍" },
            { "bs", "ବୋସନିଆନ୍" },
            { "ca", "କାଟାଲାନ୍" },
            { "ce", "ଚେଚନ୍" },
            { "ch", "ଚାମୋରୋ" },
            { "co", "କୋର୍ସିକାନ୍" },
            { "cr", "କ୍ରୀ" },
            { "cs", "ଚେକ୍" },
            { "cu", "ଚର୍ଚ୍ଚ ସ୍ଲାଭିକ୍" },
            { "cv", "ଚୁଭାଶ୍" },
            { "cy", "ୱେଲ୍ସ" },
            { "da", "ଡାନିସ୍‌" },
            { "de", "ଜର୍ମାନ" },
            { "dv", "ଡିଭେହୀ" },
            { "dz", "ଦଡଜୋଙ୍ଗଖା" },
            { "ee", "ଇୱେ" },
            { "el", metaValue_el },
            { "en", "ଇଂରାଜୀ" },
            { "eo", "ଏସ୍ପାରେଣ୍ଟୋ" },
            { "es", "ସ୍ପାନିସ୍‌" },
            { "et", "ଏସ୍ତୋନିଆନ୍" },
            { "eu", "ବାସ୍କ୍ୱି" },
            { "fa", "ପର୍ସିଆନ୍" },
            { "ff", "ଫୁଲାହ" },
            { "fi", "ଫିନ୍ନିସ୍" },
            { "fj", metaValue_FJ },
            { "fo", "ଫାରୋଇଜ୍‌" },
            { "fr", "ଫରାସୀ" },
            { "fy", "ପାଶ୍ଚାତ୍ୟ ଫ୍ରିସିଆନ୍" },
            { "ga", "ଆଇରିସ୍‌" },
            { "gd", "ସ୍କଟିସ୍ ଗାଏଲିକ୍" },
            { "gl", "ଗାଲିସିଆନ୍‌" },
            { "gn", "ଗୁଆରାନୀ" },
            { "gu", metaValue_gu },
            { "gv", "ମାଁକ୍ସ" },
            { "ha", "ହୌସା" },
            { "he", "ହିବ୍ରୁ" },
            { "hi", "ହିନ୍ଦୀ" },
            { "ho", "ହିରି ମୋଟୁ" },
            { "hr", "କ୍ରୋଏସୀୟ" },
            { "ht", "ହୈତାୟିନ୍" },
            { "hu", "ହଙ୍ଗେରୀୟ" },
            { "hy", "ଆର୍ମେନିଆନ୍" },
            { "hz", "ହେରେରୋ" },
            { "ia", "ଇର୍ଣ୍ଟଲିଙ୍ଗୁଆ" },
            { "id", "ଇଣ୍ଡୋନେସୀୟ" },
            { "ie", "ଇର୍ଣ୍ଟରଲିଙ୍ଗୁଇ" },
            { "ig", "ଇଗବୋ" },
            { "ii", "ସିଚୁଆନ୍ ୟୀ" },
            { "ik", "ଇନୁପିୟାକ୍" },
            { "io", "ଇଡୋ" },
            { "is", "ଆଇସଲାଣ୍ଡିକ୍" },
            { "it", "ଇଟାଲୀୟ" },
            { "iu", "ଇନୁକଟିଟୁତ୍‌" },
            { "ja", "ଜାପାନୀ" },
            { "jv", "ଜାଭାନିଜ୍‌" },
            { "ka", "ଜର୍ଜିଆନ୍‌" },
            { "kg", "କଙ୍ଗୋ" },
            { "ki", "କୀକୁୟୁ" },
            { "kj", "କ୍ୱାନ୍ୟାମ୍" },
            { "kk", "କାଜାଖ୍‌" },
            { "kl", "କାଲାଲିସୁଟ୍" },
            { "km", "ଖାମେର୍" },
            { "kn", "କନ୍ନଡ" },
            { "ko", metaValue_ko },
            { "kr", "କନୁରୀ" },
            { "ks", "କାଶ୍ମିରୀ" },
            { "ku", "କୁର୍ଦ୍ଦିଶ୍" },
            { "kv", "କୋମି" },
            { "kw", "କୋର୍ନିସ୍" },
            { "ky", "କୀରଗୀଜ୍" },
            { "la", metaValue_la },
            { "lb", "ଲକ୍ସେମବର୍ଗିସ୍" },
            { "lg", "ଗନ୍ଦା" },
            { "li", "ଲିମ୍ବୁର୍ଗିସ୍" },
            { "ln", "ଲିଙ୍ଗାଲା" },
            { "lo", metaValue_lo },
            { "lt", "ଲିଥୁଆନିଆନ୍" },
            { "lu", "ଲ୍ୟୁବା-କାଟାଙ୍ଗା" },
            { "lv", "ଲାଟଭିଆନ୍" },
            { "mg", "ମାଲାଗାସୀ" },
            { "mh", "ମାର୍ଶାଲୀଜ୍" },
            { "mi", "ମାଓରୀ" },
            { "mk", "ମାସେଡୋନିଆନ୍" },
            { "ml", "ମାଲାୟଲମ୍" },
            { "mn", "ମଙ୍ଗୋଲୀୟ" },
            { "mr", "ମରାଠୀ" },
            { "ms", "ମାଲୟ" },
            { "mt", "ମାଲଟୀଜ୍" },
            { "my", "ବର୍ମୀଜ୍" },
            { "na", metaValue_NR },
            { "nb", "ନରୱେଜିଆନ୍ ବୋକମଲ୍" },
            { "nd", "ଉତ୍ତର ନେଡବେଲେ" },
            { "ne", "ନେପାଳୀ" },
            { "ng", "ଡୋଙ୍ଗା" },
            { "nl", "ଡଚ୍" },
            { "nn", "ନରୱେଜିଆନ୍ ନିନର୍ସ୍କ୍‌" },
            { "no", "ନରୱେଜିଆନ୍" },
            { "nr", "ଦକ୍ଷିଣ ନେଡବେଲେ" },
            { "nv", "ନାଭାଜୋ" },
            { "ny", "ନିୟାଞ୍ଜ" },
            { "oc", "ଓସିଟାନ୍" },
            { "oj", "ଓଜିୱା" },
            { "om", "ଓରୋମୋ" },
            { "or", metaValue_or },
            { "os", "ଓସେଟିକ୍" },
            { "pa", "ପଞ୍ଜାବୀ" },
            { "pi", "ପାଲି" },
            { "pl", "ପୋଲିଶ୍" },
            { "ps", "ପାସ୍ତୋ" },
            { "pt", "ପର୍ତ୍ତୁଗୀଜ୍‌" },
            { "qu", "କ୍ୱେଚୁଆ" },
            { "rm", "ରୋମାନଶ୍‌" },
            { "rn", "ରୁଣ୍ଡି" },
            { "ro", "ରୋମାନିଆନ୍" },
            { "ru", "ରୁଷିୟ" },
            { "rw", "କିନ୍ୟାରୱାଣ୍ଡା" },
            { "sa", "ସଂସ୍କୃତ" },
            { "sc", "ସାର୍ଡିନିଆନ୍‌" },
            { "sd", "ସିନ୍ଧୀ" },
            { "se", "ଉତ୍ତର ସାମି" },
            { "sg", "ସାଙ୍ଗୋ" },
            { "sh", "ସର୍ବୋ-କ୍ରୋଆଟିଆନ୍" },
            { "si", metaValue_si },
            { "sk", "ସ୍ଲୋଭାକ୍" },
            { "sl", "ସ୍ଲୋଭେନିଆନ୍" },
            { "sm", "ସାମୋଆନ୍" },
            { "sn", "ଶୋନା" },
            { "so", metaValue_SO },
            { "sq", "ଆଲବାନିଆନ୍" },
            { "sr", "ସର୍ବିୟ" },
            { "ss", "ସ୍ଵାତି" },
            { "st", "ସେସୋଥୋ" },
            { "su", "ସୁଦାନୀଜ୍" },
            { "sv", "ସ୍ୱେଡିସ୍" },
            { "sw", "ସ୍ୱାହିଲି" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ତାଜିକ୍" },
            { "th", metaValue_th },
            { "ti", "ଟାଇଗ୍ରିନିଆ" },
            { "tk", "ତୁର୍କମେନ୍" },
            { "tl", "ଟାଗାଲଗ୍" },
            { "tn", "ସୱାନା" },
            { "to", metaValue_TO },
            { "tr", "ତୁର୍କିସ୍" },
            { "ts", "ସୋଙ୍ଗା" },
            { "tt", "ତାତାର୍" },
            { "tw", "ତ୍ୱି" },
            { "ty", "ତାହିତିଆନ୍" },
            { "ug", "ୟୁଘୁର୍" },
            { "uk", "ୟୁକ୍ରେନିଆନ୍" },
            { "ur", "ଉର୍ଦ୍ଦୁ" },
            { "uz", "ଉଜବେକ୍" },
            { "ve", "ଭେଣ୍ଡା" },
            { "vi", "ଭିଏତନାମିଜ୍" },
            { "vo", "ବୋଲାପୁକ" },
            { "wa", "ୱାଲୁନ୍" },
            { "wo", "ୱୋଲଫ୍" },
            { "xh", "ଖୋସା" },
            { "yi", "ୟିଡିସ୍" },
            { "yo", "ୟୋରୁବା" },
            { "za", "ଜୁଆଙ୍ଗ୍‌" },
            { "zh", "ଚାଇନିଜ୍‌" },
            { "zu", "ଜୁଲୁ" },
            { "ace", "ଆଚାଇନୀଜ୍" },
            { "ach", "ଆକୋଲି" },
            { "ada", "ଆଦାଙ୍ଗେମ୍" },
            { "ady", "ଅଦ୍ୟଘେ" },
            { "afh", "ଆଫ୍ରିହିଲି" },
            { "agq", "ଆଘେମ" },
            { "ain", "ଆଇନୁ" },
            { "akk", "ଆକାଡିଆନ୍" },
            { "ale", "ଆଲେଇଟୁ" },
            { "alt", "ଦକ୍ଷିଣ ଆଲ୍ଟାଇ" },
            { "ang", "ପୁରୁଣା ଇଁରାଜୀ" },
            { "ann", "ଅବୋଲା" },
            { "anp", "ଅଁଗୀକା" },
            { "arc", "ଆରାମାଇକ୍" },
            { "arn", "ମାପୁଚେ" },
            { "arp", "ଆରାପାହୋ" },
            { "ars", "ନାଜଦି ଆରବିକ" },
            { "arw", "ଆରୱକ" },
            { "asa", "ଆସୁ" },
            { "ast", "ଆଷ୍ଟୁରିଆନ୍" },
            { "atj", "ଆଟିକାମେକ୍ୱ" },
            { "awa", "ଆୱାଧି" },
            { "bal", "ବାଲୁଚି" },
            { "ban", metaValue_ban },
            { "bas", "ବାସା" },
            { "bej", "ବେଜା" },
            { "bem", "ବେମ୍ବା" },
            { "bez", "ବେନା" },
            { "bgc", "ହରିୟାନଭି" },
            { "bho", "ଭୋଜପୁରୀ" },
            { "bik", "ବିକୋଲ୍" },
            { "bin", "ବିନି" },
            { "bla", "ସିକସିକା" },
            { "blo", "ବ୍ଲୋ" },
            { "bra", "ବ୍ରାଜ୍" },
            { "brx", "ବୋଡୋ" },
            { "bua", "ବୁରିଆଟ୍" },
            { "bug", "ବୁଗୀନୀଜ୍" },
            { "byn", "ବ୍ଲିନ୍" },
            { "cad", "କାଡୋ" },
            { "car", "କାରିବ୍" },
            { "cay", "କାୟୁଗା" },
            { "cch", "ଆତ୍ସମ୍" },
            { "ccp", metaValue_ccp },
            { "ceb", "ସୀବୁଆନୋ" },
            { "cgg", "ଚିଗା" },
            { "chb", "ଚିବ୍ଚା" },
            { "chg", "ଛଗତାଇ" },
            { "chk", "ଚୁକୀସେ" },
            { "chm", "ମାରୀ" },
            { "chn", "ଚିନୁକ୍ ଜାରଗାଁନ୍" },
            { "cho", "ଚୋଟୱା" },
            { "chp", "ଚିପେୱାନ୍" },
            { "chr", "ଚେରୋକୀ" },
            { "chy", "ଚେଚେନା" },
            { "ckb", "କେନ୍ଦ୍ରୀୟ କୁରଡିସ୍" },
            { "clc", "ଚିଲକୋଟିନ୍" },
            { "cop", "କପ୍ଟିକ୍" },
            { "crg", "ମିସିଫ" },
            { "crh", "କ୍ରୀମିନ୍ ତୁର୍କୀସ୍" },
            { "crj", "ସାଉଥ୍ ଇଷ୍ଟ କ୍ରି" },
            { "crk", "ପ୍ଲେନ୍ସ କ୍ରି" },
            { "crl", "ଉତ୍ତର ପୂର୍ବ କ୍ରୀ" },
            { "crm", "ମୁସେ କ୍ରୀ" },
            { "crr", "କାରୋଲିନା ଆଲଗୋନ୍କିଆନ୍" },
            { "crs", "ସେସେଲୱା କ୍ରେଓଲେ ଫ୍ରେଞ୍ଚ୍" },
            { "csb", "କାଶୁବିଆନ୍" },
            { "csw", "ସ୍ୱାମ୍ପି କ୍ରି" },
            { "dak", "ଡାକୋଟା" },
            { "dar", "ଡାରାଗ୍ୱା" },
            { "dav", "ତାଇତି" },
            { "del", "ଡେଲାୱେର୍" },
            { "den", "ସ୍ଲେଭ୍" },
            { "dgr", "ଡୋଗ୍ରିବ୍" },
            { "din", "ଦିଙ୍କା" },
            { "dje", "ଜର୍ମା" },
            { "doi", "ଡୋଗ୍ରୀ" },
            { "dsb", "ନିମ୍ନ ସର୍ବିଆନ୍‌" },
            { "dua", "ଡୁଆନା" },
            { "dum", "ମଧ୍ୟ ପର୍ତ୍ତୁଗାଲୀ" },
            { "dyo", "ଜୋଲା-ଫୋନୟି" },
            { "dyu", "ଡୁଆଲା" },
            { "dzg", "ଡାଜାଗା" },
            { "ebu", "ଏମ୍ଵୁ" },
            { "efi", "ଏଫିକ୍" },
            { "egy", "ପ୍ରାଚୀନ୍ ମିଶିରି" },
            { "eka", "ଏକାଜୁକ୍" },
            { "elx", "ଏଲାମାଇଟ୍" },
            { "enm", "ମଧ୍ୟ ଇଁରାଜୀ" },
            { "ewo", "ଇୱୋଣ୍ଡୋ" },
            { "fan", "ଫାଙ୍ଗ" },
            { "fat", "ଫାଣ୍ଟି" },
            { "fil", "ଫିଲିପିନୋ" },
            { "fon", "ଫନ୍" },
            { "frc", "କାଜୁନ୍ ଫରାସୀ" },
            { "frm", "ମଧ୍ୟ ଫ୍ରେଞ୍ଚ" },
            { "fro", "ପୁରୁଣା ଫ୍ରେଞ୍ଚ" },
            { "frr", "ଉତ୍ତର ଫ୍ରିସିୟାନ୍" },
            { "frs", "ପୂର୍ବ ଫ୍ରିସିୟାନ୍" },
            { "fur", "ଫ୍ରିୟୁଲୀୟାନ୍" },
            { "gaa", "ଗା" },
            { "gay", "ଗାୟୋ" },
            { "gba", "ଗବାୟା" },
            { "gez", "ଗୀଜ୍" },
            { "gil", "ଜିବ୍ରାଟୀଜ୍" },
            { "gmh", "ମିଡିଲ୍ ହାଇ ଜର୍ମାନ୍" },
            { "goh", "ପୁରୁଣା ହାଇ ଜର୍ମାନ୍" },
            { "gon", "ଗୋଣ୍ଡି" },
            { "gor", "ଗୋରୋଣ୍ଟାଲୋ" },
            { "got", metaValue_got },
            { "grb", "ଗ୍ରେବୋ" },
            { "grc", "ପ୍ରାଚୀନ୍ ୟୁନାନୀ" },
            { "gsw", "ସୁଇସ୍ ଜର୍ମାନ୍" },
            { "guz", "ଗୁସି" },
            { "gwi", "ଗୱିଚ’ଇନ୍" },
            { "hai", "ହାଇଡା" },
            { "haw", "ହାୱାଇନ୍" },
            { "hax", "ସାଉଥ୍ ହାଇଡା" },
            { "hil", "ହିଲିଗୈନନ୍" },
            { "hit", "ହିତୀତେ" },
            { "hmn", "ହଁଙ୍ଗ" },
            { "hsb", "ଉପର ସର୍ବିଆନ୍" },
            { "hup", "ହୁପା" },
            { "hur", "ହାଲକୋମେଲେମ" },
            { "iba", "ଇବାନ୍" },
            { "ibb", "ଇବିବିଓ" },
            { "ikt", "ପାଶ୍ଚାତ୍ୟ କାନାଡିୟ ଇନୁକ୍ଟିଟ" },
            { "ilo", "ଇଲୋକୋ" },
            { "inh", "ଇଁଙ୍ଗୁଶ୍" },
            { "jbo", "ଲୋଜବାନ୍" },
            { "jgo", "ନାଗୋମ୍ଵା" },
            { "jmc", "ମାଚେମେ" },
            { "jpr", "ଜୁଡେଓ-ପର୍ସିଆନ୍" },
            { "jrb", "ଜୁଡେଓ-ଆରବୀକ୍" },
            { "kaa", "କାରା-କଲ୍ପକ୍" },
            { "kab", "କବାଇଲ୍" },
            { "kac", "କଚିନ୍" },
            { "kaj", "ଜଜୁ" },
            { "kam", "କମ୍ବା" },
            { "kaw", "କାୱି" },
            { "kbd", "କାବାର୍ଡିଆନ୍" },
            { "kcg", "ତ୍ୟାପ୍" },
            { "kde", "ମାକୋଣ୍ଡେ" },
            { "kea", "କାବୁଭେରଡିଆନୁ" },
            { "kfo", "କୋରୋ" },
            { "kgp", "କାଇଙ୍ଗାଂ" },
            { "kha", "ଖାସୀ" },
            { "kho", "ଖୋତାନୀଜ୍" },
            { "khq", "କୋୟରା ଚିନି" },
            { "kkj", "କାକୋ" },
            { "kln", "କାଲେନଜିନ୍" },
            { "kmb", "କିମ୍ବୁଣ୍ଡୁ" },
            { "kok", "କୋଙ୍କଣି" },
            { "kos", "କୋସରୈନ୍" },
            { "kpe", "କୈପେଲେ" },
            { "krc", "କରାଚୟ-ବଲ୍କାର" },
            { "krl", "କାରେଲିୟାନ୍" },
            { "kru", "କୁରୁଖ" },
            { "ksb", "ଶାମବାଲା" },
            { "ksf", "ବାଫଲା" },
            { "ksh", "କୋଲୋବନିୟ" },
            { "kum", "କୁମୀକ୍" },
            { "kut", "କୁତେନାଉ" },
            { "kwk", "କ୍ଵାକୱାଲା" },
            { "kxv", "କୁୱି" },
            { "lad", "ଲାଦିନୋ" },
            { "lag", "ଲାନଗି" },
            { "lah", "ଲାହାଣ୍ଡା" },
            { "lam", "ଲାମ୍ବା" },
            { "lez", "ଲେଜଗିୟାନ୍" },
            { "lij", "ଲିଗୁରିଆନ୍‌" },
            { "lil", "ଲିଲ୍ଲୁଏଟ" },
            { "lkt", "ଲାକୋଟା" },
            { "lmo", "ଲୋମ୍ବାର୍ଡ୍‌" },
            { "lol", "ମଙ୍ଗୋ" },
            { "lou", "ଲୌସିଆନା କ୍ରେଓଲେ" },
            { "loz", "ଲୋଜି" },
            { "lrc", "ଉତ୍ତର ଲୁରି" },
            { "lsm", "ସାମିଆ" },
            { "lua", "ଲୁବା-ଲୁଲୁଆ" },
            { "lui", "ଲୁଇସେନୋ" },
            { "lun", "ଲୁଣ୍ଡା" },
            { "luo", "ଲୁଓ" },
            { "lus", "ମିଜୋ" },
            { "luy", "ଲୁୟିଆ" },
            { "mad", "ମାଦୁରୀସ୍" },
            { "mag", "ମାଗାହୀ" },
            { "mai", "ମୈଥିଳୀ" },
            { "mak", "ମକାସର୍" },
            { "man", "ମାଣ୍ଡିଙ୍ଗୋ" },
            { "mas", "ମାସାଇ" },
            { "mdf", "ମୋକ୍ଷ" },
            { "mdr", "ମନ୍ଦାର" },
            { "men", "ମେନଡେ" },
            { "mer", "ମେରୁ" },
            { "mfe", "ମୋରିସୟେନ୍" },
            { "mga", "ମଧ୍ୟ ଇରିଶ୍" },
            { "mgh", "ମଖୁୱା-ମେଟ୍ଟା" },
            { "mgo", "ମେଟା" },
            { "mic", "ମିକମୌକ୍" },
            { "min", "ମିନାଙ୍ଗାବାଉ" },
            { "mnc", "ମାଞ୍ଚୁ" },
            { "mni", "ମଣିପୁରୀ" },
            { "moe", "ଇନ୍ନୁ-ଏମୁନ" },
            { "moh", "ମୋହୌକ" },
            { "mos", "ମୋସି" },
            { "mua", "ମୁନଡାଂ" },
            { "mul", "ବିବିଧ ଭାଷା" },
            { "mus", "କ୍ରୀକ୍" },
            { "mwl", "ମିରାଣ୍ଡିଜ୍" },
            { "mwr", "ମାରୱାରୀ" },
            { "myv", "ଏର୍ଜୟା" },
            { "mzn", "ମାଜାନଡେରାନି" },
            { "nap", "ନୀପୋଲିଟାନ୍" },
            { "naq", "ନାମା" },
            { "nds", "ଲୋ ଜର୍ମାନ୍" },
            { "new", "ନେୱାରୀ" },
            { "nia", "ନୀୟାସ୍" },
            { "niu", "ନିୟୁଆନ୍" },
            { "nmg", "କୱାସିଓ" },
            { "nnh", "ନାଗିମବୋନ୍" },
            { "nog", "ନୋଗାଇ" },
            { "non", "ପୁରୁଣା ନର୍ସ" },
            { "nqo", "ଏନକୋ" },
            { "nso", "ଉତ୍ତରୀ ସୋଥୋ" },
            { "nus", "ନୁଏର" },
            { "nwc", "ପାରମ୍ପରିକ ନେୱାରୀ" },
            { "nym", "ନ୍ୟାମୱେଜୀ" },
            { "nyn", "ନ୍ୟାନକୋଲ୍" },
            { "nyo", "ନ୍ୟାରୋ" },
            { "nzi", "ଞ୍ଜିମା" },
            { "ojb", "ଉତ୍ତର-ପଶ୍ଚିମ ଓଜିବ୍ଵା" },
            { "ojc", "କେନ୍ଦ୍ରୀୟ ଓଜିବ୍ଵା" },
            { "ojs", "ଓଜି-କ୍ରି" },
            { "ojw", "ପାଶ୍ଚାତ୍ୟ ଓଜିବ୍ଵା" },
            { "oka", "ଓକାନାଗାନ୍" },
            { "osa", "ୱୌସେଜ୍" },
            { "ota", "ଓଟ୍ଟୋମନ୍ ତୁର୍କିସ୍" },
            { "pag", "ପାଙ୍ଗାସିନିଆନ୍" },
            { "pal", "ପାହ୍ଲାଭି" },
            { "pam", "ପାମ୍ପାଙ୍ଗା" },
            { "pap", "ପାପିଆମେଣ୍ଟୋ" },
            { "pau", "ପାଲାଉଆନ୍" },
            { "pcm", "ନାଇଜେରୀୟ ପିଡଗିନ୍" },
            { "peo", "ପୁରୁଣା ପର୍ସିଆନ୍" },
            { "phn", "ଫୋନେସିଆନ୍" },
            { "pis", "ପିଜିନ୍" },
            { "pon", "ପୋହପିଏନ୍" },
            { "pqm", "ମାଲିସୀଟ-ପାସମକୁଅଡ୍ଡି" },
            { "prg", "ପ୍ରୁସିୟ" },
            { "pro", "ପୁରୁଣା ପ୍ରେଭେନେସିଆଲ୍" },
            { "quc", "କିଚେ" },
            { "raj", "ରାଜସ୍ଥାନୀ" },
            { "rap", "ରାପାନୁଇ" },
            { "rar", "ରାରୋତୋଙ୍ଗନ୍" },
            { "rhg", "ରୋହିଙ୍ଗ୍ୟା" },
            { "rof", "ରୋମ୍ବୋ" },
            { "rom", "ରୋମାନି" },
            { "rup", "ଆରୋମାନିଆନ୍" },
            { "rwk", "ଆରଡବ୍ୟୁଏ" },
            { "sad", "ସଣ୍ଡାୱେ" },
            { "sah", "ୟାକୂଟ୍‌" },
            { "sam", "ସାମୌରିଟନ୍ ଆରମାଇକ୍" },
            { "saq", "ସମବୁରୁ" },
            { "sas", "ସାସାକ୍" },
            { "sat", "ସାନ୍ତାଳି" },
            { "sba", "ନଗାମବେ" },
            { "sbp", "ସାନଗୁ" },
            { "scn", "ସିଶିଲିଆନ୍" },
            { "sco", "ସ୍କଟସ୍" },
            { "seh", "ସେନା" },
            { "sel", "ସେଲ୍କପ୍" },
            { "ses", "କୋୟରା ସେନ୍ନି" },
            { "sga", "ପୁରୁଣା ଇରିଶ୍" },
            { "shi", "ତାଚେଲହିଟ୍" },
            { "shn", "ଶାନ୍" },
            { "sid", "ସିଦାମୋ" },
            { "slh", "ସାଉଥ୍ ଲୁଶୋସିଟେଡ୍" },
            { "sma", "ଦକ୍ଷିଣ ସାମି" },
            { "smj", "ଲୁଲେ ସାମି" },
            { "smn", "ଇନାରୀ ସାମି" },
            { "sms", "ସ୍କୋଲ୍ଟ ସାମି" },
            { "snk", "ସୋନିଙ୍କେ" },
            { "sog", "ସୋଗଡିଏନ୍" },
            { "srn", "ଶାରାନା ଟୋଙ୍ଗୋ" },
            { "srr", "ଶେରେର୍" },
            { "ssy", "ସହୋ" },
            { "str", "ଷ୍ଟ୍ରାଇଟ୍ ସାଲିଶ୍" },
            { "suk", "ସୁକୁମା" },
            { "sus", "ଶୁଶୁ" },
            { "sux", "ସୁମେରିଆନ୍" },
            { "swb", "କୋମୋରିୟ" },
            { "syc", "କ୍ଲାସିକାଲ୍ ସିରିକ୍" },
            { "syr", "ସିରିଆକ୍‌" },
            { "szl", "ସାଇଲେସିଆନ୍‌" },
            { "tce", "ସାଉଥ୍ ଟଚୋନ୍" },
            { "tem", "ତିମନେ" },
            { "teo", "ତେସା" },
            { "ter", "ତେରେନୋ" },
            { "tet", "ତେତୁମ୍" },
            { "tgx", "ତାଗିଶ" },
            { "tht", "ତହଲତାନ୍" },
            { "tig", "ଟାଇଗ୍ରେ" },
            { "tiv", "ତୀଭ୍" },
            { "tkl", metaValue_TK },
            { "tlh", "କ୍ଲିଙ୍ଗନ୍" },
            { "tli", "ତ୍ଲିଙ୍ଗିଟ୍" },
            { "tmh", "ତାମାଶେକ୍" },
            { "tog", "ନ୍ୟାସା ଟୋଙ୍ଗୋ" },
            { "tok", "ଟୋକି ପୋନା" },
            { "tpi", "ଟୋକ୍ ପିସିନ୍" },
            { "trv", "ତାରୋକୋ" },
            { "tsi", "ତିସିମିସିଆନ୍" },
            { "ttm", "ଉତ୍ତର ଟୁଚୋନ୍" },
            { "tum", "ଟୁମ୍ବୁକା" },
            { "tvl", metaValue_TV },
            { "twq", "ତାସାୱାକ୍" },
            { "tyv", "ତୁଭିନିଆନ୍" },
            { "tzm", "କେନ୍ଦ୍ରୀୟ ଆଟଲାସ୍ ଟାମାଜିଘାଟ୍" },
            { "udm", "ଉଦମୂର୍ତ୍ତ" },
            { "uga", "ୟୁଗୋରଟିକ୍" },
            { "umb", "ଉମ୍ବୁଣ୍ଡୁ" },
            { "und", "ଅଜଣା ଭାଷା" },
            { "vai", "ଭାଇ" },
            { "vec", "ଭନିଶନ୍‌" },
            { "vmw", "ମାଖୁୱା" },
            { "vot", "ଭୋଟିକ୍" },
            { "vun", "ଭୁନଜୋ" },
            { "wae", "ୱାଲସେର୍" },
            { "wal", "ୱାଲମୋ" },
            { "war", "ୱାରୈ" },
            { "was", "ୱାସୋ" },
            { "wuu", "ୱୁ ଚାଇନିଜ" },
            { "xal", "କାଲ୍ମୀକ୍" },
            { "xnr", "କାଙ୍ଗ୍ରି" },
            { "xog", "ସୋଗା" },
            { "yao", "ୟାଓ" },
            { "yap", "ୟାପୀସ୍" },
            { "yav", "ୟାଂବେନ୍" },
            { "ybb", "ୟେମବା" },
            { "yrl", "ନିଙ୍ଗାଟୁ" },
            { "yue", "କାଣ୍ଟୋନିଜ୍‌" },
            { "zap", "ଜାପୋଟେକ୍" },
            { "zbl", metaValue_zbl },
            { "zen", "ଜେନାଗା" },
            { "zgh", "ମାନାଙ୍କ ମରୋକିୟ ତାମାଜିଘାଟ୍" },
            { "zun", "ଜୁନୀ" },
            { "zxx", "କୌଣସି ଲିଙ୍ଗୁଇଷ୍ଟ ସାମଗ୍ରୀ ନାହିଁ" },
            { "zza", "ଜାଜା" },
            { "Adlm", "ଆଡଲମ୍" },
            { "Arab", metaValue_ar },
            { "Aran", "ନାଷ୍ଟାଲିକ୍‌" },
            { "Armi", "ଇମ୍ପେରିଆଲ୍ ଆରମିକ୍" },
            { "Armn", "ଆର୍ମେନୀୟ" },
            { "Avst", "ଆବେସ୍ଥାନ୍" },
            { "Bali", metaValue_ban },
            { "Batk", "ବାଟାକ୍" },
            { "Beng", "ବଙ୍ଗାଳୀ" },
            { "Blis", metaValue_zbl },
            { "Bopo", "ବୋପୋମୋଫୋ" },
            { "Brah", "ବ୍ରାହ୍ମୀ" },
            { "Brai", "ବ୍ରେଲ୍" },
            { "Bugi", "ବୁଗାନୀଜ୍" },
            { "Buhd", "ବୁହିଦ୍" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ୟୁନିଫାଏଡ୍ କାନାଡିଆନ୍ ଆବ୍ରୋଜିନାଲ୍ ସିଲାବିକସ୍" },
            { "Cari", "କୈରନ୍" },
            { "Cham", "ଛମ୍" },
            { "Cher", "ଚିରୁକୀ" },
            { "Cirt", "ସିର୍ଥ" },
            { "Copt", "କପଟିକ୍" },
            { "Cprt", "ସିପ୍ରଅଟ୍" },
            { "Cyrl", "ସିରିଲିକ୍" },
            { "Cyrs", "ଓଲ୍ଡ ଚର୍ଚ୍ଚ ସାଲଭୋନିକ୍ ସିରିଲିକ୍" },
            { "Deva", "ଦେବନାଗରୀ" },
            { "Dsrt", "ଡେସର୍ଟ" },
            { "Egyd", "ଇଜିପ୍ଟିଆନ୍ ଡେମୋଟିକ୍" },
            { "Egyh", "ଇଜିପ୍ଟିଆନ୍ ହାଇଅରଟିକ୍" },
            { "Egyp", "ଇଜିପ୍ଟିଆନ୍ ହାଅରଗ୍ଲିପସ୍" },
            { "Ethi", "ଇଥିଓପିକ୍‌" },
            { "Geok", "ଜର୍ଜିଆନ୍ ଖୁଟସୁରୀ" },
            { "Geor", "ଜର୍ଜିୟ" },
            { "Glag", "ଗ୍ଲାଗ୍ଲୋଟିକ୍" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "ଗୁରମୁଖୀ" },
            { "Hanb", "ବୋପୋମୋଫୋ ସହିତ ହାନ୍‌" },
            { "Hang", "ହାଙ୍ଗୁଲ୍" },
            { "Hani", "ହାନ୍" },
            { "Hano", "ହାନୁନ୍" },
            { "Hans", "ସରଳୀକୃତ" },
            { "Hant", "ପାରମ୍ପରିକ" },
            { "Hebr", "ହିବୃ" },
            { "Hira", "ହିରାଗାନା" },
            { "Hmng", "ପାହୋ ହୋଙ୍ଗ" },
            { "Hrkt", "ଜାପାନୀ ସିଲାବରିଜ୍‌" },
            { "Hung", "ପୁରୁଣା ହଙ୍ଗେରିଆନ୍" },
            { "Inds", "ସିନ୍ଧୁ" },
            { "Ital", "ପୁରୁଣା ଇଟାଲୀ" },
            { "Jamo", "ଜାମୋ" },
            { "Java", "ଜାଭାନୀଜ୍" },
            { "Jpan", "ଜାପାନୀଜ୍" },
            { "Kali", "କାୟାହା ଲୀ" },
            { "Kana", "କାତାକାନା" },
            { "Khar", "ଖାରୋସ୍ଥି" },
            { "Khmr", "ଖମେର୍" },
            { "Knda", "କନ୍ନଡ଼" },
            { "Kore", metaValue_ko },
            { "Kthi", "କୈଥି" },
            { "Lana", "ଲାନା" },
            { "Laoo", metaValue_lo },
            { "Latf", "ଫ୍ରାକଥୁର୍ ଲାଟିନ୍" },
            { "Latg", "ଗାଏଲିକ୍ ଲାଟିନ୍" },
            { "Latn", metaValue_la },
            { "Lepc", "ଲେପଚା" },
            { "Limb", "ଲିମ୍ବୁ" },
            { "Lina", "ଲିନିୟର୍" },
            { "Linb", "ଲିନିୟର୍ ବି" },
            { "Lyci", "ଲିଶିୟନ୍" },
            { "Lydi", "ଲିଡିୟନ୍" },
            { "Mand", "ମାନଡେନ୍" },
            { "Mani", "ମନଶୀନ୍" },
            { "Maya", "ମୟାନ୍ ହାୟରଲଜିକସ୍" },
            { "Mero", "ମେରୋଇଟିକ୍" },
            { "Mlym", "ମାଲାୟାଲମ୍" },
            { "Mong", "ମଙ୍ଗୋଲିଆନ୍" },
            { "Moon", "ଚନ୍ଦ୍ର" },
            { "Mtei", "ମାଏତି ମାୟେକ୍" },
            { "Mymr", "ମ୍ୟାନମାର୍" },
            { "Nkoo", "ଏନ୍ କୋ" },
            { "Ogam", "ଓଘାମା" },
            { "Olck", "ଅଲ୍ ଚିକି" },
            { "Orkh", "ଓରୋଖନ୍" },
            { "Orya", metaValue_or },
            { "Osma", "ଓସୋମାନିୟା" },
            { "Perm", "ଓଲ୍ଡ ପରମିକ୍" },
            { "Phag", "ଫାଗସ୍-ପା" },
            { "Phli", "ଇନସ୍କ୍ରୀପସାନଲ୍ ପାହାଲାୱୀ" },
            { "Phlp", "ସ୍ଲାଟର୍ ପାହାଲାୱୀ" },
            { "Phlv", "ବୁକ୍ ପାହାଲାୱୀ" },
            { "Phnx", "ଫେନୋସିଆନ୍" },
            { "Plrd", "ପୋଲାର୍ଡ ଫୋନେଟିକ୍" },
            { "Prti", "ଇନସ୍କ୍ରୀପସାନଲ୍ ପାର୍ଥିଆନ୍" },
            { "Rjng", "ରେଜାଙ୍ଗ" },
            { "Rohg", "ହାନିଫି" },
            { "Roro", "ରୋଙ୍ଗୋରୋଙ୍ଗୋ" },
            { "Runr", "ରନିକ୍" },
            { "Samr", "ସମୌରିଟନ୍" },
            { "Sara", "ସାରାତି" },
            { "Saur", "ସୌରାଷ୍ଟ୍ର" },
            { "Sgnw", "ସାଙ୍କେତିକ ଲିଖ" },
            { "Shaw", "ସାବିୟାନ୍" },
            { "Sinh", metaValue_si },
            { "Sund", "ସୁଦାନିଜ୍" },
            { "Sylo", "ସୀଲିତୋ ନଗରୀ" },
            { "Syrc", "ସିରିୟାକ୍" },
            { "Syre", "ଏଷ୍ଟ୍ରାଙ୍ଗେଲୋ ସିରିକ୍" },
            { "Syrj", "ୱେଷ୍ଟର୍ନ ସିରିକ୍" },
            { "Syrn", "ଇଷ୍ଟର୍ନ ସିରିକ୍" },
            { "Tagb", "ତଗବାନ୍ୱା" },
            { "Tale", "ତାଇ ଲେ" },
            { "Talu", "ନୂତନ ତାଇ ଲୁଏ" },
            { "Taml", metaValue_ta },
            { "Tavt", "ତାଇ ଭିଏତ୍" },
            { "Telu", metaValue_te },
            { "Teng", "ତେଙ୍ଗୱାର୍" },
            { "Tfng", "ଟିଫିନାଘ୍‌" },
            { "Tglg", "ଟାଗାଲୋଗ୍" },
            { "Thaa", "ଥାନା" },
            { "Thai", metaValue_th },
            { "Tibt", "ତିବେତାନ୍" },
            { "Ugar", "ୟୁଗାରିଟିକ୍" },
            { "Vaii", "ୱାଇ" },
            { "Visp", "ଭିଜିବଲ୍ ସ୍ପିଚ୍" },
            { "Xpeo", "ପୁରୁଣା ଫରାସୀ" },
            { "Xsux", "ସୁମେରୋ-ଆକ୍କାଡିଆନ୍ ସୁନିଫର୍ମ" },
            { "Yiii", "ୟୀ" },
            { "Zinh", "ବଂଶଗତ" },
            { "Zmth", "ଗାଣିତିକ ନୋଟେସନ୍" },
            { "Zsye", "ଇମୋଜି" },
            { "Zsym", "ସଙ୍କେତଗୁଡ଼ିକ" },
            { "Zxxx", "ଅଲିଖିତ" },
            { "Zyyy", "ସାଧାରଣ" },
            { "Zzzz", "ଅଜଣା ଲିପି" },
            { "de_AT", "ଅଷ୍ଟ୍ରିଆନ୍ ଜର୍ମାନ" },
            { "de_CH", "ସ୍ୱିସ୍‌ ହାଇ ଜର୍ମାନ" },
            { "en_AU", "ଅଷ୍ଟ୍ରେଲିୟ ଇଂରାଜୀ" },
            { "en_CA", "କାନାଡିୟ ଇଂରାଜୀ" },
            { "en_GB", "ବ୍ରିଟିଶ୍‌ ଇଂରାଜୀ" },
            { "en_US", "ଆମେରିକୀୟ ଇଂରାଜୀ" },
            { "es_ES", "ୟୁରୋପୀୟ ସ୍ପାନିସ୍‌" },
            { "es_MX", "ମେକ୍ସିକାନ ସ୍ପାନିସ୍‌" },
            { "fa_AF", "ଦାରି" },
            { "fr_CA", "କାନାଡିୟ ଫ୍ରେଞ୍ଚ" },
            { "fr_CH", "ସ୍ୱିସ୍ ଫ୍ରେଞ୍ଚ" },
            { "nl_BE", "ଫ୍ଲେମିଶ୍" },
            { "pt_BR", "ବ୍ରାଜିଲିଆନ୍ ପର୍ତ୍ତୁଗୀଜ୍" },
            { "pt_PT", "ୟୁରୋପୀୟ ପର୍ତ୍ତୁଗୀଜ୍‌" },
            { "ro_MD", "ମୋଲଡୋଭିଆନ୍" },
            { "sw_CD", "କଙ୍ଗୋ ସ୍ୱାହିଲି" },
            { "%%1901", "ପାରମ୍ପରିକ ଜର୍ମାନ ବର୍ଣ୍ଣପ୍ରକରଣ" },
            { "%%1996", "1996ର ଜର୍ମାନ ବର୍ଣ୍ଣପ୍ରକରଣ" },
            { "ar_001", "ଆଧୁନିକ ମାନକ ଆରବିକ୍‌" },
            { "es_419", "ଲାଟିନ୍‌ ଆମେରିକୀୟ ସ୍ପାନିସ୍‌" },
            { "key.ca", "କ୍ୟାଲେଣ୍ଡର୍" },
            { "key.cf", "ମୁଦ୍ରା ଫର୍ମାଟ୍‌" },
            { "key.co", "ସର୍ଟ୍‌ କ୍ରମ" },
            { "key.cu", "ମୁଦ୍ରା" },
            { "key.hc", "ଘଣ୍ଟା ଚକ୍ର (12 ବନାମ 24)" },
            { "key.lb", "ଲାଇନ୍‌ ବ୍ରେକ୍‌ ଷ୍ଟାଇଲ୍‌" },
            { "key.ms", "ମାପ ପଦ୍ଧତି" },
            { "key.nu", "ସଂଖ୍ୟା" },
            { "%%ALUKU", "ଆଲୁକୁ ଉପଭାଷା" },
            { "zh_Hans", "ସରଳୀକୃତ ଚାଇନିଜ" },
            { "zh_Hant", "ପାରମ୍ପରିକ ଚାଇନିଜ୍‌" },
            { "%%UNIFON", "ୟୁନିଫନ୍ ଫନେଟିକ୍ ଆଲଫାବେଟ୍" },
            { "%%VAIDIKA", "ବୈଦିକ" },
            { "%%1694ACAD", "ଆଦ୍ୟ ଆଧୁନିକ ଫରାସୀ" },
            { "%%1959ACAD", "ଏକାଡେମିକ" },
            { "%%VALENCIA", "ଭେଲେନସିଆନ୍" },
            { "type.ca.roc", "ମିଙ୍ଗୋଓ କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.hc.h11", "12 ଘଣ୍ଟିଆ ପଦ୍ଧତି (0–11)" },
            { "type.hc.h12", "12 ଘଣ୍ଟିଆ ପଦ୍ଧତି (1–12)" },
            { "type.hc.h23", "24 ଘଣ୍ଟିଆ ପଦ୍ଧତି (0–23)" },
            { "type.hc.h24", "24 ଘଣ୍ଟିଆ ପଦ୍ଧତି (1–24)" },
            { "type.nu.arab", "ଆରବିକ୍‌-ଇଣ୍ଡିକ୍‌ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.armn", "ଆର୍ମେନିୟ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.beng", "ବଙ୍ଗଳା ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.cakm", "ଚକମା ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.deva", "ଦେବନାଗରୀ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.ethi", "ଇଥିଓପିକ୍‌ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.geor", "ଜର୍ଜିଆନ୍‌ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.grek", "ଗ୍ରୀକ୍‌ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.gujr", "ଗୁଜରାଟୀ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.guru", "ଗୁରମୁଖୀ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.hans", "ସରଳୀକୃତ ଚିନି ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.hant", "ପାରମ୍ପରିକ ଚିନି ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.hebr", "ହିବୃ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.java", "ଜାଭାନିଜ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.jpan", "ଜାପାନୀ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.khmr", "ଖିମର୍‌ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.knda", "କନ୍ନଡ଼ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.laoo", "ଲାଓ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.latn", "ପାଶ୍ଚାତ୍ୟ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.mlym", "ମଲୟାଲମ୍ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.mong", "ମଙ୍ଗୋଲୀୟ ଡିଜିଟ୍" },
            { "type.nu.mtei", "ମିତେଇ ମାୟେକ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.mymr", "ମିଆଁମାର୍‌ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.olck", "ଓଲ୍ ଚିକି ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.orya", "ଓଡ଼ିଆ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.taml", "ପାରମ୍ପରିକ ତାମିଲ୍ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.telu", "ତେଲୁଗୁ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.thai", "ଥାଇ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.tibt", "ତିବତୀ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.vaii", "ଭାଇ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.ca.dangi", "ଦାଙ୍ଗି କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.co.ducet", "ଡିଫଲ୍ଟ ୟୁନିକୋଡ୍‌ ସର୍ଟ୍‌ କ୍ରମ" },
            { "type.lb.loose", "କୋହଳ ଲାଇନ୍‌ ବ୍ରେକ୍‌ ଷ୍ଟାଇଲ୍‌" },
            { "type.nu.roman", "ରୋମାନ୍‌ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.ca.coptic", "କପ୍ଟିକ୍ କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.ca.hebrew", "ହିବୃ କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.ca.indian", "ଭାରତୀୟ ରାଷ୍ଟ୍ରୀୟ କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.co.search", "ସାଧାରଣ ଉଦ୍ଦେଶ୍ୟ-ବିଶିଷ୍ଟ ସନ୍ଧାନ" },
            { "type.lb.normal", "ସାଧାରଣ ଲାଇନ୍‌ ବ୍ରେକ୍‌ ଷ୍ଟାଇଲ୍‌" },
            { "type.lb.strict", "କଠୋର ଧାଡ଼ି ବିରତି ଶୈଳୀ" },
            { "type.ms.metric", "ମେଟ୍ରିକ୍‌ ପଦ୍ଧତି" },
            { "type.ca.chinese", "ଚାଇନିଜ୍‌ କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.ca.islamic", "ହିଜ୍ରି କ୍ୟାଲେଣ୍ଡର" },
            { "type.ca.iso8601", "ISO-8601 କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.ca.persian", "ପର୍ସିଆନ୍‌ କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.cf.account", "ଏକାଉଣ୍ଟିଂ ମୁଦ୍ରା ଫର୍ମାଟ୍‌" },
            { "type.nu.arabext", "ପରିବର୍ଦ୍ଧିତ ଆରବିକ୍‌-ଇଣ୍ଡିକ୍‌ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.armnlow", "ଆର୍ମେନିୟ ଛୋଟ ଅକ୍ଷର ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.greklow", "ଗ୍ରୀକ୍‌ ଛୋଟ ଅକ୍ଷର ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.hanidec", "ଚାଇନିଜ୍‌ ଦଶମିକ ସଂଖ୍ୟା" },
            { "type.nu.hansfin", "ସରଳୀକୃତ ଚିନି ଆର୍ଥିକ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.hantfin", "ପାରମ୍ପରିକ ଚିନି ଆର୍ଥିକ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.jpanfin", "ଜାପାନୀ ଆର୍ଥିକ ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.nu.tamldec", "ତାମିଲ୍ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.ca.buddhist", "ବୌଦ୍ଧ କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.ca.ethiopic", "ଇଥିଓପିକ୍‌ କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.ca.japanese", "ଜାପାନିଜ୍‌ କ୍ୟାଲେଣ୍ଡର୍‌" },
            { "type.cf.standard", "ମାନାଙ୍କ ମୁଦ୍ରା ଫର୍ମାଟ୍‌" },
            { "type.co.standard", "ଷ୍ଟାଣ୍ଡାର୍ଡ୍‌ ସର୍ଟ୍‌ କ୍ରମ" },
            { "type.ms.uksystem", "ଇମ୍ପେରିଆଲ୍‌ ମାପ ପଦ୍ଧତି" },
            { "type.ms.ussystem", "ୟୁଏସ୍‌ ମାପ ପଦ୍ଧତି" },
            { "type.nu.fullwide", "ପୂର୍ଣ୍ଣ-ପ୍ରସ୍ଥ ଅଙ୍କଗୁଡ଼ିକ" },
            { "type.nu.romanlow", "ରୋମାନ୍‌ ଛୋଟ ଅକ୍ଷର ସଂଖ୍ୟାଗୁଡ଼ିକ" },
            { "type.ca.gregorian", "ଗ୍ରେଗୋରିୟ କ୍ୟାଲେଣ୍ଡର୍" },
            { "type.ca.islamic-civil", "ହିଜ୍ରି କ୍ୟାଲେଣ୍ଡର (ଟାବୁଲାର୍, ନାଗରିକ ଯୁଗ)" },
            { "type.ca.islamic-umalqura", "ହିଜ୍ରି କ୍ୟାଲେଣ୍ଡର (ଉମ୍ ଅଲ୍-କୁରା)" },
            { "type.ca.ethiopic-amete-alem", "ଏଥିଓପିକ୍-ଆମେଟ୍-ଆଲେମ୍" },
        };
        return data;
    }
}
