/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class TypeVariableBinding
extends ReferenceBinding {
    public Binding declaringElement;
    public int rank;
    public ReferenceBinding firstBound;
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public char[] genericTypeSignature;

    public TypeVariableBinding(char[] sourceName, Binding declaringElement, int rank) {
        this.sourceName = sourceName;
        this.declaringElement = declaringElement;
        this.rank = rank;
        this.modifiers = 0x40000001;
        this.tagBits |= 0x20000000L;
    }

    public int kind() {
        return 2052;
    }

    public boolean boundCheck(Substitution substitution, TypeBinding argumentType) {
        boolean hasSubstitution;
        if (argumentType == BaseTypes.NullBinding || this == argumentType) {
            return true;
        }
        if (!(argumentType instanceof ReferenceBinding) && !argumentType.isArrayType()) {
            return false;
        }
        if (argumentType.isWildcard()) {
            WildcardBinding wildcard = (WildcardBinding)argumentType;
            switch (wildcard.kind) {
                case 2: {
                    if (this.boundCheck(substitution, wildcard.bound)) break;
                    return false;
                }
                case 0: {
                    if (this != wildcard.typeVariable()) break;
                    return true;
                }
            }
        }
        boolean bl = hasSubstitution = substitution != null;
        if (this.superclass.id != 1 && !argumentType.isCompatibleWith(hasSubstitution ? substitution.substitute(this.superclass) : this.superclass)) {
            return false;
        }
        int i = 0;
        int length = this.superInterfaces.length;
        while (i < length) {
            if (!argumentType.isCompatibleWith(hasSubstitution ? substitution.substitute(this.superInterfaces[i]) : this.superInterfaces[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canBeInstantiated() {
        return false;
    }

    public void collectSubstitutes(TypeBinding otherType, Map substitutes) {
        if (otherType == BaseTypes.NullBinding) {
            return;
        }
        TypeBinding[] variableSubstitutes = (TypeBinding[])substitutes.get(this);
        if (variableSubstitutes != null) {
            int length = variableSubstitutes.length;
            int i = 0;
            while (i < length) {
                TypeBinding substitute = variableSubstitutes[i];
                if (substitute == otherType) {
                    return;
                }
                if (substitute == null) {
                    variableSubstitutes[i] = otherType;
                    return;
                }
                ++i;
            }
            TypeBinding[] typeBindingArray = variableSubstitutes;
            variableSubstitutes = new TypeBinding[2 * length];
            System.arraycopy(typeBindingArray, 0, variableSubstitutes, 0, length);
            variableSubstitutes[length] = otherType;
            substitutes.put(this, variableSubstitutes);
        }
    }

    public char[] constantPoolName() {
        if (this.firstBound != null) {
            return this.firstBound.constantPoolName();
        }
        return this.superclass.constantPoolName();
    }

    public char[] computeUniqueKey() {
        char[] declaringKey = this.declaringElement.computeUniqueKey();
        int declaringLength = declaringKey.length;
        char[] sig = this.genericTypeSignature();
        int sigLength = sig.length;
        char[] uniqueKey = new char[declaringLength + 1 + sigLength];
        System.arraycopy(declaringKey, 0, uniqueKey, 0, declaringLength);
        uniqueKey[declaringLength] = 58;
        System.arraycopy(sig, 0, uniqueKey, declaringLength + 1, sigLength);
        return uniqueKey;
    }

    public String debugName() {
        return new String(this.sourceName);
    }

    public TypeBinding erasure() {
        if (this.firstBound != null) {
            return this.firstBound.erasure();
        }
        return this.superclass;
    }

    public ReferenceBinding findSuperTypeErasingTo(int erasureId, boolean erasureIsClass) {
        ReferenceBinding currentType = this;
        if (erasureIsClass) {
            while ((currentType = currentType.superclass()) != null) {
                if (currentType.id != erasureId && currentType.erasure().id != erasureId) continue;
                return currentType;
            }
            return null;
        }
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == TypeConstants.NoSuperInterfaces) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while ((currentType = currentType.superclass()) != null);
        int i = 0;
        while (i <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType.id == erasureId || currentType.erasure().id == erasureId) {
                    return currentType;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public ReferenceBinding findSuperTypeErasingTo(ReferenceBinding erasure) {
        if (this == erasure) {
            return this;
        }
        ReferenceBinding currentType = this;
        if (erasure.isClass()) {
            while ((currentType = currentType.superclass()) != null) {
                if (currentType != erasure && currentType.erasure() != erasure) continue;
                return currentType;
            }
            return null;
        }
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == TypeConstants.NoSuperInterfaces) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while ((currentType = currentType.superclass()) != null);
        int i = 0;
        while (i <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType == erasure || currentType.erasure() == erasure) {
                    return currentType;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public char[] genericSignature() {
        StringBuffer sig = new StringBuffer(10);
        sig.append(this.sourceName).append(':');
        int interfaceLength = this.superInterfaces.length;
        if (interfaceLength == 0 || this.firstBound == this.superclass) {
            sig.append(this.superclass.genericTypeSignature());
        }
        int i = 0;
        while (i < interfaceLength) {
            sig.append(':').append(this.superInterfaces[i].genericTypeSignature());
            ++i;
        }
        int sigLength = sig.length();
        char[] genericSignature = new char[sigLength];
        sig.getChars(0, sigLength, genericSignature, 0);
        return genericSignature;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature != null) {
            return this.genericTypeSignature;
        }
        this.genericTypeSignature = CharOperation.concat('T', this.sourceName, ';');
        return this.genericTypeSignature;
    }

    public boolean isErasureBoundTo(TypeBinding type) {
        if (this.superclass.erasure() == type) {
            return true;
        }
        int i = 0;
        int length = this.superInterfaces.length;
        while (i < length) {
            if (this.superInterfaces[i].erasure() == type) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isTypeVariable() {
        return true;
    }

    public char[] readableName() {
        return this.sourceName;
    }

    ReferenceBinding resolve(LookupEnvironment environment) {
        if ((this.modifiers & 0x2000000) == 0) {
            return this;
        }
        if (this.superclass != null) {
            this.superclass = BinaryTypeBinding.resolveUnresolvedType(this.superclass, environment, true);
        }
        if (this.firstBound != null) {
            this.firstBound = BinaryTypeBinding.resolveUnresolvedType(this.firstBound, environment, true);
        }
        ReferenceBinding[] interfaces = this.superInterfaces;
        int i = interfaces.length;
        while (--i >= 0) {
            interfaces[i] = BinaryTypeBinding.resolveUnresolvedType(interfaces[i], environment, true);
        }
        this.modifiers &= 0xFDFFFFFF;
        if (this.superclass != null) {
            this.superclass = BinaryTypeBinding.resolveType(this.superclass, environment, true);
        }
        if (this.firstBound != null) {
            this.firstBound = BinaryTypeBinding.resolveType(this.firstBound, environment, true);
        }
        i = interfaces.length;
        while (--i >= 0) {
            interfaces[i] = BinaryTypeBinding.resolveType(interfaces[i], environment, true);
        }
        return this;
    }

    public char[] shortReadableName() {
        return this.readableName();
    }

    public ReferenceBinding superclass() {
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append('<').append(this.sourceName);
        if (this.superclass != null && this.firstBound == this.superclass) {
            buffer.append(" extends ").append(this.superclass.debugName());
        }
        if (this.superInterfaces != null && this.superInterfaces != TypeConstants.NoSuperInterfaces) {
            if (this.firstBound != this.superclass) {
                buffer.append(" extends ");
            }
            int i = 0;
            int length = this.superInterfaces.length;
            while (i < length) {
                if (i > 0 || this.firstBound == this.superclass) {
                    buffer.append(" & ");
                }
                buffer.append(this.superInterfaces[i].debugName());
                ++i;
            }
        }
        buffer.append('>');
        return buffer.toString();
    }
}

