/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core;

import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.aspectj.org.eclipse.jdt.internal.core.INamingRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.InternalNamingConventions;

public final class NamingConventions {
    private static final char[] GETTER_BOOL_NAME = "is".toCharArray();
    private static final char[] GETTER_NAME = "get".toCharArray();
    private static final char[] SETTER_NAME = "set".toCharArray();

    private NamingConventions() {
    }

    private static char[] removePrefixAndSuffix(char[] name, char[][] prefixes, char[][] suffixes) {
        char[] withoutPrefixName = name;
        if (prefixes != null) {
            int bestLength = 0;
            int i = 0;
            while (i < prefixes.length) {
                int currLen;
                boolean lastCharIsLetter;
                char[] prefix = prefixes[i];
                if (CharOperation.prefixEquals(prefix, name) && (!(lastCharIsLetter = Character.isLetter(prefix[(currLen = prefix.length) - 1])) || lastCharIsLetter && name.length > currLen && Character.isUpperCase(name[currLen])) && bestLength < currLen && name.length != currLen) {
                    withoutPrefixName = CharOperation.subarray(name, currLen, name.length);
                    bestLength = currLen;
                }
                ++i;
            }
        }
        char[] withoutSuffixName = withoutPrefixName;
        if (suffixes != null) {
            int bestLength = 0;
            int i = 0;
            while (i < suffixes.length) {
                int currLen;
                char[] suffix = suffixes[i];
                if (CharOperation.endsWith(withoutPrefixName, suffix) && bestLength < (currLen = suffix.length) && withoutPrefixName.length != currLen) {
                    withoutSuffixName = CharOperation.subarray(withoutPrefixName, 0, withoutPrefixName.length - currLen);
                    bestLength = currLen;
                }
                ++i;
            }
        }
        withoutSuffixName[0] = Character.toLowerCase(withoutSuffixName[0]);
        return withoutSuffixName;
    }

    public static char[] removePrefixAndSuffixForArgumentName(IJavaProject javaProject, char[] argumentName) {
        AssistOptions assistOptions = new AssistOptions(javaProject.getOptions(true));
        return NamingConventions.removePrefixAndSuffix(argumentName, assistOptions.argumentPrefixes, assistOptions.argumentSuffixes);
    }

    public static String removePrefixAndSuffixForArgumentName(IJavaProject javaProject, String argumentName) {
        return String.valueOf(NamingConventions.removePrefixAndSuffixForArgumentName(javaProject, argumentName.toCharArray()));
    }

    public static char[] removePrefixAndSuffixForFieldName(IJavaProject javaProject, char[] fieldName, int modifiers) {
        boolean isStatic = Flags.isStatic(modifiers);
        AssistOptions assistOptions = new AssistOptions(javaProject.getOptions(true));
        return NamingConventions.removePrefixAndSuffix(fieldName, isStatic ? assistOptions.staticFieldPrefixes : assistOptions.fieldPrefixes, isStatic ? assistOptions.staticFieldSuffixes : assistOptions.fieldSuffixes);
    }

    public static String removePrefixAndSuffixForFieldName(IJavaProject javaProject, String fieldName, int modifiers) {
        return String.valueOf(NamingConventions.removePrefixAndSuffixForFieldName(javaProject, fieldName.toCharArray(), modifiers));
    }

    public static char[] removePrefixAndSuffixForLocalVariableName(IJavaProject javaProject, char[] localName) {
        AssistOptions assistOptions = new AssistOptions(javaProject.getOptions(true));
        return NamingConventions.removePrefixAndSuffix(localName, assistOptions.localPrefixes, assistOptions.localSuffixes);
    }

    public static String removePrefixAndSuffixForLocalVariableName(IJavaProject javaProject, String localName) {
        return String.valueOf(NamingConventions.removePrefixAndSuffixForLocalVariableName(javaProject, localName.toCharArray()));
    }

    public static char[][] suggestArgumentNames(IJavaProject javaProject, char[] packageName, char[] qualifiedTypeName, int dim, char[][] excludedNames) {
        NamingRequestor requestor = new NamingRequestor();
        InternalNamingConventions.suggestArgumentNames(javaProject, packageName, qualifiedTypeName, dim, excludedNames, requestor);
        return requestor.getResults();
    }

    public static String[] suggestArgumentNames(IJavaProject javaProject, String packageName, String qualifiedTypeName, int dim, String[] excludedNames) {
        return NamingConventions.convertCharsToString(NamingConventions.suggestArgumentNames(javaProject, packageName.toCharArray(), qualifiedTypeName.toCharArray(), dim, NamingConventions.convertStringToChars(excludedNames)));
    }

    public static char[][] suggestFieldNames(IJavaProject javaProject, char[] packageName, char[] qualifiedTypeName, int dim, int modifiers, char[][] excludedNames) {
        NamingRequestor requestor = new NamingRequestor();
        InternalNamingConventions.suggestFieldNames(javaProject, packageName, qualifiedTypeName, dim, modifiers, excludedNames, requestor);
        return requestor.getResults();
    }

    public static String[] suggestFieldNames(IJavaProject javaProject, String packageName, String qualifiedTypeName, int dim, int modifiers, String[] excludedNames) {
        return NamingConventions.convertCharsToString(NamingConventions.suggestFieldNames(javaProject, packageName.toCharArray(), qualifiedTypeName.toCharArray(), dim, modifiers, NamingConventions.convertStringToChars(excludedNames)));
    }

    public static char[][] suggestLocalVariableNames(IJavaProject javaProject, char[] packageName, char[] qualifiedTypeName, int dim, char[][] excludedNames) {
        NamingRequestor requestor = new NamingRequestor();
        InternalNamingConventions.suggestLocalVariableNames(javaProject, packageName, qualifiedTypeName, dim, excludedNames, requestor);
        return requestor.getResults();
    }

    public static String[] suggestLocalVariableNames(IJavaProject javaProject, String packageName, String qualifiedTypeName, int dim, String[] excludedNames) {
        return NamingConventions.convertCharsToString(NamingConventions.suggestLocalVariableNames(javaProject, packageName.toCharArray(), qualifiedTypeName.toCharArray(), dim, NamingConventions.convertStringToChars(excludedNames)));
    }

    public static char[] suggestGetterName(IJavaProject project, char[] fieldName, int modifiers, boolean isBoolean, char[][] excludedNames) {
        if (isBoolean) {
            char[] name = NamingConventions.removePrefixAndSuffixForFieldName(project, fieldName, modifiers);
            int prefixLen = GETTER_BOOL_NAME.length;
            if (CharOperation.prefixEquals(GETTER_BOOL_NAME, name) && name.length > prefixLen && Character.isUpperCase(name[prefixLen])) {
                return NamingConventions.suggestNewName(name, excludedNames);
            }
            return NamingConventions.suggestNewName(CharOperation.concat(GETTER_BOOL_NAME, NamingConventions.suggestAccessorName(project, fieldName, modifiers)), excludedNames);
        }
        return NamingConventions.suggestNewName(CharOperation.concat(GETTER_NAME, NamingConventions.suggestAccessorName(project, fieldName, modifiers)), excludedNames);
    }

    public static String suggestGetterName(IJavaProject project, String fieldName, int modifiers, boolean isBoolean, String[] excludedNames) {
        return String.valueOf(NamingConventions.suggestGetterName(project, fieldName.toCharArray(), modifiers, isBoolean, NamingConventions.convertStringToChars(excludedNames)));
    }

    public static char[] suggestSetterName(IJavaProject project, char[] fieldName, int modifiers, boolean isBoolean, char[][] excludedNames) {
        if (isBoolean) {
            char[] name = NamingConventions.removePrefixAndSuffixForFieldName(project, fieldName, modifiers);
            int prefixLen = GETTER_BOOL_NAME.length;
            if (CharOperation.prefixEquals(GETTER_BOOL_NAME, name) && name.length > prefixLen && Character.isUpperCase(name[prefixLen])) {
                name = CharOperation.subarray(name, prefixLen, name.length);
                return NamingConventions.suggestNewName(CharOperation.concat(SETTER_NAME, NamingConventions.suggestAccessorName(project, name, modifiers)), excludedNames);
            }
            return NamingConventions.suggestNewName(CharOperation.concat(SETTER_NAME, NamingConventions.suggestAccessorName(project, fieldName, modifiers)), excludedNames);
        }
        return NamingConventions.suggestNewName(CharOperation.concat(SETTER_NAME, NamingConventions.suggestAccessorName(project, fieldName, modifiers)), excludedNames);
    }

    public static String suggestSetterName(IJavaProject project, String fieldName, int modifiers, boolean isBoolean, String[] excludedNames) {
        return String.valueOf(NamingConventions.suggestSetterName(project, fieldName.toCharArray(), modifiers, isBoolean, NamingConventions.convertStringToChars(excludedNames)));
    }

    private static char[] suggestAccessorName(IJavaProject project, char[] fieldName, int modifiers) {
        char[] name = NamingConventions.removePrefixAndSuffixForFieldName(project, fieldName, modifiers);
        if (name.length > 0 && Character.isLowerCase(name[0])) {
            name[0] = Character.toUpperCase(name[0]);
        }
        return name;
    }

    private static char[] suggestNewName(char[] name, char[][] excludedNames) {
        if (excludedNames == null) {
            return name;
        }
        char[] newName = name;
        int count = 2;
        int i = 0;
        while (i < excludedNames.length) {
            if (CharOperation.equals(newName, excludedNames[i], false)) {
                newName = CharOperation.concat(name, String.valueOf(count++).toCharArray());
                i = 0;
                continue;
            }
            ++i;
        }
        return newName;
    }

    private static String[] convertCharsToString(char[][] c) {
        int length = c == null ? 0 : c.length;
        String[] s = new String[length];
        int i = 0;
        while (i < length) {
            s[i] = String.valueOf(c[i]);
            ++i;
        }
        return s;
    }

    private static char[][] convertStringToChars(String[] s) {
        int length = s == null ? 0 : s.length;
        char[][] c = new char[length][];
        int i = 0;
        while (i < length) {
            c[i] = s[i] == null ? CharOperation.NO_CHAR : s[i].toCharArray();
            ++i;
        }
        return c;
    }

    private static class NamingRequestor
    implements INamingRequestor {
        private static final int SIZE = 10;
        private char[][] firstPrefixAndFirstSuffixResults = new char[10][];
        private int firstPrefixAndFirstSuffixResultsCount = 0;
        private char[][] firstPrefixAndSuffixResults = new char[10][];
        private int firstPrefixAndSuffixResultsCount = 0;
        private char[][] prefixAndFirstSuffixResults = new char[10][];
        private int prefixAndFirstSuffixResultsCount = 0;
        private char[][] prefixAndSuffixResults = new char[10][];
        private int prefixAndSuffixResultsCount = 0;
        private char[][] firstPrefixResults = new char[10][];
        private int firstPrefixResultsCount = 0;
        private char[][] prefixResults = new char[10][];
        private int prefixResultsCount = 0;
        private char[][] firstSuffixResults = new char[10][];
        private int firstSuffixResultsCount = 0;
        private char[][] suffixResults = new char[10][];
        private int suffixResultsCount = 0;
        private char[][] otherResults = new char[10][];
        private int otherResultsCount = 0;

        NamingRequestor() {
        }

        public void acceptNameWithPrefixAndSuffix(char[] name, boolean isFirstPrefix, boolean isFirstSuffix) {
            if (isFirstPrefix && isFirstSuffix) {
                int length = this.firstPrefixAndFirstSuffixResults.length;
                if (length == this.firstPrefixAndFirstSuffixResultsCount) {
                    this.firstPrefixAndFirstSuffixResults = new char[length * 2][];
                    System.arraycopy(this.firstPrefixAndFirstSuffixResults, 0, this.firstPrefixAndFirstSuffixResults, 0, length);
                }
                this.firstPrefixAndFirstSuffixResults[this.firstPrefixAndFirstSuffixResultsCount++] = name;
            } else if (isFirstPrefix) {
                int length = this.firstPrefixAndSuffixResults.length;
                if (length == this.firstPrefixAndSuffixResultsCount) {
                    this.firstPrefixAndSuffixResults = new char[length * 2][];
                    System.arraycopy(this.firstPrefixAndSuffixResults, 0, this.firstPrefixAndSuffixResults, 0, length);
                }
                this.firstPrefixAndSuffixResults[this.firstPrefixAndSuffixResultsCount++] = name;
            } else if (isFirstSuffix) {
                int length = this.prefixAndFirstSuffixResults.length;
                if (length == this.prefixAndFirstSuffixResultsCount) {
                    this.prefixAndFirstSuffixResults = new char[length * 2][];
                    System.arraycopy(this.prefixAndFirstSuffixResults, 0, this.prefixAndFirstSuffixResults, 0, length);
                }
                this.prefixAndFirstSuffixResults[this.prefixAndFirstSuffixResultsCount++] = name;
            } else {
                int length = this.prefixAndSuffixResults.length;
                if (length == this.prefixAndSuffixResultsCount) {
                    this.prefixAndSuffixResults = new char[length * 2][];
                    System.arraycopy(this.prefixAndSuffixResults, 0, this.prefixAndSuffixResults, 0, length);
                }
                this.prefixAndSuffixResults[this.prefixAndSuffixResultsCount++] = name;
            }
        }

        public void acceptNameWithPrefix(char[] name, boolean isFirstPrefix) {
            if (isFirstPrefix) {
                int length = this.firstPrefixResults.length;
                if (length == this.firstPrefixResultsCount) {
                    this.firstPrefixResults = new char[length * 2][];
                    System.arraycopy(this.firstPrefixResults, 0, this.firstPrefixResults, 0, length);
                }
                this.firstPrefixResults[this.firstPrefixResultsCount++] = name;
            } else {
                int length = this.prefixResults.length;
                if (length == this.prefixResultsCount) {
                    this.prefixResults = new char[length * 2][];
                    System.arraycopy(this.prefixResults, 0, this.prefixResults, 0, length);
                }
                this.prefixResults[this.prefixResultsCount++] = name;
            }
        }

        public void acceptNameWithSuffix(char[] name, boolean isFirstSuffix) {
            if (isFirstSuffix) {
                int length = this.firstSuffixResults.length;
                if (length == this.firstSuffixResultsCount) {
                    this.firstSuffixResults = new char[length * 2][];
                    System.arraycopy(this.firstSuffixResults, 0, this.firstSuffixResults, 0, length);
                }
                this.firstSuffixResults[this.firstSuffixResultsCount++] = name;
            } else {
                int length = this.suffixResults.length;
                if (length == this.suffixResultsCount) {
                    this.suffixResults = new char[length * 2][];
                    System.arraycopy(this.suffixResults, 0, this.suffixResults, 0, length);
                }
                this.suffixResults[this.suffixResultsCount++] = name;
            }
        }

        public void acceptNameWithoutPrefixAndSuffix(char[] name) {
            int length = this.otherResults.length;
            if (length == this.otherResultsCount) {
                this.otherResults = new char[length * 2][];
                System.arraycopy(this.otherResults, 0, this.otherResults, 0, length);
            }
            this.otherResults[this.otherResultsCount++] = name;
        }

        public char[][] getResults() {
            int count = this.firstPrefixAndFirstSuffixResultsCount + this.firstPrefixAndSuffixResultsCount + this.prefixAndFirstSuffixResultsCount + this.prefixAndSuffixResultsCount + this.firstPrefixResultsCount + this.prefixResultsCount + this.firstSuffixResultsCount + this.suffixResultsCount + this.otherResultsCount;
            char[][] results = new char[count][];
            int index = 0;
            System.arraycopy(this.firstPrefixAndFirstSuffixResults, 0, results, index, this.firstPrefixAndFirstSuffixResultsCount);
            System.arraycopy(this.firstPrefixAndSuffixResults, 0, results, index += this.firstPrefixAndFirstSuffixResultsCount, this.firstPrefixAndSuffixResultsCount);
            System.arraycopy(this.prefixAndFirstSuffixResults, 0, results, index += this.firstPrefixAndSuffixResultsCount, this.prefixAndFirstSuffixResultsCount);
            System.arraycopy(this.prefixAndSuffixResults, 0, results, index += this.prefixAndFirstSuffixResultsCount, this.prefixAndSuffixResultsCount);
            System.arraycopy(this.firstPrefixResults, 0, results, index += this.prefixAndSuffixResultsCount, this.firstPrefixResultsCount);
            System.arraycopy(this.prefixResults, 0, results, index += this.firstPrefixResultsCount, this.prefixResultsCount);
            System.arraycopy(this.firstSuffixResults, 0, results, index += this.prefixResultsCount, this.firstSuffixResultsCount);
            System.arraycopy(this.suffixResults, 0, results, index += this.firstSuffixResultsCount, this.suffixResultsCount);
            System.arraycopy(this.otherResults, 0, results, index += this.suffixResultsCount, this.otherResultsCount);
            return results;
        }
    }
}

